
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.votes_list import TypeMessagesVotesList


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class GetPollVotes(TLRequest[TypeMessagesVotesList]):
    """
    Get poll results for non-anonymous polls

    Raises:
        `403`BroadcastForbiddenError: Channel poll voters and reactions cannot be fetched to prevent deanonymization.
        `403`PollVoteRequiredError: Cast a vote in the poll before calling this method.
        `400`MsgIdInvalidError: Invalid message ID provided.

    """

    _id = 0XB86E380E
    _result_id = 0XADB5E0FE

    def __init__(
        self,
        peer: 'TypeInputPeer',
        id: int,
        limit: int,
        option: Optional[bytes] = None,
        offset: Optional[str] = None
    ):

        """
        Get poll results for non-anonymous polls

        Args:
            peer ('TypeInputPeer'): Chat where the poll was sent
            id (int): Message ID
            limit (int): Number of results to return
            option (Optional[bytes], optional): Get only results for the specified poll option
            offset (Optional[str], optional): Offset for results, taken from the next_offset field of [messages.votesList](https://core.telegram.org/constructor/messages.votesList), initially an empty string. Note: if no more results are available, the method call will return an empty next_offset; thus, avoid providing the next_offset returned in [messages.votesList](https://core.telegram.org/constructor/messages.votesList) if it is empty, to avoid an infinite loop.
        """

        self.peer = peer
        self.id = id
        self.limit = limit
        self.option = option
        self.offset = offset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x0e8n\xb8' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.id)

                if flags(self.option, 0):
                    writer.bytes(self.option)

                if flags(self.offset, 1):
                    writer.string(self.offset)
                writer.int(self.limit)

            return writer.getvalue()