
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.messages import TypeMessagesMessages


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class GetUnreadMentions(TLRequest[TypeMessagesMessages]):
    """
    Get unread messages where we were mentioned

    Raises:
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0XF107E790
    _result_id = 0XC8BB9188

    def __init__(
        self,
        peer: 'TypeInputPeer',
        offset_id: int,
        add_offset: int,
        limit: int,
        max_id: int,
        min_id: int,
        top_msg_id: Optional[int] = None
    ):

        """
        Get unread messages where we were mentioned

        Args:
            peer ('TypeInputPeer'): Peer where to look for mentions
            offset_id (int): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
            add_offset (int): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
            limit (int): Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
            max_id (int): Maximum message ID to return, [see pagination](https://core.telegram.org/api/offsets)
            min_id (int): Minimum message ID to return, [see pagination](https://core.telegram.org/api/offsets)
            top_msg_id (Optional[int], optional): If set, considers only messages within the specified [forum topic](https://core.telegram.org/api/forum#forum-topics)
        """

        self.peer = peer
        self.offset_id = offset_id
        self.add_offset = add_offset
        self.limit = limit
        self.max_id = max_id
        self.min_id = min_id
        self.top_msg_id = top_msg_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x90\xe7\x07\xf1' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )

                if flags(self.top_msg_id, 0):
                    writer.int(self.top_msg_id)
                writer.int(self.offset_id)
                writer.int(self.add_offset)
                writer.int(self.limit)
                writer.int(self.max_id)
                writer.int(self.min_id)

            return writer.getvalue()