
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_dialog_peer import TypeInputDialogPeer


class ReorderPinnedDialogs(TLRequest[bool]):
    """
    Reorder pinned dialogs

    Raises:
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0X3B1ADF37
    _result_id = 0X43B904E1

    def __init__(
        self,
        folder_id: int,
        order: List['TypeInputDialogPeer'],
        force: bool = False
    ):

        """
        Reorder pinned dialogs

        Args:
            folder_id (int): [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
            order (List['TypeInputDialogPeer']): New dialog order
            force (bool, optional): If set, dialogs pinned server-side but not present in the order field will be unpinned.
        """

        self.folder_id = folder_id
        self.order = order
        self.force = force

    def to_bytes(self, boxed: bool=True):
        with Writer(b'7\xdf\x1a;' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.force, 0)
                writer.int(self.folder_id)
                writer.vector(
                    self.order,
                    lambda value: writer.object(
                        value,
                        group_id=0XE22959A
                    )
                )

            return writer.getvalue()