
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.messages import TypeMessagesMessages


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.messages_filter import TypeMessagesFilter


class SearchGlobal(TLRequest[TypeMessagesMessages]):
    """
    Search for messages and peers globally

    Raises:
        `400`FolderIdInvalidError: Invalid folder ID.
        `400`InputFilterInvalidError: The specified filter is invalid.
        `400`SearchQueryEmptyError: The search query is empty.

    """

    _id = 0X4BC6589A
    _result_id = 0XC8BB9188

    def __init__(
        self,
        q: str,
        filter: 'TypeMessagesFilter',
        min_date: int,
        max_date: int,
        offset_rate: int,
        offset_peer: 'TypeInputPeer',
        offset_id: int,
        limit: int,
        broadcasts_only: bool = False,
        groups_only: bool = False,
        users_only: bool = False,
        folder_id: Optional[int] = None
    ):

        """
        Search for messages and peers globally

        Args:
            q (str): Query
            filter ('TypeMessagesFilter'): Global search filter
            min_date (int): If a positive value was specified, the method will return only messages with date bigger than min_date
            max_date (int): If a positive value was transferred, the method will return only messages with date smaller than max_date
            offset_rate (int): Initially 0, then set to the [next_rate parameter of messages.messagesSlice](https://core.telegram.org/constructor/messages.messagesSlice)
            offset_peer ('TypeInputPeer'): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
            offset_id (int): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
            limit (int): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
            broadcasts_only (bool, optional): If set, only returns results from channels (used in the [global channel search tab](https://core.telegram.org/api/search#global-search)).
            groups_only (bool, optional): Whether to search only in groups
            users_only (bool, optional): Whether to search only in private chats
            folder_id (Optional[int], optional): [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
        """

        self.q = q
        self.filter = filter
        self.min_date = min_date
        self.max_date = max_date
        self.offset_rate = offset_rate
        self.offset_peer = offset_peer
        self.offset_id = offset_id
        self.limit = limit
        self.broadcasts_only = broadcasts_only
        self.groups_only = groups_only
        self.users_only = users_only
        self.folder_id = folder_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9aX\xc6K' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.broadcasts_only, 1)
                flags(self.groups_only, 2)
                flags(self.users_only, 3)

                if flags(self.folder_id, 0):
                    writer.int(self.folder_id)
                writer.string(self.q)
                writer.object(
                    self.filter,
                    group_id=0X8CDA33F
                )
                writer.int(self.min_date)
                writer.int(self.max_date)
                writer.int(self.offset_rate)
                writer.object(
                    self.offset_peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.offset_id)
                writer.int(self.limit)

            return writer.getvalue()