
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.data_json import TypeDataJSON
    from ...types.input_peer import TypeInputPeer
    from ...types.input_group_call import TypeInputGroupCall


class JoinGroupCall(TLRequest[TypeUpdates]):
    """
    Join a group call

    Raises:
        `400`DataJsonInvalidError: The provided JSON data is invalid.
        `400`GroupcallInvalidError: The specified group call is invalid.
        `400`GroupcallSsrcDuplicateMuchError: The app needs to retry joining the group call with a new SSRC value.
        `400`JoinAsPeerInvalidError: The specified peer cannot be used to join a group call.
        `403`GroupcallForbiddenError: The group call has already ended.

    """

    _id = 0X8FB53057
    _result_id = 0XD68D29C0

    def __init__(
        self,
        call: 'TypeInputGroupCall',
        join_as: 'TypeInputPeer',
        params: 'TypeDataJSON',
        muted: bool = False,
        video_stopped: bool = False,
        invite_hash: Optional[str] = None,
        public_key: Optional[int] = None,
        block: Optional[bytes] = None
    ):

        """
        Join a group call

        Args:
            call ('TypeInputGroupCall'): The group call
            join_as ('TypeInputPeer'): Join the group call, presenting yourself as the specified user/channel
            params ('TypeDataJSON'): WebRTC parameters
            muted (bool, optional): If set, the user will be muted by default upon joining.
            video_stopped (bool, optional): If set, the user's video will be disabled by default upon joining.
            invite_hash (Optional[str], optional): The invitation hash from the [invite link](https://core.telegram.org/api/links#video-chat-livestream-links), if provided allows speaking in a livestream or muted group chat.
            public_key (Optional[int], optional): ...
            block (Optional[bytes], optional): ...
        """

        self.call = call
        self.join_as = join_as
        self.params = params
        self.muted = muted
        self.video_stopped = video_stopped
        self.invite_hash = invite_hash
        self.public_key = public_key
        self.block = block

    def to_bytes(self, boxed: bool=True):
        with Writer(b'W0\xb5\x8f' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.muted, 0)
                flags(self.video_stopped, 2)
                writer.object(
                    self.call,
                    group_id=0XDA9A559A
                )
                writer.object(
                    self.join_as,
                    group_id=0X995DB9DF
                )

                if flags(self.invite_hash, 1):
                    writer.string(self.invite_hash)

                if flags(self.public_key, 3):
                    writer.int256(self.public_key)

                if flags(self.block, 3):
                    writer.bytes(self.block)
                writer.object(
                    self.params,
                    group_id=0XE95B0798
                )

            return writer.getvalue()