
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_phone_call import TypeInputPhoneCall


class SetCallRating(TLRequest[TypeUpdates]):
    """
    Rate a call, returns info about the rating message sent to the official VoIP bot.

    Raises:
        `400`CallPeerInvalidError: The provided call peer object is invalid.

    """

    _id = 0X59EAD627
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPhoneCall',
        rating: int,
        comment: str,
        user_initiative: bool = False
    ):

        """
        Rate a call, returns info about the rating message sent to the official VoIP bot.

        Args:
            peer ('TypeInputPhoneCall'): The call to rate
            rating (int): Rating in 1-5 stars
            comment (str): An additional comment
            user_initiative (bool, optional): Whether the user decided on their own initiative to rate the call
        """

        self.peer = peer
        self.rating = rating
        self.comment = comment
        self.user_initiative = user_initiative

    def to_bytes(self, boxed: bool=True):
        with Writer(b"'\xd6\xeaY" if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.user_initiative, 0)
                writer.object(
                    self.peer,
                    group_id=0X3E51BD6B
                )
                writer.int(self.rating)
                writer.string(self.comment)

            return writer.getvalue()