
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.stats.story_stats import TypeStatsStoryStats


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class GetStoryStats(TLRequest[TypeStatsStoryStats]):
    """
    Get [statistics](https://core.telegram.org/api/stats) for a certain [story](https://core.telegram.org/api/stories).

    Raises:
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`StoriesNeverCreatedError: This peer hasn't ever posted any stories.

    """

    _id = 0X374FEF40
    _result_id = 0X75FA0162

    def __init__(
        self,
        peer: 'TypeInputPeer',
        id: int,
        dark: bool = False
    ):

        """
        Get [statistics](https://core.telegram.org/api/stats) for a certain [story](https://core.telegram.org/api/stories).

        Args:
            peer ('TypeInputPeer'): The peer that posted the story
            id (int): Story ID
            dark (bool, optional): Whether to enable the dark theme for graph colors
        """

        self.peer = peer
        self.id = id
        self.dark = dark

    def to_bytes(self, boxed: bool=True):
        with Writer(b'@\xefO7' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.dark, 0)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.id)

            return writer.getvalue()