
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader
    from .attach_menu_bot_icon import TypeAttachMenuBotIcon
    from .attach_menu_peer_type import TypeAttachMenuPeerType


class AttachMenuBot(TLObject, family='TypeAttachMenuBot'):
    """
    Represents a [bot mini app that can be launched from the attachment/side menu](https://core.telegram.org/api/bots/attach)
    """

    _id = 0XD90D8DFE
    _group_id = 0X6CB39E10

    def __init__(
        self,
        bot_id: int,
        short_name: str,
        icons: List['TypeAttachMenuBotIcon'],
        inactive: bool = False,
        has_settings: bool = False,
        request_write_access: bool = False,
        show_in_attach_menu: bool = False,
        show_in_side_menu: bool = False,
        side_menu_disclaimer_needed: bool = False,
        peer_types: Optional[List['TypeAttachMenuPeerType']] = None
    ):

        """
        Represents a [bot mini app that can be launched from the attachment/side menu](https://core.telegram.org/api/bots/attach)

        Args:
            bot_id (int): Bot ID
            short_name (str): Attachment menu item name
            icons (List['TypeAttachMenuBotIcon']): List of platform-specific static icons and animations to use for the attachment menu button
            inactive (bool, optional): If set, before launching the mini app the client should ask the user to add the mini app to the attachment/side menu, and only if the user accepts, after invoking [messages.toggleBotInAttachMenu](https://core.telegram.org/method/messages.toggleBotInAttachMenu) the app should be opened.
            has_settings (bool, optional): Deprecated flag, can be ignored.
            request_write_access (bool, optional): Whether the bot would like to send messages to the user.
            show_in_attach_menu (bool, optional): Whether, when installed, an attachment menu entry should be shown for the Mini App.
            show_in_side_menu (bool, optional): Whether, when installed, an entry in the main view side menu should be shown for the Mini App.
            side_menu_disclaimer_needed (bool, optional): If inactive if set and the user hasn't previously accepted the third-party mini apps [Terms of Service](https://telegram.org/tos/mini-apps) for this bot, when showing the mini app installation prompt, an additional mandatory checkbox to accept the [mini apps TOS](https://telegram.org/tos/mini-apps) and a disclaimer indicating that this Mini App is not affiliated to Telegram should be shown.
            peer_types (Optional[List['TypeAttachMenuPeerType']], optional): List of dialog types where this attachment menu entry should be shown
        """

        self.bot_id = bot_id
        self.short_name = short_name
        self.icons = icons
        self.inactive = inactive
        self.has_settings = has_settings
        self.request_write_access = request_write_access
        self.show_in_attach_menu = show_in_attach_menu
        self.show_in_side_menu = show_in_side_menu
        self.side_menu_disclaimer_needed = side_menu_disclaimer_needed
        self.peer_types = peer_types

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfe\x8d\r\xd9' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.inactive, 0)
                flags(self.has_settings, 1)
                flags(self.request_write_access, 2)
                flags(self.show_in_attach_menu, 3)
                flags(self.show_in_side_menu, 4)
                flags(self.side_menu_disclaimer_needed, 5)
                writer.long(self.bot_id)
                writer.string(self.short_name)

                if flags(self.peer_types, 3):
                    writer.vector(
                        self.peer_types,
                        lambda value: writer.object(
                            value,
                            group_id=0X29D3BE68
                        )
                    )
                writer.vector(
                    self.icons,
                    lambda value: writer.object(
                        value,
                        group_id=0XE9DE9488
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        bot_id_ = reader.long()
        short_name_ = reader.string()
        peer_types_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X29D3BE68
                )
            )
            if flags(3) else None
        )

        icons_ = reader.vector(
            lambda: reader.object(
                group_id=0XE9DE9488
            )
        )

        return cls(
            bot_id=bot_id_,
            short_name=short_name_,
            icons=icons_,
            inactive=flags(0),
            has_settings=flags(1),
            request_write_access=flags(2),
            show_in_attach_menu=flags(3),
            show_in_side_menu=flags(4),
            side_menu_disclaimer_needed=flags(5),
            peer_types=peer_types_
        )

TypeAttachMenuBot = AttachMenuBot