
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .user import TypeUser
    from .attach_menu_bot import TypeAttachMenuBot
    from ...gadgets.byteutils import Reader


class AttachMenuBotsNotModified(TLObject, family='TypeAttachMenuBots'):
    """
    The list of bot mini apps hasn't changed
    """

    _id = 0XF1D88A5C
    _group_id = 0X6D56CF1


    def to_bytes(self, boxed: bool=True):
        return b'\\\x8a\xd8\xf1' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class AttachMenuBots(TLObject, family='TypeAttachMenuBots'):
    """
    Represents a list of [bot mini apps that can be launched from the attachment menu](https://core.telegram.org/api/bots/attach)
    """

    _id = 0X3C4301C0
    _group_id = 0X6D56CF1

    def __init__(
        self,
        hash: int,
        bots: List['TypeAttachMenuBot'],
        users: List['TypeUser']
    ):

        """
        Represents a list of [bot mini apps that can be launched from the attachment menu](https://core.telegram.org/api/bots/attach)

        Args:
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
            bots (List['TypeAttachMenuBot']): List of [bot mini apps that can be launched from the attachment menu](https://core.telegram.org/api/bots/attach)
            users (List['TypeUser']): Info about related users/bots
        """

        self.hash = hash
        self.bots = bots
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc0\x01C<' if boxed else b'') as writer:
            writer.long(self.hash)
            writer.vector(
                self.bots,
                lambda value: writer.object(
                    value,
                    group_id=0X6CB39E10
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        hash_ = reader.long()
        bots_ = reader.vector(
            lambda: reader.object(
                group_id=0X6CB39E10
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            hash=hash_,
            bots=bots_,
            users=users_
        )

TypeAttachMenuBots = Union[
    AttachMenuBotsNotModified,
    AttachMenuBots
]