
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union, Optional
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .code_type import TypeAuthCodeType
    from .authorization import TypeAuthAuthorization
    from .sent_code_type import TypeAuthSentCodeType
    from ....gadgets.byteutils import Reader


class SentCode(TLObject, family='TypeAuthSentCode'):
    """
    Contains info about a sent verification code.
    """

    _id = 0X5E002502
    _group_id = 0X8F0C24F5

    def __init__(
        self,
        type: 'TypeAuthSentCodeType',
        phone_code_hash: str,
        next_type: Optional['TypeAuthCodeType'] = None,
        timeout: Optional[int] = None
    ):

        """
        Contains info about a sent verification code.

        Args:
            type ('TypeAuthSentCodeType'): Phone code type
            phone_code_hash (str): Phone code hash, to be stored and later re-used with [auth.signIn](https://core.telegram.org/method/auth.signIn)
            next_type (Optional['TypeAuthCodeType'], optional): Phone code type that will be sent next, if the phone code is not received within timeout seconds: to send it use [auth.resendCode](https://core.telegram.org/method/auth.resendCode)
            timeout (Optional[int], optional): Timeout for reception of the phone code
        """

        self.type = type
        self.phone_code_hash = phone_code_hash
        self.next_type = next_type
        self.timeout = timeout

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x02%\x00^' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.type,
                    group_id=0X73A22103
                )
                writer.string(self.phone_code_hash)

                if flags(self.next_type, 1):
                    writer.object(
                        self.next_type,
                        group_id=0X5017B075
                    )

                if flags(self.timeout, 2):
                    writer.int(self.timeout)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        type_ = reader.object(
            group_id=0X73A22103
        )

        phone_code_hash_ = reader.string()
        next_type_ = (
            reader.object(
                group_id=0X5017B075
            )
            if flags(1) else None
        )

        timeout_ = (
            reader.int()
            if flags(2) else None
        )

        return cls(
            type=type_,
            phone_code_hash=phone_code_hash_,
            next_type=next_type_,
            timeout=timeout_
        )

class SentCodeSuccess(TLObject, family='TypeAuthSentCode'):
    """
    The user successfully authorized using [future auth tokens](https://core.telegram.org/api/auth#future-auth-tokens)
    """

    _id = 0X2390FE44
    _group_id = 0X8F0C24F5

    def __init__(
        self,
        authorization: 'TypeAuthAuthorization'
    ):

        """
        The user successfully authorized using [future auth tokens](https://core.telegram.org/api/auth#future-auth-tokens)

        Args:
            authorization ('TypeAuthAuthorization'): Authorization info
        """

        self.authorization = authorization

    def to_bytes(self, boxed: bool=True):
        with Writer(b'D\xfe\x90#' if boxed else b'') as writer:
            writer.object(
                self.authorization,
                group_id=0X2A654890
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        authorization_ = reader.object(
            group_id=0X2A654890
        )

        return cls(
            authorization=authorization_
        )

class SentCodePaymentRequired(TLObject, family='TypeAuthSentCode'):
    _id = 0XD7A2FCF9
    _group_id = 0X8F0C24F5

    def __init__(
        self,
        store_product: str,
        phone_code_hash: str,
        support_email_address: str,
        support_email_subject: str
    ):

        self.store_product = store_product
        self.phone_code_hash = phone_code_hash
        self.support_email_address = support_email_address
        self.support_email_subject = support_email_subject

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf9\xfc\xa2\xd7' if boxed else b'') as writer:
            writer.string(self.store_product)
            writer.string(self.phone_code_hash)
            writer.string(self.support_email_address)
            writer.string(self.support_email_subject)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        store_product_ = reader.string()
        phone_code_hash_ = reader.string()
        support_email_address_ = reader.string()
        support_email_subject_ = reader.string()

        return cls(
            store_product=store_product_,
            phone_code_hash=phone_code_hash_,
            support_email_address=support_email_address_,
            support_email_subject=support_email_subject_
        )

TypeAuthSentCode = Union[
    SentCode,
    SentCodeSuccess,
    SentCodePaymentRequired
]