
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class CdnPublicKey(TLObject, family='TypeCdnPublicKey'):
    """
    Public key to use only during handshakes to [CDN](https://core.telegram.org/cdn) DCs.
    """

    _id = 0XC982EABA
    _group_id = 0X144059E1

    def __init__(
        self,
        dc_id: int,
        public_key: str
    ):

        """
        Public key to use only during handshakes to [CDN](https://core.telegram.org/cdn) DCs.

        Args:
            dc_id (int): [CDN DC](https://core.telegram.org/cdn) ID
            public_key (str): RSA public key
        """

        self.dc_id = dc_id
        self.public_key = public_key

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xba\xea\x82\xc9' if boxed else b'') as writer:
            writer.int(self.dc_id)
            writer.string(self.public_key)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        dc_id_ = reader.int()
        public_key_ = reader.string()

        return cls(
            dc_id=dc_id_,
            public_key=public_key_
        )

TypeCdnPublicKey = CdnPublicKey