
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..send_as_peer import TypeSendAsPeer
    from ....gadgets.byteutils import Reader


class SendAsPeers(TLObject, family='TypeChannelsSendAsPeers'):
    """
    A list of peers that can be used to send messages in a specific group
    """

    _id = 0XF496B0C6
    _group_id = 0X5B0AE521

    def __init__(
        self,
        peers: List['TypeSendAsPeer'],
        chats: List['TypeChat'],
        users: List['TypeUser']
    ):

        """
        A list of peers that can be used to send messages in a specific group

        Args:
            peers (List['TypeSendAsPeer']): Peers that can be used to send messages to the group
            chats (List['TypeChat']): Mentioned chats
            users (List['TypeUser']): Mentioned users
        """

        self.peers = peers
        self.chats = chats
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc6\xb0\x96\xf4' if boxed else b'') as writer:
            writer.vector(
                self.peers,
                lambda value: writer.object(
                    value,
                    group_id=0X701D1931
                )
            )
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peers_ = reader.vector(
            lambda: reader.object(
                group_id=0X701D1931
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            peers=peers_,
            chats=chats_,
            users=users_
        )

TypeChannelsSendAsPeers = SendAsPeers