
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class ChatPhotoEmpty(TLObject, family='TypeChatPhoto'):
    """
    Group photo is not set.
    """

    _id = 0X37C1011C
    _group_id = 0XFC7FED8C


    def to_bytes(self, boxed: bool=True):
        return b'\x1c\x01\xc17' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class ChatPhoto(TLObject, family='TypeChatPhoto'):
    """
    Group profile photo.
    """

    _id = 0X1C6E1C11
    _group_id = 0XFC7FED8C

    def __init__(
        self,
        photo_id: int,
        dc_id: int,
        has_video: bool = False,
        stripped_thumb: Optional[bytes] = None
    ):

        """
        Group profile photo.

        Args:
            photo_id (int): Photo ID
            dc_id (int): DC where this photo is stored
            has_video (bool, optional): Whether the user has an animated profile picture
            stripped_thumb (Optional[bytes], optional): [Stripped thumbnail](https://core.telegram.org/api/files#stripped-thumbnails)
        """

        self.photo_id = photo_id
        self.dc_id = dc_id
        self.has_video = has_video
        self.stripped_thumb = stripped_thumb

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x11\x1cn\x1c' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.has_video, 0)
                writer.long(self.photo_id)

                if flags(self.stripped_thumb, 1):
                    writer.bytes(self.stripped_thumb)
                writer.int(self.dc_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        photo_id_ = reader.long()
        stripped_thumb_ = (
            reader.bytes()
            if flags(1) else None
        )

        dc_id_ = reader.int()

        return cls(
            photo_id=photo_id_,
            dc_id=dc_id_,
            has_video=flags(0),
            stripped_thumb=stripped_thumb_
        )

TypeChatPhoto = Union[
    ChatPhotoEmpty,
    ChatPhoto
]