
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .star_gift import TypeStarGift
    from .theme_settings import TypeThemeSettings
    from ...gadgets.byteutils import Reader


class ChatTheme(TLObject, family='TypeChatTheme'):
    """
    A chat theme
    """

    _id = 0XC3DFFC04
    _group_id = 0X7FBD8E9C

    def __init__(
        self,
        emoticon: str
    ):

        """
        A chat theme

        Args:
            emoticon (str): Emoji, identifying this specific chat theme
        """

        self.emoticon = emoticon

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x04\xfc\xdf\xc3' if boxed else b'') as writer:
            writer.string(self.emoticon)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        emoticon_ = reader.string()

        return cls(
            emoticon=emoticon_
        )

class ChatThemeUniqueGift(TLObject, family='TypeChatTheme'):
    _id = 0X3458F9C8
    _group_id = 0X7FBD8E9C

    def __init__(
        self,
        gift: 'TypeStarGift',
        theme_settings: List['TypeThemeSettings']
    ):

        self.gift = gift
        self.theme_settings = theme_settings

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc8\xf9X4' if boxed else b'') as writer:
            writer.object(
                self.gift,
                group_id=0X87440C7B
            )
            writer.vector(
                self.theme_settings,
                lambda value: writer.object(
                    value,
                    group_id=0X71DD876E
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        gift_ = reader.object(
            group_id=0X87440C7B
        )

        theme_settings_ = reader.vector(
            lambda: reader.object(
                group_id=0X71DD876E
            )
        )

        return cls(
            gift=gift_,
            theme_settings=theme_settings_
        )

TypeChatTheme = Union[
    ChatTheme,
    ChatThemeUniqueGift
]