
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class EmailVerificationCode(TLObject, family='TypeEmailVerification'):
    """
    Email verification code
    """

    _id = 0X922E55A9
    _group_id = 0X4D88339D

    def __init__(
        self,
        code: str
    ):

        """
        Email verification code

        Args:
            code (str): Received verification code
        """

        self.code = code

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa9U.\x92' if boxed else b'') as writer:
            writer.string(self.code)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        code_ = reader.string()

        return cls(
            code=code_
        )

class EmailVerificationGoogle(TLObject, family='TypeEmailVerification'):
    """
    Google ID email verification token
    """

    _id = 0XDB909EC2
    _group_id = 0X4D88339D

    def __init__(
        self,
        token: str
    ):

        """
        Google ID email verification token

        Args:
            token (str): Token
        """

        self.token = token

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc2\x9e\x90\xdb' if boxed else b'') as writer:
            writer.string(self.token)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        token_ = reader.string()

        return cls(
            token=token_
        )

class EmailVerificationApple(TLObject, family='TypeEmailVerification'):
    """
    Apple ID email verification token
    """

    _id = 0X96D074FD
    _group_id = 0X4D88339D

    def __init__(
        self,
        token: str
    ):

        """
        Apple ID email verification token

        Args:
            token (str): Token
        """

        self.token = token

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfdt\xd0\x96' if boxed else b'') as writer:
            writer.string(self.token)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        token_ = reader.string()

        return cls(
            token=token_
        )

TypeEmailVerification = Union[
    EmailVerificationCode,
    EmailVerificationGoogle,
    EmailVerificationApple
]