
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class FileHash(TLObject, family='TypeFileHash'):
    """
    SHA256 Hash of an uploaded file, to be checked for validity after download
    """

    _id = 0XF39B035C
    _group_id = 0XAE8C6DC3

    def __init__(
        self,
        offset: int,
        limit: int,
        hash: bytes
    ):

        """
        SHA256 Hash of an uploaded file, to be checked for validity after download

        Args:
            offset (int): Offset from where to start computing SHA-256 hash
            limit (int): Length
            hash (bytes): SHA-256 Hash of file chunk, to be checked for validity after download
        """

        self.offset = offset
        self.limit = limit
        self.hash = hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\\\x03\x9b\xf3' if boxed else b'') as writer:
            writer.long(self.offset)
            writer.int(self.limit)
            writer.bytes(self.hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.long()
        limit_ = reader.int()
        hash_ = reader.bytes()

        return cls(
            offset=offset_,
            limit=limit_,
            hash=hash_
        )

TypeFileHash = FileHash