
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .chat_photo import TypeChatPhoto
    from ...gadgets.byteutils import Reader


class Folder(TLObject, family='TypeFolder'):
    """
    Folder
    """

    _id = 0XFF544E65
    _group_id = 0X20676440

    def __init__(
        self,
        id: int,
        title: str,
        autofill_new_broadcasts: bool = False,
        autofill_public_groups: bool = False,
        autofill_new_correspondents: bool = False,
        photo: Optional['TypeChatPhoto'] = None
    ):

        """
        Folder

        Args:
            id (int): Folder ID
            title (str): Folder title
            autofill_new_broadcasts (bool, optional): Automatically add new channels to this folder
            autofill_public_groups (bool, optional): Automatically add joined new public supergroups to this folder
            autofill_new_correspondents (bool, optional): Automatically add new private chats to this folder
            photo (Optional['TypeChatPhoto'], optional): Folder picture
        """

        self.id = id
        self.title = title
        self.autofill_new_broadcasts = autofill_new_broadcasts
        self.autofill_public_groups = autofill_public_groups
        self.autofill_new_correspondents = autofill_new_correspondents
        self.photo = photo

    def to_bytes(self, boxed: bool=True):
        with Writer(b'eNT\xff' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.autofill_new_broadcasts, 0)
                flags(self.autofill_public_groups, 1)
                flags(self.autofill_new_correspondents, 2)
                writer.int(self.id)
                writer.string(self.title)

                if flags(self.photo, 3):
                    writer.object(
                        self.photo,
                        group_id=0XFC7FED8C
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.int()
        title_ = reader.string()
        photo_ = (
            reader.object(
                group_id=0XFC7FED8C
            )
            if flags(3) else None
        )

        return cls(
            id=id_,
            title=title_,
            autofill_new_broadcasts=flags(0),
            autofill_public_groups=flags(1),
            autofill_new_correspondents=flags(2),
            photo=photo_
        )

TypeFolder = Folder