
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class GeoPointEmpty(TLObject, family='TypeGeoPoint'):
    """
    Empty constructor.
    """

    _id = 0X1117DD5F
    _group_id = 0X9248B41D


    def to_bytes(self, boxed: bool=True):
        return b'_\xdd\x17\x11' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class GeoPoint(TLObject, family='TypeGeoPoint'):
    """
    GeoPoint.
    """

    _id = 0XB2A2F663
    _group_id = 0X9248B41D

    def __init__(
        self,
        long: float,
        lat: float,
        access_hash: int,
        accuracy_radius: Optional[int] = None
    ):

        """
        GeoPoint.

        Args:
            long (float): Longitude
            lat (float): Latitude
            access_hash (int): Access hash
            accuracy_radius (Optional[int], optional): The estimated horizontal accuracy of the location, in meters; as defined by the sender.
        """

        self.long = long
        self.lat = lat
        self.access_hash = access_hash
        self.accuracy_radius = accuracy_radius

    def to_bytes(self, boxed: bool=True):
        with Writer(b'c\xf6\xa2\xb2' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.double(self.long)
                writer.double(self.lat)
                writer.long(self.access_hash)

                if flags(self.accuracy_radius, 0):
                    writer.int(self.accuracy_radius)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        long_ = reader.double()
        lat_ = reader.double()
        access_hash_ = reader.long()
        accuracy_radius_ = (
            reader.int()
            if flags(0) else None
        )

        return cls(
            long=long_,
            lat=lat_,
            access_hash=access_hash_,
            accuracy_radius=accuracy_radius_
        )

TypeGeoPoint = Union[
    GeoPointEmpty,
    GeoPoint
]