
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from ...gadgets.byteutils import Reader
    from .group_call_participant_video import TypeGroupCallParticipantVideo


class GroupCallParticipant(TLObject, family='TypeGroupCallParticipant'):
    """
    Info about a group call participant
    """

    _id = 0XEBA636FE
    _group_id = 0XC404CB69

    def __init__(
        self,
        peer: 'TypePeer',
        date: int,
        source: int,
        muted: bool = False,
        left: bool = False,
        can_self_unmute: bool = False,
        just_joined: bool = False,
        versioned: bool = False,
        min: bool = False,
        muted_by_you: bool = False,
        volume_by_admin: bool = False,
        is_self: bool = False,
        video_joined: bool = False,
        active_date: Optional[int] = None,
        volume: Optional[int] = None,
        about: Optional[str] = None,
        raise_hand_rating: Optional[int] = None,
        video: Optional['TypeGroupCallParticipantVideo'] = None,
        presentation: Optional['TypeGroupCallParticipantVideo'] = None
    ):

        """
        Info about a group call participant

        Args:
            peer ('TypePeer'): Peer information
            date (int): When did this participant join the group call
            source (int): Source ID
            muted (bool, optional): Whether the participant is muted
            left (bool, optional): Whether the participant has left
            can_self_unmute (bool, optional): Whether the participant can unmute themselves
            just_joined (bool, optional): Whether the participant has just joined
            versioned (bool, optional): If set, and [updateGroupCallParticipants](https://core.telegram.org/constructor/updateGroupCallParticipants).version < locally stored call.version, info about this participant should be ignored. If (...), and [updateGroupCallParticipants](https://core.telegram.org/constructor/updateGroupCallParticipants).version > call.version+1, the participant list should be refetched using [phone.getGroupParticipants](https://core.telegram.org/method/phone.getGroupParticipants).
            min (bool, optional): If not set, the volume and muted_by_you fields can be safely used to overwrite locally cached information; otherwise, volume will contain valid information only if volume_by_admin is set both in the cache and in the received constructor.
            muted_by_you (bool, optional): Whether this participant was muted by the current user
            volume_by_admin (bool, optional): Whether our volume can only changed by an admin
            is_self (bool, optional): Whether this participant is the current user
            video_joined (bool, optional): Whether this participant is currently broadcasting video
            active_date (Optional[int], optional): When was this participant last active in the group call
            volume (Optional[int], optional): Volume, if not set the volume is set to 100%.
            about (Optional[str], optional): Info about this participant
            raise_hand_rating (Optional[int], optional): Specifies the UI visualization order of peers with raised hands: peers with a higher rating should be showed first in the list.
            video (Optional['TypeGroupCallParticipantVideo'], optional): Info about the video stream the participant is currently broadcasting
            presentation (Optional['TypeGroupCallParticipantVideo'], optional): Info about the screen sharing stream the participant is currently broadcasting
        """

        self.peer = peer
        self.date = date
        self.source = source
        self.muted = muted
        self.left = left
        self.can_self_unmute = can_self_unmute
        self.just_joined = just_joined
        self.versioned = versioned
        self.min = min
        self.muted_by_you = muted_by_you
        self.volume_by_admin = volume_by_admin
        self.is_self = is_self
        self.video_joined = video_joined
        self.active_date = active_date
        self.volume = volume
        self.about = about
        self.raise_hand_rating = raise_hand_rating
        self.video = video
        self.presentation = presentation

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfe6\xa6\xeb' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.muted, 0)
                flags(self.left, 1)
                flags(self.can_self_unmute, 2)
                flags(self.just_joined, 4)
                flags(self.versioned, 5)
                flags(self.min, 8)
                flags(self.muted_by_you, 9)
                flags(self.volume_by_admin, 10)
                flags(self.is_self, 12)
                flags(self.video_joined, 15)
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )
                writer.int(self.date)

                if flags(self.active_date, 3):
                    writer.int(self.active_date)
                writer.int(self.source)

                if flags(self.volume, 7):
                    writer.int(self.volume)

                if flags(self.about, 11):
                    writer.string(self.about)

                if flags(self.raise_hand_rating, 13):
                    writer.long(self.raise_hand_rating)

                if flags(self.video, 6):
                    writer.object(
                        self.video,
                        group_id=0X20F73385
                    )

                if flags(self.presentation, 14):
                    writer.object(
                        self.presentation,
                        group_id=0X20F73385
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        date_ = reader.int()
        active_date_ = (
            reader.int()
            if flags(3) else None
        )

        source_ = reader.int()
        volume_ = (
            reader.int()
            if flags(7) else None
        )

        about_ = (
            reader.string()
            if flags(11) else None
        )

        raise_hand_rating_ = (
            reader.long()
            if flags(13) else None
        )

        video_ = (
            reader.object(
                group_id=0X20F73385
            )
            if flags(6) else None
        )

        presentation_ = (
            reader.object(
                group_id=0X20F73385
            )
            if flags(14) else None
        )

        return cls(
            peer=peer_,
            date=date_,
            source=source_,
            muted=flags(0),
            left=flags(1),
            can_self_unmute=flags(2),
            just_joined=flags(4),
            versioned=flags(5),
            min=flags(8),
            muted_by_you=flags(9),
            volume_by_admin=flags(10),
            is_self=flags(12),
            video_joined=flags(15),
            active_date=active_date_,
            volume=volume_,
            about=about_,
            raise_hand_rating=raise_hand_rating_,
            video=video_,
            presentation=presentation_
        )

TypeGroupCallParticipant = GroupCallParticipant