
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..user import TypeUser
    from ..document import TypeDocument
    from ..message_entity import TypeMessageEntity
    from ....gadgets.byteutils import Reader
    from ..premium_subscription_option import TypePremiumSubscriptionOption


class PremiumPromo(TLObject, family='TypeHelpPremiumPromo'):
    """
    Telegram Premium promotion information
    """

    _id = 0X5334759C
    _group_id = 0X3E199A18

    def __init__(
        self,
        status_text: str,
        status_entities: List['TypeMessageEntity'],
        video_sections: List[str],
        videos: List['TypeDocument'],
        period_options: List['TypePremiumSubscriptionOption'],
        users: List['TypeUser']
    ):

        """
        Telegram Premium promotion information

        Args:
            status_text (str): Description of the current state of the user's Telegram Premium subscription
            status_entities (List['TypeMessageEntity']): [Message entities for styled text](https://core.telegram.org/api/entities)
            video_sections (List[str]): A list of [premium feature identifiers](https://core.telegram.org/api/premium), associated to each video
            videos (List['TypeDocument']): A list of videos
            period_options (List['TypePremiumSubscriptionOption']): Telegram Premium subscription options
            users (List['TypeUser']): Related user information
        """

        self.status_text = status_text
        self.status_entities = status_entities
        self.video_sections = video_sections
        self.videos = videos
        self.period_options = period_options
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9cu4S' if boxed else b'') as writer:
            writer.string(self.status_text)
            writer.vector(
                self.status_entities,
                lambda value: writer.object(
                    value,
                    group_id=0X3CDFF38A
                )
            )
            writer.vector(
                self.video_sections,
                writer.string
            )
            writer.vector(
                self.videos,
                lambda value: writer.object(
                    value,
                    group_id=0X6547BD50
                )
            )
            writer.vector(
                self.period_options,
                lambda value: writer.object(
                    value,
                    group_id=0XE19C4C61
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        status_text_ = reader.string()
        status_entities_ = reader.vector(
            lambda: reader.object(
                group_id=0X3CDFF38A
            )
        )

        video_sections_ = reader.vector(
            reader.string
        )

        videos_ = reader.vector(
            lambda: reader.object(
                group_id=0X6547BD50
            )
        )

        period_options_ = reader.vector(
            lambda: reader.object(
                group_id=0XE19C4C61
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            status_text=status_text_,
            status_entities=status_entities_,
            video_sections=video_sections_,
            videos=videos_,
            period_options=period_options_,
            users=users_
        )

TypeHelpPremiumPromo = PremiumPromo