
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Optional, Union
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..peer import TypePeer
    from ..pending_suggestion import TypePendingSuggestion
    from ....gadgets.byteutils import Reader


class PromoDataEmpty(TLObject, family='TypeHelpPromoData'):
    """
    No PSA/MTProxy info is available
    """

    _id = 0X98F6AC75
    _group_id = 0X6563E0A3

    def __init__(
        self,
        expires: int
    ):

        """
        No PSA/MTProxy info is available

        Args:
            expires (int): Re-fetch PSA/MTProxy info after the specified number of seconds
        """

        self.expires = expires

    def to_bytes(self, boxed: bool=True):
        with Writer(b'u\xac\xf6\x98' if boxed else b'') as writer:
            writer.int(self.expires)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        expires_ = reader.int()

        return cls(
            expires=expires_
        )

class PromoData(TLObject, family='TypeHelpPromoData'):
    """
    MTProxy/Public Service Announcement information
    """

    _id = 0X8A4D87A
    _group_id = 0X6563E0A3

    def __init__(
        self,
        expires: int,
        pending_suggestions: List[str],
        dismissed_suggestions: List[str],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        proxy: bool = False,
        peer: Optional['TypePeer'] = None,
        psa_type: Optional[str] = None,
        psa_message: Optional[str] = None,
        custom_pending_suggestion: Optional['TypePendingSuggestion'] = None
    ):

        """
        MTProxy/Public Service Announcement information

        Args:
            expires (int): Expiry of PSA/MTProxy info
            pending_suggestions (List[str]): ...
            dismissed_suggestions (List[str]): ...
            chats (List['TypeChat']): Chat info
            users (List['TypeUser']): User info
            proxy (bool, optional): MTProxy-related channel
            peer (Optional['TypePeer'], optional): MTProxy/PSA peer
            psa_type (Optional[str], optional): PSA type
            psa_message (Optional[str], optional): PSA message
            custom_pending_suggestion (Optional['TypePendingSuggestion'], optional): ...
        """

        self.expires = expires
        self.pending_suggestions = pending_suggestions
        self.dismissed_suggestions = dismissed_suggestions
        self.chats = chats
        self.users = users
        self.proxy = proxy
        self.peer = peer
        self.psa_type = psa_type
        self.psa_message = psa_message
        self.custom_pending_suggestion = custom_pending_suggestion

    def to_bytes(self, boxed: bool=True):
        with Writer(b'z\xd8\xa4\x08' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.proxy, 0)
                writer.int(self.expires)

                if flags(self.peer, 3):
                    writer.object(
                        self.peer,
                        group_id=0XB4DECBCA
                    )

                if flags(self.psa_type, 1):
                    writer.string(self.psa_type)

                if flags(self.psa_message, 2):
                    writer.string(self.psa_message)
                writer.vector(
                    self.pending_suggestions,
                    writer.string
                )
                writer.vector(
                    self.dismissed_suggestions,
                    writer.string
                )

                if flags(self.custom_pending_suggestion, 4):
                    writer.object(
                        self.custom_pending_suggestion,
                        group_id=0XD3F7A57A
                    )
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        expires_ = reader.int()
        peer_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(3) else None
        )

        psa_type_ = (
            reader.string()
            if flags(1) else None
        )

        psa_message_ = (
            reader.string()
            if flags(2) else None
        )

        pending_suggestions_ = reader.vector(
            reader.string
        )

        dismissed_suggestions_ = reader.vector(
            reader.string
        )

        custom_pending_suggestion_ = (
            reader.object(
                group_id=0XD3F7A57A
            )
            if flags(4) else None
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            expires=expires_,
            pending_suggestions=pending_suggestions_,
            dismissed_suggestions=dismissed_suggestions_,
            chats=chats_,
            users=users_,
            proxy=flags(0),
            peer=peer_,
            psa_type=psa_type_,
            psa_message=psa_message_,
            custom_pending_suggestion=custom_pending_suggestion_
        )

TypeHelpPromoData = Union[
    PromoDataEmpty,
    PromoData
]