
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .jsonvalue import TypeJSONValue
    from ...gadgets.byteutils import Reader


class InputAppEvent(TLObject, family='TypeInputAppEvent'):
    """
    Event that occurred in the application.
    """

    _id = 0X1D1B1245
    _group_id = 0X7A89CB50

    def __init__(
        self,
        time: float,
        type: str,
        peer: int,
        data: 'TypeJSONValue'
    ):

        """
        Event that occurred in the application.

        Args:
            time (float): Client's exact timestamp for the event
            type (str): Type of event
            peer (int): Arbitrary numeric value for more convenient selection of certain event types, or events referring to a certain object
            data ('TypeJSONValue'): Details of the event
        """

        self.time = time
        self.type = type
        self.peer = peer
        self.data = data

    def to_bytes(self, boxed: bool=True):
        with Writer(b'E\x12\x1b\x1d' if boxed else b'') as writer:
            writer.double(self.time)
            writer.string(self.type)
            writer.long(self.peer)
            writer.object(
                self.data,
                group_id=0XBBD8AEDA
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        time_ = reader.double()
        type_ = reader.string()
        peer_ = reader.long()
        data_ = reader.object(
            group_id=0XBBD8AEDA
        )

        return cls(
            time=time_,
            type=type_,
            peer=peer_,
            data=data_
        )

TypeInputAppEvent = InputAppEvent