
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_file import TypeInputFile
    from .video_size import TypeVideoSize
    from .input_photo import TypeInputPhoto
    from ...gadgets.byteutils import Reader


class InputChatPhotoEmpty(TLObject, family='TypeInputChatPhoto'):
    """
    Empty constructor, remove group photo.
    """

    _id = 0X1CA48F57
    _group_id = 0X5610625F


    def to_bytes(self, boxed: bool=True):
        return b'W\x8f\xa4\x1c' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputChatUploadedPhoto(TLObject, family='TypeInputChatPhoto'):
    """
    New photo to be set as group profile photo.
    """

    _id = 0XBDCDAEC0
    _group_id = 0X5610625F

    def __init__(
        self,
        file: Optional['TypeInputFile'] = None,
        video: Optional['TypeInputFile'] = None,
        video_start_ts: Optional[float] = None,
        video_emoji_markup: Optional['TypeVideoSize'] = None
    ):

        """
        New photo to be set as group profile photo.

        Args:
            file (Optional['TypeInputFile'], optional): File saved in parts using the method [upload.saveFilePart](https://core.telegram.org/method/upload.saveFilePart)
            video (Optional['TypeInputFile'], optional): Square video for animated profile picture
            video_start_ts (Optional[float], optional): Floating point UNIX timestamp in seconds, indicating the frame of the video/sticker that should be used as static preview; can only be used if video or video_emoji_markup is set.
            video_emoji_markup (Optional['TypeVideoSize'], optional): Animated sticker profile picture, must contain either a [videoSizeEmojiMarkup](https://core.telegram.org/constructor/videoSizeEmojiMarkup) or a [videoSizeStickerMarkup](https://core.telegram.org/constructor/videoSizeStickerMarkup) constructor.
        """

        self.file = file
        self.video = video
        self.video_start_ts = video_start_ts
        self.video_emoji_markup = video_emoji_markup

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc0\xae\xcd\xbd' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.file, 0):
                    writer.object(
                        self.file,
                        group_id=0XB7247676
                    )

                if flags(self.video, 1):
                    writer.object(
                        self.video,
                        group_id=0XB7247676
                    )

                if flags(self.video_start_ts, 2):
                    writer.double(self.video_start_ts)

                if flags(self.video_emoji_markup, 3):
                    writer.object(
                        self.video_emoji_markup,
                        group_id=0X32B0FC60
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        file_ = (
            reader.object(
                group_id=0XB7247676
            )
            if flags(0) else None
        )

        video_ = (
            reader.object(
                group_id=0XB7247676
            )
            if flags(1) else None
        )

        video_start_ts_ = (
            reader.double()
            if flags(2) else None
        )

        video_emoji_markup_ = (
            reader.object(
                group_id=0X32B0FC60
            )
            if flags(3) else None
        )

        return cls(
            file=file_,
            video=video_,
            video_start_ts=video_start_ts_,
            video_emoji_markup=video_emoji_markup_
        )

class InputChatPhoto(TLObject, family='TypeInputChatPhoto'):
    """
    Existing photo to be set as a chat profile photo.
    """

    _id = 0X8953AD37
    _group_id = 0X5610625F

    def __init__(
        self,
        id: 'TypeInputPhoto'
    ):

        """
        Existing photo to be set as a chat profile photo.

        Args:
            id ('TypeInputPhoto'): Existing photo
        """

        self.id = id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'7\xadS\x89' if boxed else b'') as writer:
            writer.object(
                self.id,
                group_id=0XB05DFB35
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.object(
            group_id=0XB05DFB35
        )

        return cls(
            id=id_
        )

TypeInputChatPhoto = Union[
    InputChatPhotoEmpty,
    InputChatUploadedPhoto,
    InputChatPhoto
]