
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class InputPeerEmpty(TLObject, family='TypeInputPeer'):
    """
    An empty constructor, no user or chat is defined.
    """

    _id = 0X7F3B18EA
    _group_id = 0X995DB9DF


    def to_bytes(self, boxed: bool=True):
        return b'\xea\x18;\x7f' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputPeerSelf(TLObject, family='TypeInputPeer'):
    """
    Defines the current user.
    """

    _id = 0X7DA07EC9
    _group_id = 0X995DB9DF


    def to_bytes(self, boxed: bool=True):
        return b'\xc9~\xa0}' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputPeerChat(TLObject, family='TypeInputPeer'):
    """
    Defines a chat for further interaction.
    """

    _id = 0X35A95CB9
    _group_id = 0X995DB9DF

    def __init__(
        self,
        chat_id: int
    ):

        """
        Defines a chat for further interaction.

        Args:
            chat_id (int): Chat identifier
        """

        self.chat_id = chat_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb9\\\xa95' if boxed else b'') as writer:
            writer.long(self.chat_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        chat_id_ = reader.long()

        return cls(
            chat_id=chat_id_
        )

class InputPeerUser(TLObject, family='TypeInputPeer'):
    """
    Defines a user for further interaction.
    """

    _id = 0XDDE8A54C
    _group_id = 0X995DB9DF

    def __init__(
        self,
        user_id: int,
        access_hash: int
    ):

        """
        Defines a user for further interaction.

        Args:
            user_id (int): User identifier
            access_hash (int): access_hash value from the [user](https://core.telegram.org/constructor/user) constructor
        """

        self.user_id = user_id
        self.access_hash = access_hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'L\xa5\xe8\xdd' if boxed else b'') as writer:
            writer.long(self.user_id)
            writer.long(self.access_hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        user_id_ = reader.long()
        access_hash_ = reader.long()

        return cls(
            user_id=user_id_,
            access_hash=access_hash_
        )

class InputPeerChannel(TLObject, family='TypeInputPeer'):
    """
    Defines a channel for further interaction.
    """

    _id = 0X27BCBBFC
    _group_id = 0X995DB9DF

    def __init__(
        self,
        channel_id: int,
        access_hash: int
    ):

        """
        Defines a channel for further interaction.

        Args:
            channel_id (int): Channel identifier
            access_hash (int): access_hash value from the [channel](https://core.telegram.org/constructor/channel) constructor
        """

        self.channel_id = channel_id
        self.access_hash = access_hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b"\xfc\xbb\xbc'" if boxed else b'') as writer:
            writer.long(self.channel_id)
            writer.long(self.access_hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        channel_id_ = reader.long()
        access_hash_ = reader.long()

        return cls(
            channel_id=channel_id_,
            access_hash=access_hash_
        )

class InputPeerUserFromMessage(TLObject, family='TypeInputPeer'):
    """
    Defines a [min](https://core.telegram.org/api/min) user that was seen in a certain message of a certain chat.
    """

    _id = 0XA87B0A1C
    _group_id = 0X995DB9DF

    def __init__(
        self,
        peer: 'TypeInputPeer',
        msg_id: int,
        user_id: int
    ):

        """
        Defines a [min](https://core.telegram.org/api/min) user that was seen in a certain message of a certain chat.

        Args:
            peer ('TypeInputPeer'): The chat where the user was seen
            msg_id (int): The message ID
            user_id (int): The identifier of the user that was seen
        """

        self.peer = peer
        self.msg_id = msg_id
        self.user_id = user_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1c\n{\xa8' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.int(self.msg_id)
            writer.long(self.user_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0X995DB9DF
        )

        msg_id_ = reader.int()
        user_id_ = reader.long()

        return cls(
            peer=peer_,
            msg_id=msg_id_,
            user_id=user_id_
        )

class InputPeerChannelFromMessage(TLObject, family='TypeInputPeer'):
    """
    Defines a [min](https://core.telegram.org/api/min) channel that was seen in a certain message of a certain chat.
    """

    _id = 0XBD2A0840
    _group_id = 0X995DB9DF

    def __init__(
        self,
        peer: 'TypeInputPeer',
        msg_id: int,
        channel_id: int
    ):

        """
        Defines a [min](https://core.telegram.org/api/min) channel that was seen in a certain message of a certain chat.

        Args:
            peer ('TypeInputPeer'): The chat where the channel's message was seen
            msg_id (int): The message ID
            channel_id (int): The identifier of the channel that was seen
        """

        self.peer = peer
        self.msg_id = msg_id
        self.channel_id = channel_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'@\x08*\xbd' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.int(self.msg_id)
            writer.long(self.channel_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0X995DB9DF
        )

        msg_id_ = reader.int()
        channel_id_ = reader.long()

        return cls(
            peer=peer_,
            msg_id=msg_id_,
            channel_id=channel_id_
        )

TypeInputPeer = Union[
    InputPeerEmpty,
    InputPeerSelf,
    InputPeerChat,
    InputPeerUser,
    InputPeerChannel,
    InputPeerUserFromMessage,
    InputPeerChannelFromMessage
]