
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Optional, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Long, Writer


if TYPE_CHECKING:
    from .input_user import TypeInputUser
    from .input_peer import TypeInputPeer
    from .text_with_entities import TypeTextWithEntities
    from ...gadgets.byteutils import Reader


class InputStorePaymentPremiumSubscription(TLObject, family='TypeInputStorePaymentPurpose'):
    """
    Info about a Telegram Premium purchase
    """

    _id = 0XA6751E66
    _group_id = 0XECBAD07B

    def __init__(
        self,
        restore: bool = False,
        upgrade: bool = False
    ):

        """
        Info about a Telegram Premium purchase

        Args:
            restore (bool, optional): Pass true if this is a restore of a Telegram Premium purchase; only for the App Store
            upgrade (bool, optional): Pass true if this is an upgrade from a monthly subscription to a yearly subscription; only for App Store
        """

        self.restore = restore
        self.upgrade = upgrade

    def to_bytes(self, boxed: bool=True):
        with Writer(b'f\x1eu\xa6' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.restore, 0)
                flags(self.upgrade, 1)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()

        return cls(
            restore=flags(0),
            upgrade=flags(1)
        )

class InputStorePaymentGiftPremium(TLObject, family='TypeInputStorePaymentPurpose'):
    """
    Info about a gifted Telegram Premium purchase
    """

    _id = 0X616F7FE8
    _group_id = 0XECBAD07B

    def __init__(
        self,
        user_id: 'TypeInputUser',
        currency: str,
        amount: int
    ):

        """
        Info about a gifted Telegram Premium purchase

        Args:
            user_id ('TypeInputUser'): The user to which the Telegram Premium subscription was gifted
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code
            amount (int): Price of the product in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
        """

        self.user_id = user_id
        self.currency = currency
        self.amount = amount

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe8\x7foa' if boxed else b'') as writer:
            writer.object(
                self.user_id,
                group_id=0XB628962F
            )
            writer.string(self.currency)
            writer.long(self.amount)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        user_id_ = reader.object(
            group_id=0XB628962F
        )

        currency_ = reader.string()
        amount_ = reader.long()

        return cls(
            user_id=user_id_,
            currency=currency_,
            amount=amount_
        )

class InputStorePaymentPremiumGiftCode(TLObject, family='TypeInputStorePaymentPurpose'):
    """
    Used to gift [Telegram Premium](https://core.telegram.org/api/premium) subscriptions only to some specific subscribers of a channel/supergroup or to some of our contacts, see [here](https://core.telegram.org/api/giveaways) for more info on giveaways and gifts.
    """

    _id = 0XFB790393
    _group_id = 0XECBAD07B

    def __init__(
        self,
        users: List['TypeInputUser'],
        currency: str,
        amount: int,
        boost_peer: Optional['TypeInputPeer'] = None,
        message: Optional['TypeTextWithEntities'] = None
    ):

        """
        Used to gift [Telegram Premium](https://core.telegram.org/api/premium) subscriptions only to some specific subscribers of a channel/supergroup or to some of our contacts, see [here](https://core.telegram.org/api/giveaways) for more info on giveaways and gifts.

        Args:
            users (List['TypeInputUser']): The users that will receive the [Telegram Premium](https://core.telegram.org/api/premium) subscriptions.
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code
            amount (int): Total price in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            boost_peer (Optional['TypeInputPeer'], optional): If set, the gifts will be sent on behalf of a channel/supergroup we are an admin of, which will also assign some [boosts](https://core.telegram.org/api/boost) to it. Otherwise, the gift will be sent directly from the currently logged in user, and we will gain some extra [boost slots](https://core.telegram.org/api/boost). See [here](https://core.telegram.org/api/giveaways) for more info on giveaways and gifts.
            message (Optional['TypeTextWithEntities'], optional): Message attached with the gift
        """

        self.users = users
        self.currency = currency
        self.amount = amount
        self.boost_peer = boost_peer
        self.message = message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x93\x03y\xfb' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0XB628962F
                    )
                )

                if flags(self.boost_peer, 0):
                    writer.object(
                        self.boost_peer,
                        group_id=0X995DB9DF
                    )
                writer.string(self.currency)
                writer.long(self.amount)

                if flags(self.message, 1):
                    writer.object(
                        self.message,
                        group_id=0X5D96896
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        users_ = reader.vector(
            lambda: reader.object(
                group_id=0XB628962F
            )
        )

        boost_peer_ = (
            reader.object(
                group_id=0X995DB9DF
            )
            if flags(0) else None
        )

        currency_ = reader.string()
        amount_ = reader.long()
        message_ = (
            reader.object(
                group_id=0X5D96896
            )
            if flags(1) else None
        )

        return cls(
            users=users_,
            currency=currency_,
            amount=amount_,
            boost_peer=boost_peer_,
            message=message_
        )

class InputStorePaymentPremiumGiveaway(TLObject, family='TypeInputStorePaymentPurpose'):
    """
    Used to pay for a [giveaway, see here](https://core.telegram.org/api/giveaways) for more info.
    """

    _id = 0X160544CA
    _group_id = 0XECBAD07B

    def __init__(
        self,
        boost_peer: 'TypeInputPeer',
        until_date: int,
        currency: str,
        amount: int,
        only_new_subscribers: bool = False,
        winners_are_visible: bool = False,
        additional_peers: Optional[List['TypeInputPeer']] = None,
        countries_iso2: Optional[List[str]] = None,
        prize_description: Optional[str] = None,
        random_id: int = None
    ):

        """
        Used to pay for a [giveaway, see here](https://core.telegram.org/api/giveaways) for more info.

        Args:
            boost_peer ('TypeInputPeer'): The channel/supergroup starting the giveaway, that the user must join to participate, that will receive the giveaway [boosts](https://core.telegram.org/api/boost); see [here](https://core.telegram.org/api/giveaways) for more info on giveaways.
            until_date (int): The end date of the giveaway, must be at most [giveaway_period_max](https://core.telegram.org/api/config#giveaway-period-max) seconds in the future; see [here](https://core.telegram.org/api/giveaways) for more info on giveaways.
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code
            amount (int): Total price in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            only_new_subscribers (bool, optional): If set, only new subscribers starting from the giveaway creation date will be able to participate to the giveaway.
            winners_are_visible (bool, optional): If set, giveaway winners are public and will be listed in a [messageMediaGiveawayResults](https://core.telegram.org/constructor/messageMediaGiveawayResults) message that will be automatically sent to the channel once the giveaway ends.
            additional_peers (Optional[List['TypeInputPeer']], optional): Additional channels that the user must join to participate to the giveaway can be specified here.
            countries_iso2 (Optional[List[str]], optional): The set of users that can participate to the giveaway can be restricted by passing here an explicit whitelist of up to [giveaway_countries_max](https://core.telegram.org/api/config#giveaway-countries-max) countries, specified as two-letter ISO 3166-1 alpha-2 country codes.
            prize_description (Optional[str], optional): Can contain a textual description of additional giveaway prizes.
            random_id (int, optional): Random ID to avoid resending the giveaway
        """

        self.boost_peer = boost_peer
        self.until_date = until_date
        self.currency = currency
        self.amount = amount
        self.only_new_subscribers = only_new_subscribers
        self.winners_are_visible = winners_are_visible
        self.additional_peers = additional_peers
        self.countries_iso2 = countries_iso2
        self.prize_description = prize_description
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xcaD\x05\x16' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.only_new_subscribers, 0)
                flags(self.winners_are_visible, 3)
                writer.object(
                    self.boost_peer,
                    group_id=0X995DB9DF
                )

                if flags(self.additional_peers, 1):
                    writer.vector(
                        self.additional_peers,
                        lambda value: writer.object(
                            value,
                            group_id=0X995DB9DF
                        )
                    )

                if flags(self.countries_iso2, 2):
                    writer.vector(
                        self.countries_iso2,
                        writer.string
                    )

                if flags(self.prize_description, 4):
                    writer.string(self.prize_description)
                writer.long(self.random_id)
                writer.int(self.until_date)
                writer.string(self.currency)
                writer.long(self.amount)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        boost_peer_ = reader.object(
            group_id=0X995DB9DF
        )

        additional_peers_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X995DB9DF
                )
            )
            if flags(1) else None
        )

        countries_iso2_ = (
            reader.vector(
                reader.string
            )
            if flags(2) else None
        )

        prize_description_ = (
            reader.string()
            if flags(4) else None
        )

        random_id_ = reader.long()
        until_date_ = reader.int()
        currency_ = reader.string()
        amount_ = reader.long()

        return cls(
            boost_peer=boost_peer_,
            random_id=random_id_,
            until_date=until_date_,
            currency=currency_,
            amount=amount_,
            only_new_subscribers=flags(0),
            winners_are_visible=flags(3),
            additional_peers=additional_peers_,
            countries_iso2=countries_iso2_,
            prize_description=prize_description_
        )

class InputStorePaymentStarsTopup(TLObject, family='TypeInputStorePaymentPurpose'):
    """
    Used to top up the [Telegram Stars balance](https://core.telegram.org/api/stars) of the current account.
    """

    _id = 0XF9A2A6CB
    _group_id = 0XECBAD07B

    def __init__(
        self,
        stars: int,
        currency: str,
        amount: int,
        spend_purpose_peer: Optional['TypeInputPeer'] = None
    ):

        """
        Used to top up the [Telegram Stars balance](https://core.telegram.org/api/stars) of the current account.

        Args:
            stars (int): Amount of stars to topup
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code
            amount (int): Total price in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            spend_purpose_peer (Optional['TypeInputPeer'], optional): ...
        """

        self.stars = stars
        self.currency = currency
        self.amount = amount
        self.spend_purpose_peer = spend_purpose_peer

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xcb\xa6\xa2\xf9' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.stars)
                writer.string(self.currency)
                writer.long(self.amount)

                if flags(self.spend_purpose_peer, 0):
                    writer.object(
                        self.spend_purpose_peer,
                        group_id=0X995DB9DF
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        stars_ = reader.long()
        currency_ = reader.string()
        amount_ = reader.long()
        spend_purpose_peer_ = (
            reader.object(
                group_id=0X995DB9DF
            )
            if flags(0) else None
        )

        return cls(
            stars=stars_,
            currency=currency_,
            amount=amount_,
            spend_purpose_peer=spend_purpose_peer_
        )

class InputStorePaymentStarsGift(TLObject, family='TypeInputStorePaymentPurpose'):
    """
    Used to gift [Telegram Stars](https://core.telegram.org/api/stars) to a friend.
    """

    _id = 0X1D741EF7
    _group_id = 0XECBAD07B

    def __init__(
        self,
        user_id: 'TypeInputUser',
        stars: int,
        currency: str,
        amount: int
    ):

        """
        Used to gift [Telegram Stars](https://core.telegram.org/api/stars) to a friend.

        Args:
            user_id ('TypeInputUser'): The user to which the stars should be gifted.
            stars (int): Amount of stars to gift
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code
            amount (int): Total price in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
        """

        self.user_id = user_id
        self.stars = stars
        self.currency = currency
        self.amount = amount

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf7\x1et\x1d' if boxed else b'') as writer:
            writer.object(
                self.user_id,
                group_id=0XB628962F
            )
            writer.long(self.stars)
            writer.string(self.currency)
            writer.long(self.amount)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        user_id_ = reader.object(
            group_id=0XB628962F
        )

        stars_ = reader.long()
        currency_ = reader.string()
        amount_ = reader.long()

        return cls(
            user_id=user_id_,
            stars=stars_,
            currency=currency_,
            amount=amount_
        )

class InputStorePaymentStarsGiveaway(TLObject, family='TypeInputStorePaymentPurpose'):
    """
    Used to pay for a [star giveaway, see here](https://core.telegram.org/api/giveaways#star-giveaways) for more info.
    """

    _id = 0X751F08FA
    _group_id = 0XECBAD07B

    def __init__(
        self,
        stars: int,
        boost_peer: 'TypeInputPeer',
        until_date: int,
        currency: str,
        amount: int,
        users: int,
        only_new_subscribers: bool = False,
        winners_are_visible: bool = False,
        additional_peers: Optional[List['TypeInputPeer']] = None,
        countries_iso2: Optional[List[str]] = None,
        prize_description: Optional[str] = None,
        random_id: int = None
    ):

        """
        Used to pay for a [star giveaway, see here](https://core.telegram.org/api/giveaways#star-giveaways) for more info.

        Args:
            stars (int): Total number of Telegram Stars being given away (each user will receive stars/users stars).
            boost_peer ('TypeInputPeer'): The channel/supergroup starting the giveaway, that the user must join to participate, that will receive the giveaway [boosts](https://core.telegram.org/api/boost); see [here](https://core.telegram.org/api/giveaways) for more info on giveaways.
            until_date (int): The end date of the giveaway, must be at most [giveaway_period_max](https://core.telegram.org/api/config#giveaway-period-max) seconds in the future; see [here](https://core.telegram.org/api/giveaways) for more info on giveaways.
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code
            amount (int): Total price in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            users (int): Number of winners.
            only_new_subscribers (bool, optional): If set, only new subscribers starting from the giveaway creation date will be able to participate to the giveaway.
            winners_are_visible (bool, optional): If set, giveaway winners are public and will be listed in a [messageMediaGiveawayResults](https://core.telegram.org/constructor/messageMediaGiveawayResults) message that will be automatically sent to the channel once the giveaway ends.
            additional_peers (Optional[List['TypeInputPeer']], optional): Additional channels that the user must join to participate to the giveaway can be specified here.
            countries_iso2 (Optional[List[str]], optional): The set of users that can participate to the giveaway can be restricted by passing here an explicit whitelist of up to [giveaway_countries_max](https://core.telegram.org/api/config#giveaway-countries-max) countries, specified as two-letter ISO 3166-1 alpha-2 country codes.
            prize_description (Optional[str], optional): Can contain a textual description of additional giveaway prizes.
            random_id (int, optional): Random ID to avoid resending the giveaway
        """

        self.stars = stars
        self.boost_peer = boost_peer
        self.until_date = until_date
        self.currency = currency
        self.amount = amount
        self.users = users
        self.only_new_subscribers = only_new_subscribers
        self.winners_are_visible = winners_are_visible
        self.additional_peers = additional_peers
        self.countries_iso2 = countries_iso2
        self.prize_description = prize_description
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfa\x08\x1fu' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.only_new_subscribers, 0)
                flags(self.winners_are_visible, 3)
                writer.long(self.stars)
                writer.object(
                    self.boost_peer,
                    group_id=0X995DB9DF
                )

                if flags(self.additional_peers, 1):
                    writer.vector(
                        self.additional_peers,
                        lambda value: writer.object(
                            value,
                            group_id=0X995DB9DF
                        )
                    )

                if flags(self.countries_iso2, 2):
                    writer.vector(
                        self.countries_iso2,
                        writer.string
                    )

                if flags(self.prize_description, 4):
                    writer.string(self.prize_description)
                writer.long(self.random_id)
                writer.int(self.until_date)
                writer.string(self.currency)
                writer.long(self.amount)
                writer.int(self.users)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        stars_ = reader.long()
        boost_peer_ = reader.object(
            group_id=0X995DB9DF
        )

        additional_peers_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X995DB9DF
                )
            )
            if flags(1) else None
        )

        countries_iso2_ = (
            reader.vector(
                reader.string
            )
            if flags(2) else None
        )

        prize_description_ = (
            reader.string()
            if flags(4) else None
        )

        random_id_ = reader.long()
        until_date_ = reader.int()
        currency_ = reader.string()
        amount_ = reader.long()
        users_ = reader.int()

        return cls(
            stars=stars_,
            boost_peer=boost_peer_,
            random_id=random_id_,
            until_date=until_date_,
            currency=currency_,
            amount=amount_,
            users=users_,
            only_new_subscribers=flags(0),
            winners_are_visible=flags(3),
            additional_peers=additional_peers_,
            countries_iso2=countries_iso2_,
            prize_description=prize_description_
        )

class InputStorePaymentAuthCode(TLObject, family='TypeInputStorePaymentPurpose'):
    _id = 0X9BB2636D
    _group_id = 0XECBAD07B

    def __init__(
        self,
        phone_number: str,
        phone_code_hash: str,
        currency: str,
        amount: int,
        restore: bool = False
    ):

        self.phone_number = phone_number
        self.phone_code_hash = phone_code_hash
        self.currency = currency
        self.amount = amount
        self.restore = restore

    def to_bytes(self, boxed: bool=True):
        with Writer(b'mc\xb2\x9b' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.restore, 0)
                writer.string(self.phone_number)
                writer.string(self.phone_code_hash)
                writer.string(self.currency)
                writer.long(self.amount)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        phone_number_ = reader.string()
        phone_code_hash_ = reader.string()
        currency_ = reader.string()
        amount_ = reader.long()

        return cls(
            phone_number=phone_number_,
            phone_code_hash=phone_code_hash_,
            currency=currency_,
            amount=amount_,
            restore=flags(0)
        )

TypeInputStorePaymentPurpose = Union[
    InputStorePaymentPremiumSubscription,
    InputStorePaymentGiftPremium,
    InputStorePaymentPremiumGiftCode,
    InputStorePaymentPremiumGiveaway,
    InputStorePaymentStarsTopup,
    InputStorePaymentStarsGift,
    InputStorePaymentStarsGiveaway,
    InputStorePaymentAuthCode
]