
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_user import TypeInputUser
    from ...gadgets.byteutils import Reader


class MessageEntityUnknown(TLObject, family='TypeMessageEntity'):
    """
    Unknown message entity
    """

    _id = 0XBB92BA95
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int
    ):

        """
        Unknown message entity

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
        """

        self.offset = offset
        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x95\xba\x92\xbb' if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()

        return cls(
            offset=offset_,
            length=length_
        )

class MessageEntityMention(TLObject, family='TypeMessageEntity'):
    """
    Message entity [mentioning](https://core.telegram.org/api/mentions) a user by @username; [messageEntityMentionName](https://core.telegram.org/constructor/messageEntityMentionName) can also be used to mention users by their ID.
    """

    _id = 0XFA04579D
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int
    ):

        """
        Message entity [mentioning](https://core.telegram.org/api/mentions) a user by @username; [messageEntityMentionName](https://core.telegram.org/constructor/messageEntityMentionName) can also be used to mention users by their ID.

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
        """

        self.offset = offset
        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9dW\x04\xfa' if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()

        return cls(
            offset=offset_,
            length=length_
        )

class MessageEntityHashtag(TLObject, family='TypeMessageEntity'):
    """
    #hashtag message entity
    """

    _id = 0X6F635B0D
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int
    ):

        """
        #hashtag message entity

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
        """

        self.offset = offset
        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\r[co' if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()

        return cls(
            offset=offset_,
            length=length_
        )

class MessageEntityBotCommand(TLObject, family='TypeMessageEntity'):
    """
    Message entity representing a bot /command
    """

    _id = 0X6CEF8AC7
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int
    ):

        """
        Message entity representing a bot /command

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
        """

        self.offset = offset
        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc7\x8a\xefl' if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()

        return cls(
            offset=offset_,
            length=length_
        )

class MessageEntityUrl(TLObject, family='TypeMessageEntity'):
    """
    Message entity representing an in-text url: [https://google.com](https://google.com); for [text urls](https://google.com), use [messageEntityTextUrl](https://core.telegram.org/constructor/messageEntityTextUrl).
    """

    _id = 0X6ED02538
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int
    ):

        """
        Message entity representing an in-text url: [https://google.com](https://google.com); for [text urls](https://google.com), use [messageEntityTextUrl](https://core.telegram.org/constructor/messageEntityTextUrl).

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
        """

        self.offset = offset
        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'8%\xd0n' if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()

        return cls(
            offset=offset_,
            length=length_
        )

class MessageEntityEmail(TLObject, family='TypeMessageEntity'):
    """
    Message entity representing an [email@example.com](mailto:email@example.com).
    """

    _id = 0X64E475C2
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int
    ):

        """
        Message entity representing an [email@example.com](mailto:email@example.com).

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
        """

        self.offset = offset
        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc2u\xe4d' if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()

        return cls(
            offset=offset_,
            length=length_
        )

class MessageEntityBold(TLObject, family='TypeMessageEntity'):
    """
    Message entity representing bold text.
    """

    _id = 0XBD610BC9
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int
    ):

        """
        Message entity representing bold text.

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
        """

        self.offset = offset
        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc9\x0ba\xbd' if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()

        return cls(
            offset=offset_,
            length=length_
        )

class MessageEntityItalic(TLObject, family='TypeMessageEntity'):
    """
    Message entity representing italic text.
    """

    _id = 0X826F8B60
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int
    ):

        """
        Message entity representing italic text.

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
        """

        self.offset = offset
        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'`\x8bo\x82' if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()

        return cls(
            offset=offset_,
            length=length_
        )

class MessageEntityCode(TLObject, family='TypeMessageEntity'):
    """
    Message entity representing a codeblock.
    """

    _id = 0X28A20571
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int
    ):

        """
        Message entity representing a codeblock.

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
        """

        self.offset = offset
        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'q\x05\xa2(' if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()

        return cls(
            offset=offset_,
            length=length_
        )

class MessageEntityPre(TLObject, family='TypeMessageEntity'):
    """
    Message entity representing a preformatted codeblock, allowing the user to specify a programming language for the codeblock.
    """

    _id = 0X73924BE0
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int,
        language: str
    ):

        """
        Message entity representing a preformatted codeblock, allowing the user to specify a programming language for the codeblock.

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            language (str): Programming language of the code
        """

        self.offset = offset
        self.length = length
        self.language = language

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe0K\x92s' if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)
            writer.string(self.language)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()
        language_ = reader.string()

        return cls(
            offset=offset_,
            length=length_,
            language=language_
        )

class MessageEntityTextUrl(TLObject, family='TypeMessageEntity'):
    """
    Message entity representing a [text url](https://google.com): for in-text urls like [https://google.com](https://google.com) use [messageEntityUrl](https://core.telegram.org/constructor/messageEntityUrl).
    """

    _id = 0X76A6D327
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int,
        url: str
    ):

        """
        Message entity representing a [text url](https://google.com): for in-text urls like [https://google.com](https://google.com) use [messageEntityUrl](https://core.telegram.org/constructor/messageEntityUrl).

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            url (str): The actual URL
        """

        self.offset = offset
        self.length = length
        self.url = url

    def to_bytes(self, boxed: bool=True):
        with Writer(b"'\xd3\xa6v" if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)
            writer.string(self.url)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()
        url_ = reader.string()

        return cls(
            offset=offset_,
            length=length_,
            url=url_
        )

class MessageEntityMentionName(TLObject, family='TypeMessageEntity'):
    """
    Message entity representing a [user mention](https://core.telegram.org/api/mentions): for creating a mention use [inputMessageEntityMentionName](https://core.telegram.org/constructor/inputMessageEntityMentionName).
    """

    _id = 0XDC7B1140
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int,
        user_id: int
    ):

        """
        Message entity representing a [user mention](https://core.telegram.org/api/mentions): for creating a mention use [inputMessageEntityMentionName](https://core.telegram.org/constructor/inputMessageEntityMentionName).

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            user_id (int): Identifier of the user that was mentioned
        """

        self.offset = offset
        self.length = length
        self.user_id = user_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'@\x11{\xdc' if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)
            writer.long(self.user_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()
        user_id_ = reader.long()

        return cls(
            offset=offset_,
            length=length_,
            user_id=user_id_
        )

class InputMessageEntityMentionName(TLObject, family='TypeMessageEntity'):
    """
    Message entity that can be used to create a user [user mention](https://core.telegram.org/api/mentions): received mentions use the [messageEntityMentionName](https://core.telegram.org/constructor/messageEntityMentionName) constructor, instead.
    """

    _id = 0X208E68C9
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int,
        user_id: 'TypeInputUser'
    ):

        """
        Message entity that can be used to create a user [user mention](https://core.telegram.org/api/mentions): received mentions use the [messageEntityMentionName](https://core.telegram.org/constructor/messageEntityMentionName) constructor, instead.

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            user_id ('TypeInputUser'): Identifier of the user that was mentioned
        """

        self.offset = offset
        self.length = length
        self.user_id = user_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc9h\x8e ' if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)
            writer.object(
                self.user_id,
                group_id=0XB628962F
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()
        user_id_ = reader.object(
            group_id=0XB628962F
        )

        return cls(
            offset=offset_,
            length=length_,
            user_id=user_id_
        )

class MessageEntityPhone(TLObject, family='TypeMessageEntity'):
    """
    Message entity representing a phone number.
    """

    _id = 0X9B69E34B
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int
    ):

        """
        Message entity representing a phone number.

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
        """

        self.offset = offset
        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'K\xe3i\x9b' if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()

        return cls(
            offset=offset_,
            length=length_
        )

class MessageEntityCashtag(TLObject, family='TypeMessageEntity'):
    """
    Message entity representing a $cashtag.
    """

    _id = 0X4C4E743F
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int
    ):

        """
        Message entity representing a $cashtag.

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
        """

        self.offset = offset
        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'?tNL' if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()

        return cls(
            offset=offset_,
            length=length_
        )

class MessageEntityUnderline(TLObject, family='TypeMessageEntity'):
    """
    Message entity representing underlined text.
    """

    _id = 0X9C4E7E8B
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int
    ):

        """
        Message entity representing underlined text.

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
        """

        self.offset = offset
        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x8b~N\x9c' if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()

        return cls(
            offset=offset_,
            length=length_
        )

class MessageEntityStrike(TLObject, family='TypeMessageEntity'):
    """
    Message entity representing strikethrough text.
    """

    _id = 0XBF0693D4
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int
    ):

        """
        Message entity representing strikethrough text.

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
        """

        self.offset = offset
        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd4\x93\x06\xbf' if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()

        return cls(
            offset=offset_,
            length=length_
        )

class MessageEntityBankCard(TLObject, family='TypeMessageEntity'):
    """
    Indicates a credit card number
    """

    _id = 0X761E6AF4
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int
    ):

        """
        Indicates a credit card number

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
        """

        self.offset = offset
        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf4j\x1ev' if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()

        return cls(
            offset=offset_,
            length=length_
        )

class MessageEntitySpoiler(TLObject, family='TypeMessageEntity'):
    """
    Message entity representing a spoiler
    """

    _id = 0X32CA960F
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int
    ):

        """
        Message entity representing a spoiler

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
        """

        self.offset = offset
        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x0f\x96\xca2' if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()

        return cls(
            offset=offset_,
            length=length_
        )

class MessageEntityCustomEmoji(TLObject, family='TypeMessageEntity'):
    """
    Represents a custom emoji. 
    Note that this entity must wrap exactly one regular emoji (the one contained in [documentAttributeCustomEmoji](https://core.telegram.org/constructor/documentAttributeCustomEmoji). alt) in the related text, otherwise the server will ignore it.
    """

    _id = 0XC8CF05F8
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int,
        document_id: int
    ):

        """
        Represents a custom emoji. 
        Note that this entity must wrap exactly one regular emoji (the one contained in [documentAttributeCustomEmoji](https://core.telegram.org/constructor/documentAttributeCustomEmoji). alt) in the related text, otherwise the server will ignore it.

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            document_id (int): Document ID of the [custom emoji](https://core.telegram.org/api/custom-emoji), use [messages.getCustomEmojiDocuments](https://core.telegram.org/method/messages.getCustomEmojiDocuments) to fetch the emoji animation and the actual emoji it represents.
        """

        self.offset = offset
        self.length = length
        self.document_id = document_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf8\x05\xcf\xc8' if boxed else b'') as writer:
            writer.int(self.offset)
            writer.int(self.length)
            writer.long(self.document_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        offset_ = reader.int()
        length_ = reader.int()
        document_id_ = reader.long()

        return cls(
            offset=offset_,
            length=length_,
            document_id=document_id_
        )

class MessageEntityBlockquote(TLObject, family='TypeMessageEntity'):
    """
    Message entity representing a block quote.
    """

    _id = 0XF1CCAAAC
    _group_id = 0X3CDFF38A

    def __init__(
        self,
        offset: int,
        length: int,
        collapsed: bool = False
    ):

        """
        Message entity representing a block quote.

        Args:
            offset (int): Offset of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            length (int): Length of message entity within message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length))
            collapsed (bool, optional): Whether the quote is collapsed by default.
        """

        self.offset = offset
        self.length = length
        self.collapsed = collapsed

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xac\xaa\xcc\xf1' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.collapsed, 0)
                writer.int(self.offset)
                writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        offset_ = reader.int()
        length_ = reader.int()

        return cls(
            offset=offset_,
            length=length_,
            collapsed=flags(0)
        )

TypeMessageEntity = Union[
    MessageEntityUnknown,
    MessageEntityMention,
    MessageEntityHashtag,
    MessageEntityBotCommand,
    MessageEntityUrl,
    MessageEntityEmail,
    MessageEntityBold,
    MessageEntityItalic,
    MessageEntityCode,
    MessageEntityPre,
    MessageEntityTextUrl,
    MessageEntityMentionName,
    InputMessageEntityMentionName,
    MessageEntityPhone,
    MessageEntityCashtag,
    MessageEntityUnderline,
    MessageEntityStrike,
    MessageEntityBankCard,
    MessageEntitySpoiler,
    MessageEntityCustomEmoji,
    MessageEntityBlockquote
]