
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Union
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..sticker_set import TypeStickerSet
    from ....gadgets.byteutils import Reader


class AllStickersNotModified(TLObject, family='TypeMessagesAllStickers'):
    """
    Info about all installed stickers hasn't changed
    """

    _id = 0XE86602C3
    _group_id = 0XD7967EB6


    def to_bytes(self, boxed: bool=True):
        return b'\xc3\x02f\xe8' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class AllStickers(TLObject, family='TypeMessagesAllStickers'):
    """
    Info about all installed stickers
    """

    _id = 0XCDBBCEBB
    _group_id = 0XD7967EB6

    def __init__(
        self,
        hash: int,
        sets: List['TypeStickerSet']
    ):

        """
        Info about all installed stickers

        Args:
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
            sets (List['TypeStickerSet']): All stickersets
        """

        self.hash = hash
        self.sets = sets

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xbb\xce\xbb\xcd' if boxed else b'') as writer:
            writer.long(self.hash)
            writer.vector(
                self.sets,
                lambda value: writer.object(
                    value,
                    group_id=0X8EED6744
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        hash_ = reader.long()
        sets_ = reader.vector(
            lambda: reader.object(
                group_id=0X8EED6744
            )
        )

        return cls(
            hash=hash_,
            sets=sets_
        )

TypeMessagesAllStickers = Union[
    AllStickersNotModified,
    AllStickers
]