
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Union
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ....gadgets.byteutils import Reader


class Chats(TLObject, family='TypeMessagesChats'):
    """
    List of chats with auxiliary data.
    """

    _id = 0X64FF9FD5
    _group_id = 0X23A4AC0E

    def __init__(
        self,
        chats: List['TypeChat']
    ):

        """
        List of chats with auxiliary data.

        Args:
            chats (List['TypeChat']): List of chats
        """

        self.chats = chats

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd5\x9f\xffd' if boxed else b'') as writer:
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        return cls(
            chats=chats_
        )

class ChatsSlice(TLObject, family='TypeMessagesChats'):
    """
    Partial list of chats, more would have to be fetched with [pagination](https://core.telegram.org/api/offsets)
    """

    _id = 0X9CD81144
    _group_id = 0X23A4AC0E

    def __init__(
        self,
        count: int,
        chats: List['TypeChat']
    ):

        """
        Partial list of chats, more would have to be fetched with [pagination](https://core.telegram.org/api/offsets)

        Args:
            count (int): Total number of results that were found server-side (not all are included in chats)
            chats (List['TypeChat']): Chats
        """

        self.count = count
        self.chats = chats

    def to_bytes(self, boxed: bool=True):
        with Writer(b'D\x11\xd8\x9c' if boxed else b'') as writer:
            writer.int(self.count)
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        count_ = reader.int()
        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        return cls(
            count=count_,
            chats=chats_
        )

TypeMessagesChats = Union[
    Chats,
    ChatsSlice
]