
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ....gadgets.byteutils import Reader


class DhConfigNotModified(TLObject, family='TypeMessagesDhConfig'):
    """
    Configuring parameters did not change.
    """

    _id = 0XC0E24635
    _group_id = 0XF887775D

    def __init__(
        self,
        random: bytes
    ):

        """
        Configuring parameters did not change.

        Args:
            random (bytes): Random sequence of bytes of assigned length
        """

        self.random = random

    def to_bytes(self, boxed: bool=True):
        with Writer(b'5F\xe2\xc0' if boxed else b'') as writer:
            writer.bytes(self.random)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        random_ = reader.bytes()

        return cls(
            random=random_
        )

class DhConfig(TLObject, family='TypeMessagesDhConfig'):
    """
    New set of configuring parameters.
    """

    _id = 0X2C221EDD
    _group_id = 0XF887775D

    def __init__(
        self,
        g: int,
        p: bytes,
        version: int,
        random: bytes
    ):

        """
        New set of configuring parameters.

        Args:
            g (int): New value prime, see [Wikipedia](https://en.wikipedia.org/wiki/Diffie%E2%80%93Hellman_key_exchange)
            p (bytes): New value primitive root, see [Wikipedia](https://en.wikipedia.org/wiki/Diffie%E2%80%93Hellman_key_exchange)
            version (int): Version of set of parameters
            random (bytes): Random sequence of bytes of assigned length
        """

        self.g = g
        self.p = p
        self.version = version
        self.random = random

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xdd\x1e",' if boxed else b'') as writer:
            writer.int(self.g)
            writer.bytes(self.p)
            writer.int(self.version)
            writer.bytes(self.random)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        g_ = reader.int()
        p_ = reader.bytes()
        version_ = reader.int()
        random_ = reader.bytes()

        return cls(
            g=g_,
            p=p_,
            version=version_,
            random=random_
        )

TypeMessagesDhConfig = Union[
    DhConfigNotModified,
    DhConfig
]