
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..user import TypeUser
    from ....gadgets.byteutils import Reader
    from ..exported_chat_invite import TypeExportedChatInvite


class ExportedChatInvites(TLObject, family='TypeMessagesExportedChatInvites'):
    """
    Info about chat invites exported by a certain admin.
    """

    _id = 0XBDC62DCC
    _group_id = 0XA5F3E91C

    def __init__(
        self,
        count: int,
        invites: List['TypeExportedChatInvite'],
        users: List['TypeUser']
    ):

        """
        Info about chat invites exported by a certain admin.

        Args:
            count (int): Number of invites exported by the admin
            invites (List['TypeExportedChatInvite']): Exported invites
            users (List['TypeUser']): Info about the admin
        """

        self.count = count
        self.invites = invites
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xcc-\xc6\xbd' if boxed else b'') as writer:
            writer.int(self.count)
            writer.vector(
                self.invites,
                lambda value: writer.object(
                    value,
                    group_id=0X4C7FB2E0
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        count_ = reader.int()
        invites_ = reader.vector(
            lambda: reader.object(
                group_id=0X4C7FB2E0
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            count=count_,
            invites=invites_,
            users=users_
        )

TypeMessagesExportedChatInvites = ExportedChatInvites