
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ....gadgets.byteutils import Reader


class InactiveChats(TLObject, family='TypeMessagesInactiveChats'):
    """
    Inactive chat list
    """

    _id = 0XA927FEC5
    _group_id = 0XB290468D

    def __init__(
        self,
        dates: List[int],
        chats: List['TypeChat'],
        users: List['TypeUser']
    ):

        """
        Inactive chat list

        Args:
            dates (List[int]): When was the chat last active
            chats (List['TypeChat']): Chat list
            users (List['TypeUser']): Users mentioned in the chat list
        """

        self.dates = dates
        self.chats = chats
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b"\xc5\xfe'\xa9" if boxed else b'') as writer:
            writer.vector(
                self.dates,
                writer.int
            )
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        dates_ = reader.vector(
            reader.int
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            dates=dates_,
            chats=chats_,
            users=users_
        )

TypeMessagesInactiveChats = InactiveChats