
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class NotificationSoundDefault(TLObject, family='TypeNotificationSound'):
    """
    Indicates the default notification sound should be used
    """

    _id = 0X97E8BEBE
    _group_id = 0X9B633486


    def to_bytes(self, boxed: bool=True):
        return b'\xbe\xbe\xe8\x97' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class NotificationSoundNone(TLObject, family='TypeNotificationSound'):
    """
    No notification sound should be used
    """

    _id = 0X6F0C34DF
    _group_id = 0X9B633486


    def to_bytes(self, boxed: bool=True):
        return b'\xdf4\x0co' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class NotificationSoundLocal(TLObject, family='TypeNotificationSound'):
    """
    Indicates a specific local notification sound should be used
    """

    _id = 0X830B9AE4
    _group_id = 0X9B633486

    def __init__(
        self,
        title: str,
        data: str
    ):

        """
        Indicates a specific local notification sound should be used

        Args:
            title (str): Notification sound title
            data (str): Notification sound identifier (arbitrary data used by the client to identify a specific local notification sound)
        """

        self.title = title
        self.data = data

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe4\x9a\x0b\x83' if boxed else b'') as writer:
            writer.string(self.title)
            writer.string(self.data)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        title_ = reader.string()
        data_ = reader.string()

        return cls(
            title=title_,
            data=data_
        )

class NotificationSoundRingtone(TLObject, family='TypeNotificationSound'):
    """
    A specific previously uploaded notification sound should be used
    """

    _id = 0XFF6C8049
    _group_id = 0X9B633486

    def __init__(
        self,
        id: int
    ):

        """
        A specific previously uploaded notification sound should be used

        Args:
            id (int): Document ID of notification sound uploaded using [account.uploadRingtone](https://core.telegram.org/method/account.uploadRingtone)
        """

        self.id = id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'I\x80l\xff' if boxed else b'') as writer:
            writer.long(self.id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()

        return cls(
            id=id_
        )

TypeNotificationSound = Union[
    NotificationSoundDefault,
    NotificationSoundNone,
    NotificationSoundLocal,
    NotificationSoundRingtone
]