
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from ...gadgets.byteutils import Reader


class PeerLocated(TLObject, family='TypePeerLocated'):
    """
    Peer geolocated nearby
    """

    _id = 0XCA461B5D
    _group_id = 0XC572C6F

    def __init__(
        self,
        peer: 'TypePeer',
        expires: int,
        distance: int
    ):

        """
        Peer geolocated nearby

        Args:
            peer ('TypePeer'): Peer
            expires (int): Validity period of current data
            distance (int): Distance from the peer in meters
        """

        self.peer = peer
        self.expires = expires
        self.distance = distance

    def to_bytes(self, boxed: bool=True):
        with Writer(b']\x1bF\xca' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.int(self.expires)
            writer.int(self.distance)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        expires_ = reader.int()
        distance_ = reader.int()

        return cls(
            peer=peer_,
            expires=expires_,
            distance=distance_
        )

class PeerSelfLocated(TLObject, family='TypePeerLocated'):
    """
    Current peer
    """

    _id = 0XF8EC284B
    _group_id = 0XC572C6F

    def __init__(
        self,
        expires: int
    ):

        """
        Current peer

        Args:
            expires (int): Expiry of geolocation info for current peer
        """

        self.expires = expires

    def to_bytes(self, boxed: bool=True):
        with Writer(b'K(\xec\xf8' if boxed else b'') as writer:
            writer.int(self.expires)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        expires_ = reader.int()

        return cls(
            expires=expires_
        )

TypePeerLocated = Union[
    PeerLocated,
    PeerSelfLocated
]