
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ....gadgets.byteutils import Reader
    from ..group_call_participant import TypeGroupCallParticipant


class GroupParticipants(TLObject, family='TypePhoneGroupParticipants'):
    """
    Info about the participants of a group call or livestream
    """

    _id = 0XF47751B6
    _group_id = 0X752DA8B2

    def __init__(
        self,
        count: int,
        participants: List['TypeGroupCallParticipant'],
        next_offset: str,
        chats: List['TypeChat'],
        users: List['TypeUser'],
        version: int
    ):

        """
        Info about the participants of a group call or livestream

        Args:
            count (int): Number of participants
            participants (List['TypeGroupCallParticipant']): List of participants
            next_offset (str): If not empty, the specified list of participants is partial, and more participants can be fetched specifying this parameter as offset in [phone.getGroupParticipants](https://core.telegram.org/method/phone.getGroupParticipants).
            chats (List['TypeChat']): Mentioned chats
            users (List['TypeUser']): Mentioned users
            version (int): Version info
        """

        self.count = count
        self.participants = participants
        self.next_offset = next_offset
        self.chats = chats
        self.users = users
        self.version = version

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb6Qw\xf4' if boxed else b'') as writer:
            writer.int(self.count)
            writer.vector(
                self.participants,
                lambda value: writer.object(
                    value,
                    group_id=0XC404CB69
                )
            )
            writer.string(self.next_offset)
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )
            writer.int(self.version)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        count_ = reader.int()
        participants_ = reader.vector(
            lambda: reader.object(
                group_id=0XC404CB69
            )
        )

        next_offset_ = reader.string()
        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        version_ = reader.int()

        return cls(
            count=count_,
            participants=participants_,
            next_offset=next_offset_,
            chats=chats_,
            users=users_,
            version=version_
        )

TypePhoneGroupParticipants = GroupParticipants