
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..peer import TypePeer
    from ..chat import TypeChat
    from ..user import TypeUser
    from ....gadgets.byteutils import Reader


class JoinAsPeers(TLObject, family='TypePhoneJoinAsPeers'):
    """
    A list of peers that can be used to join a group call, presenting yourself as a specific user/channel.
    """

    _id = 0XAFE5623F
    _group_id = 0X4779BF6E

    def __init__(
        self,
        peers: List['TypePeer'],
        chats: List['TypeChat'],
        users: List['TypeUser']
    ):

        """
        A list of peers that can be used to join a group call, presenting yourself as a specific user/channel.

        Args:
            peers (List['TypePeer']): Peers
            chats (List['TypeChat']): Chats mentioned in the peers vector
            users (List['TypeUser']): Users mentioned in the peers vector
        """

        self.peers = peers
        self.chats = chats
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'?b\xe5\xaf' if boxed else b'') as writer:
            writer.vector(
                self.peers,
                lambda value: writer.object(
                    value,
                    group_id=0XB4DECBCA
                )
            )
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peers_ = reader.vector(
            lambda: reader.object(
                group_id=0XB4DECBCA
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            peers=peers_,
            chats=chats_,
            users=users_
        )

TypePhoneJoinAsPeers = JoinAsPeers