
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class PhotoSizeEmpty(TLObject, family='TypePhotoSize'):
    """
    Empty constructor. Image with this thumbnail is unavailable.
    """

    _id = 0XE17E23C
    _group_id = 0X478D00B0

    def __init__(
        self,
        type: str
    ):

        """
        Empty constructor. Image with this thumbnail is unavailable.

        Args:
            type (str): [Thumbnail type](https://core.telegram.org/api/files#image-thumbnail-types)
        """

        self.type = type

    def to_bytes(self, boxed: bool=True):
        with Writer(b'<\xe2\x17\x0e' if boxed else b'') as writer:
            writer.string(self.type)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        type_ = reader.string()

        return cls(
            type=type_
        )

class PhotoSize(TLObject, family='TypePhotoSize'):
    """
    Image description.
    """

    _id = 0X75C78E60
    _group_id = 0X478D00B0

    def __init__(
        self,
        type: str,
        w: int,
        h: int,
        size: int
    ):

        """
        Image description.

        Args:
            type (str): [Thumbnail type](https://core.telegram.org/api/files#image-thumbnail-types)
            w (int): Image width
            h (int): Image height
            size (int): File size
        """

        self.type = type
        self.w = w
        self.h = h
        self.size = size

    def to_bytes(self, boxed: bool=True):
        with Writer(b'`\x8e\xc7u' if boxed else b'') as writer:
            writer.string(self.type)
            writer.int(self.w)
            writer.int(self.h)
            writer.int(self.size)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        type_ = reader.string()
        w_ = reader.int()
        h_ = reader.int()
        size_ = reader.int()

        return cls(
            type=type_,
            w=w_,
            h=h_,
            size=size_
        )

class PhotoCachedSize(TLObject, family='TypePhotoSize'):
    """
    Description of an image and its content.
    """

    _id = 0X21E1AD6
    _group_id = 0X478D00B0

    def __init__(
        self,
        type: str,
        w: int,
        h: int,
        bytes: bytes
    ):

        """
        Description of an image and its content.

        Args:
            type (str): Thumbnail type
            w (int): Image width
            h (int): Image height
            bytes (bytes): Binary data, file content
        """

        self.type = type
        self.w = w
        self.h = h
        self.bytes = bytes

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd6\x1a\x1e\x02' if boxed else b'') as writer:
            writer.string(self.type)
            writer.int(self.w)
            writer.int(self.h)
            writer.bytes(self.bytes)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        type_ = reader.string()
        w_ = reader.int()
        h_ = reader.int()
        bytes_ = reader.bytes()

        return cls(
            type=type_,
            w=w_,
            h=h_,
            bytes=bytes_
        )

class PhotoStrippedSize(TLObject, family='TypePhotoSize'):
    """
    A low-resolution compressed JPG payload
    """

    _id = 0XE0B0BC2E
    _group_id = 0X478D00B0

    def __init__(
        self,
        type: str,
        bytes: bytes
    ):

        """
        A low-resolution compressed JPG payload

        Args:
            type (str): Thumbnail type
            bytes (bytes): Thumbnail data, see [here for more info on decompression](https://core.telegram.org/api/files#stripped-thumbnails)
        """

        self.type = type
        self.bytes = bytes

    def to_bytes(self, boxed: bool=True):
        with Writer(b'.\xbc\xb0\xe0' if boxed else b'') as writer:
            writer.string(self.type)
            writer.bytes(self.bytes)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        type_ = reader.string()
        bytes_ = reader.bytes()

        return cls(
            type=type_,
            bytes=bytes_
        )

class PhotoSizeProgressive(TLObject, family='TypePhotoSize'):
    """
    Progressively encoded photosize
    """

    _id = 0XFA3EFB95
    _group_id = 0X478D00B0

    def __init__(
        self,
        type: str,
        w: int,
        h: int,
        sizes: List[int]
    ):

        """
        Progressively encoded photosize

        Args:
            type (str): [Photosize type](https://core.telegram.org/api/files#image-thumbnail-types)
            w (int): Photo width
            h (int): Photo height
            sizes (List[int]): Sizes of progressive JPEG file prefixes, which can be used to preliminarily show the image.
        """

        self.type = type
        self.w = w
        self.h = h
        self.sizes = sizes

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x95\xfb>\xfa' if boxed else b'') as writer:
            writer.string(self.type)
            writer.int(self.w)
            writer.int(self.h)
            writer.vector(
                self.sizes,
                writer.int
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        type_ = reader.string()
        w_ = reader.int()
        h_ = reader.int()
        sizes_ = reader.vector(
            reader.int
        )

        return cls(
            type=type_,
            w=w_,
            h=h_,
            sizes=sizes_
        )

class PhotoPathSize(TLObject, family='TypePhotoSize'):
    """
    Messages with animated stickers can have a compressed svg (< 300 bytes) to show the outline of the sticker before fetching the actual lottie animation.
    """

    _id = 0XD8214D41
    _group_id = 0X478D00B0

    def __init__(
        self,
        type: str,
        bytes: bytes
    ):

        """
        Messages with animated stickers can have a compressed svg (< 300 bytes) to show the outline of the sticker before fetching the actual lottie animation.

        Args:
            type (str): Always j
            bytes (bytes): Compressed SVG path payload, [see here for decompression instructions](https://core.telegram.org/api/files#vector-thumbnails)
        """

        self.type = type
        self.bytes = bytes

    def to_bytes(self, boxed: bool=True):
        with Writer(b'AM!\xd8' if boxed else b'') as writer:
            writer.string(self.type)
            writer.bytes(self.bytes)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        type_ = reader.string()
        bytes_ = reader.bytes()

        return cls(
            type=type_,
            bytes=bytes_
        )

TypePhotoSize = Union[
    PhotoSizeEmpty,
    PhotoSize,
    PhotoCachedSize,
    PhotoStrippedSize,
    PhotoSizeProgressive,
    PhotoPathSize
]