
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .data_json import TypeDataJSON
    from ...gadgets.byteutils import Reader


class SendMessageTypingAction(TLObject, family='TypeSendMessageAction'):
    """
    User is typing.
    """

    _id = 0X16BF744E
    _group_id = 0X49241DFC


    def to_bytes(self, boxed: bool=True):
        return b'Nt\xbf\x16' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class SendMessageCancelAction(TLObject, family='TypeSendMessageAction'):
    """
    Invalidate all previous action updates. E.g. when user deletes entered text or aborts a video upload.
    """

    _id = 0XFD5EC8F5
    _group_id = 0X49241DFC


    def to_bytes(self, boxed: bool=True):
        return b'\xf5\xc8^\xfd' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class SendMessageRecordVideoAction(TLObject, family='TypeSendMessageAction'):
    """
    User is recording a video.
    """

    _id = 0XA187D66F
    _group_id = 0X49241DFC


    def to_bytes(self, boxed: bool=True):
        return b'o\xd6\x87\xa1' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class SendMessageUploadVideoAction(TLObject, family='TypeSendMessageAction'):
    """
    User is uploading a video.
    """

    _id = 0XE9763AEC
    _group_id = 0X49241DFC

    def __init__(
        self,
        progress: int
    ):

        """
        User is uploading a video.

        Args:
            progress (int): Progress percentage
        """

        self.progress = progress

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xec:v\xe9' if boxed else b'') as writer:
            writer.int(self.progress)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        progress_ = reader.int()

        return cls(
            progress=progress_
        )

class SendMessageRecordAudioAction(TLObject, family='TypeSendMessageAction'):
    """
    User is recording a voice message.
    """

    _id = 0XD52F73F7
    _group_id = 0X49241DFC


    def to_bytes(self, boxed: bool=True):
        return b'\xf7s/\xd5' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class SendMessageUploadAudioAction(TLObject, family='TypeSendMessageAction'):
    """
    User is uploading a voice message.
    """

    _id = 0XF351D7AB
    _group_id = 0X49241DFC

    def __init__(
        self,
        progress: int
    ):

        """
        User is uploading a voice message.

        Args:
            progress (int): Progress percentage
        """

        self.progress = progress

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xab\xd7Q\xf3' if boxed else b'') as writer:
            writer.int(self.progress)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        progress_ = reader.int()

        return cls(
            progress=progress_
        )

class SendMessageUploadPhotoAction(TLObject, family='TypeSendMessageAction'):
    """
    User is uploading a photo.
    """

    _id = 0XD1D34A26
    _group_id = 0X49241DFC

    def __init__(
        self,
        progress: int
    ):

        """
        User is uploading a photo.

        Args:
            progress (int): Progress percentage
        """

        self.progress = progress

    def to_bytes(self, boxed: bool=True):
        with Writer(b'&J\xd3\xd1' if boxed else b'') as writer:
            writer.int(self.progress)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        progress_ = reader.int()

        return cls(
            progress=progress_
        )

class SendMessageUploadDocumentAction(TLObject, family='TypeSendMessageAction'):
    """
    User is uploading a file.
    """

    _id = 0XAA0CD9E4
    _group_id = 0X49241DFC

    def __init__(
        self,
        progress: int
    ):

        """
        User is uploading a file.

        Args:
            progress (int): Progress percentage
        """

        self.progress = progress

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe4\xd9\x0c\xaa' if boxed else b'') as writer:
            writer.int(self.progress)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        progress_ = reader.int()

        return cls(
            progress=progress_
        )

class SendMessageGeoLocationAction(TLObject, family='TypeSendMessageAction'):
    """
    User is selecting a location to share.
    """

    _id = 0X176F8BA1
    _group_id = 0X49241DFC


    def to_bytes(self, boxed: bool=True):
        return b'\xa1\x8bo\x17' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class SendMessageChooseContactAction(TLObject, family='TypeSendMessageAction'):
    """
    User is selecting a contact to share.
    """

    _id = 0X628CBC6F
    _group_id = 0X49241DFC


    def to_bytes(self, boxed: bool=True):
        return b'o\xbc\x8cb' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class SendMessageGamePlayAction(TLObject, family='TypeSendMessageAction'):
    """
    User is playing a game
    """

    _id = 0XDD6A8F48
    _group_id = 0X49241DFC


    def to_bytes(self, boxed: bool=True):
        return b'H\x8fj\xdd' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class SendMessageRecordRoundAction(TLObject, family='TypeSendMessageAction'):
    """
    User is recording a round video to share
    """

    _id = 0X88F27FBC
    _group_id = 0X49241DFC


    def to_bytes(self, boxed: bool=True):
        return b'\xbc\x7f\xf2\x88' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class SendMessageUploadRoundAction(TLObject, family='TypeSendMessageAction'):
    """
    User is uploading a round video
    """

    _id = 0X243E1C66
    _group_id = 0X49241DFC

    def __init__(
        self,
        progress: int
    ):

        """
        User is uploading a round video

        Args:
            progress (int): Progress percentage
        """

        self.progress = progress

    def to_bytes(self, boxed: bool=True):
        with Writer(b'f\x1c>$' if boxed else b'') as writer:
            writer.int(self.progress)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        progress_ = reader.int()

        return cls(
            progress=progress_
        )

class SpeakingInGroupCallAction(TLObject, family='TypeSendMessageAction'):
    """
    User is currently speaking in the group call
    """

    _id = 0XD92C2285
    _group_id = 0X49241DFC


    def to_bytes(self, boxed: bool=True):
        return b'\x85",\xd9' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class SendMessageHistoryImportAction(TLObject, family='TypeSendMessageAction'):
    """
    Chat history is being imported
    """

    _id = 0XDBDA9246
    _group_id = 0X49241DFC

    def __init__(
        self,
        progress: int
    ):

        """
        Chat history is being imported

        Args:
            progress (int): Progress percentage
        """

        self.progress = progress

    def to_bytes(self, boxed: bool=True):
        with Writer(b'F\x92\xda\xdb' if boxed else b'') as writer:
            writer.int(self.progress)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        progress_ = reader.int()

        return cls(
            progress=progress_
        )

class SendMessageChooseStickerAction(TLObject, family='TypeSendMessageAction'):
    """
    User is choosing a sticker
    """

    _id = 0XB05AC6B1
    _group_id = 0X49241DFC


    def to_bytes(self, boxed: bool=True):
        return b'\xb1\xc6Z\xb0' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class SendMessageEmojiInteraction(TLObject, family='TypeSendMessageAction'):
    """
    User has clicked on an animated emoji triggering a [reaction, click here for more info](https://core.telegram.org/api/animated-emojis#emoji-reactions).
    """

    _id = 0X25972BCB
    _group_id = 0X49241DFC

    def __init__(
        self,
        emoticon: str,
        msg_id: int,
        interaction: 'TypeDataJSON'
    ):

        """
        User has clicked on an animated emoji triggering a [reaction, click here for more info](https://core.telegram.org/api/animated-emojis#emoji-reactions).

        Args:
            emoticon (str): Emoji
            msg_id (int): Message ID of the animated emoji that was clicked
            interaction ('TypeDataJSON'): A JSON object with interaction info, [click here for more info](https://core.telegram.org/api/animated-emojis#emoji-reactions)
        """

        self.emoticon = emoticon
        self.msg_id = msg_id
        self.interaction = interaction

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xcb+\x97%' if boxed else b'') as writer:
            writer.string(self.emoticon)
            writer.int(self.msg_id)
            writer.object(
                self.interaction,
                group_id=0XE95B0798
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        emoticon_ = reader.string()
        msg_id_ = reader.int()
        interaction_ = reader.object(
            group_id=0XE95B0798
        )

        return cls(
            emoticon=emoticon_,
            msg_id=msg_id_,
            interaction=interaction_
        )

class SendMessageEmojiInteractionSeen(TLObject, family='TypeSendMessageAction'):
    """
    User is watching an animated emoji reaction triggered by another user, [click here for more info](https://core.telegram.org/api/animated-emojis#emoji-reactions).
    """

    _id = 0XB665902E
    _group_id = 0X49241DFC

    def __init__(
        self,
        emoticon: str
    ):

        """
        User is watching an animated emoji reaction triggered by another user, [click here for more info](https://core.telegram.org/api/animated-emojis#emoji-reactions).

        Args:
            emoticon (str): Emoji
        """

        self.emoticon = emoticon

    def to_bytes(self, boxed: bool=True):
        with Writer(b'.\x90e\xb6' if boxed else b'') as writer:
            writer.string(self.emoticon)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        emoticon_ = reader.string()

        return cls(
            emoticon=emoticon_
        )

TypeSendMessageAction = Union[
    SendMessageTypingAction,
    SendMessageCancelAction,
    SendMessageRecordVideoAction,
    SendMessageUploadVideoAction,
    SendMessageRecordAudioAction,
    SendMessageUploadAudioAction,
    SendMessageUploadPhotoAction,
    SendMessageUploadDocumentAction,
    SendMessageGeoLocationAction,
    SendMessageChooseContactAction,
    SendMessageGamePlayAction,
    SendMessageRecordRoundAction,
    SendMessageUploadRoundAction,
    SpeakingInGroupCallAction,
    SendMessageHistoryImportAction,
    SendMessageChooseStickerAction,
    SendMessageEmojiInteraction,
    SendMessageEmojiInteractionSeen
]