
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class StarsGiftOption(TLObject, family='TypeStarsGiftOption'):
    """
    [Telegram Stars gift option](https://core.telegram.org/api/stars#buying-or-gifting-stars).
    """

    _id = 0X5E0589F1
    _group_id = 0X5F349B8

    def __init__(
        self,
        stars: int,
        currency: str,
        amount: int,
        extended: bool = False,
        store_product: Optional[str] = None
    ):

        """
        [Telegram Stars gift option](https://core.telegram.org/api/stars#buying-or-gifting-stars).

        Args:
            stars (int): Amount of Telegram stars.
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code
            amount (int): Price of the product in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            extended (bool, optional): If set, the option must only be shown in the full list of topup options.
            store_product (Optional[str], optional): Identifier of the store product associated with the option, official apps only.
        """

        self.stars = stars
        self.currency = currency
        self.amount = amount
        self.extended = extended
        self.store_product = store_product

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf1\x89\x05^' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.extended, 1)
                writer.long(self.stars)

                if flags(self.store_product, 0):
                    writer.string(self.store_product)
                writer.string(self.currency)
                writer.long(self.amount)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        stars_ = reader.long()
        store_product_ = (
            reader.string()
            if flags(0) else None
        )

        currency_ = reader.string()
        amount_ = reader.long()

        return cls(
            stars=stars_,
            currency=currency_,
            amount=amount_,
            extended=flags(1),
            store_product=store_product_
        )

TypeStarsGiftOption = StarsGiftOption