
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from ...gadgets.byteutils import Reader


class StoryFwdHeader(TLObject, family='TypeStoryFwdHeader'):
    """
    Contains info about the original poster of a reposted story.
    """

    _id = 0XB826E150
    _group_id = 0X284BFE07

    def __init__(
        self,
        modified: bool = False,
        from_: Optional['TypePeer'] = None,
        from_name: Optional[str] = None,
        story_id: Optional[int] = None
    ):

        """
        Contains info about the original poster of a reposted story.

        Args:
            modified (bool, optional): Whether the story media was modified before reposting it (for example by overlaying a round video with a reaction).
            from_ (Optional['TypePeer'], optional): Peer that originally posted the story; will be empty for stories forwarded from a user with forwards privacy enabled, in which case from_name will be set, instead.
            from_name (Optional[str], optional): Will be set for stories forwarded from a user with forwards privacy enabled, in which case from will also be empty.
            story_id (Optional[int], optional): , contains the story ID
        """

        self.modified = modified
        self.from_ = from_
        self.from_name = from_name
        self.story_id = story_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'P\xe1&\xb8' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.modified, 3)

                if flags(self.from_, 0):
                    writer.object(
                        self.from_,
                        group_id=0XB4DECBCA
                    )

                if flags(self.from_name, 1):
                    writer.string(self.from_name)

                if flags(self.story_id, 2):
                    writer.int(self.story_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        from__ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(0) else None
        )

        from_name_ = (
            reader.string()
            if flags(1) else None
        )

        story_id_ = (
            reader.int()
            if flags(2) else None
        )

        return cls(
            modified=flags(3),
            from_=from__,
            from_name=from_name_,
            story_id=story_id_
        )

TypeStoryFwdHeader = StoryFwdHeader