
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Optional, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Long, Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from .poll import TypePoll
    from .theme import TypeTheme
    from .boost import TypeBoost
    from .message import TypeMessage
    from .username import TypeUsername
    from .web_page import TypeWebPage
    from .reaction import TypeReaction
    from .dc_option import TypeDcOption
    from .geo_point import TypeGeoPoint
    from .data_json import TypeDataJSON
    from .phone_call import TypePhoneCall
    from .group_call import TypeGroupCall
    from .story_item import TypeStoryItem
    from .wall_paper import TypeWallPaper
    from .user_status import TypeUserStatus
    from .notify_peer import TypeNotifyPeer
    from .privacy_key import TypePrivacyKey
    from .dialog_peer import TypeDialogPeer
    from .folder_peer import TypeFolderPeer
    from .bot_command import TypeBotCommand
    from .quick_reply import TypeQuickReply
    from .privacy_rule import TypePrivacyRule
    from .post_address import TypePostAddress
    from .poll_results import TypePollResults
    from .peer_located import TypePeerLocated
    from .emoji_status import TypeEmojiStatus
    from .stars_amount import TypeStarsAmount
    from .message_media import TypeMessageMedia
    from .draft_message import TypeDraftMessage
    from .peer_settings import TypePeerSettings
    from .dialog_filter import TypeDialogFilter
    from .encrypted_chat import TypeEncryptedChat
    from .message_entity import TypeMessageEntity
    from .reaction_count import TypeReactionCount
    from .auth.sent_code import TypeAuthSentCode
    from .bot_menu_button import TypeBotMenuButton
    from .input_group_call import TypeInputGroupCall
    from .chat_participant import TypeChatParticipant
    from .chat_participants import TypeChatParticipants
    from .encrypted_message import TypeEncryptedMessage
    from .message_reactions import TypeMessageReactions
    from .chat_banned_rights import TypeChatBannedRights
    from ...gadgets.byteutils import Reader
    from .send_message_action import TypeSendMessageAction
    from .channel_participant import TypeChannelParticipant
    from .peer_notify_settings import TypePeerNotifySettings
    from .messages.sticker_set import TypeMessagesStickerSet
    from .lang_pack_difference import TypeLangPackDifference
    from .exported_chat_invite import TypeExportedChatInvite
    from .stories_stealth_mode import TypeStoriesStealthMode
    from .stars_revenue_status import TypeStarsRevenueStatus
    from .paid_reaction_privacy import TypePaidReactionPrivacy
    from .inline_query_peer_type import TypeInlineQueryPeerType
    from .payment_requested_info import TypePaymentRequestedInfo
    from .group_call_participant import TypeGroupCallParticipant
    from .message_extended_media import TypeMessageExtendedMedia
    from .bot_business_connection import TypeBotBusinessConnection
    from .input_bot_inline_message_id import TypeInputBotInlineMessageID


class UpdateNewMessage(TLObject, family='TypeUpdate'):
    """
    New message in a private chat or in a [basic group](https://core.telegram.org/api/channel#basic-groups).
    """

    _id = 0X1F2B0AFD
    _group_id = 0X54E058F5

    def __init__(
        self,
        message: 'TypeMessage',
        pts: int,
        pts_count: int
    ):

        """
        New message in a private chat or in a [basic group](https://core.telegram.org/api/channel#basic-groups).

        Args:
            message ('TypeMessage'): Message
            pts (int): New quantity of actions in a message box
            pts_count (int): Number of generated events
        """

        self.message = message
        self.pts = pts
        self.pts_count = pts_count

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfd\n+\x1f' if boxed else b'') as writer:
            writer.object(
                self.message,
                group_id=0X25780A8F
            )
            writer.int(self.pts)
            writer.int(self.pts_count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        message_ = reader.object(
            group_id=0X25780A8F
        )

        pts_ = reader.int()
        pts_count_ = reader.int()

        return cls(
            message=message_,
            pts=pts_,
            pts_count=pts_count_
        )

class UpdateMessageID(TLObject, family='TypeUpdate'):
    """
    Sent message with random_id client identifier was assigned an identifier.
    """

    _id = 0X4E90BFD6
    _group_id = 0X54E058F5

    def __init__(
        self,
        id: int,
        random_id: int = None
    ):

        """
        Sent message with random_id client identifier was assigned an identifier.

        Args:
            id (int): id identifier of a respective [Message](https://core.telegram.org/type/Message)
            random_id (int, optional): Previously transferred client random_id identifier
        """

        self.id = id
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd6\xbf\x90N' if boxed else b'') as writer:
            writer.int(self.id)
            writer.long(self.random_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.int()
        random_id_ = reader.long()

        return cls(
            id=id_,
            random_id=random_id_
        )

class UpdateDeleteMessages(TLObject, family='TypeUpdate'):
    """
    Messages were deleted.
    """

    _id = 0XA20DB0E5
    _group_id = 0X54E058F5

    def __init__(
        self,
        messages: List[int],
        pts: int,
        pts_count: int
    ):

        """
        Messages were deleted.

        Args:
            messages (List[int]): List of identifiers of deleted messages
            pts (int): New quality of actions in a message box
            pts_count (int): Number of generated [events](https://core.telegram.org/api/updates)
        """

        self.messages = messages
        self.pts = pts
        self.pts_count = pts_count

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe5\xb0\r\xa2' if boxed else b'') as writer:
            writer.vector(
                self.messages,
                writer.int
            )
            writer.int(self.pts)
            writer.int(self.pts_count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        messages_ = reader.vector(
            reader.int
        )

        pts_ = reader.int()
        pts_count_ = reader.int()

        return cls(
            messages=messages_,
            pts=pts_,
            pts_count=pts_count_
        )

class UpdateUserTyping(TLObject, family='TypeUpdate'):
    """
    The user is preparing a message; typing, recording, uploading, etc. This update is valid for 6 seconds. If no further updates of this kind are received after 6 seconds, it should be considered that the user stopped doing whatever they were doing
    """

    _id = 0XC01E857F
    _group_id = 0X54E058F5

    def __init__(
        self,
        user_id: int,
        action: 'TypeSendMessageAction'
    ):

        """
        The user is preparing a message; typing, recording, uploading, etc. This update is valid for 6 seconds. If no further updates of this kind are received after 6 seconds, it should be considered that the user stopped doing whatever they were doing

        Args:
            user_id (int): User id
            action ('TypeSendMessageAction'): Action type
        """

        self.user_id = user_id
        self.action = action

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x7f\x85\x1e\xc0' if boxed else b'') as writer:
            writer.long(self.user_id)
            writer.object(
                self.action,
                group_id=0X49241DFC
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        user_id_ = reader.long()
        action_ = reader.object(
            group_id=0X49241DFC
        )

        return cls(
            user_id=user_id_,
            action=action_
        )

class UpdateChatUserTyping(TLObject, family='TypeUpdate'):
    """
    The user is preparing a message in a group; typing, recording, uploading, etc. This update is valid for 6 seconds. If no further updates of this kind are received after 6 seconds, it should be considered that the user stopped doing whatever they were doing
    """

    _id = 0X83487AF0
    _group_id = 0X54E058F5

    def __init__(
        self,
        chat_id: int,
        from_id: 'TypePeer',
        action: 'TypeSendMessageAction'
    ):

        """
        The user is preparing a message in a group; typing, recording, uploading, etc. This update is valid for 6 seconds. If no further updates of this kind are received after 6 seconds, it should be considered that the user stopped doing whatever they were doing

        Args:
            chat_id (int): Group id
            from_id ('TypePeer'): Peer that started typing (can be the chat itself, in case of anonymous admins).
            action ('TypeSendMessageAction'): Type of action
        """

        self.chat_id = chat_id
        self.from_id = from_id
        self.action = action

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf0zH\x83' if boxed else b'') as writer:
            writer.long(self.chat_id)
            writer.object(
                self.from_id,
                group_id=0XB4DECBCA
            )
            writer.object(
                self.action,
                group_id=0X49241DFC
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        chat_id_ = reader.long()
        from_id_ = reader.object(
            group_id=0XB4DECBCA
        )

        action_ = reader.object(
            group_id=0X49241DFC
        )

        return cls(
            chat_id=chat_id_,
            from_id=from_id_,
            action=action_
        )

class UpdateChatParticipants(TLObject, family='TypeUpdate'):
    """
    Composition of chat participants changed.
    """

    _id = 0X7761198
    _group_id = 0X54E058F5

    def __init__(
        self,
        participants: 'TypeChatParticipants'
    ):

        """
        Composition of chat participants changed.

        Args:
            participants ('TypeChatParticipants'): Updated chat participants
        """

        self.participants = participants

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x98\x11v\x07' if boxed else b'') as writer:
            writer.object(
                self.participants,
                group_id=0X8FBBB6E2
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        participants_ = reader.object(
            group_id=0X8FBBB6E2
        )

        return cls(
            participants=participants_
        )

class UpdateUserStatus(TLObject, family='TypeUpdate'):
    """
    Contact status update.
    """

    _id = 0XE5BDF8DE
    _group_id = 0X54E058F5

    def __init__(
        self,
        user_id: int,
        status: 'TypeUserStatus'
    ):

        """
        Contact status update.

        Args:
            user_id (int): User identifier
            status ('TypeUserStatus'): New status
        """

        self.user_id = user_id
        self.status = status

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xde\xf8\xbd\xe5' if boxed else b'') as writer:
            writer.long(self.user_id)
            writer.object(
                self.status,
                group_id=0X6F35ECEB
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        user_id_ = reader.long()
        status_ = reader.object(
            group_id=0X6F35ECEB
        )

        return cls(
            user_id=user_id_,
            status=status_
        )

class UpdateUserName(TLObject, family='TypeUpdate'):
    """
    Changes the user's first name, last name and username.
    """

    _id = 0XA7848924
    _group_id = 0X54E058F5

    def __init__(
        self,
        user_id: int,
        first_name: str,
        last_name: str,
        usernames: List['TypeUsername']
    ):

        """
        Changes the user's first name, last name and username.

        Args:
            user_id (int): User identifier
            first_name (str): New first name. Corresponds to the new value of real_first_name field of the [userFull](https://core.telegram.org/constructor/userFull) constructor.
            last_name (str): New last name. Corresponds to the new value of real_last_name field of the [userFull](https://core.telegram.org/constructor/userFull) constructor.
            usernames (List['TypeUsername']): Usernames.
        """

        self.user_id = user_id
        self.first_name = first_name
        self.last_name = last_name
        self.usernames = usernames

    def to_bytes(self, boxed: bool=True):
        with Writer(b'$\x89\x84\xa7' if boxed else b'') as writer:
            writer.long(self.user_id)
            writer.string(self.first_name)
            writer.string(self.last_name)
            writer.vector(
                self.usernames,
                lambda value: writer.object(
                    value,
                    group_id=0X45703151
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        user_id_ = reader.long()
        first_name_ = reader.string()
        last_name_ = reader.string()
        usernames_ = reader.vector(
            lambda: reader.object(
                group_id=0X45703151
            )
        )

        return cls(
            user_id=user_id_,
            first_name=first_name_,
            last_name=last_name_,
            usernames=usernames_
        )

class UpdateNewAuthorization(TLObject, family='TypeUpdate'):
    """
    A new session logged into the current user's account through an unknown device.
    """

    _id = 0X8951ABEF
    _group_id = 0X54E058F5

    def __init__(
        self,
        hash: int,
        unconfirmed: bool = False,
        date: Optional[int] = None,
        device: Optional[str] = None,
        location: Optional[str] = None
    ):

        """
        A new session logged into the current user's account through an unknown device.

        Args:
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
            unconfirmed (bool, optional): Whether the session is [unconfirmed, see here](https://core.telegram.org/api/auth#confirming-login) for more info.
            date (Optional[int], optional): Authorization date
            device (Optional[str], optional): Name of device, for example Android
            location (Optional[str], optional): Location, for example USA, NY (IP=1.2.3.4)
        """

        self.hash = hash
        self.unconfirmed = unconfirmed
        self.date = date
        self.device = device
        self.location = location

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xef\xabQ\x89' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.unconfirmed, 0)
                writer.long(self.hash)

                if flags(self.date, 0):
                    writer.int(self.date)

                if flags(self.device, 0):
                    writer.string(self.device)

                if flags(self.location, 0):
                    writer.string(self.location)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        hash_ = reader.long()
        date_ = (
            reader.int()
            if flags(0) else None
        )

        device_ = (
            reader.string()
            if flags(0) else None
        )

        location_ = (
            reader.string()
            if flags(0) else None
        )

        return cls(
            hash=hash_,
            unconfirmed=flags(0),
            date=date_,
            device=device_,
            location=location_
        )

class UpdateNewEncryptedMessage(TLObject, family='TypeUpdate'):
    """
    New encrypted message.
    """

    _id = 0X12BCBD9A
    _group_id = 0X54E058F5

    def __init__(
        self,
        message: 'TypeEncryptedMessage',
        qts: int
    ):

        """
        New encrypted message.

        Args:
            message ('TypeEncryptedMessage'): Message
            qts (int): New qts value, see [updates](https://core.telegram.org/api/updates) for more info.
        """

        self.message = message
        self.qts = qts

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9a\xbd\xbc\x12' if boxed else b'') as writer:
            writer.object(
                self.message,
                group_id=0XB38C0DC2
            )
            writer.int(self.qts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        message_ = reader.object(
            group_id=0XB38C0DC2
        )

        qts_ = reader.int()

        return cls(
            message=message_,
            qts=qts_
        )

class UpdateEncryptedChatTyping(TLObject, family='TypeUpdate'):
    """
    Interlocutor is typing a message in an encrypted chat. Update period is 6 second. If upon this time there is no repeated update, it shall be considered that the interlocutor stopped typing.
    """

    _id = 0X1710F156
    _group_id = 0X54E058F5

    def __init__(
        self,
        chat_id: int
    ):

        """
        Interlocutor is typing a message in an encrypted chat. Update period is 6 second. If upon this time there is no repeated update, it shall be considered that the interlocutor stopped typing.

        Args:
            chat_id (int): Chat ID
        """

        self.chat_id = chat_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'V\xf1\x10\x17' if boxed else b'') as writer:
            writer.int(self.chat_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        chat_id_ = reader.int()

        return cls(
            chat_id=chat_id_
        )

class UpdateEncryption(TLObject, family='TypeUpdate'):
    """
    Change of state in an encrypted chat.
    """

    _id = 0XB4A2E88D
    _group_id = 0X54E058F5

    def __init__(
        self,
        chat: 'TypeEncryptedChat',
        date: int
    ):

        """
        Change of state in an encrypted chat.

        Args:
            chat ('TypeEncryptedChat'): Encrypted chat
            date (int): Date of change
        """

        self.chat = chat
        self.date = date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x8d\xe8\xa2\xb4' if boxed else b'') as writer:
            writer.object(
                self.chat,
                group_id=0X9E93492C
            )
            writer.int(self.date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        chat_ = reader.object(
            group_id=0X9E93492C
        )

        date_ = reader.int()

        return cls(
            chat=chat_,
            date=date_
        )

class UpdateEncryptedMessagesRead(TLObject, family='TypeUpdate'):
    """
    Communication history in an encrypted chat was marked as read.
    """

    _id = 0X38FE25B7
    _group_id = 0X54E058F5

    def __init__(
        self,
        chat_id: int,
        max_date: int,
        date: int
    ):

        """
        Communication history in an encrypted chat was marked as read.

        Args:
            chat_id (int): Chat ID
            max_date (int): Maximum value of data for read messages
            date (int): Time when messages were read
        """

        self.chat_id = chat_id
        self.max_date = max_date
        self.date = date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb7%\xfe8' if boxed else b'') as writer:
            writer.int(self.chat_id)
            writer.int(self.max_date)
            writer.int(self.date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        chat_id_ = reader.int()
        max_date_ = reader.int()
        date_ = reader.int()

        return cls(
            chat_id=chat_id_,
            max_date=max_date_,
            date=date_
        )

class UpdateChatParticipantAdd(TLObject, family='TypeUpdate'):
    """
    New group member.
    """

    _id = 0X3DDA5451
    _group_id = 0X54E058F5

    def __init__(
        self,
        chat_id: int,
        user_id: int,
        inviter_id: int,
        date: int,
        version: int
    ):

        """
        New group member.

        Args:
            chat_id (int): Group ID
            user_id (int): ID of the new member
            inviter_id (int): ID of the user, who added member to the group
            date (int): When was the participant added
            version (int): Chat version number
        """

        self.chat_id = chat_id
        self.user_id = user_id
        self.inviter_id = inviter_id
        self.date = date
        self.version = version

    def to_bytes(self, boxed: bool=True):
        with Writer(b'QT\xda=' if boxed else b'') as writer:
            writer.long(self.chat_id)
            writer.long(self.user_id)
            writer.long(self.inviter_id)
            writer.int(self.date)
            writer.int(self.version)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        chat_id_ = reader.long()
        user_id_ = reader.long()
        inviter_id_ = reader.long()
        date_ = reader.int()
        version_ = reader.int()

        return cls(
            chat_id=chat_id_,
            user_id=user_id_,
            inviter_id=inviter_id_,
            date=date_,
            version=version_
        )

class UpdateChatParticipantDelete(TLObject, family='TypeUpdate'):
    """
    A member has left the group.
    """

    _id = 0XE32F3D77
    _group_id = 0X54E058F5

    def __init__(
        self,
        chat_id: int,
        user_id: int,
        version: int
    ):

        """
        A member has left the group.

        Args:
            chat_id (int): Group ID
            user_id (int): ID of the user
            version (int): Used in basic groups to reorder updates and make sure that all of them was received.
        """

        self.chat_id = chat_id
        self.user_id = user_id
        self.version = version

    def to_bytes(self, boxed: bool=True):
        with Writer(b'w=/\xe3' if boxed else b'') as writer:
            writer.long(self.chat_id)
            writer.long(self.user_id)
            writer.int(self.version)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        chat_id_ = reader.long()
        user_id_ = reader.long()
        version_ = reader.int()

        return cls(
            chat_id=chat_id_,
            user_id=user_id_,
            version=version_
        )

class UpdateDcOptions(TLObject, family='TypeUpdate'):
    """
    Changes in the data center configuration options.
    """

    _id = 0X8E5E9873
    _group_id = 0X54E058F5

    def __init__(
        self,
        dc_options: List['TypeDcOption']
    ):

        """
        Changes in the data center configuration options.

        Args:
            dc_options (List['TypeDcOption']): New connection options
        """

        self.dc_options = dc_options

    def to_bytes(self, boxed: bool=True):
        with Writer(b's\x98^\x8e' if boxed else b'') as writer:
            writer.vector(
                self.dc_options,
                lambda value: writer.object(
                    value,
                    group_id=0XDA1BB453
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        dc_options_ = reader.vector(
            lambda: reader.object(
                group_id=0XDA1BB453
            )
        )

        return cls(
            dc_options=dc_options_
        )

class UpdateNotifySettings(TLObject, family='TypeUpdate'):
    """
    Changes in notification settings.
    """

    _id = 0XBEC268EF
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypeNotifyPeer',
        notify_settings: 'TypePeerNotifySettings'
    ):

        """
        Changes in notification settings.

        Args:
            peer ('TypeNotifyPeer'): Notification source
            notify_settings ('TypePeerNotifySettings'): New notification settings
        """

        self.peer = peer
        self.notify_settings = notify_settings

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xefh\xc2\xbe' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XEBD6F8FB
            )
            writer.object(
                self.notify_settings,
                group_id=0X372BF8CC
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XEBD6F8FB
        )

        notify_settings_ = reader.object(
            group_id=0X372BF8CC
        )

        return cls(
            peer=peer_,
            notify_settings=notify_settings_
        )

class UpdateServiceNotification(TLObject, family='TypeUpdate'):
    """
    A service message for the user.
    """

    _id = 0XEBE46819
    _group_id = 0X54E058F5

    def __init__(
        self,
        type: str,
        message: str,
        media: 'TypeMessageMedia',
        entities: List['TypeMessageEntity'],
        popup: bool = False,
        invert_media: bool = False,
        inbox_date: Optional[int] = None
    ):

        """
        A service message for the user.

        Args:
            type (str): String, identical in format and contents to the [type](https://core.telegram.org/api/errors#error-type) field in API errors. Describes type of service message. It is acceptable to ignore repeated messages of the same type within a short period of time (15 minutes).
            message (str): Message text
            media ('TypeMessageMedia'): Media content (optional)
            entities (List['TypeMessageEntity']): [Message entities for styled text](https://core.telegram.org/api/entities)
            popup (bool, optional): If set, the message must be displayed in a popup.
            invert_media (bool, optional): If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
            inbox_date (Optional[int], optional): When was the notification received The message must also be stored locally as part of the message history with the user id 777000 (Telegram Notifications).
        """

        self.type = type
        self.message = message
        self.media = media
        self.entities = entities
        self.popup = popup
        self.invert_media = invert_media
        self.inbox_date = inbox_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x19h\xe4\xeb' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.popup, 0)
                flags(self.invert_media, 2)

                if flags(self.inbox_date, 1):
                    writer.int(self.inbox_date)
                writer.string(self.type)
                writer.string(self.message)
                writer.object(
                    self.media,
                    group_id=0X45F7A020
                )
                writer.vector(
                    self.entities,
                    lambda value: writer.object(
                        value,
                        group_id=0X3CDFF38A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        inbox_date_ = (
            reader.int()
            if flags(1) else None
        )

        type_ = reader.string()
        message_ = reader.string()
        media_ = reader.object(
            group_id=0X45F7A020
        )

        entities_ = reader.vector(
            lambda: reader.object(
                group_id=0X3CDFF38A
            )
        )

        return cls(
            type=type_,
            message=message_,
            media=media_,
            entities=entities_,
            popup=flags(0),
            invert_media=flags(2),
            inbox_date=inbox_date_
        )

class UpdatePrivacy(TLObject, family='TypeUpdate'):
    """
    Privacy rules were changed
    """

    _id = 0XEE3B272A
    _group_id = 0X54E058F5

    def __init__(
        self,
        key: 'TypePrivacyKey',
        rules: List['TypePrivacyRule']
    ):

        """
        Privacy rules were changed

        Args:
            key ('TypePrivacyKey'): Peers to which the privacy rules apply
            rules (List['TypePrivacyRule']): New privacy rules
        """

        self.key = key
        self.rules = rules

    def to_bytes(self, boxed: bool=True):
        with Writer(b"*';\xee" if boxed else b'') as writer:
            writer.object(
                self.key,
                group_id=0XB678C916
            )
            writer.vector(
                self.rules,
                lambda value: writer.object(
                    value,
                    group_id=0X1D3AEAB3
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        key_ = reader.object(
            group_id=0XB678C916
        )

        rules_ = reader.vector(
            lambda: reader.object(
                group_id=0X1D3AEAB3
            )
        )

        return cls(
            key=key_,
            rules=rules_
        )

class UpdateUserPhone(TLObject, family='TypeUpdate'):
    """
    A user's phone number was changed
    """

    _id = 0X5492A13
    _group_id = 0X54E058F5

    def __init__(
        self,
        user_id: int,
        phone: str
    ):

        """
        A user's phone number was changed

        Args:
            user_id (int): User ID
            phone (str): New phone number
        """

        self.user_id = user_id
        self.phone = phone

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x13*I\x05' if boxed else b'') as writer:
            writer.long(self.user_id)
            writer.string(self.phone)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        user_id_ = reader.long()
        phone_ = reader.string()

        return cls(
            user_id=user_id_,
            phone=phone_
        )

class UpdateReadHistoryInbox(TLObject, family='TypeUpdate'):
    """
    Incoming messages were read
    """

    _id = 0X9C974FDF
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        max_id: int,
        still_unread_count: int,
        pts: int,
        pts_count: int,
        folder_id: Optional[int] = None
    ):

        """
        Incoming messages were read

        Args:
            peer ('TypePeer'): Peer
            max_id (int): Maximum ID of messages read
            still_unread_count (int): Number of messages that are still unread
            pts (int): [Event count after generation](https://core.telegram.org/api/updates)
            pts_count (int): [Number of events that were generated](https://core.telegram.org/api/updates)
            folder_id (Optional[int], optional): [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
        """

        self.peer = peer
        self.max_id = max_id
        self.still_unread_count = still_unread_count
        self.pts = pts
        self.pts_count = pts_count
        self.folder_id = folder_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xdfO\x97\x9c' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.folder_id, 0):
                    writer.int(self.folder_id)
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )
                writer.int(self.max_id)
                writer.int(self.still_unread_count)
                writer.int(self.pts)
                writer.int(self.pts_count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        folder_id_ = (
            reader.int()
            if flags(0) else None
        )

        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        max_id_ = reader.int()
        still_unread_count_ = reader.int()
        pts_ = reader.int()
        pts_count_ = reader.int()

        return cls(
            peer=peer_,
            max_id=max_id_,
            still_unread_count=still_unread_count_,
            pts=pts_,
            pts_count=pts_count_,
            folder_id=folder_id_
        )

class UpdateReadHistoryOutbox(TLObject, family='TypeUpdate'):
    """
    Outgoing messages were read
    """

    _id = 0X2F2F21BF
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        max_id: int,
        pts: int,
        pts_count: int
    ):

        """
        Outgoing messages were read

        Args:
            peer ('TypePeer'): Peer
            max_id (int): Maximum ID of read outgoing messages
            pts (int): [Event count after generation](https://core.telegram.org/api/updates)
            pts_count (int): [Number of events that were generated](https://core.telegram.org/api/updates)
        """

        self.peer = peer
        self.max_id = max_id
        self.pts = pts
        self.pts_count = pts_count

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xbf!//' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.int(self.max_id)
            writer.int(self.pts)
            writer.int(self.pts_count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        max_id_ = reader.int()
        pts_ = reader.int()
        pts_count_ = reader.int()

        return cls(
            peer=peer_,
            max_id=max_id_,
            pts=pts_,
            pts_count=pts_count_
        )

class UpdateWebPage(TLObject, family='TypeUpdate'):
    """
    An [instant view](https://instantview.telegram.org) webpage preview was generated
    """

    _id = 0X7F891213
    _group_id = 0X54E058F5

    def __init__(
        self,
        webpage: 'TypeWebPage',
        pts: int,
        pts_count: int
    ):

        """
        An [instant view](https://instantview.telegram.org) webpage preview was generated

        Args:
            webpage ('TypeWebPage'): Webpage preview
            pts (int): [Event count after generation](https://core.telegram.org/api/updates)
            pts_count (int): [Number of events that were generated](https://core.telegram.org/api/updates)
        """

        self.webpage = webpage
        self.pts = pts
        self.pts_count = pts_count

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x13\x12\x89\x7f' if boxed else b'') as writer:
            writer.object(
                self.webpage,
                group_id=0X9D177ED
            )
            writer.int(self.pts)
            writer.int(self.pts_count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        webpage_ = reader.object(
            group_id=0X9D177ED
        )

        pts_ = reader.int()
        pts_count_ = reader.int()

        return cls(
            webpage=webpage_,
            pts=pts_,
            pts_count=pts_count_
        )

class UpdateReadMessagesContents(TLObject, family='TypeUpdate'):
    """
    Contents of messages in the common [message box](https://core.telegram.org/api/updates) were read
    """

    _id = 0XF8227181
    _group_id = 0X54E058F5

    def __init__(
        self,
        messages: List[int],
        pts: int,
        pts_count: int,
        date: Optional[int] = None
    ):

        """
        Contents of messages in the common [message box](https://core.telegram.org/api/updates) were read

        Args:
            messages (List[int]): IDs of read messages
            pts (int): [Event count after generation](https://core.telegram.org/api/updates)
            pts_count (int): [Number of events that were generated](https://core.telegram.org/api/updates)
            date (Optional[int], optional): When was the last message in messages marked as read.
        """

        self.messages = messages
        self.pts = pts
        self.pts_count = pts_count
        self.date = date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x81q"\xf8' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.vector(
                    self.messages,
                    writer.int
                )
                writer.int(self.pts)
                writer.int(self.pts_count)

                if flags(self.date, 0):
                    writer.int(self.date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        messages_ = reader.vector(
            reader.int
        )

        pts_ = reader.int()
        pts_count_ = reader.int()
        date_ = (
            reader.int()
            if flags(0) else None
        )

        return cls(
            messages=messages_,
            pts=pts_,
            pts_count=pts_count_,
            date=date_
        )

class UpdateChannelTooLong(TLObject, family='TypeUpdate'):
    """
    There are new updates in the specified channel, the client must fetch them. 
    If the difference is too long or if the channel isn't currently in the states, start fetching from the specified pts.
    """

    _id = 0X108D941F
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        pts: Optional[int] = None
    ):

        """
        There are new updates in the specified channel, the client must fetch them. 
        If the difference is too long or if the channel isn't currently in the states, start fetching from the specified pts.

        Args:
            channel_id (int): The channel
            pts (Optional[int], optional): The [PTS](https://core.telegram.org/api/updates).
        """

        self.channel_id = channel_id
        self.pts = pts

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1f\x94\x8d\x10' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.channel_id)

                if flags(self.pts, 0):
                    writer.int(self.pts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        channel_id_ = reader.long()
        pts_ = (
            reader.int()
            if flags(0) else None
        )

        return cls(
            channel_id=channel_id_,
            pts=pts_
        )

class UpdateChannel(TLObject, family='TypeUpdate'):
    """
    Channel/supergroup ( [channel](https://core.telegram.org/constructor/channel) and/or [channelFull](https://core.telegram.org/constructor/channelFull)) information was updated.
    """

    _id = 0X635B4C09
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int
    ):

        """
        Channel/supergroup ( [channel](https://core.telegram.org/constructor/channel) and/or [channelFull](https://core.telegram.org/constructor/channelFull)) information was updated.

        Args:
            channel_id (int): Channel ID
        """

        self.channel_id = channel_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\tL[c' if boxed else b'') as writer:
            writer.long(self.channel_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        channel_id_ = reader.long()

        return cls(
            channel_id=channel_id_
        )

class UpdateNewChannelMessage(TLObject, family='TypeUpdate'):
    """
    A new message was sent in a [channel/supergroup](https://core.telegram.org/api/channel)
    """

    _id = 0X62BA04D9
    _group_id = 0X54E058F5

    def __init__(
        self,
        message: 'TypeMessage',
        pts: int,
        pts_count: int
    ):

        """
        A new message was sent in a [channel/supergroup](https://core.telegram.org/api/channel)

        Args:
            message ('TypeMessage'): New message
            pts (int): [Event count after generation](https://core.telegram.org/api/updates)
            pts_count (int): [Number of events that were generated](https://core.telegram.org/api/updates)
        """

        self.message = message
        self.pts = pts
        self.pts_count = pts_count

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd9\x04\xbab' if boxed else b'') as writer:
            writer.object(
                self.message,
                group_id=0X25780A8F
            )
            writer.int(self.pts)
            writer.int(self.pts_count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        message_ = reader.object(
            group_id=0X25780A8F
        )

        pts_ = reader.int()
        pts_count_ = reader.int()

        return cls(
            message=message_,
            pts=pts_,
            pts_count=pts_count_
        )

class UpdateReadChannelInbox(TLObject, family='TypeUpdate'):
    """
    Incoming messages in a [channel/supergroup](https://core.telegram.org/api/channel) were read
    """

    _id = 0X922E6E10
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        max_id: int,
        still_unread_count: int,
        pts: int,
        folder_id: Optional[int] = None
    ):

        """
        Incoming messages in a [channel/supergroup](https://core.telegram.org/api/channel) were read

        Args:
            channel_id (int): Channel/supergroup ID
            max_id (int): Position up to which all incoming messages are read.
            still_unread_count (int): Count of messages weren't read yet
            pts (int): [Event count after generation](https://core.telegram.org/api/updates)
            folder_id (Optional[int], optional): [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
        """

        self.channel_id = channel_id
        self.max_id = max_id
        self.still_unread_count = still_unread_count
        self.pts = pts
        self.folder_id = folder_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x10n.\x92' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.folder_id, 0):
                    writer.int(self.folder_id)
                writer.long(self.channel_id)
                writer.int(self.max_id)
                writer.int(self.still_unread_count)
                writer.int(self.pts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        folder_id_ = (
            reader.int()
            if flags(0) else None
        )

        channel_id_ = reader.long()
        max_id_ = reader.int()
        still_unread_count_ = reader.int()
        pts_ = reader.int()

        return cls(
            channel_id=channel_id_,
            max_id=max_id_,
            still_unread_count=still_unread_count_,
            pts=pts_,
            folder_id=folder_id_
        )

class UpdateDeleteChannelMessages(TLObject, family='TypeUpdate'):
    """
    Some messages in a [supergroup/channel](https://core.telegram.org/api/channel) were deleted
    """

    _id = 0XC32D5B12
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        messages: List[int],
        pts: int,
        pts_count: int
    ):

        """
        Some messages in a [supergroup/channel](https://core.telegram.org/api/channel) were deleted

        Args:
            channel_id (int): Channel ID
            messages (List[int]): IDs of messages that were deleted
            pts (int): [Event count after generation](https://core.telegram.org/api/updates)
            pts_count (int): [Number of events that were generated](https://core.telegram.org/api/updates)
        """

        self.channel_id = channel_id
        self.messages = messages
        self.pts = pts
        self.pts_count = pts_count

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x12[-\xc3' if boxed else b'') as writer:
            writer.long(self.channel_id)
            writer.vector(
                self.messages,
                writer.int
            )
            writer.int(self.pts)
            writer.int(self.pts_count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        channel_id_ = reader.long()
        messages_ = reader.vector(
            reader.int
        )

        pts_ = reader.int()
        pts_count_ = reader.int()

        return cls(
            channel_id=channel_id_,
            messages=messages_,
            pts=pts_,
            pts_count=pts_count_
        )

class UpdateChannelMessageViews(TLObject, family='TypeUpdate'):
    """
    The view counter of a message in a channel has changed
    """

    _id = 0XF226AC08
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        id: int,
        views: int
    ):

        """
        The view counter of a message in a channel has changed

        Args:
            channel_id (int): Channel ID
            id (int): ID of the message
            views (int): New view counter
        """

        self.channel_id = channel_id
        self.id = id
        self.views = views

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x08\xac&\xf2' if boxed else b'') as writer:
            writer.long(self.channel_id)
            writer.int(self.id)
            writer.int(self.views)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        channel_id_ = reader.long()
        id_ = reader.int()
        views_ = reader.int()

        return cls(
            channel_id=channel_id_,
            id=id_,
            views=views_
        )

class UpdateChatParticipantAdmin(TLObject, family='TypeUpdate'):
    """
    Admin permissions of a user in a [basic group](https://core.telegram.org/api/channel#basic-groups) were changed
    """

    _id = 0XD7CA61A2
    _group_id = 0X54E058F5

    def __init__(
        self,
        chat_id: int,
        user_id: int,
        is_admin: bool,
        version: int
    ):

        """
        Admin permissions of a user in a [basic group](https://core.telegram.org/api/channel#basic-groups) were changed

        Args:
            chat_id (int): Chat ID
            user_id (int): ID of the (de)admined user
            is_admin (bool): Whether the user was rendered admin
            version (int): Used in basic groups to reorder updates and make sure that all of them was received.
        """

        self.chat_id = chat_id
        self.user_id = user_id
        self.is_admin = is_admin
        self.version = version

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa2a\xca\xd7' if boxed else b'') as writer:
            writer.long(self.chat_id)
            writer.long(self.user_id)
            writer.object(
                self.is_admin,
                group_id=0X43B904E1
            )
            writer.int(self.version)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        chat_id_ = reader.long()
        user_id_ = reader.long()
        is_admin_ = reader.object(
            group_id=0X43B904E1
        )

        version_ = reader.int()

        return cls(
            chat_id=chat_id_,
            user_id=user_id_,
            is_admin=is_admin_,
            version=version_
        )

class UpdateNewStickerSet(TLObject, family='TypeUpdate'):
    """
    A new stickerset was installed
    """

    _id = 0X688A30AA
    _group_id = 0X54E058F5

    def __init__(
        self,
        stickerset: 'TypeMessagesStickerSet'
    ):

        """
        A new stickerset was installed

        Args:
            stickerset ('TypeMessagesStickerSet'): The installed stickerset
        """

        self.stickerset = stickerset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xaa0\x8ah' if boxed else b'') as writer:
            writer.object(
                self.stickerset,
                group_id=0X5CC84E96
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        stickerset_ = reader.object(
            group_id=0X5CC84E96
        )

        return cls(
            stickerset=stickerset_
        )

class UpdateStickerSetsOrder(TLObject, family='TypeUpdate'):
    """
    The order of stickersets was changed
    """

    _id = 0XBB2D201
    _group_id = 0X54E058F5

    def __init__(
        self,
        order: List[int],
        masks: bool = False,
        emojis: bool = False
    ):

        """
        The order of stickersets was changed

        Args:
            order (List[int]): New sticker order by sticker ID
            masks (bool, optional): Whether the updated stickers are mask stickers
            emojis (bool, optional): Whether the updated stickers are custom emoji stickers
        """

        self.order = order
        self.masks = masks
        self.emojis = emojis

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x01\xd2\xb2\x0b' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.masks, 0)
                flags(self.emojis, 1)
                writer.vector(
                    self.order,
                    writer.long
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        order_ = reader.vector(
            reader.long
        )

        return cls(
            order=order_,
            masks=flags(0),
            emojis=flags(1)
        )

class UpdateStickerSets(TLObject, family='TypeUpdate'):
    """
    Installed stickersets have changed, the client should refetch them as [described in the docs](https://core.telegram.org/api/stickers#installing-stickersets).
    """

    _id = 0X31C24808
    _group_id = 0X54E058F5

    def __init__(
        self,
        masks: bool = False,
        emojis: bool = False
    ):

        """
        Installed stickersets have changed, the client should refetch them as [described in the docs](https://core.telegram.org/api/stickers#installing-stickersets).

        Args:
            masks (bool, optional): Whether mask stickersets have changed
            emojis (bool, optional): Whether the list of installed [custom emoji stickersets](https://core.telegram.org/api/custom-emoji) has changed
        """

        self.masks = masks
        self.emojis = emojis

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x08H\xc21' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.masks, 0)
                flags(self.emojis, 1)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()

        return cls(
            masks=flags(0),
            emojis=flags(1)
        )

class UpdateSavedGifs(TLObject, family='TypeUpdate'):
    """
    The saved gif list has changed, the client should refetch it using [messages.getSavedGifs](https://core.telegram.org/method/messages.getSavedGifs)
    """

    _id = 0X9375341E
    _group_id = 0X54E058F5


    def to_bytes(self, boxed: bool=True):
        return b'\x1e4u\x93' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class UpdateBotInlineQuery(TLObject, family='TypeUpdate'):
    """
    An incoming inline query
    """

    _id = 0X496F379C
    _group_id = 0X54E058F5

    def __init__(
        self,
        query_id: int,
        user_id: int,
        query: str,
        offset: str,
        geo: Optional['TypeGeoPoint'] = None,
        peer_type: Optional['TypeInlineQueryPeerType'] = None
    ):

        """
        An incoming inline query

        Args:
            query_id (int): Query ID
            user_id (int): User that sent the query
            query (str): Text of query
            offset (str): Offset to navigate through results
            geo (Optional['TypeGeoPoint'], optional): Attached geolocation
            peer_type (Optional['TypeInlineQueryPeerType'], optional): Type of the chat from which the inline query was sent.
        """

        self.query_id = query_id
        self.user_id = user_id
        self.query = query
        self.offset = offset
        self.geo = geo
        self.peer_type = peer_type

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9c7oI' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.query_id)
                writer.long(self.user_id)
                writer.string(self.query)

                if flags(self.geo, 0):
                    writer.object(
                        self.geo,
                        group_id=0X9248B41D
                    )

                if flags(self.peer_type, 1):
                    writer.object(
                        self.peer_type,
                        group_id=0X6AF2CA99
                    )
                writer.string(self.offset)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        query_id_ = reader.long()
        user_id_ = reader.long()
        query_ = reader.string()
        geo_ = (
            reader.object(
                group_id=0X9248B41D
            )
            if flags(0) else None
        )

        peer_type_ = (
            reader.object(
                group_id=0X6AF2CA99
            )
            if flags(1) else None
        )

        offset_ = reader.string()

        return cls(
            query_id=query_id_,
            user_id=user_id_,
            query=query_,
            offset=offset_,
            geo=geo_,
            peer_type=peer_type_
        )

class UpdateBotInlineSend(TLObject, family='TypeUpdate'):
    """
    The result of an inline query that was chosen by a user and sent to their chat partner. Please see our documentation on the [feedback collecting](https://core.telegram.org/bots/inline#collecting-feedback) for details on how to enable these updates for your bot.
    """

    _id = 0X12F12A07
    _group_id = 0X54E058F5

    def __init__(
        self,
        user_id: int,
        query: str,
        id: str,
        geo: Optional['TypeGeoPoint'] = None,
        msg_id: Optional['TypeInputBotInlineMessageID'] = None
    ):

        """
        The result of an inline query that was chosen by a user and sent to their chat partner. Please see our documentation on the [feedback collecting](https://core.telegram.org/bots/inline#collecting-feedback) for details on how to enable these updates for your bot.

        Args:
            user_id (int): The user that chose the result
            query (str): The query that was used to obtain the result
            id (str): The unique identifier for the result that was chosen
            geo (Optional['TypeGeoPoint'], optional): Optional. Sender location, only for bots that require user location
            msg_id (Optional['TypeInputBotInlineMessageID'], optional): Identifier of the sent inline message. Available only if there is an inline keyboard attached to the message. Will be also received in callback queries and can be used to edit the message.
        """

        self.user_id = user_id
        self.query = query
        self.id = id
        self.geo = geo
        self.msg_id = msg_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x07*\xf1\x12' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.user_id)
                writer.string(self.query)

                if flags(self.geo, 0):
                    writer.object(
                        self.geo,
                        group_id=0X9248B41D
                    )
                writer.string(self.id)

                if flags(self.msg_id, 1):
                    writer.object(
                        self.msg_id,
                        group_id=0XE8D574CF
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        user_id_ = reader.long()
        query_ = reader.string()
        geo_ = (
            reader.object(
                group_id=0X9248B41D
            )
            if flags(0) else None
        )

        id_ = reader.string()
        msg_id_ = (
            reader.object(
                group_id=0XE8D574CF
            )
            if flags(1) else None
        )

        return cls(
            user_id=user_id_,
            query=query_,
            id=id_,
            geo=geo_,
            msg_id=msg_id_
        )

class UpdateEditChannelMessage(TLObject, family='TypeUpdate'):
    """
    A message was edited in a [channel/supergroup](https://core.telegram.org/api/channel)
    """

    _id = 0X1B3F4DF7
    _group_id = 0X54E058F5

    def __init__(
        self,
        message: 'TypeMessage',
        pts: int,
        pts_count: int
    ):

        """
        A message was edited in a [channel/supergroup](https://core.telegram.org/api/channel)

        Args:
            message ('TypeMessage'): The new message
            pts (int): [Event count after generation](https://core.telegram.org/api/updates)
            pts_count (int): [Number of events that were generated](https://core.telegram.org/api/updates)
        """

        self.message = message
        self.pts = pts
        self.pts_count = pts_count

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf7M?\x1b' if boxed else b'') as writer:
            writer.object(
                self.message,
                group_id=0X25780A8F
            )
            writer.int(self.pts)
            writer.int(self.pts_count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        message_ = reader.object(
            group_id=0X25780A8F
        )

        pts_ = reader.int()
        pts_count_ = reader.int()

        return cls(
            message=message_,
            pts=pts_,
            pts_count=pts_count_
        )

class UpdateBotCallbackQuery(TLObject, family='TypeUpdate'):
    """
    A callback button was pressed, and the button data was sent to the bot that created the button
    """

    _id = 0XB9CFC48D
    _group_id = 0X54E058F5

    def __init__(
        self,
        query_id: int,
        user_id: int,
        peer: 'TypePeer',
        msg_id: int,
        chat_instance: int,
        data: Optional[bytes] = None,
        game_short_name: Optional[str] = None
    ):

        """
        A callback button was pressed, and the button data was sent to the bot that created the button

        Args:
            query_id (int): Query ID
            user_id (int): ID of the user that pressed the button
            peer ('TypePeer'): Chat where the inline keyboard was sent
            msg_id (int): Message ID
            chat_instance (int): Global identifier, uniquely corresponding to the chat to which the message with the callback button was sent. Useful for high scores in games.
            data (Optional[bytes], optional): Callback data
            game_short_name (Optional[str], optional): Short name of a Game to be returned, serves as the unique identifier for the game
        """

        self.query_id = query_id
        self.user_id = user_id
        self.peer = peer
        self.msg_id = msg_id
        self.chat_instance = chat_instance
        self.data = data
        self.game_short_name = game_short_name

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x8d\xc4\xcf\xb9' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.query_id)
                writer.long(self.user_id)
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )
                writer.int(self.msg_id)
                writer.long(self.chat_instance)

                if flags(self.data, 0):
                    writer.bytes(self.data)

                if flags(self.game_short_name, 1):
                    writer.string(self.game_short_name)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        query_id_ = reader.long()
        user_id_ = reader.long()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        msg_id_ = reader.int()
        chat_instance_ = reader.long()
        data_ = (
            reader.bytes()
            if flags(0) else None
        )

        game_short_name_ = (
            reader.string()
            if flags(1) else None
        )

        return cls(
            query_id=query_id_,
            user_id=user_id_,
            peer=peer_,
            msg_id=msg_id_,
            chat_instance=chat_instance_,
            data=data_,
            game_short_name=game_short_name_
        )

class UpdateEditMessage(TLObject, family='TypeUpdate'):
    """
    A message was edited
    """

    _id = 0XE40370A3
    _group_id = 0X54E058F5

    def __init__(
        self,
        message: 'TypeMessage',
        pts: int,
        pts_count: int
    ):

        """
        A message was edited

        Args:
            message ('TypeMessage'): The new edited message
            pts (int): [PTS](https://core.telegram.org/api/updates)
            pts_count (int): [PTS count](https://core.telegram.org/api/updates)
        """

        self.message = message
        self.pts = pts
        self.pts_count = pts_count

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa3p\x03\xe4' if boxed else b'') as writer:
            writer.object(
                self.message,
                group_id=0X25780A8F
            )
            writer.int(self.pts)
            writer.int(self.pts_count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        message_ = reader.object(
            group_id=0X25780A8F
        )

        pts_ = reader.int()
        pts_count_ = reader.int()

        return cls(
            message=message_,
            pts=pts_,
            pts_count=pts_count_
        )

class UpdateInlineBotCallbackQuery(TLObject, family='TypeUpdate'):
    """
    This notification is received by bots when a button is pressed
    """

    _id = 0X691E9052
    _group_id = 0X54E058F5

    def __init__(
        self,
        query_id: int,
        user_id: int,
        msg_id: 'TypeInputBotInlineMessageID',
        chat_instance: int,
        data: Optional[bytes] = None,
        game_short_name: Optional[str] = None
    ):

        """
        This notification is received by bots when a button is pressed

        Args:
            query_id (int): Query ID
            user_id (int): ID of the user that pressed the button
            msg_id ('TypeInputBotInlineMessageID'): ID of the inline message with the button
            chat_instance (int): Global identifier, uniquely corresponding to the chat to which the message with the callback button was sent. Useful for high scores in games.
            data (Optional[bytes], optional): Data associated with the callback button. Be aware that a bad client can send arbitrary data in this field.
            game_short_name (Optional[str], optional): Short name of a Game to be returned, serves as the unique identifier for the game
        """

        self.query_id = query_id
        self.user_id = user_id
        self.msg_id = msg_id
        self.chat_instance = chat_instance
        self.data = data
        self.game_short_name = game_short_name

    def to_bytes(self, boxed: bool=True):
        with Writer(b'R\x90\x1ei' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.query_id)
                writer.long(self.user_id)
                writer.object(
                    self.msg_id,
                    group_id=0XE8D574CF
                )
                writer.long(self.chat_instance)

                if flags(self.data, 0):
                    writer.bytes(self.data)

                if flags(self.game_short_name, 1):
                    writer.string(self.game_short_name)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        query_id_ = reader.long()
        user_id_ = reader.long()
        msg_id_ = reader.object(
            group_id=0XE8D574CF
        )

        chat_instance_ = reader.long()
        data_ = (
            reader.bytes()
            if flags(0) else None
        )

        game_short_name_ = (
            reader.string()
            if flags(1) else None
        )

        return cls(
            query_id=query_id_,
            user_id=user_id_,
            msg_id=msg_id_,
            chat_instance=chat_instance_,
            data=data_,
            game_short_name=game_short_name_
        )

class UpdateReadChannelOutbox(TLObject, family='TypeUpdate'):
    """
    Outgoing messages in a [channel/supergroup](https://core.telegram.org/api/channel) were read
    """

    _id = 0XB75F99A9
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        max_id: int
    ):

        """
        Outgoing messages in a [channel/supergroup](https://core.telegram.org/api/channel) were read

        Args:
            channel_id (int): Channel/supergroup ID
            max_id (int): Position up to which all outgoing messages are read.
        """

        self.channel_id = channel_id
        self.max_id = max_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa9\x99_\xb7' if boxed else b'') as writer:
            writer.long(self.channel_id)
            writer.int(self.max_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        channel_id_ = reader.long()
        max_id_ = reader.int()

        return cls(
            channel_id=channel_id_,
            max_id=max_id_
        )

class UpdateDraftMessage(TLObject, family='TypeUpdate'):
    """
    Notifies a change of a message [draft](https://core.telegram.org/api/drafts).
    """

    _id = 0XEDFC111E
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        draft: 'TypeDraftMessage',
        top_msg_id: Optional[int] = None,
        saved_peer_id: Optional['TypePeer'] = None
    ):

        """
        Notifies a change of a message [draft](https://core.telegram.org/api/drafts).

        Args:
            peer ('TypePeer'): The peer to which the draft is associated
            draft ('TypeDraftMessage'): The draft
            top_msg_id (Optional[int], optional): ID of the [forum topic](https://core.telegram.org/api/forum#forum-topics) to which the draft is associated
            saved_peer_id (Optional['TypePeer'], optional): ...
        """

        self.peer = peer
        self.draft = draft
        self.top_msg_id = top_msg_id
        self.saved_peer_id = saved_peer_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1e\x11\xfc\xed' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )

                if flags(self.top_msg_id, 0):
                    writer.int(self.top_msg_id)

                if flags(self.saved_peer_id, 1):
                    writer.object(
                        self.saved_peer_id,
                        group_id=0XB4DECBCA
                    )
                writer.object(
                    self.draft,
                    group_id=0X314F6157
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        top_msg_id_ = (
            reader.int()
            if flags(0) else None
        )

        saved_peer_id_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(1) else None
        )

        draft_ = reader.object(
            group_id=0X314F6157
        )

        return cls(
            peer=peer_,
            draft=draft_,
            top_msg_id=top_msg_id_,
            saved_peer_id=saved_peer_id_
        )

class UpdateReadFeaturedStickers(TLObject, family='TypeUpdate'):
    """
    Some featured stickers were marked as read
    """

    _id = 0X571D2742
    _group_id = 0X54E058F5


    def to_bytes(self, boxed: bool=True):
        return b"B'\x1dW" if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class UpdateRecentStickers(TLObject, family='TypeUpdate'):
    """
    The recent sticker list was updated
    """

    _id = 0X9A422C20
    _group_id = 0X54E058F5


    def to_bytes(self, boxed: bool=True):
        return b' ,B\x9a' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class UpdateConfig(TLObject, family='TypeUpdate'):
    """
    The server-side configuration has changed; the client should re-fetch the config using [help.getConfig](https://core.telegram.org/method/help.getConfig) and [help.getAppConfig](https://core.telegram.org/method/help.getAppConfig).
    """

    _id = 0XA229DD06
    _group_id = 0X54E058F5


    def to_bytes(self, boxed: bool=True):
        return b'\x06\xdd)\xa2' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class UpdatePtsChanged(TLObject, family='TypeUpdate'):
    """
    [Common message box sequence PTS](https://core.telegram.org/api/updates) has changed, [state has to be refetched using updates.getState](https://core.telegram.org/api/updates#fetching-state)
    """

    _id = 0X3354678F
    _group_id = 0X54E058F5


    def to_bytes(self, boxed: bool=True):
        return b'\x8fgT3' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class UpdateChannelWebPage(TLObject, family='TypeUpdate'):
    """
    A webpage preview of a link in a [channel/supergroup](https://core.telegram.org/api/channel) message was generated
    """

    _id = 0X2F2BA99F
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        webpage: 'TypeWebPage',
        pts: int,
        pts_count: int
    ):

        """
        A webpage preview of a link in a [channel/supergroup](https://core.telegram.org/api/channel) message was generated

        Args:
            channel_id (int): [Channel/supergroup](https://core.telegram.org/api/channel) ID
            webpage ('TypeWebPage'): Generated webpage preview
            pts (int): [Event count after generation](https://core.telegram.org/api/updates)
            pts_count (int): [Number of events that were generated](https://core.telegram.org/api/updates)
        """

        self.channel_id = channel_id
        self.webpage = webpage
        self.pts = pts
        self.pts_count = pts_count

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9f\xa9+/' if boxed else b'') as writer:
            writer.long(self.channel_id)
            writer.object(
                self.webpage,
                group_id=0X9D177ED
            )
            writer.int(self.pts)
            writer.int(self.pts_count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        channel_id_ = reader.long()
        webpage_ = reader.object(
            group_id=0X9D177ED
        )

        pts_ = reader.int()
        pts_count_ = reader.int()

        return cls(
            channel_id=channel_id_,
            webpage=webpage_,
            pts=pts_,
            pts_count=pts_count_
        )

class UpdateDialogPinned(TLObject, family='TypeUpdate'):
    """
    A dialog was pinned/unpinned
    """

    _id = 0X6E6FE51C
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypeDialogPeer',
        pinned: bool = False,
        folder_id: Optional[int] = None
    ):

        """
        A dialog was pinned/unpinned

        Args:
            peer ('TypeDialogPeer'): The dialog
            pinned (bool, optional): Whether the dialog was pinned
            folder_id (Optional[int], optional): [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
        """

        self.peer = peer
        self.pinned = pinned
        self.folder_id = folder_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1c\xe5on' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.pinned, 0)

                if flags(self.folder_id, 1):
                    writer.int(self.folder_id)
                writer.object(
                    self.peer,
                    group_id=0X1152797B
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        folder_id_ = (
            reader.int()
            if flags(1) else None
        )

        peer_ = reader.object(
            group_id=0X1152797B
        )

        return cls(
            peer=peer_,
            pinned=flags(0),
            folder_id=folder_id_
        )

class UpdatePinnedDialogs(TLObject, family='TypeUpdate'):
    """
    Pinned dialogs were updated
    """

    _id = 0XFA0F3CA2
    _group_id = 0X54E058F5

    def __init__(
        self,
        folder_id: Optional[int] = None,
        order: Optional[List['TypeDialogPeer']] = None
    ):

        """
        Pinned dialogs were updated

        Args:
            folder_id (Optional[int], optional): [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
            order (Optional[List['TypeDialogPeer']], optional): New order of pinned dialogs
        """

        self.folder_id = folder_id
        self.order = order

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa2<\x0f\xfa' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.folder_id, 1):
                    writer.int(self.folder_id)

                if flags(self.order, 0):
                    writer.vector(
                        self.order,
                        lambda value: writer.object(
                            value,
                            group_id=0X1152797B
                        )
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        folder_id_ = (
            reader.int()
            if flags(1) else None
        )

        order_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X1152797B
                )
            )
            if flags(0) else None
        )

        return cls(
            folder_id=folder_id_,
            order=order_
        )

class UpdateBotWebhookJSON(TLObject, family='TypeUpdate'):
    """
    A new incoming event **for bots only**
    """

    _id = 0X8317C0C3
    _group_id = 0X54E058F5

    def __init__(
        self,
        data: 'TypeDataJSON'
    ):

        """
        A new incoming event **for bots only**

        Args:
            data ('TypeDataJSON'): The event
        """

        self.data = data

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc3\xc0\x17\x83' if boxed else b'') as writer:
            writer.object(
                self.data,
                group_id=0XE95B0798
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        data_ = reader.object(
            group_id=0XE95B0798
        )

        return cls(
            data=data_
        )

class UpdateBotWebhookJSONQuery(TLObject, family='TypeUpdate'):
    """
    A new incoming query **for bots only**
    """

    _id = 0X9B9240A6
    _group_id = 0X54E058F5

    def __init__(
        self,
        query_id: int,
        data: 'TypeDataJSON',
        timeout: int
    ):

        """
        A new incoming query **for bots only**

        Args:
            query_id (int): Query identifier
            data ('TypeDataJSON'): Query data
            timeout (int): Query timeout
        """

        self.query_id = query_id
        self.data = data
        self.timeout = timeout

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa6@\x92\x9b' if boxed else b'') as writer:
            writer.long(self.query_id)
            writer.object(
                self.data,
                group_id=0XE95B0798
            )
            writer.int(self.timeout)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        query_id_ = reader.long()
        data_ = reader.object(
            group_id=0XE95B0798
        )

        timeout_ = reader.int()

        return cls(
            query_id=query_id_,
            data=data_,
            timeout=timeout_
        )

class UpdateBotShippingQuery(TLObject, family='TypeUpdate'):
    """
    This object contains information about an incoming shipping query.
    """

    _id = 0XB5AEFD7D
    _group_id = 0X54E058F5

    def __init__(
        self,
        query_id: int,
        user_id: int,
        payload: bytes,
        shipping_address: 'TypePostAddress'
    ):

        """
        This object contains information about an incoming shipping query.

        Args:
            query_id (int): Unique query identifier
            user_id (int): User who sent the query
            payload (bytes): Bot specified invoice payload
            shipping_address ('TypePostAddress'): User specified shipping address
        """

        self.query_id = query_id
        self.user_id = user_id
        self.payload = payload
        self.shipping_address = shipping_address

    def to_bytes(self, boxed: bool=True):
        with Writer(b'}\xfd\xae\xb5' if boxed else b'') as writer:
            writer.long(self.query_id)
            writer.long(self.user_id)
            writer.bytes(self.payload)
            writer.object(
                self.shipping_address,
                group_id=0X7BF3C2EF
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        query_id_ = reader.long()
        user_id_ = reader.long()
        payload_ = reader.bytes()
        shipping_address_ = reader.object(
            group_id=0X7BF3C2EF
        )

        return cls(
            query_id=query_id_,
            user_id=user_id_,
            payload=payload_,
            shipping_address=shipping_address_
        )

class UpdateBotPrecheckoutQuery(TLObject, family='TypeUpdate'):
    """
    This object contains information about an incoming pre-checkout query.
    """

    _id = 0X8CAA9A96
    _group_id = 0X54E058F5

    def __init__(
        self,
        query_id: int,
        user_id: int,
        payload: bytes,
        currency: str,
        total_amount: int,
        info: Optional['TypePaymentRequestedInfo'] = None,
        shipping_option_id: Optional[str] = None
    ):

        """
        This object contains information about an incoming pre-checkout query.

        Args:
            query_id (int): Unique query identifier
            user_id (int): User who sent the query
            payload (bytes): Bot specified invoice payload
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code, or XTR for [Telegram Stars](https://core.telegram.org/api/stars).
            total_amount (int): Total amount in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            info (Optional['TypePaymentRequestedInfo'], optional): Order info provided by the user
            shipping_option_id (Optional[str], optional): Identifier of the shipping option chosen by the user
        """

        self.query_id = query_id
        self.user_id = user_id
        self.payload = payload
        self.currency = currency
        self.total_amount = total_amount
        self.info = info
        self.shipping_option_id = shipping_option_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x96\x9a\xaa\x8c' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.query_id)
                writer.long(self.user_id)
                writer.bytes(self.payload)

                if flags(self.info, 0):
                    writer.object(
                        self.info,
                        group_id=0X89AE5563
                    )

                if flags(self.shipping_option_id, 1):
                    writer.string(self.shipping_option_id)
                writer.string(self.currency)
                writer.long(self.total_amount)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        query_id_ = reader.long()
        user_id_ = reader.long()
        payload_ = reader.bytes()
        info_ = (
            reader.object(
                group_id=0X89AE5563
            )
            if flags(0) else None
        )

        shipping_option_id_ = (
            reader.string()
            if flags(1) else None
        )

        currency_ = reader.string()
        total_amount_ = reader.long()

        return cls(
            query_id=query_id_,
            user_id=user_id_,
            payload=payload_,
            currency=currency_,
            total_amount=total_amount_,
            info=info_,
            shipping_option_id=shipping_option_id_
        )

class UpdatePhoneCall(TLObject, family='TypeUpdate'):
    """
    An incoming phone call
    """

    _id = 0XAB0F6B1E
    _group_id = 0X54E058F5

    def __init__(
        self,
        phone_call: 'TypePhoneCall'
    ):

        """
        An incoming phone call

        Args:
            phone_call ('TypePhoneCall'): Phone call
        """

        self.phone_call = phone_call

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1ek\x0f\xab' if boxed else b'') as writer:
            writer.object(
                self.phone_call,
                group_id=0X943E32B8
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        phone_call_ = reader.object(
            group_id=0X943E32B8
        )

        return cls(
            phone_call=phone_call_
        )

class UpdateLangPackTooLong(TLObject, family='TypeUpdate'):
    """
    A language pack has changed, the client should manually fetch the changed strings using [langpack.getDifference](https://core.telegram.org/method/langpack.getDifference)
    """

    _id = 0X46560264
    _group_id = 0X54E058F5

    def __init__(
        self,
        lang_code: str
    ):

        """
        A language pack has changed, the client should manually fetch the changed strings using [langpack.getDifference](https://core.telegram.org/method/langpack.getDifference)

        Args:
            lang_code (str): Language code
        """

        self.lang_code = lang_code

    def to_bytes(self, boxed: bool=True):
        with Writer(b'd\x02VF' if boxed else b'') as writer:
            writer.string(self.lang_code)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        lang_code_ = reader.string()

        return cls(
            lang_code=lang_code_
        )

class UpdateLangPack(TLObject, family='TypeUpdate'):
    """
    Language pack updated
    """

    _id = 0X56022F4D
    _group_id = 0X54E058F5

    def __init__(
        self,
        difference: 'TypeLangPackDifference'
    ):

        """
        Language pack updated

        Args:
            difference ('TypeLangPackDifference'): Changed strings
        """

        self.difference = difference

    def to_bytes(self, boxed: bool=True):
        with Writer(b'M/\x02V' if boxed else b'') as writer:
            writer.object(
                self.difference,
                group_id=0XAA6D15ED
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        difference_ = reader.object(
            group_id=0XAA6D15ED
        )

        return cls(
            difference=difference_
        )

class UpdateFavedStickers(TLObject, family='TypeUpdate'):
    """
    The list of favorited stickers was changed, the client should call [messages.getFavedStickers](https://core.telegram.org/method/messages.getFavedStickers) to refetch the new list
    """

    _id = 0XE511996D
    _group_id = 0X54E058F5


    def to_bytes(self, boxed: bool=True):
        return b'm\x99\x11\xe5' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class UpdateChannelReadMessagesContents(TLObject, family='TypeUpdate'):
    """
    The specified [channel/supergroup](https://core.telegram.org/api/channel) messages were read
    """

    _id = 0X25F324F7
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        messages: List[int],
        top_msg_id: Optional[int] = None,
        saved_peer_id: Optional['TypePeer'] = None
    ):

        """
        The specified [channel/supergroup](https://core.telegram.org/api/channel) messages were read

        Args:
            channel_id (int): [Channel/supergroup](https://core.telegram.org/api/channel) ID
            messages (List[int]): IDs of messages that were read
            top_msg_id (Optional[int], optional): [Forum topic ID](https://core.telegram.org/api/forum#forum-topics).
            saved_peer_id (Optional['TypePeer'], optional): ...
        """

        self.channel_id = channel_id
        self.messages = messages
        self.top_msg_id = top_msg_id
        self.saved_peer_id = saved_peer_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf7$\xf3%' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.channel_id)

                if flags(self.top_msg_id, 0):
                    writer.int(self.top_msg_id)

                if flags(self.saved_peer_id, 1):
                    writer.object(
                        self.saved_peer_id,
                        group_id=0XB4DECBCA
                    )
                writer.vector(
                    self.messages,
                    writer.int
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        channel_id_ = reader.long()
        top_msg_id_ = (
            reader.int()
            if flags(0) else None
        )

        saved_peer_id_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(1) else None
        )

        messages_ = reader.vector(
            reader.int
        )

        return cls(
            channel_id=channel_id_,
            messages=messages_,
            top_msg_id=top_msg_id_,
            saved_peer_id=saved_peer_id_
        )

class UpdateContactsReset(TLObject, family='TypeUpdate'):
    """
    All contacts were deleted
    """

    _id = 0X7084A7BE
    _group_id = 0X54E058F5


    def to_bytes(self, boxed: bool=True):
        return b'\xbe\xa7\x84p' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class UpdateChannelAvailableMessages(TLObject, family='TypeUpdate'):
    """
    The history of a [channel/supergroup](https://core.telegram.org/api/channel) was hidden.
    """

    _id = 0XB23FC698
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        available_min_id: int
    ):

        """
        The history of a [channel/supergroup](https://core.telegram.org/api/channel) was hidden.

        Args:
            channel_id (int): Channel/supergroup ID
            available_min_id (int): Identifier of a maximum unavailable message in a channel due to hidden history.
        """

        self.channel_id = channel_id
        self.available_min_id = available_min_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x98\xc6?\xb2' if boxed else b'') as writer:
            writer.long(self.channel_id)
            writer.int(self.available_min_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        channel_id_ = reader.long()
        available_min_id_ = reader.int()

        return cls(
            channel_id=channel_id_,
            available_min_id=available_min_id_
        )

class UpdateDialogUnreadMark(TLObject, family='TypeUpdate'):
    """
    The manual unread mark of a chat was changed
    """

    _id = 0XB658F23E
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypeDialogPeer',
        unread: bool = False,
        saved_peer_id: Optional['TypePeer'] = None
    ):

        """
        The manual unread mark of a chat was changed

        Args:
            peer ('TypeDialogPeer'): The dialog
            unread (bool, optional): Was the chat marked or unmarked as read
            saved_peer_id (Optional['TypePeer'], optional): ...
        """

        self.peer = peer
        self.unread = unread
        self.saved_peer_id = saved_peer_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'>\xf2X\xb6' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.unread, 0)
                writer.object(
                    self.peer,
                    group_id=0X1152797B
                )

                if flags(self.saved_peer_id, 1):
                    writer.object(
                        self.saved_peer_id,
                        group_id=0XB4DECBCA
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0X1152797B
        )

        saved_peer_id_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(1) else None
        )

        return cls(
            peer=peer_,
            unread=flags(0),
            saved_peer_id=saved_peer_id_
        )

class UpdateMessagePoll(TLObject, family='TypeUpdate'):
    """
    The results of a poll have changed
    """

    _id = 0XACA1657B
    _group_id = 0X54E058F5

    def __init__(
        self,
        poll_id: int,
        results: 'TypePollResults',
        poll: Optional['TypePoll'] = None
    ):

        """
        The results of a poll have changed

        Args:
            poll_id (int): Poll ID
            results ('TypePollResults'): New poll results
            poll (Optional['TypePoll'], optional): If the server knows the client hasn't cached this poll yet, the poll itself
        """

        self.poll_id = poll_id
        self.results = results
        self.poll = poll

    def to_bytes(self, boxed: bool=True):
        with Writer(b'{e\xa1\xac' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.poll_id)

                if flags(self.poll, 0):
                    writer.object(
                        self.poll,
                        group_id=0X9284C836
                    )
                writer.object(
                    self.results,
                    group_id=0X3539EE44
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        poll_id_ = reader.long()
        poll_ = (
            reader.object(
                group_id=0X9284C836
            )
            if flags(0) else None
        )

        results_ = reader.object(
            group_id=0X3539EE44
        )

        return cls(
            poll_id=poll_id_,
            results=results_,
            poll=poll_
        )

class UpdateChatDefaultBannedRights(TLObject, family='TypeUpdate'):
    """
    Default banned rights in a [normal chat](https://core.telegram.org/api/channel) were updated
    """

    _id = 0X54C01850
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        default_banned_rights: 'TypeChatBannedRights',
        version: int
    ):

        """
        Default banned rights in a [normal chat](https://core.telegram.org/api/channel) were updated

        Args:
            peer ('TypePeer'): The chat
            default_banned_rights ('TypeChatBannedRights'): New default banned rights
            version (int): Version
        """

        self.peer = peer
        self.default_banned_rights = default_banned_rights
        self.version = version

    def to_bytes(self, boxed: bool=True):
        with Writer(b'P\x18\xc0T' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.object(
                self.default_banned_rights,
                group_id=0XDB47663A
            )
            writer.int(self.version)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        default_banned_rights_ = reader.object(
            group_id=0XDB47663A
        )

        version_ = reader.int()

        return cls(
            peer=peer_,
            default_banned_rights=default_banned_rights_,
            version=version_
        )

class UpdateFolderPeers(TLObject, family='TypeUpdate'):
    """
    The peer list of a [peer folder](https://core.telegram.org/api/folders#peer-folders) was updated
    """

    _id = 0X19360DC0
    _group_id = 0X54E058F5

    def __init__(
        self,
        folder_peers: List['TypeFolderPeer'],
        pts: int,
        pts_count: int
    ):

        """
        The peer list of a [peer folder](https://core.telegram.org/api/folders#peer-folders) was updated

        Args:
            folder_peers (List['TypeFolderPeer']): New peer list
            pts (int): [Event count after generation](https://core.telegram.org/api/updates)
            pts_count (int): [Number of events that were generated](https://core.telegram.org/api/updates)
        """

        self.folder_peers = folder_peers
        self.pts = pts
        self.pts_count = pts_count

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc0\r6\x19' if boxed else b'') as writer:
            writer.vector(
                self.folder_peers,
                lambda value: writer.object(
                    value,
                    group_id=0XC7CCB0EE
                )
            )
            writer.int(self.pts)
            writer.int(self.pts_count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        folder_peers_ = reader.vector(
            lambda: reader.object(
                group_id=0XC7CCB0EE
            )
        )

        pts_ = reader.int()
        pts_count_ = reader.int()

        return cls(
            folder_peers=folder_peers_,
            pts=pts_,
            pts_count=pts_count_
        )

class UpdatePeerSettings(TLObject, family='TypeUpdate'):
    """
    Settings of a certain peer have changed
    """

    _id = 0X6A7E7366
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        settings: 'TypePeerSettings'
    ):

        """
        Settings of a certain peer have changed

        Args:
            peer ('TypePeer'): The peer
            settings ('TypePeerSettings'): Associated peer settings
        """

        self.peer = peer
        self.settings = settings

    def to_bytes(self, boxed: bool=True):
        with Writer(b'fs~j' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.object(
                self.settings,
                group_id=0XF43C8196
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        settings_ = reader.object(
            group_id=0XF43C8196
        )

        return cls(
            peer=peer_,
            settings=settings_
        )

class UpdatePeerLocated(TLObject, family='TypeUpdate'):
    """
    List of peers near you was updated
    """

    _id = 0XB4AFCFB0
    _group_id = 0X54E058F5

    def __init__(
        self,
        peers: List['TypePeerLocated']
    ):

        """
        List of peers near you was updated

        Args:
            peers (List['TypePeerLocated']): Geolocated peer list update
        """

        self.peers = peers

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb0\xcf\xaf\xb4' if boxed else b'') as writer:
            writer.vector(
                self.peers,
                lambda value: writer.object(
                    value,
                    group_id=0XC572C6F
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peers_ = reader.vector(
            lambda: reader.object(
                group_id=0XC572C6F
            )
        )

        return cls(
            peers=peers_
        )

class UpdateNewScheduledMessage(TLObject, family='TypeUpdate'):
    """
    A message was added to the [schedule queue of a chat](https://core.telegram.org/api/scheduled-messages)
    """

    _id = 0X39A51DFB
    _group_id = 0X54E058F5

    def __init__(
        self,
        message: 'TypeMessage'
    ):

        """
        A message was added to the [schedule queue of a chat](https://core.telegram.org/api/scheduled-messages)

        Args:
            message ('TypeMessage'): Message
        """

        self.message = message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfb\x1d\xa59' if boxed else b'') as writer:
            writer.object(
                self.message,
                group_id=0X25780A8F
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        message_ = reader.object(
            group_id=0X25780A8F
        )

        return cls(
            message=message_
        )

class UpdateDeleteScheduledMessages(TLObject, family='TypeUpdate'):
    """
    Some [scheduled messages](https://core.telegram.org/api/scheduled-messages) were deleted (or sent) from the schedule queue of a chat
    """

    _id = 0XF2A71983
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        messages: List[int],
        sent_messages: Optional[List[int]] = None
    ):

        """
        Some [scheduled messages](https://core.telegram.org/api/scheduled-messages) were deleted (or sent) from the schedule queue of a chat

        Args:
            peer ('TypePeer'): Peer
            messages (List[int]): Deleted scheduled messages
            sent_messages (Optional[List[int]], optional): If set, this update indicates that some scheduled messages were sent (not simply deleted from the schedule queue).  In this case, the messages field will contain the scheduled message IDs for the sent messages (initially returned in [updateNewScheduledMessage](https://core.telegram.org/constructor/updateNewScheduledMessage)), and sent_messages will contain the real message IDs for the sent messages.
        """

        self.peer = peer
        self.messages = messages
        self.sent_messages = sent_messages

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x83\x19\xa7\xf2' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )
                writer.vector(
                    self.messages,
                    writer.int
                )

                if flags(self.sent_messages, 0):
                    writer.vector(
                        self.sent_messages,
                        writer.int
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        messages_ = reader.vector(
            reader.int
        )

        sent_messages_ = (
            reader.vector(
                reader.int
            )
            if flags(0) else None
        )

        return cls(
            peer=peer_,
            messages=messages_,
            sent_messages=sent_messages_
        )

class UpdateTheme(TLObject, family='TypeUpdate'):
    """
    A cloud theme was updated
    """

    _id = 0X8216FBA3
    _group_id = 0X54E058F5

    def __init__(
        self,
        theme: 'TypeTheme'
    ):

        """
        A cloud theme was updated

        Args:
            theme ('TypeTheme'): Theme
        """

        self.theme = theme

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa3\xfb\x16\x82' if boxed else b'') as writer:
            writer.object(
                self.theme,
                group_id=0X5E6FFFBC
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        theme_ = reader.object(
            group_id=0X5E6FFFBC
        )

        return cls(
            theme=theme_
        )

class UpdateGeoLiveViewed(TLObject, family='TypeUpdate'):
    """
    Live geoposition message was viewed
    """

    _id = 0X871FB939
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        msg_id: int
    ):

        """
        Live geoposition message was viewed

        Args:
            peer ('TypePeer'): The user that viewed the live geoposition
            msg_id (int): Message ID of geoposition message
        """

        self.peer = peer
        self.msg_id = msg_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'9\xb9\x1f\x87' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.int(self.msg_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        msg_id_ = reader.int()

        return cls(
            peer=peer_,
            msg_id=msg_id_
        )

class UpdateLoginToken(TLObject, family='TypeUpdate'):
    """
    A login token (for login via QR code) was accepted.
    """

    _id = 0X564FE691
    _group_id = 0X54E058F5


    def to_bytes(self, boxed: bool=True):
        return b'\x91\xe6OV' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class UpdateMessagePollVote(TLObject, family='TypeUpdate'):
    """
    A specific peer has voted in a poll
    """

    _id = 0X24F40E77
    _group_id = 0X54E058F5

    def __init__(
        self,
        poll_id: int,
        peer: 'TypePeer',
        options: List[bytes],
        qts: int
    ):

        """
        A specific peer has voted in a poll

        Args:
            poll_id (int): Poll ID
            peer ('TypePeer'): The peer that voted in the poll
            options (List[bytes]): Chosen option(s)
            qts (int): New qts value, see [updates](https://core.telegram.org/api/updates) for more info.
        """

        self.poll_id = poll_id
        self.peer = peer
        self.options = options
        self.qts = qts

    def to_bytes(self, boxed: bool=True):
        with Writer(b'w\x0e\xf4$' if boxed else b'') as writer:
            writer.long(self.poll_id)
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.vector(
                self.options,
                writer.bytes
            )
            writer.int(self.qts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        poll_id_ = reader.long()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        options_ = reader.vector(
            reader.bytes
        )

        qts_ = reader.int()

        return cls(
            poll_id=poll_id_,
            peer=peer_,
            options=options_,
            qts=qts_
        )

class UpdateDialogFilter(TLObject, family='TypeUpdate'):
    """
    A new [folder](https://core.telegram.org/api/folders) was added
    """

    _id = 0X26FFDE7D
    _group_id = 0X54E058F5

    def __init__(
        self,
        id: int,
        filter: Optional['TypeDialogFilter'] = None
    ):

        """
        A new [folder](https://core.telegram.org/api/folders) was added

        Args:
            id (int): [Folder](https://core.telegram.org/api/folders) ID
            filter (Optional['TypeDialogFilter'], optional): [Folder](https://core.telegram.org/api/folders) info
        """

        self.id = id
        self.filter = filter

    def to_bytes(self, boxed: bool=True):
        with Writer(b'}\xde\xff&' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.int(self.id)

                if flags(self.filter, 0):
                    writer.object(
                        self.filter,
                        group_id=0X6BB0DA45
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.int()
        filter_ = (
            reader.object(
                group_id=0X6BB0DA45
            )
            if flags(0) else None
        )

        return cls(
            id=id_,
            filter=filter_
        )

class UpdateDialogFilterOrder(TLObject, family='TypeUpdate'):
    """
    New [folder](https://core.telegram.org/api/folders) order
    """

    _id = 0XA5D72105
    _group_id = 0X54E058F5

    def __init__(
        self,
        order: List[int]
    ):

        """
        New [folder](https://core.telegram.org/api/folders) order

        Args:
            order (List[int]): Ordered [folder IDs](https://core.telegram.org/api/folders)
        """

        self.order = order

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x05!\xd7\xa5' if boxed else b'') as writer:
            writer.vector(
                self.order,
                writer.int
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        order_ = reader.vector(
            reader.int
        )

        return cls(
            order=order_
        )

class UpdateDialogFilters(TLObject, family='TypeUpdate'):
    """
    Clients should update [folder](https://core.telegram.org/api/folders) info
    """

    _id = 0X3504914F
    _group_id = 0X54E058F5


    def to_bytes(self, boxed: bool=True):
        return b'O\x91\x045' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class UpdatePhoneCallSignalingData(TLObject, family='TypeUpdate'):
    """
    Incoming phone call signaling payload
    """

    _id = 0X2661BF09
    _group_id = 0X54E058F5

    def __init__(
        self,
        phone_call_id: int,
        data: bytes
    ):

        """
        Incoming phone call signaling payload

        Args:
            phone_call_id (int): Phone call ID
            data (bytes): Signaling payload
        """

        self.phone_call_id = phone_call_id
        self.data = data

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\t\xbfa&' if boxed else b'') as writer:
            writer.long(self.phone_call_id)
            writer.bytes(self.data)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        phone_call_id_ = reader.long()
        data_ = reader.bytes()

        return cls(
            phone_call_id=phone_call_id_,
            data=data_
        )

class UpdateChannelMessageForwards(TLObject, family='TypeUpdate'):
    """
    The forward counter of a message in a channel has changed
    """

    _id = 0XD29A27F4
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        id: int,
        forwards: int
    ):

        """
        The forward counter of a message in a channel has changed

        Args:
            channel_id (int): Channel ID
            id (int): ID of the message
            forwards (int): New forward counter
        """

        self.channel_id = channel_id
        self.id = id
        self.forwards = forwards

    def to_bytes(self, boxed: bool=True):
        with Writer(b"\xf4'\x9a\xd2" if boxed else b'') as writer:
            writer.long(self.channel_id)
            writer.int(self.id)
            writer.int(self.forwards)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        channel_id_ = reader.long()
        id_ = reader.int()
        forwards_ = reader.int()

        return cls(
            channel_id=channel_id_,
            id=id_,
            forwards=forwards_
        )

class UpdateReadChannelDiscussionInbox(TLObject, family='TypeUpdate'):
    """
    Incoming comments in a [discussion thread](https://core.telegram.org/api/threads) were marked as read
    """

    _id = 0XD6B19546
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        top_msg_id: int,
        read_max_id: int,
        broadcast_id: Optional[int] = None,
        broadcast_post: Optional[int] = None
    ):

        """
        Incoming comments in a [discussion thread](https://core.telegram.org/api/threads) were marked as read

        Args:
            channel_id (int): [Discussion group ID](https://core.telegram.org/api/channel)
            top_msg_id (int): ID of the group message that started the [thread](https://core.telegram.org/api/threads) (message in linked discussion group)
            read_max_id (int): Message ID of latest read incoming message for this [thread](https://core.telegram.org/api/threads)
            broadcast_id (Optional[int], optional): If set, contains the ID of the [channel](https://core.telegram.org/api/channel) that contains the post that started the [comment thread](https://core.telegram.org/api/threads) in the discussion group ( channel_id)
            broadcast_post (Optional[int], optional): If set, contains the ID of the channel post that started the [comment thread](https://core.telegram.org/api/threads)
        """

        self.channel_id = channel_id
        self.top_msg_id = top_msg_id
        self.read_max_id = read_max_id
        self.broadcast_id = broadcast_id
        self.broadcast_post = broadcast_post

    def to_bytes(self, boxed: bool=True):
        with Writer(b'F\x95\xb1\xd6' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.channel_id)
                writer.int(self.top_msg_id)
                writer.int(self.read_max_id)

                if flags(self.broadcast_id, 0):
                    writer.long(self.broadcast_id)

                if flags(self.broadcast_post, 0):
                    writer.int(self.broadcast_post)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        channel_id_ = reader.long()
        top_msg_id_ = reader.int()
        read_max_id_ = reader.int()
        broadcast_id_ = (
            reader.long()
            if flags(0) else None
        )

        broadcast_post_ = (
            reader.int()
            if flags(0) else None
        )

        return cls(
            channel_id=channel_id_,
            top_msg_id=top_msg_id_,
            read_max_id=read_max_id_,
            broadcast_id=broadcast_id_,
            broadcast_post=broadcast_post_
        )

class UpdateReadChannelDiscussionOutbox(TLObject, family='TypeUpdate'):
    """
    Outgoing comments in a [discussion thread](https://core.telegram.org/api/threads) were marked as read
    """

    _id = 0X695C9E7C
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        top_msg_id: int,
        read_max_id: int
    ):

        """
        Outgoing comments in a [discussion thread](https://core.telegram.org/api/threads) were marked as read

        Args:
            channel_id (int): [Supergroup ID](https://core.telegram.org/api/channel)
            top_msg_id (int): ID of the group message that started the [thread](https://core.telegram.org/api/threads)
            read_max_id (int): Message ID of latest read outgoing message for this [thread](https://core.telegram.org/api/threads)
        """

        self.channel_id = channel_id
        self.top_msg_id = top_msg_id
        self.read_max_id = read_max_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'|\x9e\\i' if boxed else b'') as writer:
            writer.long(self.channel_id)
            writer.int(self.top_msg_id)
            writer.int(self.read_max_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        channel_id_ = reader.long()
        top_msg_id_ = reader.int()
        read_max_id_ = reader.int()

        return cls(
            channel_id=channel_id_,
            top_msg_id=top_msg_id_,
            read_max_id=read_max_id_
        )

class UpdatePeerBlocked(TLObject, family='TypeUpdate'):
    """
    We blocked a peer, see [here](https://core.telegram.org/api/block) for more info on blocklists.
    """

    _id = 0XEBE07752
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer_id: 'TypePeer',
        blocked: bool = False,
        blocked_my_stories_from: bool = False
    ):

        """
        We blocked a peer, see [here](https://core.telegram.org/api/block) for more info on blocklists.

        Args:
            peer_id ('TypePeer'): The (un)blocked peer
            blocked (bool, optional): Whether the peer was blocked or unblocked
            blocked_my_stories_from (bool, optional): Whether the peer was added/removed to/from the story blocklist; if not set, this update affects the main blocklist, see [here](https://core.telegram.org/api/block) for more info.
        """

        self.peer_id = peer_id
        self.blocked = blocked
        self.blocked_my_stories_from = blocked_my_stories_from

    def to_bytes(self, boxed: bool=True):
        with Writer(b'Rw\xe0\xeb' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.blocked, 0)
                flags(self.blocked_my_stories_from, 1)
                writer.object(
                    self.peer_id,
                    group_id=0XB4DECBCA
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_id_ = reader.object(
            group_id=0XB4DECBCA
        )

        return cls(
            peer_id=peer_id_,
            blocked=flags(0),
            blocked_my_stories_from=flags(1)
        )

class UpdateChannelUserTyping(TLObject, family='TypeUpdate'):
    """
    A user is typing in a [supergroup, channel](https://core.telegram.org/api/channel) or [message thread](https://core.telegram.org/api/threads)
    """

    _id = 0X8C88C923
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        from_id: 'TypePeer',
        action: 'TypeSendMessageAction',
        top_msg_id: Optional[int] = None
    ):

        """
        A user is typing in a [supergroup, channel](https://core.telegram.org/api/channel) or [message thread](https://core.telegram.org/api/threads)

        Args:
            channel_id (int): Channel ID
            from_id ('TypePeer'): The peer that is typing
            action ('TypeSendMessageAction'): Whether the user is typing, sending a media or doing something else
            top_msg_id (Optional[int], optional): [Thread ID](https://core.telegram.org/api/threads)
        """

        self.channel_id = channel_id
        self.from_id = from_id
        self.action = action
        self.top_msg_id = top_msg_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'#\xc9\x88\x8c' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.channel_id)

                if flags(self.top_msg_id, 0):
                    writer.int(self.top_msg_id)
                writer.object(
                    self.from_id,
                    group_id=0XB4DECBCA
                )
                writer.object(
                    self.action,
                    group_id=0X49241DFC
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        channel_id_ = reader.long()
        top_msg_id_ = (
            reader.int()
            if flags(0) else None
        )

        from_id_ = reader.object(
            group_id=0XB4DECBCA
        )

        action_ = reader.object(
            group_id=0X49241DFC
        )

        return cls(
            channel_id=channel_id_,
            from_id=from_id_,
            action=action_,
            top_msg_id=top_msg_id_
        )

class UpdatePinnedMessages(TLObject, family='TypeUpdate'):
    """
    Some messages were pinned in a chat
    """

    _id = 0XED85EAB5
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        messages: List[int],
        pts: int,
        pts_count: int,
        pinned: bool = False
    ):

        """
        Some messages were pinned in a chat

        Args:
            peer ('TypePeer'): Peer
            messages (List[int]): Message IDs
            pts (int): [Event count after generation](https://core.telegram.org/api/updates)
            pts_count (int): [Number of events that were generated](https://core.telegram.org/api/updates)
            pinned (bool, optional): Whether the messages were pinned or unpinned
        """

        self.peer = peer
        self.messages = messages
        self.pts = pts
        self.pts_count = pts_count
        self.pinned = pinned

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb5\xea\x85\xed' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.pinned, 0)
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )
                writer.vector(
                    self.messages,
                    writer.int
                )
                writer.int(self.pts)
                writer.int(self.pts_count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        messages_ = reader.vector(
            reader.int
        )

        pts_ = reader.int()
        pts_count_ = reader.int()

        return cls(
            peer=peer_,
            messages=messages_,
            pts=pts_,
            pts_count=pts_count_,
            pinned=flags(0)
        )

class UpdatePinnedChannelMessages(TLObject, family='TypeUpdate'):
    """
    Messages were pinned/unpinned in a [channel/supergroup](https://core.telegram.org/api/channel)
    """

    _id = 0X5BB98608
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        messages: List[int],
        pts: int,
        pts_count: int,
        pinned: bool = False
    ):

        """
        Messages were pinned/unpinned in a [channel/supergroup](https://core.telegram.org/api/channel)

        Args:
            channel_id (int): Channel ID
            messages (List[int]): Messages
            pts (int): [Event count after generation](https://core.telegram.org/api/updates)
            pts_count (int): [Number of events that were generated](https://core.telegram.org/api/updates)
            pinned (bool, optional): Whether the messages were pinned or unpinned
        """

        self.channel_id = channel_id
        self.messages = messages
        self.pts = pts
        self.pts_count = pts_count
        self.pinned = pinned

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x08\x86\xb9[' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.pinned, 0)
                writer.long(self.channel_id)
                writer.vector(
                    self.messages,
                    writer.int
                )
                writer.int(self.pts)
                writer.int(self.pts_count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        channel_id_ = reader.long()
        messages_ = reader.vector(
            reader.int
        )

        pts_ = reader.int()
        pts_count_ = reader.int()

        return cls(
            channel_id=channel_id_,
            messages=messages_,
            pts=pts_,
            pts_count=pts_count_,
            pinned=flags(0)
        )

class UpdateChat(TLObject, family='TypeUpdate'):
    """
    Chat ( [chat](https://core.telegram.org/constructor/chat) and/or [chatFull](https://core.telegram.org/constructor/chatFull)) information was updated.
    """

    _id = 0XF89A6A4E
    _group_id = 0X54E058F5

    def __init__(
        self,
        chat_id: int
    ):

        """
        Chat ( [chat](https://core.telegram.org/constructor/chat) and/or [chatFull](https://core.telegram.org/constructor/chatFull)) information was updated.

        Args:
            chat_id (int): Chat ID
        """

        self.chat_id = chat_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'Nj\x9a\xf8' if boxed else b'') as writer:
            writer.long(self.chat_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        chat_id_ = reader.long()

        return cls(
            chat_id=chat_id_
        )

class UpdateGroupCallParticipants(TLObject, family='TypeUpdate'):
    """
    The participant list of a certain group call has changed
    """

    _id = 0XF2EBDB4E
    _group_id = 0X54E058F5

    def __init__(
        self,
        call: 'TypeInputGroupCall',
        participants: List['TypeGroupCallParticipant'],
        version: int
    ):

        """
        The participant list of a certain group call has changed

        Args:
            call ('TypeInputGroupCall'): Group call
            participants (List['TypeGroupCallParticipant']): New participant list
            version (int): Version
        """

        self.call = call
        self.participants = participants
        self.version = version

    def to_bytes(self, boxed: bool=True):
        with Writer(b'N\xdb\xeb\xf2' if boxed else b'') as writer:
            writer.object(
                self.call,
                group_id=0XDA9A559A
            )
            writer.vector(
                self.participants,
                lambda value: writer.object(
                    value,
                    group_id=0XC404CB69
                )
            )
            writer.int(self.version)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        call_ = reader.object(
            group_id=0XDA9A559A
        )

        participants_ = reader.vector(
            lambda: reader.object(
                group_id=0XC404CB69
            )
        )

        version_ = reader.int()

        return cls(
            call=call_,
            participants=participants_,
            version=version_
        )

class UpdateGroupCall(TLObject, family='TypeUpdate'):
    """
    A new groupcall was started
    """

    _id = 0X97D64341
    _group_id = 0X54E058F5

    def __init__(
        self,
        call: 'TypeGroupCall',
        chat_id: Optional[int] = None
    ):

        """
        A new groupcall was started

        Args:
            call ('TypeGroupCall'): Info about the group call or livestream
            chat_id (Optional[int], optional): The [channel/supergroup](https://core.telegram.org/api/channel) where this group call or livestream takes place
        """

        self.call = call
        self.chat_id = chat_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'AC\xd6\x97' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.chat_id, 0):
                    writer.long(self.chat_id)
                writer.object(
                    self.call,
                    group_id=0X70F5DA49
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        chat_id_ = (
            reader.long()
            if flags(0) else None
        )

        call_ = reader.object(
            group_id=0X70F5DA49
        )

        return cls(
            call=call_,
            chat_id=chat_id_
        )

class UpdatePeerHistoryTTL(TLObject, family='TypeUpdate'):
    """
    The Time-To-Live for messages sent by the current user in a specific chat has changed
    """

    _id = 0XBB9BB9A5
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        ttl_period: Optional[int] = None
    ):

        """
        The Time-To-Live for messages sent by the current user in a specific chat has changed

        Args:
            peer ('TypePeer'): The chat
            ttl_period (Optional[int], optional): The new Time-To-Live
        """

        self.peer = peer
        self.ttl_period = ttl_period

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa5\xb9\x9b\xbb' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )

                if flags(self.ttl_period, 0):
                    writer.int(self.ttl_period)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        ttl_period_ = (
            reader.int()
            if flags(0) else None
        )

        return cls(
            peer=peer_,
            ttl_period=ttl_period_
        )

class UpdateChatParticipant(TLObject, family='TypeUpdate'):
    """
    A user has joined or left a specific chat
    """

    _id = 0XD087663A
    _group_id = 0X54E058F5

    def __init__(
        self,
        chat_id: int,
        date: int,
        actor_id: int,
        user_id: int,
        qts: int,
        prev_participant: Optional['TypeChatParticipant'] = None,
        new_participant: Optional['TypeChatParticipant'] = None,
        invite: Optional['TypeExportedChatInvite'] = None
    ):

        """
        A user has joined or left a specific chat

        Args:
            chat_id (int): [Chat](https://core.telegram.org/api/channel) ID
            date (int): When did this event occur
            actor_id (int): User that triggered the change (inviter, admin that kicked the user, or the even the user_id itself)
            user_id (int): User that was affected by the change
            qts (int): New qts value, see [updates](https://core.telegram.org/api/updates) for more info.
            prev_participant (Optional['TypeChatParticipant'], optional): Previous participant info (empty if this participant just joined)
            new_participant (Optional['TypeChatParticipant'], optional): New participant info (empty if this participant just left)
            invite (Optional['TypeExportedChatInvite'], optional): The invite that was used to join the group
        """

        self.chat_id = chat_id
        self.date = date
        self.actor_id = actor_id
        self.user_id = user_id
        self.qts = qts
        self.prev_participant = prev_participant
        self.new_participant = new_participant
        self.invite = invite

    def to_bytes(self, boxed: bool=True):
        with Writer(b':f\x87\xd0' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.chat_id)
                writer.int(self.date)
                writer.long(self.actor_id)
                writer.long(self.user_id)

                if flags(self.prev_participant, 0):
                    writer.object(
                        self.prev_participant,
                        group_id=0XD1426D89
                    )

                if flags(self.new_participant, 1):
                    writer.object(
                        self.new_participant,
                        group_id=0XD1426D89
                    )

                if flags(self.invite, 2):
                    writer.object(
                        self.invite,
                        group_id=0X4C7FB2E0
                    )
                writer.int(self.qts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        chat_id_ = reader.long()
        date_ = reader.int()
        actor_id_ = reader.long()
        user_id_ = reader.long()
        prev_participant_ = (
            reader.object(
                group_id=0XD1426D89
            )
            if flags(0) else None
        )

        new_participant_ = (
            reader.object(
                group_id=0XD1426D89
            )
            if flags(1) else None
        )

        invite_ = (
            reader.object(
                group_id=0X4C7FB2E0
            )
            if flags(2) else None
        )

        qts_ = reader.int()

        return cls(
            chat_id=chat_id_,
            date=date_,
            actor_id=actor_id_,
            user_id=user_id_,
            qts=qts_,
            prev_participant=prev_participant_,
            new_participant=new_participant_,
            invite=invite_
        )

class UpdateChannelParticipant(TLObject, family='TypeUpdate'):
    """
    A participant has left, joined, was banned or admined in a [channel or supergroup](https://core.telegram.org/api/channel).
    """

    _id = 0X985D3ABB
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        date: int,
        actor_id: int,
        user_id: int,
        qts: int,
        via_chatlist: bool = False,
        prev_participant: Optional['TypeChannelParticipant'] = None,
        new_participant: Optional['TypeChannelParticipant'] = None,
        invite: Optional['TypeExportedChatInvite'] = None
    ):

        """
        A participant has left, joined, was banned or admined in a [channel or supergroup](https://core.telegram.org/api/channel).

        Args:
            channel_id (int): Channel ID
            date (int): Date of the event
            actor_id (int): User that triggered the change (inviter, admin that kicked the user, or the even the user_id itself)
            user_id (int): User that was affected by the change
            qts (int): New qts value, see [updates](https://core.telegram.org/api/updates) for more info.
            via_chatlist (bool, optional): Whether the participant joined using a [chat folder deep link](https://core.telegram.org/api/links#chat-folder-links).
            prev_participant (Optional['TypeChannelParticipant'], optional): Previous participant status
            new_participant (Optional['TypeChannelParticipant'], optional): New participant status
            invite (Optional['TypeExportedChatInvite'], optional): Chat invite used to join the [channel/supergroup](https://core.telegram.org/api/channel)
        """

        self.channel_id = channel_id
        self.date = date
        self.actor_id = actor_id
        self.user_id = user_id
        self.qts = qts
        self.via_chatlist = via_chatlist
        self.prev_participant = prev_participant
        self.new_participant = new_participant
        self.invite = invite

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xbb:]\x98' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.via_chatlist, 3)
                writer.long(self.channel_id)
                writer.int(self.date)
                writer.long(self.actor_id)
                writer.long(self.user_id)

                if flags(self.prev_participant, 0):
                    writer.object(
                        self.prev_participant,
                        group_id=0X21CCC4A0
                    )

                if flags(self.new_participant, 1):
                    writer.object(
                        self.new_participant,
                        group_id=0X21CCC4A0
                    )

                if flags(self.invite, 2):
                    writer.object(
                        self.invite,
                        group_id=0X4C7FB2E0
                    )
                writer.int(self.qts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        channel_id_ = reader.long()
        date_ = reader.int()
        actor_id_ = reader.long()
        user_id_ = reader.long()
        prev_participant_ = (
            reader.object(
                group_id=0X21CCC4A0
            )
            if flags(0) else None
        )

        new_participant_ = (
            reader.object(
                group_id=0X21CCC4A0
            )
            if flags(1) else None
        )

        invite_ = (
            reader.object(
                group_id=0X4C7FB2E0
            )
            if flags(2) else None
        )

        qts_ = reader.int()

        return cls(
            channel_id=channel_id_,
            date=date_,
            actor_id=actor_id_,
            user_id=user_id_,
            qts=qts_,
            via_chatlist=flags(3),
            prev_participant=prev_participant_,
            new_participant=new_participant_,
            invite=invite_
        )

class UpdateBotStopped(TLObject, family='TypeUpdate'):
    """
    A bot was stopped or re-started.
    """

    _id = 0XC4870A49
    _group_id = 0X54E058F5

    def __init__(
        self,
        user_id: int,
        date: int,
        stopped: bool,
        qts: int
    ):

        """
        A bot was stopped or re-started.

        Args:
            user_id (int): The user ID
            date (int): When did this action occur
            stopped (bool): Whether the bot was stopped or started
            qts (int): New qts value, see [updates](https://core.telegram.org/api/updates) for more info.
        """

        self.user_id = user_id
        self.date = date
        self.stopped = stopped
        self.qts = qts

    def to_bytes(self, boxed: bool=True):
        with Writer(b'I\n\x87\xc4' if boxed else b'') as writer:
            writer.long(self.user_id)
            writer.int(self.date)
            writer.object(
                self.stopped,
                group_id=0X43B904E1
            )
            writer.int(self.qts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        user_id_ = reader.long()
        date_ = reader.int()
        stopped_ = reader.object(
            group_id=0X43B904E1
        )

        qts_ = reader.int()

        return cls(
            user_id=user_id_,
            date=date_,
            stopped=stopped_,
            qts=qts_
        )

class UpdateGroupCallConnection(TLObject, family='TypeUpdate'):
    """
    New WebRTC parameters
    """

    _id = 0XB783982
    _group_id = 0X54E058F5

    def __init__(
        self,
        params: 'TypeDataJSON',
        presentation: bool = False
    ):

        """
        New WebRTC parameters

        Args:
            params ('TypeDataJSON'): WebRTC parameters
            presentation (bool, optional): Are these parameters related to the screen capture session currently in progress?
        """

        self.params = params
        self.presentation = presentation

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x829x\x0b' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.presentation, 0)
                writer.object(
                    self.params,
                    group_id=0XE95B0798
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        params_ = reader.object(
            group_id=0XE95B0798
        )

        return cls(
            params=params_,
            presentation=flags(0)
        )

class UpdateBotCommands(TLObject, family='TypeUpdate'):
    """
    The [command set](https://core.telegram.org/api/bots/commands) of a certain bot in a certain chat has changed.
    """

    _id = 0X4D712F2E
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        bot_id: int,
        commands: List['TypeBotCommand']
    ):

        """
        The [command set](https://core.telegram.org/api/bots/commands) of a certain bot in a certain chat has changed.

        Args:
            peer ('TypePeer'): The affected chat
            bot_id (int): ID of the bot that changed its command set
            commands (List['TypeBotCommand']): New bot commands
        """

        self.peer = peer
        self.bot_id = bot_id
        self.commands = commands

    def to_bytes(self, boxed: bool=True):
        with Writer(b'./qM' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.long(self.bot_id)
            writer.vector(
                self.commands,
                lambda value: writer.object(
                    value,
                    group_id=0X3A20FA17
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        bot_id_ = reader.long()
        commands_ = reader.vector(
            lambda: reader.object(
                group_id=0X3A20FA17
            )
        )

        return cls(
            peer=peer_,
            bot_id=bot_id_,
            commands=commands_
        )

class UpdatePendingJoinRequests(TLObject, family='TypeUpdate'):
    """
    Someone has requested to join a chat or channel
    """

    _id = 0X7063C3DB
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        requests_pending: int,
        recent_requesters: List[int]
    ):

        """
        Someone has requested to join a chat or channel

        Args:
            peer ('TypePeer'): Chat or channel
            requests_pending (int): Number of pending [join requests](https://core.telegram.org/api/invites#join-requests) for the chat or channel
            recent_requesters (List[int]): IDs of users that have recently requested to join
        """

        self.peer = peer
        self.requests_pending = requests_pending
        self.recent_requesters = recent_requesters

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xdb\xc3cp' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.int(self.requests_pending)
            writer.vector(
                self.recent_requesters,
                writer.long
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        requests_pending_ = reader.int()
        recent_requesters_ = reader.vector(
            reader.long
        )

        return cls(
            peer=peer_,
            requests_pending=requests_pending_,
            recent_requesters=recent_requesters_
        )

class UpdateBotChatInviteRequester(TLObject, family='TypeUpdate'):
    """
    Someone has requested to join a chat or channel (bots only, users will receive an [updatePendingJoinRequests](https://core.telegram.org/constructor/updatePendingJoinRequests), instead)
    """

    _id = 0X11DFA986
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        date: int,
        user_id: int,
        about: str,
        invite: 'TypeExportedChatInvite',
        qts: int
    ):

        """
        Someone has requested to join a chat or channel (bots only, users will receive an [updatePendingJoinRequests](https://core.telegram.org/constructor/updatePendingJoinRequests), instead)

        Args:
            peer ('TypePeer'): The chat or channel in question
            date (int): When was the [join request](https://core.telegram.org/api/invites#join-requests) made
            user_id (int): The user ID that is asking to join the chat or channel
            about (str): Bio of the user
            invite ('TypeExportedChatInvite'): Chat invite link that was used by the user to send the [join request](https://core.telegram.org/api/invites#join-requests)
            qts (int): [QTS](https://core.telegram.org/api/updates) event sequence identifier
        """

        self.peer = peer
        self.date = date
        self.user_id = user_id
        self.about = about
        self.invite = invite
        self.qts = qts

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x86\xa9\xdf\x11' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.int(self.date)
            writer.long(self.user_id)
            writer.string(self.about)
            writer.object(
                self.invite,
                group_id=0X4C7FB2E0
            )
            writer.int(self.qts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        date_ = reader.int()
        user_id_ = reader.long()
        about_ = reader.string()
        invite_ = reader.object(
            group_id=0X4C7FB2E0
        )

        qts_ = reader.int()

        return cls(
            peer=peer_,
            date=date_,
            user_id=user_id_,
            about=about_,
            invite=invite_,
            qts=qts_
        )

class UpdateMessageReactions(TLObject, family='TypeUpdate'):
    """
    New [message reactions](https://core.telegram.org/api/reactions) are available
    """

    _id = 0X1E297BFA
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        msg_id: int,
        reactions: 'TypeMessageReactions',
        top_msg_id: Optional[int] = None,
        saved_peer_id: Optional['TypePeer'] = None
    ):

        """
        New [message reactions](https://core.telegram.org/api/reactions) are available

        Args:
            peer ('TypePeer'): Peer
            msg_id (int): Message ID
            reactions ('TypeMessageReactions'): Reactions
            top_msg_id (Optional[int], optional): [Forum topic ID](https://core.telegram.org/api/forum#forum-topics)
            saved_peer_id (Optional['TypePeer'], optional): ...
        """

        self.peer = peer
        self.msg_id = msg_id
        self.reactions = reactions
        self.top_msg_id = top_msg_id
        self.saved_peer_id = saved_peer_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfa{)\x1e' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )
                writer.int(self.msg_id)

                if flags(self.top_msg_id, 0):
                    writer.int(self.top_msg_id)

                if flags(self.saved_peer_id, 1):
                    writer.object(
                        self.saved_peer_id,
                        group_id=0XB4DECBCA
                    )
                writer.object(
                    self.reactions,
                    group_id=0X1A48248F
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        msg_id_ = reader.int()
        top_msg_id_ = (
            reader.int()
            if flags(0) else None
        )

        saved_peer_id_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(1) else None
        )

        reactions_ = reader.object(
            group_id=0X1A48248F
        )

        return cls(
            peer=peer_,
            msg_id=msg_id_,
            reactions=reactions_,
            top_msg_id=top_msg_id_,
            saved_peer_id=saved_peer_id_
        )

class UpdateAttachMenuBots(TLObject, family='TypeUpdate'):
    """
    The list of installed [attachment menu entries](https://core.telegram.org/api/bots/attach) has changed, use [messages.getAttachMenuBots](https://core.telegram.org/method/messages.getAttachMenuBots) to fetch the updated list.
    """

    _id = 0X17B7A20B
    _group_id = 0X54E058F5


    def to_bytes(self, boxed: bool=True):
        return b'\x0b\xa2\xb7\x17' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class UpdateWebViewResultSent(TLObject, family='TypeUpdate'):
    """
    Indicates to a bot that a webview was closed and an inline message was sent on behalf of the user using [messages.sendWebViewResultMessage](https://core.telegram.org/method/messages.sendWebViewResultMessage)
    """

    _id = 0X1592B79D
    _group_id = 0X54E058F5

    def __init__(
        self,
        query_id: int
    ):

        """
        Indicates to a bot that a webview was closed and an inline message was sent on behalf of the user using [messages.sendWebViewResultMessage](https://core.telegram.org/method/messages.sendWebViewResultMessage)

        Args:
            query_id (int): Web app interaction ID
        """

        self.query_id = query_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9d\xb7\x92\x15' if boxed else b'') as writer:
            writer.long(self.query_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        query_id_ = reader.long()

        return cls(
            query_id=query_id_
        )

class UpdateBotMenuButton(TLObject, family='TypeUpdate'):
    """
    The menu button behavior for the specified bot has changed
    """

    _id = 0X14B85813
    _group_id = 0X54E058F5

    def __init__(
        self,
        bot_id: int,
        button: 'TypeBotMenuButton'
    ):

        """
        The menu button behavior for the specified bot has changed

        Args:
            bot_id (int): Bot ID
            button ('TypeBotMenuButton'): New menu button
        """

        self.bot_id = bot_id
        self.button = button

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x13X\xb8\x14' if boxed else b'') as writer:
            writer.long(self.bot_id)
            writer.object(
                self.button,
                group_id=0XBFCA576A
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        bot_id_ = reader.long()
        button_ = reader.object(
            group_id=0XBFCA576A
        )

        return cls(
            bot_id=bot_id_,
            button=button_
        )

class UpdateSavedRingtones(TLObject, family='TypeUpdate'):
    """
    The list of saved notification sounds has changed, use [account.getSavedRingtones](https://core.telegram.org/method/account.getSavedRingtones) to fetch the new list.
    """

    _id = 0X74D8BE99
    _group_id = 0X54E058F5


    def to_bytes(self, boxed: bool=True):
        return b'\x99\xbe\xd8t' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class UpdateTranscribedAudio(TLObject, family='TypeUpdate'):
    """
    A pending [voice message transcription](https://core.telegram.org/api/transcribe) initiated with [messages.transcribeAudio](https://core.telegram.org/method/messages.transcribeAudio) was updated.
    """

    _id = 0X84CD5A
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        msg_id: int,
        transcription_id: int,
        text: str,
        pending: bool = False
    ):

        """
        A pending [voice message transcription](https://core.telegram.org/api/transcribe) initiated with [messages.transcribeAudio](https://core.telegram.org/method/messages.transcribeAudio) was updated.

        Args:
            peer ('TypePeer'): Peer of the transcribed message
            msg_id (int): Transcribed message ID
            transcription_id (int): Transcription ID
            text (str): Transcribed text
            pending (bool, optional): Whether this transcription is still pending and further [updateTranscribedAudio](https://core.telegram.org/constructor/updateTranscribedAudio) about it will be sent in the future.
        """

        self.peer = peer
        self.msg_id = msg_id
        self.transcription_id = transcription_id
        self.text = text
        self.pending = pending

    def to_bytes(self, boxed: bool=True):
        with Writer(b'Z\xcd\x84\x00' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.pending, 0)
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )
                writer.int(self.msg_id)
                writer.long(self.transcription_id)
                writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        msg_id_ = reader.int()
        transcription_id_ = reader.long()
        text_ = reader.string()

        return cls(
            peer=peer_,
            msg_id=msg_id_,
            transcription_id=transcription_id_,
            text=text_,
            pending=flags(0)
        )

class UpdateReadFeaturedEmojiStickers(TLObject, family='TypeUpdate'):
    """
    Some featured [custom emoji stickers](https://core.telegram.org/api/custom-emoji) were marked as read
    """

    _id = 0XFB4C496C
    _group_id = 0X54E058F5


    def to_bytes(self, boxed: bool=True):
        return b'lIL\xfb' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class UpdateUserEmojiStatus(TLObject, family='TypeUpdate'):
    """
    The [emoji status](https://core.telegram.org/api/emoji-status) of a certain user has changed
    """

    _id = 0X28373599
    _group_id = 0X54E058F5

    def __init__(
        self,
        user_id: int,
        emoji_status: 'TypeEmojiStatus'
    ):

        """
        The [emoji status](https://core.telegram.org/api/emoji-status) of a certain user has changed

        Args:
            user_id (int): User ID
            emoji_status ('TypeEmojiStatus'): New [emoji status](https://core.telegram.org/api/emoji-status)
        """

        self.user_id = user_id
        self.emoji_status = emoji_status

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9957(' if boxed else b'') as writer:
            writer.long(self.user_id)
            writer.object(
                self.emoji_status,
                group_id=0XFBDA9FB
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        user_id_ = reader.long()
        emoji_status_ = reader.object(
            group_id=0XFBDA9FB
        )

        return cls(
            user_id=user_id_,
            emoji_status=emoji_status_
        )

class UpdateRecentEmojiStatuses(TLObject, family='TypeUpdate'):
    """
    The list of recent [emoji statuses](https://core.telegram.org/api/emoji-status) has changed
    """

    _id = 0X30F443DB
    _group_id = 0X54E058F5


    def to_bytes(self, boxed: bool=True):
        return b'\xdbC\xf40' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class UpdateRecentReactions(TLObject, family='TypeUpdate'):
    """
    The list of recent [message reactions](https://core.telegram.org/api/reactions) has changed
    """

    _id = 0X6F7863F4
    _group_id = 0X54E058F5


    def to_bytes(self, boxed: bool=True):
        return b'\xf4cxo' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class UpdateMoveStickerSetToTop(TLObject, family='TypeUpdate'):
    """
    A stickerset was just moved to top, [see here for more info](https://core.telegram.org/api/stickers#recent-stickersets)
    """

    _id = 0X86FCCF85
    _group_id = 0X54E058F5

    def __init__(
        self,
        stickerset: int,
        masks: bool = False,
        emojis: bool = False
    ):

        """
        A stickerset was just moved to top, [see here for more info](https://core.telegram.org/api/stickers#recent-stickersets)

        Args:
            stickerset (int): [Stickerset](https://core.telegram.org/api/stickers) ID
            masks (bool, optional): This update is referring to a [mask stickerset](https://core.telegram.org/api/stickers#mask-stickers)
            emojis (bool, optional): This update is referring to a [custom emoji stickerset](https://core.telegram.org/api/custom-emoji)
        """

        self.stickerset = stickerset
        self.masks = masks
        self.emojis = emojis

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x85\xcf\xfc\x86' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.masks, 0)
                flags(self.emojis, 1)
                writer.long(self.stickerset)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        stickerset_ = reader.long()

        return cls(
            stickerset=stickerset_,
            masks=flags(0),
            emojis=flags(1)
        )

class UpdateMessageExtendedMedia(TLObject, family='TypeUpdate'):
    """
    You [bought a paid media](https://core.telegram.org/api/paid-media): this update contains the revealed media.
    """

    _id = 0XD5A41724
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        msg_id: int,
        extended_media: List['TypeMessageExtendedMedia']
    ):

        """
        You [bought a paid media](https://core.telegram.org/api/paid-media): this update contains the revealed media.

        Args:
            peer ('TypePeer'): Peer where the paid media was posted
            msg_id (int): ID of the message containing the paid media
            extended_media (List['TypeMessageExtendedMedia']): Revealed media, contains only [messageExtendedMedia](https://core.telegram.org/constructor/messageExtendedMedia) constructors.
        """

        self.peer = peer
        self.msg_id = msg_id
        self.extended_media = extended_media

    def to_bytes(self, boxed: bool=True):
        with Writer(b'$\x17\xa4\xd5' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.int(self.msg_id)
            writer.vector(
                self.extended_media,
                lambda value: writer.object(
                    value,
                    group_id=0X9339BD78
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        msg_id_ = reader.int()
        extended_media_ = reader.vector(
            lambda: reader.object(
                group_id=0X9339BD78
            )
        )

        return cls(
            peer=peer_,
            msg_id=msg_id_,
            extended_media=extended_media_
        )

class UpdateChannelPinnedTopic(TLObject, family='TypeUpdate'):
    """
    A [forum topic](https://core.telegram.org/api/forum#forum-topics) was pinned or unpinned.
    """

    _id = 0X192EFBE3
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        topic_id: int,
        pinned: bool = False
    ):

        """
        A [forum topic](https://core.telegram.org/api/forum#forum-topics) was pinned or unpinned.

        Args:
            channel_id (int): The forum ID
            topic_id (int): The topic ID
            pinned (bool, optional): Whether the topic was pinned or unpinned
        """

        self.channel_id = channel_id
        self.topic_id = topic_id
        self.pinned = pinned

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe3\xfb.\x19' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.pinned, 0)
                writer.long(self.channel_id)
                writer.int(self.topic_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        channel_id_ = reader.long()
        topic_id_ = reader.int()

        return cls(
            channel_id=channel_id_,
            topic_id=topic_id_,
            pinned=flags(0)
        )

class UpdateChannelPinnedTopics(TLObject, family='TypeUpdate'):
    """
    The [pinned topics](https://core.telegram.org/api/forum#forum-topics) of a forum have changed.
    """

    _id = 0XFE198602
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        order: Optional[List[int]] = None
    ):

        """
        The [pinned topics](https://core.telegram.org/api/forum#forum-topics) of a forum have changed.

        Args:
            channel_id (int): Forum ID.
            order (Optional[List[int]], optional): Ordered list containing the IDs of all pinned topics.
        """

        self.channel_id = channel_id
        self.order = order

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x02\x86\x19\xfe' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.channel_id)

                if flags(self.order, 0):
                    writer.vector(
                        self.order,
                        writer.int
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        channel_id_ = reader.long()
        order_ = (
            reader.vector(
                reader.int
            )
            if flags(0) else None
        )

        return cls(
            channel_id=channel_id_,
            order=order_
        )

class UpdateUser(TLObject, family='TypeUpdate'):
    """
    User ( [user](https://core.telegram.org/constructor/user) and/or [userFull](https://core.telegram.org/constructor/userFull)) information was updated.
    """

    _id = 0X20529438
    _group_id = 0X54E058F5

    def __init__(
        self,
        user_id: int
    ):

        """
        User ( [user](https://core.telegram.org/constructor/user) and/or [userFull](https://core.telegram.org/constructor/userFull)) information was updated.

        Args:
            user_id (int): User ID
        """

        self.user_id = user_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'8\x94R ' if boxed else b'') as writer:
            writer.long(self.user_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        user_id_ = reader.long()

        return cls(
            user_id=user_id_
        )

class UpdateAutoSaveSettings(TLObject, family='TypeUpdate'):
    """
    Media autosave settings have changed and must be refetched using [account.getAutoSaveSettings](https://core.telegram.org/method/account.getAutoSaveSettings).
    """

    _id = 0XEC05B097
    _group_id = 0X54E058F5


    def to_bytes(self, boxed: bool=True):
        return b'\x97\xb0\x05\xec' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class UpdateStory(TLObject, family='TypeUpdate'):
    """
    A new story was posted.
    """

    _id = 0X75B3B798
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        story: 'TypeStoryItem'
    ):

        """
        A new story was posted.

        Args:
            peer ('TypePeer'): ID of the poster.
            story ('TypeStoryItem'): The story that was posted.
        """

        self.peer = peer
        self.story = story

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x98\xb7\xb3u' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.object(
                self.story,
                group_id=0X8436985A
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        story_ = reader.object(
            group_id=0X8436985A
        )

        return cls(
            peer=peer_,
            story=story_
        )

class UpdateReadStories(TLObject, family='TypeUpdate'):
    """
    Stories of a specific peer were marked as read.
    """

    _id = 0XF74E932B
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        max_id: int
    ):

        """
        Stories of a specific peer were marked as read.

        Args:
            peer ('TypePeer'): The peer
            max_id (int): ID of the last story that was marked as read
        """

        self.peer = peer
        self.max_id = max_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'+\x93N\xf7' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.int(self.max_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        max_id_ = reader.int()

        return cls(
            peer=peer_,
            max_id=max_id_
        )

class UpdateStoryID(TLObject, family='TypeUpdate'):
    """
    A story was successfully uploaded.
    """

    _id = 0X1BF335B9
    _group_id = 0X54E058F5

    def __init__(
        self,
        id: int,
        random_id: int = None
    ):

        """
        A story was successfully uploaded.

        Args:
            id (int): The id that was attributed to the story.
            random_id (int, optional): The random_id that was passed to [stories.sendStory](https://core.telegram.org/method/stories.sendStory).
        """

        self.id = id
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb95\xf3\x1b' if boxed else b'') as writer:
            writer.int(self.id)
            writer.long(self.random_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.int()
        random_id_ = reader.long()

        return cls(
            id=id_,
            random_id=random_id_
        )

class UpdateStoriesStealthMode(TLObject, family='TypeUpdate'):
    """
    Indicates that [stories stealth mode](https://core.telegram.org/api/stories#stealth-mode) was activated.
    """

    _id = 0X2C084DC1
    _group_id = 0X54E058F5

    def __init__(
        self,
        stealth_mode: 'TypeStoriesStealthMode'
    ):

        """
        Indicates that [stories stealth mode](https://core.telegram.org/api/stories#stealth-mode) was activated.

        Args:
            stealth_mode ('TypeStoriesStealthMode'): Information about the current [stealth mode](https://core.telegram.org/api/stories#stealth-mode) session.
        """

        self.stealth_mode = stealth_mode

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc1M\x08,' if boxed else b'') as writer:
            writer.object(
                self.stealth_mode,
                group_id=0XFAE6BCB9
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        stealth_mode_ = reader.object(
            group_id=0XFAE6BCB9
        )

        return cls(
            stealth_mode=stealth_mode_
        )

class UpdateSentStoryReaction(TLObject, family='TypeUpdate'):
    """
    Indicates we [reacted to a story](https://core.telegram.org/api/stories#reactions).
    """

    _id = 0X7D627683
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        story_id: int,
        reaction: 'TypeReaction'
    ):

        """
        Indicates we [reacted to a story](https://core.telegram.org/api/stories#reactions).

        Args:
            peer ('TypePeer'): The peer that sent the story
            story_id (int): ID of the story we reacted to
            reaction ('TypeReaction'): The reaction that was sent
        """

        self.peer = peer
        self.story_id = story_id
        self.reaction = reaction

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x83vb}' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.int(self.story_id)
            writer.object(
                self.reaction,
                group_id=0X19F930D1
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        story_id_ = reader.int()
        reaction_ = reader.object(
            group_id=0X19F930D1
        )

        return cls(
            peer=peer_,
            story_id=story_id_,
            reaction=reaction_
        )

class UpdateBotChatBoost(TLObject, family='TypeUpdate'):
    """
    A [channel/supergroup boost](https://core.telegram.org/api/boost) has changed (bots only)
    """

    _id = 0X904DD49C
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        boost: 'TypeBoost',
        qts: int
    ):

        """
        A [channel/supergroup boost](https://core.telegram.org/api/boost) has changed (bots only)

        Args:
            peer ('TypePeer'): Channel
            boost ('TypeBoost'): New boost information
            qts (int): [QTS](https://core.telegram.org/api/updates) event sequence identifier
        """

        self.peer = peer
        self.boost = boost
        self.qts = qts

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9c\xd4M\x90' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.object(
                self.boost,
                group_id=0X9F7E3FDC
            )
            writer.int(self.qts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        boost_ = reader.object(
            group_id=0X9F7E3FDC
        )

        qts_ = reader.int()

        return cls(
            peer=peer_,
            boost=boost_,
            qts=qts_
        )

class UpdateChannelViewForumAsMessages(TLObject, family='TypeUpdate'):
    """
    Users may also choose to display messages from all topics as if they were sent to a normal group, using a "View as messages" setting in the local client. 
    This setting only affects the current account, and is synced to other logged in sessions using the [channels.toggleViewForumAsMessages](https://core.telegram.org/method/channels.toggleViewForumAsMessages) method; invoking this method will update the value of the view_forum_as_messages flag of [channelFull](https://core.telegram.org/constructor/channelFull) or [dialog](https://core.telegram.org/constructor/dialog) and emit an [updateChannelViewForumAsMessages](https://core.telegram.org/constructor/updateChannelViewForumAsMessages).
    """

    _id = 0X7B68920
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        enabled: bool
    ):

        """
        Users may also choose to display messages from all topics as if they were sent to a normal group, using a "View as messages" setting in the local client. 
        This setting only affects the current account, and is synced to other logged in sessions using the [channels.toggleViewForumAsMessages](https://core.telegram.org/method/channels.toggleViewForumAsMessages) method; invoking this method will update the value of the view_forum_as_messages flag of [channelFull](https://core.telegram.org/constructor/channelFull) or [dialog](https://core.telegram.org/constructor/dialog) and emit an [updateChannelViewForumAsMessages](https://core.telegram.org/constructor/updateChannelViewForumAsMessages).

        Args:
            channel_id (int): The forum ID
            enabled (bool): The new value of the toggle.
        """

        self.channel_id = channel_id
        self.enabled = enabled

    def to_bytes(self, boxed: bool=True):
        with Writer(b' \x89\xb6\x07' if boxed else b'') as writer:
            writer.long(self.channel_id)
            writer.object(
                self.enabled,
                group_id=0X43B904E1
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        channel_id_ = reader.long()
        enabled_ = reader.object(
            group_id=0X43B904E1
        )

        return cls(
            channel_id=channel_id_,
            enabled=enabled_
        )

class UpdatePeerWallpaper(TLObject, family='TypeUpdate'):
    """
    The [wallpaper](https://core.telegram.org/api/wallpapers) of a given peer has changed.
    """

    _id = 0XAE3F101D
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        wallpaper_overridden: bool = False,
        wallpaper: Optional['TypeWallPaper'] = None
    ):

        """
        The [wallpaper](https://core.telegram.org/api/wallpapers) of a given peer has changed.

        Args:
            peer ('TypePeer'): The peer where the wallpaper has changed.
            wallpaper_overridden (bool, optional): Whether the other user has chosen a custom wallpaper for us using [messages.setChatWallPaper](https://core.telegram.org/method/messages.setChatWallPaper) and the for_both flag, see [here](https://core.telegram.org/api/wallpapers#installing-wallpapers-in-a-specific-chat-or-channel) for more info.
            wallpaper (Optional['TypeWallPaper'], optional): The new wallpaper, if none the wallpaper was removed and the default wallpaper should be used.
        """

        self.peer = peer
        self.wallpaper_overridden = wallpaper_overridden
        self.wallpaper = wallpaper

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1d\x10?\xae' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.wallpaper_overridden, 1)
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )

                if flags(self.wallpaper, 0):
                    writer.object(
                        self.wallpaper,
                        group_id=0XC6E3E0E2
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        wallpaper_ = (
            reader.object(
                group_id=0XC6E3E0E2
            )
            if flags(0) else None
        )

        return cls(
            peer=peer_,
            wallpaper_overridden=flags(1),
            wallpaper=wallpaper_
        )

class UpdateBotMessageReaction(TLObject, family='TypeUpdate'):
    """
    Bots only: a user has changed their reactions on a message with public reactions.
    """

    _id = 0XAC21D3CE
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        msg_id: int,
        date: int,
        actor: 'TypePeer',
        old_reactions: List['TypeReaction'],
        new_reactions: List['TypeReaction'],
        qts: int
    ):

        """
        Bots only: a user has changed their reactions on a message with public reactions.

        Args:
            peer ('TypePeer'): Peer of the reacted-to message.
            msg_id (int): ID of the reacted-to message.
            date (int): Date of the change.
            actor ('TypePeer'): The user that (un)reacted to the message.
            old_reactions (List['TypeReaction']): Old reactions
            new_reactions (List['TypeReaction']): New reactions
            qts (int): [QTS](https://core.telegram.org/api/updates) event sequence identifier
        """

        self.peer = peer
        self.msg_id = msg_id
        self.date = date
        self.actor = actor
        self.old_reactions = old_reactions
        self.new_reactions = new_reactions
        self.qts = qts

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xce\xd3!\xac' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.int(self.msg_id)
            writer.int(self.date)
            writer.object(
                self.actor,
                group_id=0XB4DECBCA
            )
            writer.vector(
                self.old_reactions,
                lambda value: writer.object(
                    value,
                    group_id=0X19F930D1
                )
            )
            writer.vector(
                self.new_reactions,
                lambda value: writer.object(
                    value,
                    group_id=0X19F930D1
                )
            )
            writer.int(self.qts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        msg_id_ = reader.int()
        date_ = reader.int()
        actor_ = reader.object(
            group_id=0XB4DECBCA
        )

        old_reactions_ = reader.vector(
            lambda: reader.object(
                group_id=0X19F930D1
            )
        )

        new_reactions_ = reader.vector(
            lambda: reader.object(
                group_id=0X19F930D1
            )
        )

        qts_ = reader.int()

        return cls(
            peer=peer_,
            msg_id=msg_id_,
            date=date_,
            actor=actor_,
            old_reactions=old_reactions_,
            new_reactions=new_reactions_,
            qts=qts_
        )

class UpdateBotMessageReactions(TLObject, family='TypeUpdate'):
    """
    Bots only: the number of reactions on a message with anonymous reactions has changed.
    """

    _id = 0X9CB7759
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        msg_id: int,
        date: int,
        reactions: List['TypeReactionCount'],
        qts: int
    ):

        """
        Bots only: the number of reactions on a message with anonymous reactions has changed.

        Args:
            peer ('TypePeer'): Peer of the reacted-to message.
            msg_id (int): ID of the reacted-to message.
            date (int): Date of the change.
            reactions (List['TypeReactionCount']): New reaction counters.
            qts (int): [QTS](https://core.telegram.org/api/updates) event sequence identifier
        """

        self.peer = peer
        self.msg_id = msg_id
        self.date = date
        self.reactions = reactions
        self.qts = qts

    def to_bytes(self, boxed: bool=True):
        with Writer(b'Yw\xcb\t' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.int(self.msg_id)
            writer.int(self.date)
            writer.vector(
                self.reactions,
                lambda value: writer.object(
                    value,
                    group_id=0X21B32469
                )
            )
            writer.int(self.qts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        msg_id_ = reader.int()
        date_ = reader.int()
        reactions_ = reader.vector(
            lambda: reader.object(
                group_id=0X21B32469
            )
        )

        qts_ = reader.int()

        return cls(
            peer=peer_,
            msg_id=msg_id_,
            date=date_,
            reactions=reactions_,
            qts=qts_
        )

class UpdateSavedDialogPinned(TLObject, family='TypeUpdate'):
    """
    A [saved message dialog](https://core.telegram.org/api/saved-messages) was pinned/unpinned
    """

    _id = 0XAEAF9E74
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypeDialogPeer',
        pinned: bool = False
    ):

        """
        A [saved message dialog](https://core.telegram.org/api/saved-messages) was pinned/unpinned

        Args:
            peer ('TypeDialogPeer'): The dialog
            pinned (bool, optional): Whether the dialog was pinned
        """

        self.peer = peer
        self.pinned = pinned

    def to_bytes(self, boxed: bool=True):
        with Writer(b't\x9e\xaf\xae' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.pinned, 0)
                writer.object(
                    self.peer,
                    group_id=0X1152797B
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0X1152797B
        )

        return cls(
            peer=peer_,
            pinned=flags(0)
        )

class UpdatePinnedSavedDialogs(TLObject, family='TypeUpdate'):
    """
    [Pinned saved dialogs](https://core.telegram.org/api/saved-messages) were updated
    """

    _id = 0X686C85A6
    _group_id = 0X54E058F5

    def __init__(
        self,
        order: Optional[List['TypeDialogPeer']] = None
    ):

        """
        [Pinned saved dialogs](https://core.telegram.org/api/saved-messages) were updated

        Args:
            order (Optional[List['TypeDialogPeer']], optional): New order of pinned saved dialogs
        """

        self.order = order

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa6\x85lh' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.order, 0):
                    writer.vector(
                        self.order,
                        lambda value: writer.object(
                            value,
                            group_id=0X1152797B
                        )
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        order_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X1152797B
                )
            )
            if flags(0) else None
        )

        return cls(
            order=order_
        )

class UpdateSavedReactionTags(TLObject, family='TypeUpdate'):
    """
    The list of [reaction tag](https://core.telegram.org/api/saved-messages#tags) names assigned by the user has changed and should be refetched using [messages.getSavedReactionTags](https://core.telegram.org/method/messages.getSavedReactionTags).
    """

    _id = 0X39C67432
    _group_id = 0X54E058F5


    def to_bytes(self, boxed: bool=True):
        return b'2t\xc69' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class UpdateSmsJob(TLObject, family='TypeUpdate'):
    """
    A new SMS job was received
    """

    _id = 0XF16269D4
    _group_id = 0X54E058F5

    def __init__(
        self,
        job_id: str
    ):

        """
        A new SMS job was received

        Args:
            job_id (str): SMS job ID
        """

        self.job_id = job_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd4ib\xf1' if boxed else b'') as writer:
            writer.string(self.job_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        job_id_ = reader.string()

        return cls(
            job_id=job_id_
        )

class UpdateQuickReplies(TLObject, family='TypeUpdate'):
    """
    Info about or the order of [quick reply shortcuts](https://core.telegram.org/api/business#quick-reply-shortcuts) was changed.
    """

    _id = 0XF9470AB2
    _group_id = 0X54E058F5

    def __init__(
        self,
        quick_replies: List['TypeQuickReply']
    ):

        """
        Info about or the order of [quick reply shortcuts](https://core.telegram.org/api/business#quick-reply-shortcuts) was changed.

        Args:
            quick_replies (List['TypeQuickReply']): New quick reply shortcut order and information.
        """

        self.quick_replies = quick_replies

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb2\nG\xf9' if boxed else b'') as writer:
            writer.vector(
                self.quick_replies,
                lambda value: writer.object(
                    value,
                    group_id=0XD6D497C7
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        quick_replies_ = reader.vector(
            lambda: reader.object(
                group_id=0XD6D497C7
            )
        )

        return cls(
            quick_replies=quick_replies_
        )

class UpdateNewQuickReply(TLObject, family='TypeUpdate'):
    """
    A new [quick reply shortcut](https://core.telegram.org/api/business#quick-reply-shortcuts) was created.
    """

    _id = 0XF53DA717
    _group_id = 0X54E058F5

    def __init__(
        self,
        quick_reply: 'TypeQuickReply'
    ):

        """
        A new [quick reply shortcut](https://core.telegram.org/api/business#quick-reply-shortcuts) was created.

        Args:
            quick_reply ('TypeQuickReply'): Quick reply shortcut.
        """

        self.quick_reply = quick_reply

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x17\xa7=\xf5' if boxed else b'') as writer:
            writer.object(
                self.quick_reply,
                group_id=0XD6D497C7
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        quick_reply_ = reader.object(
            group_id=0XD6D497C7
        )

        return cls(
            quick_reply=quick_reply_
        )

class UpdateDeleteQuickReply(TLObject, family='TypeUpdate'):
    """
    A [quick reply shortcut](https://core.telegram.org/api/business#quick-reply-shortcuts) was deleted. This will not emit [updateDeleteQuickReplyMessages](https://core.telegram.org/constructor/updateDeleteQuickReplyMessages) updates, even if all the messages in the shortcut are also deleted by this update.
    """

    _id = 0X53E6F1EC
    _group_id = 0X54E058F5

    def __init__(
        self,
        shortcut_id: int
    ):

        """
        A [quick reply shortcut](https://core.telegram.org/api/business#quick-reply-shortcuts) was deleted. This will not emit [updateDeleteQuickReplyMessages](https://core.telegram.org/constructor/updateDeleteQuickReplyMessages) updates, even if all the messages in the shortcut are also deleted by this update.

        Args:
            shortcut_id (int): ID of the quick reply shortcut that was deleted.
        """

        self.shortcut_id = shortcut_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xec\xf1\xe6S' if boxed else b'') as writer:
            writer.int(self.shortcut_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        shortcut_id_ = reader.int()

        return cls(
            shortcut_id=shortcut_id_
        )

class UpdateQuickReplyMessage(TLObject, family='TypeUpdate'):
    """
    A new message was added to a [quick reply shortcut](https://core.telegram.org/api/business#quick-reply-shortcuts).
    """

    _id = 0X3E050D0F
    _group_id = 0X54E058F5

    def __init__(
        self,
        message: 'TypeMessage'
    ):

        """
        A new message was added to a [quick reply shortcut](https://core.telegram.org/api/business#quick-reply-shortcuts).

        Args:
            message ('TypeMessage'): The message that was added (the [message](https://core.telegram.org/constructor/message). quick_reply_shortcut_id field will contain the shortcut ID).
        """

        self.message = message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x0f\r\x05>' if boxed else b'') as writer:
            writer.object(
                self.message,
                group_id=0X25780A8F
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        message_ = reader.object(
            group_id=0X25780A8F
        )

        return cls(
            message=message_
        )

class UpdateDeleteQuickReplyMessages(TLObject, family='TypeUpdate'):
    """
    One or more messages in a [quick reply shortcut](https://core.telegram.org/api/business#quick-reply-shortcuts) were deleted.
    """

    _id = 0X566FE7CD
    _group_id = 0X54E058F5

    def __init__(
        self,
        shortcut_id: int,
        messages: List[int]
    ):

        """
        One or more messages in a [quick reply shortcut](https://core.telegram.org/api/business#quick-reply-shortcuts) were deleted.

        Args:
            shortcut_id (int): Quick reply shortcut ID.
            messages (List[int]): IDs of the deleted messages.
        """

        self.shortcut_id = shortcut_id
        self.messages = messages

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xcd\xe7oV' if boxed else b'') as writer:
            writer.int(self.shortcut_id)
            writer.vector(
                self.messages,
                writer.int
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        shortcut_id_ = reader.int()
        messages_ = reader.vector(
            reader.int
        )

        return cls(
            shortcut_id=shortcut_id_,
            messages=messages_
        )

class UpdateBotBusinessConnect(TLObject, family='TypeUpdate'):
    """
    Connecting or disconnecting a [business bot](https://core.telegram.org/api/business#connected-bots) or changing the connection settings will emit an [updateBotBusinessConnect](https://core.telegram.org/constructor/updateBotBusinessConnect) update to the bot, with the new settings and a connection_id that will be used by the bot to handle updates from and send messages as the user.
    """

    _id = 0X8AE5C97A
    _group_id = 0X54E058F5

    def __init__(
        self,
        connection: 'TypeBotBusinessConnection',
        qts: int
    ):

        """
        Connecting or disconnecting a [business bot](https://core.telegram.org/api/business#connected-bots) or changing the connection settings will emit an [updateBotBusinessConnect](https://core.telegram.org/constructor/updateBotBusinessConnect) update to the bot, with the new settings and a connection_id that will be used by the bot to handle updates from and send messages as the user.

        Args:
            connection ('TypeBotBusinessConnection'): Business connection settings
            qts (int): New qts value, see [updates](https://core.telegram.org/api/updates) for more info.
        """

        self.connection = connection
        self.qts = qts

    def to_bytes(self, boxed: bool=True):
        with Writer(b'z\xc9\xe5\x8a' if boxed else b'') as writer:
            writer.object(
                self.connection,
                group_id=0XD013CF65
            )
            writer.int(self.qts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        connection_ = reader.object(
            group_id=0XD013CF65
        )

        qts_ = reader.int()

        return cls(
            connection=connection_,
            qts=qts_
        )

class UpdateBotNewBusinessMessage(TLObject, family='TypeUpdate'):
    """
    A message was received via a [connected business chat](https://core.telegram.org/api/business#connected-bots).
    """

    _id = 0X9DDB347C
    _group_id = 0X54E058F5

    def __init__(
        self,
        connection_id: str,
        message: 'TypeMessage',
        qts: int,
        reply_to_message: Optional['TypeMessage'] = None
    ):

        """
        A message was received via a [connected business chat](https://core.telegram.org/api/business#connected-bots).

        Args:
            connection_id (str): Connection ID.
            message ('TypeMessage'): New message.
            qts (int): New qts value, see [updates](https://core.telegram.org/api/updates) for more info.
            reply_to_message (Optional['TypeMessage'], optional): The message that message is replying to.
        """

        self.connection_id = connection_id
        self.message = message
        self.qts = qts
        self.reply_to_message = reply_to_message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'|4\xdb\x9d' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.connection_id)
                writer.object(
                    self.message,
                    group_id=0X25780A8F
                )

                if flags(self.reply_to_message, 0):
                    writer.object(
                        self.reply_to_message,
                        group_id=0X25780A8F
                    )
                writer.int(self.qts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        connection_id_ = reader.string()
        message_ = reader.object(
            group_id=0X25780A8F
        )

        reply_to_message_ = (
            reader.object(
                group_id=0X25780A8F
            )
            if flags(0) else None
        )

        qts_ = reader.int()

        return cls(
            connection_id=connection_id_,
            message=message_,
            qts=qts_,
            reply_to_message=reply_to_message_
        )

class UpdateBotEditBusinessMessage(TLObject, family='TypeUpdate'):
    """
    A message was edited in a [connected business chat](https://core.telegram.org/api/business#connected-bots).
    """

    _id = 0X7DF587C
    _group_id = 0X54E058F5

    def __init__(
        self,
        connection_id: str,
        message: 'TypeMessage',
        qts: int,
        reply_to_message: Optional['TypeMessage'] = None
    ):

        """
        A message was edited in a [connected business chat](https://core.telegram.org/api/business#connected-bots).

        Args:
            connection_id (str): Business connection ID
            message ('TypeMessage'): New message.
            qts (int): New qts value, see [updates](https://core.telegram.org/api/updates) for more info.
            reply_to_message (Optional['TypeMessage'], optional): The message that message is replying to.
        """

        self.connection_id = connection_id
        self.message = message
        self.qts = qts
        self.reply_to_message = reply_to_message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'|X\xdf\x07' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.connection_id)
                writer.object(
                    self.message,
                    group_id=0X25780A8F
                )

                if flags(self.reply_to_message, 0):
                    writer.object(
                        self.reply_to_message,
                        group_id=0X25780A8F
                    )
                writer.int(self.qts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        connection_id_ = reader.string()
        message_ = reader.object(
            group_id=0X25780A8F
        )

        reply_to_message_ = (
            reader.object(
                group_id=0X25780A8F
            )
            if flags(0) else None
        )

        qts_ = reader.int()

        return cls(
            connection_id=connection_id_,
            message=message_,
            qts=qts_,
            reply_to_message=reply_to_message_
        )

class UpdateBotDeleteBusinessMessage(TLObject, family='TypeUpdate'):
    """
    A message was deleted in a [connected business chat](https://core.telegram.org/api/business#connected-bots).
    """

    _id = 0XA02A982E
    _group_id = 0X54E058F5

    def __init__(
        self,
        connection_id: str,
        peer: 'TypePeer',
        messages: List[int],
        qts: int
    ):

        """
        A message was deleted in a [connected business chat](https://core.telegram.org/api/business#connected-bots).

        Args:
            connection_id (str): Business connection ID.
            peer ('TypePeer'): [Peer](https://core.telegram.org/api/peers) where the messages were deleted.
            messages (List[int]): IDs of the messages that were deleted.
            qts (int): New qts value, see [updates](https://core.telegram.org/api/updates) for more info.
        """

        self.connection_id = connection_id
        self.peer = peer
        self.messages = messages
        self.qts = qts

    def to_bytes(self, boxed: bool=True):
        with Writer(b'.\x98*\xa0' if boxed else b'') as writer:
            writer.string(self.connection_id)
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.vector(
                self.messages,
                writer.int
            )
            writer.int(self.qts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        connection_id_ = reader.string()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        messages_ = reader.vector(
            reader.int
        )

        qts_ = reader.int()

        return cls(
            connection_id=connection_id_,
            peer=peer_,
            messages=messages_,
            qts=qts_
        )

class UpdateNewStoryReaction(TLObject, family='TypeUpdate'):
    """
    Represents a new [reaction to a story](https://core.telegram.org/api/reactions#notifications-about-reactions).
    """

    _id = 0X1824E40B
    _group_id = 0X54E058F5

    def __init__(
        self,
        story_id: int,
        peer: 'TypePeer',
        reaction: 'TypeReaction'
    ):

        """
        Represents a new [reaction to a story](https://core.telegram.org/api/reactions#notifications-about-reactions).

        Args:
            story_id (int): [Story ID](https://core.telegram.org/api/stories).
            peer ('TypePeer'): The peer where the story was posted.
            reaction ('TypeReaction'): The [reaction](https://core.telegram.org/api/reactions).
        """

        self.story_id = story_id
        self.peer = peer
        self.reaction = reaction

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x0b\xe4$\x18' if boxed else b'') as writer:
            writer.int(self.story_id)
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.object(
                self.reaction,
                group_id=0X19F930D1
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        story_id_ = reader.int()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        reaction_ = reader.object(
            group_id=0X19F930D1
        )

        return cls(
            story_id=story_id_,
            peer=peer_,
            reaction=reaction_
        )

class UpdateStarsBalance(TLObject, family='TypeUpdate'):
    """
    The current account's [Telegram Stars balance](https://core.telegram.org/api/stars) has changed.
    """

    _id = 0X4E80A379
    _group_id = 0X54E058F5

    def __init__(
        self,
        balance: 'TypeStarsAmount'
    ):

        """
        The current account's [Telegram Stars balance](https://core.telegram.org/api/stars) has changed.

        Args:
            balance ('TypeStarsAmount'): New balance.
        """

        self.balance = balance

    def to_bytes(self, boxed: bool=True):
        with Writer(b'y\xa3\x80N' if boxed else b'') as writer:
            writer.object(
                self.balance,
                group_id=0XC3D62A83
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        balance_ = reader.object(
            group_id=0XC3D62A83
        )

        return cls(
            balance=balance_
        )

class UpdateBusinessBotCallbackQuery(TLObject, family='TypeUpdate'):
    """
    A callback button sent via a [business connection](https://core.telegram.org/api/business#connected-bots) was pressed, and the button data was sent to the bot that created the button.
    """

    _id = 0X1EA2FDA7
    _group_id = 0X54E058F5

    def __init__(
        self,
        query_id: int,
        user_id: int,
        connection_id: str,
        message: 'TypeMessage',
        chat_instance: int,
        reply_to_message: Optional['TypeMessage'] = None,
        data: Optional[bytes] = None
    ):

        """
        A callback button sent via a [business connection](https://core.telegram.org/api/business#connected-bots) was pressed, and the button data was sent to the bot that created the button.

        Args:
            query_id (int): Query ID
            user_id (int): ID of the user that pressed the button
            connection_id (str): [Business connection ID](https://core.telegram.org/api/business#connected-bots)
            message ('TypeMessage'): Message that contains the keyboard (also contains info about the chat where the message was sent).
            chat_instance (int): Global identifier, uniquely corresponding to the chat to which the message with the callback button was sent. Useful for high scores in games.
            reply_to_message (Optional['TypeMessage'], optional): The message that message is replying to.
            data (Optional[bytes], optional): Callback data
        """

        self.query_id = query_id
        self.user_id = user_id
        self.connection_id = connection_id
        self.message = message
        self.chat_instance = chat_instance
        self.reply_to_message = reply_to_message
        self.data = data

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa7\xfd\xa2\x1e' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.query_id)
                writer.long(self.user_id)
                writer.string(self.connection_id)
                writer.object(
                    self.message,
                    group_id=0X25780A8F
                )

                if flags(self.reply_to_message, 2):
                    writer.object(
                        self.reply_to_message,
                        group_id=0X25780A8F
                    )
                writer.long(self.chat_instance)

                if flags(self.data, 0):
                    writer.bytes(self.data)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        query_id_ = reader.long()
        user_id_ = reader.long()
        connection_id_ = reader.string()
        message_ = reader.object(
            group_id=0X25780A8F
        )

        reply_to_message_ = (
            reader.object(
                group_id=0X25780A8F
            )
            if flags(2) else None
        )

        chat_instance_ = reader.long()
        data_ = (
            reader.bytes()
            if flags(0) else None
        )

        return cls(
            query_id=query_id_,
            user_id=user_id_,
            connection_id=connection_id_,
            message=message_,
            chat_instance=chat_instance_,
            reply_to_message=reply_to_message_,
            data=data_
        )

class UpdateStarsRevenueStatus(TLObject, family='TypeUpdate'):
    """
    The [Telegram Star balance of a channel/bot we own has changed](https://core.telegram.org/api/stars#revenue-statistics).
    """

    _id = 0XA584B019
    _group_id = 0X54E058F5

    def __init__(
        self,
        peer: 'TypePeer',
        status: 'TypeStarsRevenueStatus'
    ):

        """
        The [Telegram Star balance of a channel/bot we own has changed](https://core.telegram.org/api/stars#revenue-statistics).

        Args:
            peer ('TypePeer'): Channel/bot
            status ('TypeStarsRevenueStatus'): New Telegram Star balance.
        """

        self.peer = peer
        self.status = status

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x19\xb0\x84\xa5' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.object(
                self.status,
                group_id=0XC576A749
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        status_ = reader.object(
            group_id=0XC576A749
        )

        return cls(
            peer=peer_,
            status=status_
        )

class UpdateBotPurchasedPaidMedia(TLObject, family='TypeUpdate'):
    """
    Bots only: a user has purchased a [paid media](https://core.telegram.org/api/paid-media).
    """

    _id = 0X283BD312
    _group_id = 0X54E058F5

    def __init__(
        self,
        user_id: int,
        payload: str,
        qts: int
    ):

        """
        Bots only: a user has purchased a [paid media](https://core.telegram.org/api/paid-media).

        Args:
            user_id (int): The user that bought the media
            payload (str): Payload passed by the bot in [inputMediaPaidMedia](https://core.telegram.org/constructor/inputMediaPaidMedia). payload
            qts (int): New qts value, see [updates](https://core.telegram.org/api/updates) for more info.
        """

        self.user_id = user_id
        self.payload = payload
        self.qts = qts

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x12\xd3;(' if boxed else b'') as writer:
            writer.long(self.user_id)
            writer.string(self.payload)
            writer.int(self.qts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        user_id_ = reader.long()
        payload_ = reader.string()
        qts_ = reader.int()

        return cls(
            user_id=user_id_,
            payload=payload_,
            qts=qts_
        )

class UpdatePaidReactionPrivacy(TLObject, family='TypeUpdate'):
    """
    Contains the current [default paid reaction privacy, see here](https://core.telegram.org/api/reactions#paid-reactions) for more info.
    """

    _id = 0X8B725FCE
    _group_id = 0X54E058F5

    def __init__(
        self,
        private: 'TypePaidReactionPrivacy'
    ):

        """
        Contains the current [default paid reaction privacy, see here](https://core.telegram.org/api/reactions#paid-reactions) for more info.

        Args:
            private ('TypePaidReactionPrivacy'): Whether paid reaction privacy is enabled or disabled.
        """

        self.private = private

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xce_r\x8b' if boxed else b'') as writer:
            writer.object(
                self.private,
                group_id=0XA09546B0
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        private_ = reader.object(
            group_id=0XA09546B0
        )

        return cls(
            private=private_
        )

class UpdateSentPhoneCode(TLObject, family='TypeUpdate'):
    _id = 0X504AA18F
    _group_id = 0X54E058F5

    def __init__(
        self,
        sent_code: 'TypeAuthSentCode'
    ):

        self.sent_code = sent_code

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x8f\xa1JP' if boxed else b'') as writer:
            writer.object(
                self.sent_code,
                group_id=0X8F0C24F5
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        sent_code_ = reader.object(
            group_id=0X8F0C24F5
        )

        return cls(
            sent_code=sent_code_
        )

class UpdateGroupCallChainBlocks(TLObject, family='TypeUpdate'):
    _id = 0XA477288F
    _group_id = 0X54E058F5

    def __init__(
        self,
        call: 'TypeInputGroupCall',
        sub_chain_id: int,
        blocks: List[bytes],
        next_offset: int
    ):

        self.call = call
        self.sub_chain_id = sub_chain_id
        self.blocks = blocks
        self.next_offset = next_offset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x8f(w\xa4' if boxed else b'') as writer:
            writer.object(
                self.call,
                group_id=0XDA9A559A
            )
            writer.int(self.sub_chain_id)
            writer.vector(
                self.blocks,
                writer.bytes
            )
            writer.int(self.next_offset)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        call_ = reader.object(
            group_id=0XDA9A559A
        )

        sub_chain_id_ = reader.int()
        blocks_ = reader.vector(
            reader.bytes
        )

        next_offset_ = reader.int()

        return cls(
            call=call_,
            sub_chain_id=sub_chain_id_,
            blocks=blocks_,
            next_offset=next_offset_
        )

class UpdateReadMonoForumInbox(TLObject, family='TypeUpdate'):
    _id = 0X77B0E372
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        saved_peer_id: 'TypePeer',
        read_max_id: int
    ):

        self.channel_id = channel_id
        self.saved_peer_id = saved_peer_id
        self.read_max_id = read_max_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'r\xe3\xb0w' if boxed else b'') as writer:
            writer.long(self.channel_id)
            writer.object(
                self.saved_peer_id,
                group_id=0XB4DECBCA
            )
            writer.int(self.read_max_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        channel_id_ = reader.long()
        saved_peer_id_ = reader.object(
            group_id=0XB4DECBCA
        )

        read_max_id_ = reader.int()

        return cls(
            channel_id=channel_id_,
            saved_peer_id=saved_peer_id_,
            read_max_id=read_max_id_
        )

class UpdateReadMonoForumOutbox(TLObject, family='TypeUpdate'):
    _id = 0XA4A79376
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        saved_peer_id: 'TypePeer',
        read_max_id: int
    ):

        self.channel_id = channel_id
        self.saved_peer_id = saved_peer_id
        self.read_max_id = read_max_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'v\x93\xa7\xa4' if boxed else b'') as writer:
            writer.long(self.channel_id)
            writer.object(
                self.saved_peer_id,
                group_id=0XB4DECBCA
            )
            writer.int(self.read_max_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        channel_id_ = reader.long()
        saved_peer_id_ = reader.object(
            group_id=0XB4DECBCA
        )

        read_max_id_ = reader.int()

        return cls(
            channel_id=channel_id_,
            saved_peer_id=saved_peer_id_,
            read_max_id=read_max_id_
        )

class UpdateMonoForumNoPaidException(TLObject, family='TypeUpdate'):
    _id = 0X9F812B08
    _group_id = 0X54E058F5

    def __init__(
        self,
        channel_id: int,
        saved_peer_id: 'TypePeer',
        exception: bool = False
    ):

        self.channel_id = channel_id
        self.saved_peer_id = saved_peer_id
        self.exception = exception

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x08+\x81\x9f' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.exception, 0)
                writer.long(self.channel_id)
                writer.object(
                    self.saved_peer_id,
                    group_id=0XB4DECBCA
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        channel_id_ = reader.long()
        saved_peer_id_ = reader.object(
            group_id=0XB4DECBCA
        )

        return cls(
            channel_id=channel_id_,
            saved_peer_id=saved_peer_id_,
            exception=flags(0)
        )

TypeUpdate = Union[
    UpdateNewMessage,
    UpdateMessageID,
    UpdateDeleteMessages,
    UpdateUserTyping,
    UpdateChatUserTyping,
    UpdateChatParticipants,
    UpdateUserStatus,
    UpdateUserName,
    UpdateNewAuthorization,
    UpdateNewEncryptedMessage,
    UpdateEncryptedChatTyping,
    UpdateEncryption,
    UpdateEncryptedMessagesRead,
    UpdateChatParticipantAdd,
    UpdateChatParticipantDelete,
    UpdateDcOptions,
    UpdateNotifySettings,
    UpdateServiceNotification,
    UpdatePrivacy,
    UpdateUserPhone,
    UpdateReadHistoryInbox,
    UpdateReadHistoryOutbox,
    UpdateWebPage,
    UpdateReadMessagesContents,
    UpdateChannelTooLong,
    UpdateChannel,
    UpdateNewChannelMessage,
    UpdateReadChannelInbox,
    UpdateDeleteChannelMessages,
    UpdateChannelMessageViews,
    UpdateChatParticipantAdmin,
    UpdateNewStickerSet,
    UpdateStickerSetsOrder,
    UpdateStickerSets,
    UpdateSavedGifs,
    UpdateBotInlineQuery,
    UpdateBotInlineSend,
    UpdateEditChannelMessage,
    UpdateBotCallbackQuery,
    UpdateEditMessage,
    UpdateInlineBotCallbackQuery,
    UpdateReadChannelOutbox,
    UpdateDraftMessage,
    UpdateReadFeaturedStickers,
    UpdateRecentStickers,
    UpdateConfig,
    UpdatePtsChanged,
    UpdateChannelWebPage,
    UpdateDialogPinned,
    UpdatePinnedDialogs,
    UpdateBotWebhookJSON,
    UpdateBotWebhookJSONQuery,
    UpdateBotShippingQuery,
    UpdateBotPrecheckoutQuery,
    UpdatePhoneCall,
    UpdateLangPackTooLong,
    UpdateLangPack,
    UpdateFavedStickers,
    UpdateChannelReadMessagesContents,
    UpdateContactsReset,
    UpdateChannelAvailableMessages,
    UpdateDialogUnreadMark,
    UpdateMessagePoll,
    UpdateChatDefaultBannedRights,
    UpdateFolderPeers,
    UpdatePeerSettings,
    UpdatePeerLocated,
    UpdateNewScheduledMessage,
    UpdateDeleteScheduledMessages,
    UpdateTheme,
    UpdateGeoLiveViewed,
    UpdateLoginToken,
    UpdateMessagePollVote,
    UpdateDialogFilter,
    UpdateDialogFilterOrder,
    UpdateDialogFilters,
    UpdatePhoneCallSignalingData,
    UpdateChannelMessageForwards,
    UpdateReadChannelDiscussionInbox,
    UpdateReadChannelDiscussionOutbox,
    UpdatePeerBlocked,
    UpdateChannelUserTyping,
    UpdatePinnedMessages,
    UpdatePinnedChannelMessages,
    UpdateChat,
    UpdateGroupCallParticipants,
    UpdateGroupCall,
    UpdatePeerHistoryTTL,
    UpdateChatParticipant,
    UpdateChannelParticipant,
    UpdateBotStopped,
    UpdateGroupCallConnection,
    UpdateBotCommands,
    UpdatePendingJoinRequests,
    UpdateBotChatInviteRequester,
    UpdateMessageReactions,
    UpdateAttachMenuBots,
    UpdateWebViewResultSent,
    UpdateBotMenuButton,
    UpdateSavedRingtones,
    UpdateTranscribedAudio,
    UpdateReadFeaturedEmojiStickers,
    UpdateUserEmojiStatus,
    UpdateRecentEmojiStatuses,
    UpdateRecentReactions,
    UpdateMoveStickerSetToTop,
    UpdateMessageExtendedMedia,
    UpdateChannelPinnedTopic,
    UpdateChannelPinnedTopics,
    UpdateUser,
    UpdateAutoSaveSettings,
    UpdateStory,
    UpdateReadStories,
    UpdateStoryID,
    UpdateStoriesStealthMode,
    UpdateSentStoryReaction,
    UpdateBotChatBoost,
    UpdateChannelViewForumAsMessages,
    UpdatePeerWallpaper,
    UpdateBotMessageReaction,
    UpdateBotMessageReactions,
    UpdateSavedDialogPinned,
    UpdatePinnedSavedDialogs,
    UpdateSavedReactionTags,
    UpdateSmsJob,
    UpdateQuickReplies,
    UpdateNewQuickReply,
    UpdateDeleteQuickReply,
    UpdateQuickReplyMessage,
    UpdateDeleteQuickReplyMessages,
    UpdateBotBusinessConnect,
    UpdateBotNewBusinessMessage,
    UpdateBotEditBusinessMessage,
    UpdateBotDeleteBusinessMessage,
    UpdateNewStoryReaction,
    UpdateStarsBalance,
    UpdateBusinessBotCallbackQuery,
    UpdateStarsRevenueStatus,
    UpdateBotPurchasedPaidMedia,
    UpdatePaidReactionPrivacy,
    UpdateSentPhoneCode,
    UpdateGroupCallChainBlocks,
    UpdateReadMonoForumInbox,
    UpdateReadMonoForumOutbox,
    UpdateMonoForumNoPaidException
]