
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Union, Optional
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..dialog import TypeDialog
    from ..update import TypeUpdate
    from ..message import TypeMessage
    from ....gadgets.byteutils import Reader


class ChannelDifferenceEmpty(TLObject, family='TypeUpdatesChannelDifference'):
    """
    There are no new updates
    """

    _id = 0X3E11AFFB
    _group_id = 0X93944747

    def __init__(
        self,
        pts: int,
        final: bool = False,
        timeout: Optional[int] = None
    ):

        """
        There are no new updates

        Args:
            pts (int): The latest [PTS](https://core.telegram.org/api/updates)
            final (bool, optional): Whether there are more updates that must be fetched (always false)
            timeout (Optional[int], optional): Clients are supposed to refetch the channel difference after timeout seconds have elapsed, if the user is [currently viewing the chat, see here](https://core.telegram.org/api/updates#subscribing-to-updates-of-channels-supergroups) for more info.
        """

        self.pts = pts
        self.final = final
        self.timeout = timeout

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfb\xaf\x11>' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.final, 0)
                writer.int(self.pts)

                if flags(self.timeout, 1):
                    writer.int(self.timeout)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        pts_ = reader.int()
        timeout_ = (
            reader.int()
            if flags(1) else None
        )

        return cls(
            pts=pts_,
            final=flags(0),
            timeout=timeout_
        )

class ChannelDifferenceTooLong(TLObject, family='TypeUpdatesChannelDifference'):
    """
    The provided pts + limit < remote pts. Simply, there are too many updates to be fetched (more than limit), the client has to resolve the update gap in one of the following ways (assuming the existence of a persistent database to locally store messages):
    """

    _id = 0XA4BCC6FE
    _group_id = 0X93944747

    def __init__(
        self,
        dialog: 'TypeDialog',
        messages: List['TypeMessage'],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        final: bool = False,
        timeout: Optional[int] = None
    ):

        """
        The provided pts + limit < remote pts. Simply, there are too many updates to be fetched (more than limit), the client has to resolve the update gap in one of the following ways (assuming the existence of a persistent database to locally store messages):

        Args:
            dialog ('TypeDialog'): Dialog containing the latest [PTS](https://core.telegram.org/api/updates) that can be used to reset the channel state
            messages (List['TypeMessage']): The latest messages
            chats (List['TypeChat']): Chats from messages
            users (List['TypeUser']): Users from messages
            final (bool, optional): Whether there are more updates that must be fetched (always false)
            timeout (Optional[int], optional): Clients are supposed to refetch the channel difference after timeout seconds have elapsed
        """

        self.dialog = dialog
        self.messages = messages
        self.chats = chats
        self.users = users
        self.final = final
        self.timeout = timeout

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfe\xc6\xbc\xa4' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.final, 0)

                if flags(self.timeout, 1):
                    writer.int(self.timeout)
                writer.object(
                    self.dialog,
                    group_id=0X89A4B5EF
                )
                writer.vector(
                    self.messages,
                    lambda value: writer.object(
                        value,
                        group_id=0X25780A8F
                    )
                )
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        timeout_ = (
            reader.int()
            if flags(1) else None
        )

        dialog_ = reader.object(
            group_id=0X89A4B5EF
        )

        messages_ = reader.vector(
            lambda: reader.object(
                group_id=0X25780A8F
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            dialog=dialog_,
            messages=messages_,
            chats=chats_,
            users=users_,
            final=flags(0),
            timeout=timeout_
        )

class ChannelDifference(TLObject, family='TypeUpdatesChannelDifference'):
    """
    The new updates
    """

    _id = 0X2064674E
    _group_id = 0X93944747

    def __init__(
        self,
        pts: int,
        new_messages: List['TypeMessage'],
        other_updates: List['TypeUpdate'],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        final: bool = False,
        timeout: Optional[int] = None
    ):

        """
        The new updates

        Args:
            pts (int): The [PTS](https://core.telegram.org/api/updates) from which to start getting updates the next time
            new_messages (List['TypeMessage']): New messages
            other_updates (List['TypeUpdate']): Other updates
            chats (List['TypeChat']): Chats
            users (List['TypeUser']): Users
            final (bool, optional): Whether there are more updates to be fetched using getDifference, starting from the provided pts
            timeout (Optional[int], optional): Clients are supposed to refetch the channel difference after timeout seconds have elapsed, if the user is [currently viewing the chat, see here](https://core.telegram.org/api/updates#subscribing-to-updates-of-channels-supergroups) for more info.
        """

        self.pts = pts
        self.new_messages = new_messages
        self.other_updates = other_updates
        self.chats = chats
        self.users = users
        self.final = final
        self.timeout = timeout

    def to_bytes(self, boxed: bool=True):
        with Writer(b'Ngd ' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.final, 0)
                writer.int(self.pts)

                if flags(self.timeout, 1):
                    writer.int(self.timeout)
                writer.vector(
                    self.new_messages,
                    lambda value: writer.object(
                        value,
                        group_id=0X25780A8F
                    )
                )
                writer.vector(
                    self.other_updates,
                    lambda value: writer.object(
                        value,
                        group_id=0X54E058F5
                    )
                )
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        pts_ = reader.int()
        timeout_ = (
            reader.int()
            if flags(1) else None
        )

        new_messages_ = reader.vector(
            lambda: reader.object(
                group_id=0X25780A8F
            )
        )

        other_updates_ = reader.vector(
            lambda: reader.object(
                group_id=0X54E058F5
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            pts=pts_,
            new_messages=new_messages_,
            other_updates=other_updates_,
            chats=chats_,
            users=users_,
            final=flags(0),
            timeout=timeout_
        )

TypeUpdatesChannelDifference = Union[
    ChannelDifferenceEmpty,
    ChannelDifferenceTooLong,
    ChannelDifference
]