
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..storage.file_type import TypeStorageFileType
    from ....gadgets.byteutils import Reader


class WebFile(TLObject, family='TypeUploadWebFile'):
    """
    Represents a chunk of an [HTTP webfile](https://core.telegram.org/api/files) downloaded through telegram's secure MTProto servers
    """

    _id = 0X21E753BC
    _group_id = 0XF9EBE229

    def __init__(
        self,
        size: int,
        mime_type: str,
        file_type: 'TypeStorageFileType',
        mtime: int,
        bytes: bytes
    ):

        """
        Represents a chunk of an [HTTP webfile](https://core.telegram.org/api/files) downloaded through telegram's secure MTProto servers

        Args:
            size (int): File size
            mime_type (str): Mime type
            file_type ('TypeStorageFileType'): File type
            mtime (int): Modified time
            bytes (bytes): Data
        """

        self.size = size
        self.mime_type = mime_type
        self.file_type = file_type
        self.mtime = mtime
        self.bytes = bytes

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xbcS\xe7!' if boxed else b'') as writer:
            writer.int(self.size)
            writer.string(self.mime_type)
            writer.object(
                self.file_type,
                group_id=0X903DE3AC
            )
            writer.int(self.mtime)
            writer.bytes(self.bytes)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        size_ = reader.int()
        mime_type_ = reader.string()
        file_type_ = reader.object(
            group_id=0X903DE3AC
        )

        mtime_ = reader.int()
        bytes_ = reader.bytes()

        return cls(
            size=size_,
            mime_type=mime_type_,
            file_type=file_type_,
            mtime=mtime_,
            bytes=bytes_
        )

TypeUploadWebFile = WebFile