
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Optional, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .username import TypeUsername
    from .peer_color import TypePeerColor
    from .user_status import TypeUserStatus
    from .emoji_status import TypeEmojiStatus
    from .user_profile_photo import TypeUserProfilePhoto
    from .restriction_reason import TypeRestrictionReason
    from ...gadgets.byteutils import Reader


class UserEmpty(TLObject, family='TypeUser'):
    """
    Empty constructor, non-existent user.
    """

    _id = 0XD3BC4B7A
    _group_id = 0X9BABE43A

    def __init__(
        self,
        id: int
    ):

        """
        Empty constructor, non-existent user.

        Args:
            id (int): User identifier or 0
        """

        self.id = id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'zK\xbc\xd3' if boxed else b'') as writer:
            writer.long(self.id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()

        return cls(
            id=id_
        )

class User(TLObject, family='TypeUser'):
    """
    Indicates info about a certain user.
    """

    _id = 0X20B1422
    _group_id = 0X9BABE43A

    def __init__(
        self,
        id: int,
        is_self: bool = False,
        contact: bool = False,
        mutual_contact: bool = False,
        deleted: bool = False,
        bot: bool = False,
        bot_chat_history: bool = False,
        bot_nochats: bool = False,
        verified: bool = False,
        restricted: bool = False,
        min: bool = False,
        bot_inline_geo: bool = False,
        support: bool = False,
        scam: bool = False,
        apply_min_photo: bool = False,
        fake: bool = False,
        bot_attach_menu: bool = False,
        premium: bool = False,
        attach_menu_enabled: bool = False,
        bot_can_edit: bool = False,
        close_friend: bool = False,
        stories_hidden: bool = False,
        stories_unavailable: bool = False,
        contact_require_premium: bool = False,
        bot_business: bool = False,
        bot_has_main_app: bool = False,
        access_hash: Optional[int] = None,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        username: Optional[str] = None,
        phone: Optional[str] = None,
        photo: Optional['TypeUserProfilePhoto'] = None,
        status: Optional['TypeUserStatus'] = None,
        bot_info_version: Optional[int] = None,
        restriction_reason: Optional[List['TypeRestrictionReason']] = None,
        bot_inline_placeholder: Optional[str] = None,
        lang_code: Optional[str] = None,
        emoji_status: Optional['TypeEmojiStatus'] = None,
        usernames: Optional[List['TypeUsername']] = None,
        stories_max_id: Optional[int] = None,
        color: Optional['TypePeerColor'] = None,
        profile_color: Optional['TypePeerColor'] = None,
        bot_active_users: Optional[int] = None,
        bot_verification_icon: Optional[int] = None,
        send_paid_messages_stars: Optional[int] = None
    ):

        """
        Indicates info about a certain user.

        Args:
            id (int): ID of the user, see [here](https://core.telegram.org/api/peers#peer-id) for more info.
            is_self (bool, optional): Whether this user indicates the currently logged in user
            contact (bool, optional): Whether this user is a contact When updating the [local peer database](https://core.telegram.org/api/peers), do not apply changes to this field if the min flag is set.
            mutual_contact (bool, optional): Whether this user is a mutual contact. When updating the [local peer database](https://core.telegram.org/api/peers), do not apply changes to this field if the min flag is set.
            deleted (bool, optional): Whether the account of this user was deleted. Changes to this flag should invalidate the local [userFull](https://core.telegram.org/constructor/userFull) cache for this user ID, see [here](https://core.telegram.org/api/peers#full-info-database) for more info.
            bot (bool, optional): Is this user a bot? Changes to this flag should invalidate the local [userFull](https://core.telegram.org/constructor/userFull) cache for this user ID, see [here](https://core.telegram.org/api/peers#full-info-database) for more info.
            bot_chat_history (bool, optional): Can the bot see all messages in groups?
            bot_nochats (bool, optional): Can the bot be added to groups?
            verified (bool, optional): Whether this user is verified
            restricted (bool, optional): Access to this user must be restricted for the reason specified in restriction_reason
            min (bool, optional): See [min](https://core.telegram.org/api/min)
            bot_inline_geo (bool, optional): Whether the bot can request our geolocation in inline mode
            support (bool, optional): Whether this is an official support user
            scam (bool, optional): This may be a scam user
            apply_min_photo (bool, optional): If set and min is set, the value of photo can be used to update the local database, see the documentation of that flag for more info.
            fake (bool, optional): If set, this user was reported by many users as a fake or scam user: be careful when interacting with them.
            bot_attach_menu (bool, optional): Whether this bot offers an [attachment menu web app](https://core.telegram.org/api/bots/attach)
            premium (bool, optional): Whether this user is a Telegram Premium user Changes to this flag should invalidate the local [userFull](https://core.telegram.org/constructor/userFull) cache for this user ID, see [here](https://core.telegram.org/api/peers#full-info-database) for more info. Changes to this flag if the self flag is set should also trigger the following calls, to refresh the respective caches: - The [help.getConfig](https://core.telegram.org/method/help.getConfig) cache - The [messages.getTopReactions](https://core.telegram.org/method/messages.getTopReactions) cache if the bot flag is not set
            attach_menu_enabled (bool, optional): Whether we installed the [attachment menu web app](https://core.telegram.org/api/bots/attach) offered by this bot. When updating the [local peer database](https://core.telegram.org/api/peers), do not apply changes to this field if the min flag is set.
            bot_can_edit (bool, optional): Whether we can edit the profile picture, name, about text and description of this bot because we own it. When updating the [local peer database](https://core.telegram.org/api/peers), do not apply changes to this field if the min flag is set. Changes to this flag (if min is not set) should invalidate the local [userFull](https://core.telegram.org/constructor/userFull) cache for this user ID.
            close_friend (bool, optional): Whether we marked this user as a [close friend, see here  for more info](https://core.telegram.org/api/privacy). When updating the [local peer database](https://core.telegram.org/api/peers), do not apply changes to this field if the min flag is set.
            stories_hidden (bool, optional): Whether we have [hidden](https://core.telegram.org/api/stories#hiding-stories-of-other-users) all active stories of this user. When updating the [local peer database](https://core.telegram.org/api/peers), do not apply changes to this field if the min flag is set.
            stories_unavailable (bool, optional): No stories from this user are visible.
            contact_require_premium (bool, optional): If set, we can only write to this user if they have already sent some messages to us, if we are subscribed to [Telegram Premium](https://core.telegram.org/api/premium), or if they're a mutual contact ( [user](https://core.telegram.org/constructor/user). mutual_contact).  All the secondary conditions listed above must be checked separately to verify whether we can still write to the user, even if this flag is set (i.e. a mutual contact will have this flag set even if we can still write to them, and so on...); to avoid doing these extra checks if we haven't yet cached all the required information (for example while displaying the chat list in the sharing UI) the [users.getIsPremiumRequiredToContact](https://core.telegram.org/method/users.getIsPremiumRequiredToContact) method may be invoked instead, passing the list of users currently visible in the UI, returning a list of booleans that directly specify whether we can or cannot write to each user; alternatively, the [userFull](https://core.telegram.org/constructor/userFull). contact_require_premium flag contains the same (fully checked, i.e. it's not just a copy of this flag) info returned by [users.getIsPremiumRequiredToContact](https://core.telegram.org/method/users.getIsPremiumRequiredToContact). To set this flag for ourselves invoke [account.setGlobalPrivacySettings](https://core.telegram.org/method/account.setGlobalPrivacySettings), setting the settings.new_noncontact_peers_require_premium flag.
            bot_business (bool, optional): Whether this bot can be [connected to a user as specified here](https://core.telegram.org/api/business#connected-bots).
            bot_has_main_app (bool, optional): If set, this bot has configured a [Main Mini App](https://core.telegram.org/api/bots/webapps#main-mini-apps).
            access_hash (Optional[int], optional): Access hash of the user, see [here](https://core.telegram.org/api/peers#access-hash) for more info. If this flag is set, when updating the [local peer database](https://core.telegram.org/api/peers), generate a virtual flag called min_access_hash, which is: - Set to true if min is set AND -- The phone flag is not set OR -- The phone flag is set and the associated phone number string is non-empty - Set to false otherwise. Then, apply both access_hash and min_access_hash to the local database if: - min_access_hash is false OR - min_access_hash is true AND -- There is no locally cached object for this user OR -- There is no access_hash in the local cache OR -- The cached object's min_access_hash is also true If the final merged object stored to the database has the min_access_hash field set to true, the related access_hash is only suitable to use in [inputPeerPhotoFileLocation](https://core.telegram.org/constructor/inputPeerPhotoFileLocation), to directly [download the profile pictures](https://core.telegram.org/api/files) of users, everywhere else a inputPeer*FromMessage constructor will have to be generated as specified [here](https://core.telegram.org/api/min). Bots can also use min access hashes in some conditions, by passing 0 instead of the min access hash.
            first_name (Optional[str], optional): First name. When updating the [local peer database](https://core.telegram.org/api/peers), apply changes to this field only if: - The min flag is not set OR - The min flag is set AND -- The min flag of the locally cached user entry is set.
            last_name (Optional[str], optional): Last name. When updating the [local peer database](https://core.telegram.org/api/peers), apply changes to this field only if: - The min flag is not set OR - The min flag is set AND -- The min flag of the locally cached user entry is set.
            username (Optional[str], optional): Main active username. When updating the [local peer database](https://core.telegram.org/api/peers), apply changes to this field only if: - The min flag is not set OR - The min flag is set AND -- The min flag of the locally cached user entry is set. Changes to this flag should invalidate the local [userFull](https://core.telegram.org/constructor/userFull) cache for this user ID if the above conditions are respected and the bot_can_edit flag is also set.
            phone (Optional[str], optional): Phone number. When updating the [local peer database](https://core.telegram.org/api/peers), apply changes to this field only if: - The min flag is not set OR - The min flag is set AND -- The min flag of the locally cached user entry is set.
            photo (Optional['TypeUserProfilePhoto'], optional): Profile picture of user. When updating the [local peer database](https://core.telegram.org/api/peers), apply changes to this field only if: - The min flag is not set OR - The min flag is set AND -- The apply_min_photo flag is set OR -- The min flag of the locally cached user entry is set.
            status (Optional['TypeUserStatus'], optional): Online status of user. When updating the [local peer database](https://core.telegram.org/api/peers), apply changes to this field only if: - The min flag is not set OR - The min flag is set AND -- The min flag of the locally cached user entry is set OR -- The locally cached user entry is equal to [userStatusEmpty](https://core.telegram.org/constructor/userStatusEmpty).
            bot_info_version (Optional[int], optional): Version of the [bot_info field in userFull](https://core.telegram.org/constructor/userFull), incremented every time it changes. Changes to this flag should invalidate the local [userFull](https://core.telegram.org/constructor/userFull) cache for this user ID, see [here](https://core.telegram.org/api/peers#full-info-database) for more info.
            restriction_reason (Optional[List['TypeRestrictionReason']], optional): Contains the reason why access to this user must be restricted.
            bot_inline_placeholder (Optional[str], optional): Inline placeholder for this inline bot
            lang_code (Optional[str], optional): Language code of the user
            emoji_status (Optional['TypeEmojiStatus'], optional): [Emoji status](https://core.telegram.org/api/emoji-status)
            usernames (Optional[List['TypeUsername']], optional): Additional usernames. When updating the [local peer database](https://core.telegram.org/api/peers), apply changes to this field only if: - The min flag is not set OR - The min flag is set AND -- The min flag of the locally cached user entry is set. Changes to this flag (if the above conditions are respected) should invalidate the local [userFull](https://core.telegram.org/constructor/userFull) cache for this user ID.
            stories_max_id (Optional[int], optional): ID of the maximum read [story](https://core.telegram.org/api/stories).  When updating the [local peer database](https://core.telegram.org/api/peers), do not apply changes to this field if the min flag of the incoming constructor is set.
            color (Optional['TypePeerColor'], optional): The user's [accent color](https://core.telegram.org/api/colors).
            profile_color (Optional['TypePeerColor'], optional): The user's [profile color](https://core.telegram.org/api/colors).
            bot_active_users (Optional[int], optional): Monthly Active Users (MAU) of this bot (may be absent for small bots).
            bot_verification_icon (Optional[int], optional): ...
            send_paid_messages_stars (Optional[int], optional): ...
        """

        self.id = id
        self.is_self = is_self
        self.contact = contact
        self.mutual_contact = mutual_contact
        self.deleted = deleted
        self.bot = bot
        self.bot_chat_history = bot_chat_history
        self.bot_nochats = bot_nochats
        self.verified = verified
        self.restricted = restricted
        self.min = min
        self.bot_inline_geo = bot_inline_geo
        self.support = support
        self.scam = scam
        self.apply_min_photo = apply_min_photo
        self.fake = fake
        self.bot_attach_menu = bot_attach_menu
        self.premium = premium
        self.attach_menu_enabled = attach_menu_enabled
        self.bot_can_edit = bot_can_edit
        self.close_friend = close_friend
        self.stories_hidden = stories_hidden
        self.stories_unavailable = stories_unavailable
        self.contact_require_premium = contact_require_premium
        self.bot_business = bot_business
        self.bot_has_main_app = bot_has_main_app
        self.access_hash = access_hash
        self.first_name = first_name
        self.last_name = last_name
        self.username = username
        self.phone = phone
        self.photo = photo
        self.status = status
        self.bot_info_version = bot_info_version
        self.restriction_reason = restriction_reason
        self.bot_inline_placeholder = bot_inline_placeholder
        self.lang_code = lang_code
        self.emoji_status = emoji_status
        self.usernames = usernames
        self.stories_max_id = stories_max_id
        self.color = color
        self.profile_color = profile_color
        self.bot_active_users = bot_active_users
        self.bot_verification_icon = bot_verification_icon
        self.send_paid_messages_stars = send_paid_messages_stars

    def to_bytes(self, boxed: bool=True):
        with Writer(b'"\x14\x0b\x02' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.is_self, 10)
                flags(self.contact, 11)
                flags(self.mutual_contact, 12)
                flags(self.deleted, 13)
                flags(self.bot, 14)
                flags(self.bot_chat_history, 15)
                flags(self.bot_nochats, 16)
                flags(self.verified, 17)
                flags(self.restricted, 18)
                flags(self.min, 20)
                flags(self.bot_inline_geo, 21)
                flags(self.support, 23)
                flags(self.scam, 24)
                flags(self.apply_min_photo, 25)
                flags(self.fake, 26)
                flags(self.bot_attach_menu, 27)
                flags(self.premium, 28)
                flags(self.attach_menu_enabled, 29)

                with writer.flag() as flags2:
                    flags2(self.bot_can_edit, 1)
                    flags2(self.close_friend, 2)
                    flags2(self.stories_hidden, 3)
                    flags2(self.stories_unavailable, 4)
                    flags2(self.contact_require_premium, 10)
                    flags2(self.bot_business, 11)
                    flags2(self.bot_has_main_app, 13)
                    writer.long(self.id)

                    if flags(self.access_hash, 0):
                        writer.long(self.access_hash)

                    if flags(self.first_name, 1):
                        writer.string(self.first_name)

                    if flags(self.last_name, 2):
                        writer.string(self.last_name)

                    if flags(self.username, 3):
                        writer.string(self.username)

                    if flags(self.phone, 4):
                        writer.string(self.phone)

                    if flags(self.photo, 5):
                        writer.object(
                            self.photo,
                            group_id=0X5620ACEE
                        )

                    if flags(self.status, 6):
                        writer.object(
                            self.status,
                            group_id=0X6F35ECEB
                        )

                    if flags(self.bot_info_version, 14):
                        writer.int(self.bot_info_version)

                    if flags(self.restriction_reason, 18):
                        writer.vector(
                            self.restriction_reason,
                            lambda value: writer.object(
                                value,
                                group_id=0X6F3B4470
                            )
                        )

                    if flags(self.bot_inline_placeholder, 19):
                        writer.string(self.bot_inline_placeholder)

                    if flags(self.lang_code, 22):
                        writer.string(self.lang_code)

                    if flags(self.emoji_status, 30):
                        writer.object(
                            self.emoji_status,
                            group_id=0XFBDA9FB
                        )

                    if flags2(self.usernames, 0):
                        writer.vector(
                            self.usernames,
                            lambda value: writer.object(
                                value,
                                group_id=0X45703151
                            )
                        )

                    if flags2(self.stories_max_id, 5):
                        writer.int(self.stories_max_id)

                    if flags2(self.color, 8):
                        writer.object(
                            self.color,
                            group_id=0XA2C08D16
                        )

                    if flags2(self.profile_color, 9):
                        writer.object(
                            self.profile_color,
                            group_id=0XA2C08D16
                        )

                    if flags2(self.bot_active_users, 12):
                        writer.int(self.bot_active_users)

                    if flags2(self.bot_verification_icon, 14):
                        writer.long(self.bot_verification_icon)

                    if flags2(self.send_paid_messages_stars, 15):
                        writer.long(self.send_paid_messages_stars)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        flags2 = reader.flag()
        id_ = reader.long()
        access_hash_ = (
            reader.long()
            if flags(0) else None
        )

        first_name_ = (
            reader.string()
            if flags(1) else None
        )

        last_name_ = (
            reader.string()
            if flags(2) else None
        )

        username_ = (
            reader.string()
            if flags(3) else None
        )

        phone_ = (
            reader.string()
            if flags(4) else None
        )

        photo_ = (
            reader.object(
                group_id=0X5620ACEE
            )
            if flags(5) else None
        )

        status_ = (
            reader.object(
                group_id=0X6F35ECEB
            )
            if flags(6) else None
        )

        bot_info_version_ = (
            reader.int()
            if flags(14) else None
        )

        restriction_reason_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X6F3B4470
                )
            )
            if flags(18) else None
        )

        bot_inline_placeholder_ = (
            reader.string()
            if flags(19) else None
        )

        lang_code_ = (
            reader.string()
            if flags(22) else None
        )

        emoji_status_ = (
            reader.object(
                group_id=0XFBDA9FB
            )
            if flags(30) else None
        )

        usernames_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X45703151
                )
            )
            if flags2(0) else None
        )

        stories_max_id_ = (
            reader.int()
            if flags2(5) else None
        )

        color_ = (
            reader.object(
                group_id=0XA2C08D16
            )
            if flags2(8) else None
        )

        profile_color_ = (
            reader.object(
                group_id=0XA2C08D16
            )
            if flags2(9) else None
        )

        bot_active_users_ = (
            reader.int()
            if flags2(12) else None
        )

        bot_verification_icon_ = (
            reader.long()
            if flags2(14) else None
        )

        send_paid_messages_stars_ = (
            reader.long()
            if flags2(15) else None
        )

        return cls(
            id=id_,
            is_self=flags(10),
            contact=flags(11),
            mutual_contact=flags(12),
            deleted=flags(13),
            bot=flags(14),
            bot_chat_history=flags(15),
            bot_nochats=flags(16),
            verified=flags(17),
            restricted=flags(18),
            min=flags(20),
            bot_inline_geo=flags(21),
            support=flags(23),
            scam=flags(24),
            apply_min_photo=flags(25),
            fake=flags(26),
            bot_attach_menu=flags(27),
            premium=flags(28),
            attach_menu_enabled=flags(29),
            bot_can_edit=flags2(1),
            close_friend=flags2(2),
            stories_hidden=flags2(3),
            stories_unavailable=flags2(4),
            contact_require_premium=flags2(10),
            bot_business=flags2(11),
            bot_has_main_app=flags2(13),
            access_hash=access_hash_,
            first_name=first_name_,
            last_name=last_name_,
            username=username_,
            phone=phone_,
            photo=photo_,
            status=status_,
            bot_info_version=bot_info_version_,
            restriction_reason=restriction_reason_,
            bot_inline_placeholder=bot_inline_placeholder_,
            lang_code=lang_code_,
            emoji_status=emoji_status_,
            usernames=usernames_,
            stories_max_id=stories_max_id_,
            color=color_,
            profile_color=profile_color_,
            bot_active_users=bot_active_users_,
            bot_verification_icon=bot_verification_icon_,
            send_paid_messages_stars=send_paid_messages_stars_
        )

TypeUser = Union[
    UserEmpty,
    User
]