
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class UserProfilePhotoEmpty(TLObject, family='TypeUserProfilePhoto'):
    """
    Profile photo has not been set, or was hidden.
    """

    _id = 0X4F11BAE1
    _group_id = 0X5620ACEE


    def to_bytes(self, boxed: bool=True):
        return b'\xe1\xba\x11O' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class UserProfilePhoto(TLObject, family='TypeUserProfilePhoto'):
    """
    User profile photo.
    """

    _id = 0X82D1F706
    _group_id = 0X5620ACEE

    def __init__(
        self,
        photo_id: int,
        dc_id: int,
        has_video: bool = False,
        personal: bool = False,
        stripped_thumb: Optional[bytes] = None
    ):

        """
        User profile photo.

        Args:
            photo_id (int): Identifier of the respective photo
            dc_id (int): DC ID where the photo is stored
            has_video (bool, optional): Whether an [animated profile picture](https://core.telegram.org/api/files#animated-profile-pictures) is available for this user
            personal (bool, optional): Whether this profile photo is only visible to us (i.e. it was set using [photos.uploadContactProfilePhoto](https://core.telegram.org/method/photos.uploadContactProfilePhoto)).
            stripped_thumb (Optional[bytes], optional): [Stripped thumbnail](https://core.telegram.org/api/files#stripped-thumbnails)
        """

        self.photo_id = photo_id
        self.dc_id = dc_id
        self.has_video = has_video
        self.personal = personal
        self.stripped_thumb = stripped_thumb

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x06\xf7\xd1\x82' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.has_video, 0)
                flags(self.personal, 2)
                writer.long(self.photo_id)

                if flags(self.stripped_thumb, 1):
                    writer.bytes(self.stripped_thumb)
                writer.int(self.dc_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        photo_id_ = reader.long()
        stripped_thumb_ = (
            reader.bytes()
            if flags(1) else None
        )

        dc_id_ = reader.int()

        return cls(
            photo_id=photo_id_,
            dc_id=dc_id_,
            has_video=flags(0),
            personal=flags(2),
            stripped_thumb=stripped_thumb_
        )

TypeUserProfilePhoto = Union[
    UserProfilePhotoEmpty,
    UserProfilePhoto
]