
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Union, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_sticker_set import TypeInputStickerSet
    from ...gadgets.byteutils import Reader


class VideoSize(TLObject, family='TypeVideoSize'):
    """
    An [animated profile picture](https://core.telegram.org/api/files#animated-profile-pictures) in MPEG4 format
    """

    _id = 0XDE33B094
    _group_id = 0X32B0FC60

    def __init__(
        self,
        type: str,
        w: int,
        h: int,
        size: int,
        video_start_ts: Optional[float] = None
    ):

        """
        An [animated profile picture](https://core.telegram.org/api/files#animated-profile-pictures) in MPEG4 format

        Args:
            type (str): u for animated profile pictures, and v for trimmed and downscaled video previews
            w (int): Video width
            h (int): Video height
            size (int): File size
            video_start_ts (Optional[float], optional): Timestamp that should be shown as static preview to the user (seconds)
        """

        self.type = type
        self.w = w
        self.h = h
        self.size = size
        self.video_start_ts = video_start_ts

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x94\xb03\xde' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.type)
                writer.int(self.w)
                writer.int(self.h)
                writer.int(self.size)

                if flags(self.video_start_ts, 0):
                    writer.double(self.video_start_ts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        type_ = reader.string()
        w_ = reader.int()
        h_ = reader.int()
        size_ = reader.int()
        video_start_ts_ = (
            reader.double()
            if flags(0) else None
        )

        return cls(
            type=type_,
            w=w_,
            h=h_,
            size=size_,
            video_start_ts=video_start_ts_
        )

class VideoSizeEmojiMarkup(TLObject, family='TypeVideoSize'):
    """
    An [animated profile picture](https://core.telegram.org/api/files#animated-profile-pictures) based on a [custom emoji sticker](https://core.telegram.org/api/custom-emoji).
    """

    _id = 0XF85C413C
    _group_id = 0X32B0FC60

    def __init__(
        self,
        emoji_id: int,
        background_colors: List[int]
    ):

        """
        An [animated profile picture](https://core.telegram.org/api/files#animated-profile-pictures) based on a [custom emoji sticker](https://core.telegram.org/api/custom-emoji).

        Args:
            emoji_id (int): [Custom emoji ID](https://core.telegram.org/api/custom-emoji): the custom emoji sticker is shown at the center of the profile picture and occupies at most 67% of it.
            background_colors (List[int]): 1, 2, 3 or 4 RBG-24 colors used to generate a solid (1), gradient (2) or freeform gradient (3, 4) background, similar to how [fill wallpapers](https://core.telegram.org/api/wallpapers#fill-types) are generated. The rotation angle for gradient backgrounds is 0.
        """

        self.emoji_id = emoji_id
        self.background_colors = background_colors

    def to_bytes(self, boxed: bool=True):
        with Writer(b'<A\\\xf8' if boxed else b'') as writer:
            writer.long(self.emoji_id)
            writer.vector(
                self.background_colors,
                writer.int
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        emoji_id_ = reader.long()
        background_colors_ = reader.vector(
            reader.int
        )

        return cls(
            emoji_id=emoji_id_,
            background_colors=background_colors_
        )

class VideoSizeStickerMarkup(TLObject, family='TypeVideoSize'):
    """
    An [animated profile picture](https://core.telegram.org/api/files#animated-profile-pictures) based on a [sticker](https://core.telegram.org/api/stickers).
    """

    _id = 0XDA082FE
    _group_id = 0X32B0FC60

    def __init__(
        self,
        stickerset: 'TypeInputStickerSet',
        sticker_id: int,
        background_colors: List[int]
    ):

        """
        An [animated profile picture](https://core.telegram.org/api/files#animated-profile-pictures) based on a [sticker](https://core.telegram.org/api/stickers).

        Args:
            stickerset ('TypeInputStickerSet'): Stickerset
            sticker_id (int): Sticker ID
            background_colors (List[int]): 1, 2, 3 or 4 RBG-24 colors used to generate a solid (1), gradient (2) or freeform gradient (3, 4) background, similar to how [fill wallpapers](https://core.telegram.org/api/wallpapers#fill-types) are generated. The rotation angle for gradient backgrounds is 0.
        """

        self.stickerset = stickerset
        self.sticker_id = sticker_id
        self.background_colors = background_colors

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfe\x82\xa0\r' if boxed else b'') as writer:
            writer.object(
                self.stickerset,
                group_id=0X919D8BA5
            )
            writer.long(self.sticker_id)
            writer.vector(
                self.background_colors,
                writer.int
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        stickerset_ = reader.object(
            group_id=0X919D8BA5
        )

        sticker_id_ = reader.long()
        background_colors_ = reader.vector(
            reader.int
        )

        return cls(
            stickerset=stickerset_,
            sticker_id=sticker_id_,
            background_colors=background_colors_
        )

TypeVideoSize = Union[
    VideoSize,
    VideoSizeEmojiMarkup,
    VideoSizeStickerMarkup
]