
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .document import TypeDocument
    from .wall_paper_settings import TypeWallPaperSettings
    from ...gadgets.byteutils import Reader


class WallPaper(TLObject, family='TypeWallPaper'):
    """
    Represents a [wallpaper](https://core.telegram.org/api/wallpapers) based on an image.
    """

    _id = 0XA437C3ED
    _group_id = 0XC6E3E0E2

    def __init__(
        self,
        id: int,
        access_hash: int,
        slug: str,
        document: 'TypeDocument',
        creator: bool = False,
        default: bool = False,
        pattern: bool = False,
        dark: bool = False,
        settings: Optional['TypeWallPaperSettings'] = None
    ):

        """
        Represents a [wallpaper](https://core.telegram.org/api/wallpapers) based on an image.

        Args:
            id (int): Identifier
            access_hash (int): Access hash
            slug (str): Unique wallpaper ID, used when generating [wallpaper links](https://core.telegram.org/api/links#wallpaper-links) or [importing wallpaper links](https://core.telegram.org/api/wallpapers).
            document ('TypeDocument'): The actual wallpaper
            creator (bool, optional): Whether we created this wallpaper
            default (bool, optional): Whether this is the default wallpaper
            pattern (bool, optional): Whether this is a [pattern wallpaper](https://core.telegram.org/api/wallpapers#pattern-wallpapers)
            dark (bool, optional): Whether this wallpaper should be used in dark mode.
            settings (Optional['TypeWallPaperSettings'], optional): Info on how to generate the wallpaper, according to [these instructions](https://core.telegram.org/api/wallpapers).
        """

        self.id = id
        self.access_hash = access_hash
        self.slug = slug
        self.document = document
        self.creator = creator
        self.default = default
        self.pattern = pattern
        self.dark = dark
        self.settings = settings

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xed\xc37\xa4' if boxed else b'') as writer:
            writer.long(self.id)
            with writer.flag() as flags:
                flags(self.creator, 0)
                flags(self.default, 1)
                flags(self.pattern, 3)
                flags(self.dark, 4)
                writer.long(self.access_hash)
                writer.string(self.slug)
                writer.object(
                    self.document,
                    group_id=0X6547BD50
                )

                if flags(self.settings, 2):
                    writer.object(
                        self.settings,
                        group_id=0X28E332CF
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        flags = reader.flag()
        access_hash_ = reader.long()
        slug_ = reader.string()
        document_ = reader.object(
            group_id=0X6547BD50
        )

        settings_ = (
            reader.object(
                group_id=0X28E332CF
            )
            if flags(2) else None
        )

        return cls(
            id=id_,
            access_hash=access_hash_,
            slug=slug_,
            document=document_,
            creator=flags(0),
            default=flags(1),
            pattern=flags(3),
            dark=flags(4),
            settings=settings_
        )

class WallPaperNoFile(TLObject, family='TypeWallPaper'):
    """
    Represents a [wallpaper](https://core.telegram.org/api/wallpapers) only based on colors/gradients.
    """

    _id = 0XE0804116
    _group_id = 0XC6E3E0E2

    def __init__(
        self,
        id: int,
        default: bool = False,
        dark: bool = False,
        settings: Optional['TypeWallPaperSettings'] = None
    ):

        """
        Represents a [wallpaper](https://core.telegram.org/api/wallpapers) only based on colors/gradients.

        Args:
            id (int): Wallpaper ID
            default (bool, optional): Whether this is the default wallpaper
            dark (bool, optional): Whether this wallpaper should be used in dark mode.
            settings (Optional['TypeWallPaperSettings'], optional): Info on how to generate the wallpaper.
        """

        self.id = id
        self.default = default
        self.dark = dark
        self.settings = settings

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x16A\x80\xe0' if boxed else b'') as writer:
            writer.long(self.id)
            with writer.flag() as flags:
                flags(self.default, 1)
                flags(self.dark, 4)

                if flags(self.settings, 2):
                    writer.object(
                        self.settings,
                        group_id=0X28E332CF
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        flags = reader.flag()
        settings_ = (
            reader.object(
                group_id=0X28E332CF
            )
            if flags(2) else None
        )

        return cls(
            id=id_,
            default=flags(1),
            dark=flags(4),
            settings=settings_
        )

TypeWallPaper = Union[
    WallPaper,
    WallPaperNoFile
]