import numpy as np
import pinocchio as pin
from . import core as jiminy
from _typeshed import Incomplete
from typing import Any, Callable, Optional, Sequence, Tuple, TypedDict

LOGGER: Incomplete

def SE3ToXYZRPY(M: pin.SE3) -> np.ndarray: ...
def XYZRPYToSE3(xyzrpy: np.ndarray) -> np.ndarray: ...
def XYZRPYToXYZQuat(xyzrpy: np.ndarray) -> np.ndarray: ...
def XYZQuatToXYZRPY(xyzquat: np.ndarray) -> np.ndarray: ...
def velocityXYZRPYToXYZQuat(xyzrpy: np.ndarray, dxyzrpy: np.ndarray) -> np.ndarray: ...
def velocityXYZQuatToXYZRPY(xyzquat: np.ndarray, v: np.ndarray) -> np.ndarray: ...

class State:
    t: Incomplete
    q: Incomplete
    v: Incomplete
    a: Incomplete
    tau: Incomplete
    contact_frames: Incomplete
    f_ext: Incomplete
    def __init__(self, t: float, q: np.ndarray, v: Optional[np.ndarray] = ..., a: Optional[np.ndarray] = ..., tau: Optional[np.ndarray] = ..., contact_frames: Optional[Sequence[str]] = ..., f_ext: Optional[Sequence[np.ndarray]] = ..., copy: bool = ..., **kwargs: Any) -> None: ...

class TrajectoryDataType(TypedDict, total=False):
    evolution_robot: Sequence[State]
    robot: Optional[jiminy.Robot]
    use_theoretical_model: bool

def update_quantities(robot: jiminy.Model, position: np.ndarray, velocity: Optional[np.ndarray] = ..., acceleration: Optional[np.ndarray] = ..., update_physics: bool = ..., update_com: bool = ..., update_energy: bool = ..., update_jacobian: bool = ..., update_collisions: bool = ..., use_theoretical_model: bool = ...) -> None: ...
def get_body_world_transform(robot: jiminy.Model, body_name: str, use_theoretical_model: bool = ..., copy: bool = ...) -> pin.SE3: ...
def get_body_world_velocity(robot: jiminy.Model, body_name: str, use_theoretical_model: bool = ...) -> pin.SE3: ...
def get_body_world_acceleration(robot: jiminy.Model, body_name: str, use_theoretical_model: bool = ...) -> pin.SE3: ...
def compute_transform_contact(robot: jiminy.Model, ground_profile: Optional[Callable[[np.ndarray], Tuple[float, np.ndarray]]] = ...) -> pin.SE3: ...
def compute_freeflyer_state_from_fixed_body(robot: jiminy.Model, position: np.ndarray, velocity: Optional[np.ndarray] = ..., acceleration: Optional[np.ndarray] = ..., fixed_body_name: Optional[str] = ..., ground_profile: Optional[Callable[[np.ndarray], Tuple[float, np.ndarray]]] = ..., use_theoretical_model: Optional[bool] = ...) -> None: ...
def compute_efforts_from_fixed_body(robot: jiminy.Model, position: np.ndarray, velocity: np.ndarray, acceleration: np.ndarray, fixed_body_name: str, use_theoretical_model: bool = ...) -> Tuple[np.ndarray, pin.Force]: ...
def compute_inverse_dynamics(robot: jiminy.Model, position: np.ndarray, velocity: np.ndarray, acceleration: np.ndarray, use_theoretical_model: bool = ...) -> np.ndarray: ...
def compute_freeflyer(trajectory_data: TrajectoryDataType, freeflyer_continuity: bool = ...) -> None: ...
def compute_efforts(trajectory_data: TrajectoryDataType) -> None: ...
