# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    import __init__ as _models


class AnalyzeTextTask(msrest.serialization.Model):
    """AnalyzeTextTask.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AnalyzeTextEntityLinkingInput, AnalyzeTextEntityRecognitionInput, AnalyzeTextKeyPhraseExtractionInput, AnalyzeTextLanguageDetectionInput, AnalyzeTextPiiEntitiesRecognitionInput, AnalyzeTextSentimentAnalysisInput.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Enumeration of supported Text Analysis tasks.Constant filled by server.
     Known values are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition",
     "KeyPhraseExtraction", "LanguageDetection", "EntityLinking".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextTaskKind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'EntityLinking': 'AnalyzeTextEntityLinkingInput', 'EntityRecognition': 'AnalyzeTextEntityRecognitionInput', 'KeyPhraseExtraction': 'AnalyzeTextKeyPhraseExtractionInput', 'LanguageDetection': 'AnalyzeTextLanguageDetectionInput', 'PiiEntityRecognition': 'AnalyzeTextPiiEntitiesRecognitionInput', 'SentimentAnalysis': 'AnalyzeTextSentimentAnalysisInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AnalyzeTextTask, self).__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class AnalyzeTextEntityLinkingInput(AnalyzeTextTask):
    """AnalyzeTextEntityLinkingInput.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Enumeration of supported Text Analysis tasks.Constant filled by server.
     Known values are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition",
     "KeyPhraseExtraction", "LanguageDetection", "EntityLinking".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextTaskKind
    :ivar analysis_input:
    :vartype analysis_input: ~azure.ai.textanalytics.v2022_05_01.models.MultiLanguageAnalysisInput
    :ivar parameters: Supported parameters for an Entity Linking task.
    :vartype parameters: ~azure.ai.textanalytics.v2022_05_01.models.EntityLinkingTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'analysis_input': {'key': 'analysisInput', 'type': 'MultiLanguageAnalysisInput'},
        'parameters': {'key': 'parameters', 'type': 'EntityLinkingTaskParameters'},
    }

    def __init__(
        self,
        *,
        analysis_input: Optional["_models.MultiLanguageAnalysisInput"] = None,
        parameters: Optional["_models.EntityLinkingTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword analysis_input:
        :paramtype analysis_input:
         ~azure.ai.textanalytics.v2022_05_01.models.MultiLanguageAnalysisInput
        :keyword parameters: Supported parameters for an Entity Linking task.
        :paramtype parameters: ~azure.ai.textanalytics.v2022_05_01.models.EntityLinkingTaskParameters
        """
        super(AnalyzeTextEntityLinkingInput, self).__init__(**kwargs)
        self.kind = 'EntityLinking'  # type: str
        self.analysis_input = analysis_input
        self.parameters = parameters


class AnalyzeTextEntityRecognitionInput(AnalyzeTextTask):
    """AnalyzeTextEntityRecognitionInput.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Enumeration of supported Text Analysis tasks.Constant filled by server.
     Known values are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition",
     "KeyPhraseExtraction", "LanguageDetection", "EntityLinking".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextTaskKind
    :ivar analysis_input:
    :vartype analysis_input: ~azure.ai.textanalytics.v2022_05_01.models.MultiLanguageAnalysisInput
    :ivar parameters: Supported parameters for an Entity Recognition task.
    :vartype parameters: ~azure.ai.textanalytics.v2022_05_01.models.EntitiesTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'analysis_input': {'key': 'analysisInput', 'type': 'MultiLanguageAnalysisInput'},
        'parameters': {'key': 'parameters', 'type': 'EntitiesTaskParameters'},
    }

    def __init__(
        self,
        *,
        analysis_input: Optional["_models.MultiLanguageAnalysisInput"] = None,
        parameters: Optional["_models.EntitiesTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword analysis_input:
        :paramtype analysis_input:
         ~azure.ai.textanalytics.v2022_05_01.models.MultiLanguageAnalysisInput
        :keyword parameters: Supported parameters for an Entity Recognition task.
        :paramtype parameters: ~azure.ai.textanalytics.v2022_05_01.models.EntitiesTaskParameters
        """
        super(AnalyzeTextEntityRecognitionInput, self).__init__(**kwargs)
        self.kind = 'EntityRecognition'  # type: str
        self.analysis_input = analysis_input
        self.parameters = parameters


class AnalyzeTextJobsInput(msrest.serialization.Model):
    """AnalyzeTextJobsInput.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: Optional display name for the analysis job.
    :vartype display_name: str
    :ivar analysis_input: Required.
    :vartype analysis_input: ~azure.ai.textanalytics.v2022_05_01.models.MultiLanguageAnalysisInput
    :ivar tasks: Required. The set of tasks to execute on the input documents.
    :vartype tasks: list[~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROTask]
    """

    _validation = {
        'analysis_input': {'required': True},
        'tasks': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'analysis_input': {'key': 'analysisInput', 'type': 'MultiLanguageAnalysisInput'},
        'tasks': {'key': 'tasks', 'type': '[AnalyzeTextLROTask]'},
    }

    def __init__(
        self,
        *,
        analysis_input: "_models.MultiLanguageAnalysisInput",
        tasks: List["_models.AnalyzeTextLROTask"],
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_name: Optional display name for the analysis job.
        :paramtype display_name: str
        :keyword analysis_input: Required.
        :paramtype analysis_input:
         ~azure.ai.textanalytics.v2022_05_01.models.MultiLanguageAnalysisInput
        :keyword tasks: Required. The set of tasks to execute on the input documents.
        :paramtype tasks: list[~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROTask]
        """
        super(AnalyzeTextJobsInput, self).__init__(**kwargs)
        self.display_name = display_name
        self.analysis_input = analysis_input
        self.tasks = tasks


class AnalyzeTextJobStatistics(msrest.serialization.Model):
    """AnalyzeTextJobStatistics.

    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
    """

    _attribute_map = {
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
    }

    def __init__(
        self,
        *,
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
        """
        super(AnalyzeTextJobStatistics, self).__init__(**kwargs)
        self.statistics = statistics


class TasksState(msrest.serialization.Model):
    """TasksState.

    All required parameters must be populated in order to send to Azure.

    :ivar tasks: Required.
    :vartype tasks: ~azure.ai.textanalytics.v2022_05_01.models.TasksStateTasks
    """

    _validation = {
        'tasks': {'required': True},
    }

    _attribute_map = {
        'tasks': {'key': 'tasks', 'type': 'TasksStateTasks'},
    }

    def __init__(
        self,
        *,
        tasks: "_models.TasksStateTasks",
        **kwargs
    ):
        """
        :keyword tasks: Required.
        :paramtype tasks: ~azure.ai.textanalytics.v2022_05_01.models.TasksStateTasks
        """
        super(TasksState, self).__init__(**kwargs)
        self.tasks = tasks


class JobState(msrest.serialization.Model):
    """JobState.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name:
    :vartype display_name: str
    :ivar created_date_time: Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time:
    :vartype expiration_date_time: ~datetime.datetime
    :ivar job_id: Required.
    :vartype job_id: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded",
     "partiallyCompleted", "failed", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
    :ivar errors:
    :vartype errors: list[~azure.ai.textanalytics.v2022_05_01.models.Error]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        'created_date_time': {'required': True},
        'job_id': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'expiration_date_time': {'key': 'expirationDateTime', 'type': 'iso-8601'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'last_update_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[Error]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        created_date_time: datetime.datetime,
        job_id: str,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        display_name: Optional[str] = None,
        expiration_date_time: Optional[datetime.datetime] = None,
        errors: Optional[List["_models.Error"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_name:
        :paramtype display_name: str
        :keyword created_date_time: Required.
        :paramtype created_date_time: ~datetime.datetime
        :keyword expiration_date_time:
        :paramtype expiration_date_time: ~datetime.datetime
        :keyword job_id: Required.
        :paramtype job_id: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded",
         "partiallyCompleted", "failed", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
        :keyword errors:
        :paramtype errors: list[~azure.ai.textanalytics.v2022_05_01.models.Error]
        :keyword next_link:
        :paramtype next_link: str
        """
        super(JobState, self).__init__(**kwargs)
        self.display_name = display_name
        self.created_date_time = created_date_time
        self.expiration_date_time = expiration_date_time
        self.job_id = job_id
        self.last_update_date_time = last_update_date_time
        self.status = status
        self.errors = errors
        self.next_link = next_link


class AnalyzeTextJobState(JobState, TasksState, AnalyzeTextJobStatistics):
    """AnalyzeTextJobState.

    All required parameters must be populated in order to send to Azure.

    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
    :ivar tasks: Required.
    :vartype tasks: ~azure.ai.textanalytics.v2022_05_01.models.TasksStateTasks
    :ivar display_name:
    :vartype display_name: str
    :ivar created_date_time: Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time:
    :vartype expiration_date_time: ~datetime.datetime
    :ivar job_id: Required.
    :vartype job_id: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded",
     "partiallyCompleted", "failed", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
    :ivar errors:
    :vartype errors: list[~azure.ai.textanalytics.v2022_05_01.models.Error]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        'tasks': {'required': True},
        'created_date_time': {'required': True},
        'job_id': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'tasks': {'key': 'tasks', 'type': 'TasksStateTasks'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'expiration_date_time': {'key': 'expirationDateTime', 'type': 'iso-8601'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'last_update_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[Error]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tasks: "_models.TasksStateTasks",
        created_date_time: datetime.datetime,
        job_id: str,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        statistics: Optional["_models.RequestStatistics"] = None,
        display_name: Optional[str] = None,
        expiration_date_time: Optional[datetime.datetime] = None,
        errors: Optional[List["_models.Error"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
        :keyword tasks: Required.
        :paramtype tasks: ~azure.ai.textanalytics.v2022_05_01.models.TasksStateTasks
        :keyword display_name:
        :paramtype display_name: str
        :keyword created_date_time: Required.
        :paramtype created_date_time: ~datetime.datetime
        :keyword expiration_date_time:
        :paramtype expiration_date_time: ~datetime.datetime
        :keyword job_id: Required.
        :paramtype job_id: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded",
         "partiallyCompleted", "failed", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
        :keyword errors:
        :paramtype errors: list[~azure.ai.textanalytics.v2022_05_01.models.Error]
        :keyword next_link:
        :paramtype next_link: str
        """
        super(AnalyzeTextJobState, self).__init__(display_name=display_name, created_date_time=created_date_time, expiration_date_time=expiration_date_time, job_id=job_id, last_update_date_time=last_update_date_time, status=status, errors=errors, next_link=next_link, tasks=tasks, statistics=statistics, **kwargs)
        self.statistics = statistics
        self.tasks = tasks
        self.display_name = display_name
        self.created_date_time = created_date_time
        self.expiration_date_time = expiration_date_time
        self.job_id = job_id
        self.last_update_date_time = last_update_date_time
        self.status = status
        self.errors = errors
        self.next_link = next_link


class AnalyzeTextKeyPhraseExtractionInput(AnalyzeTextTask):
    """AnalyzeTextKeyPhraseExtractionInput.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Enumeration of supported Text Analysis tasks.Constant filled by server.
     Known values are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition",
     "KeyPhraseExtraction", "LanguageDetection", "EntityLinking".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextTaskKind
    :ivar analysis_input:
    :vartype analysis_input: ~azure.ai.textanalytics.v2022_05_01.models.MultiLanguageAnalysisInput
    :ivar parameters: Supported parameters for a Key Phrase Extraction task.
    :vartype parameters: ~azure.ai.textanalytics.v2022_05_01.models.KeyPhraseTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'analysis_input': {'key': 'analysisInput', 'type': 'MultiLanguageAnalysisInput'},
        'parameters': {'key': 'parameters', 'type': 'KeyPhraseTaskParameters'},
    }

    def __init__(
        self,
        *,
        analysis_input: Optional["_models.MultiLanguageAnalysisInput"] = None,
        parameters: Optional["_models.KeyPhraseTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword analysis_input:
        :paramtype analysis_input:
         ~azure.ai.textanalytics.v2022_05_01.models.MultiLanguageAnalysisInput
        :keyword parameters: Supported parameters for a Key Phrase Extraction task.
        :paramtype parameters: ~azure.ai.textanalytics.v2022_05_01.models.KeyPhraseTaskParameters
        """
        super(AnalyzeTextKeyPhraseExtractionInput, self).__init__(**kwargs)
        self.kind = 'KeyPhraseExtraction'  # type: str
        self.analysis_input = analysis_input
        self.parameters = parameters


class AnalyzeTextLanguageDetectionInput(AnalyzeTextTask):
    """AnalyzeTextLanguageDetectionInput.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Enumeration of supported Text Analysis tasks.Constant filled by server.
     Known values are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition",
     "KeyPhraseExtraction", "LanguageDetection", "EntityLinking".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextTaskKind
    :ivar analysis_input:
    :vartype analysis_input:
     ~azure.ai.textanalytics.v2022_05_01.models.LanguageDetectionAnalysisInput
    :ivar parameters: Supported parameters for a Language Detection task.
    :vartype parameters: ~azure.ai.textanalytics.v2022_05_01.models.LanguageDetectionTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'analysis_input': {'key': 'analysisInput', 'type': 'LanguageDetectionAnalysisInput'},
        'parameters': {'key': 'parameters', 'type': 'LanguageDetectionTaskParameters'},
    }

    def __init__(
        self,
        *,
        analysis_input: Optional["_models.LanguageDetectionAnalysisInput"] = None,
        parameters: Optional["_models.LanguageDetectionTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword analysis_input:
        :paramtype analysis_input:
         ~azure.ai.textanalytics.v2022_05_01.models.LanguageDetectionAnalysisInput
        :keyword parameters: Supported parameters for a Language Detection task.
        :paramtype parameters:
         ~azure.ai.textanalytics.v2022_05_01.models.LanguageDetectionTaskParameters
        """
        super(AnalyzeTextLanguageDetectionInput, self).__init__(**kwargs)
        self.kind = 'LanguageDetection'  # type: str
        self.analysis_input = analysis_input
        self.parameters = parameters


class TaskState(msrest.serialization.Model):
    """TaskState.

    All required parameters must be populated in order to send to Azure.

    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded",
     "partiallyCompleted", "failed", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        **kwargs
    ):
        """
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded",
         "partiallyCompleted", "failed", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
        """
        super(TaskState, self).__init__(**kwargs)
        self.last_update_date_time = last_update_date_time
        self.status = status


class TaskIdentifier(msrest.serialization.Model):
    """Base task object.

    :ivar task_name:
    :vartype task_name: str
    """

    _attribute_map = {
        'task_name': {'key': 'taskName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        """
        super(TaskIdentifier, self).__init__(**kwargs)
        self.task_name = task_name


class AnalyzeTextLROResult(TaskIdentifier, TaskState):
    """AnalyzeTextLROResult.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CustomEntityRecognitionLROResult, CustomMultiLabelClassificationLROResult, CustomSingleLabelClassificationLROResult, EntityLinkingLROResult, EntityRecognitionLROResult, HealthcareLROResult, KeyPhraseExtractionLROResult, PiiEntityRecognitionLROResult, SentimentLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded",
     "partiallyCompleted", "failed", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported Text Analysis long-running operation task
     results.Constant filled by server. Known values are: "SentimentAnalysisLROResults",
     "EntityRecognitionLROResults", "PiiEntityRecognitionLROResults",
     "KeyPhraseExtractionLROResults", "EntityLinkingLROResults", "HealthcareLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROResultsKind
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'CustomEntityRecognitionLROResults': 'CustomEntityRecognitionLROResult', 'CustomMultiLabelClassificationLROResults': 'CustomMultiLabelClassificationLROResult', 'CustomSingleLabelClassificationLROResults': 'CustomSingleLabelClassificationLROResult', 'EntityLinkingLROResults': 'EntityLinkingLROResult', 'EntityRecognitionLROResults': 'EntityRecognitionLROResult', 'HealthcareLROResults': 'HealthcareLROResult', 'KeyPhraseExtractionLROResults': 'KeyPhraseExtractionLROResult', 'PiiEntityRecognitionLROResults': 'PiiEntityRecognitionLROResult', 'SentimentAnalysisLROResults': 'SentimentLROResult'}
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded",
         "partiallyCompleted", "failed", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
        :keyword task_name:
        :paramtype task_name: str
        """
        super(AnalyzeTextLROResult, self).__init__(task_name=task_name, last_update_date_time=last_update_date_time, status=status, **kwargs)
        self.last_update_date_time = last_update_date_time
        self.status = status
        self.kind = 'AnalyzeTextLROResult'  # type: str
        self.task_name = task_name


class AnalyzeTextLROTask(TaskIdentifier):
    """AnalyzeTextLROTask.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CustomEntitiesLROTask, CustomMultiLabelClassificationLROTask, CustomSingleLabelClassificationLROTask, EntityLinkingLROTask, EntitiesLROTask, HealthcareLROTask, KeyPhraseLROTask, PiiLROTask, SentimentAnalysisLROTask.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported long-running Text Analysis tasks.Constant filled
     by server. Known values are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition",
     "KeyPhraseExtraction", "EntityLinking", "Healthcare", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROTaskKind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'CustomEntityRecognition': 'CustomEntitiesLROTask', 'CustomMultiLabelClassification': 'CustomMultiLabelClassificationLROTask', 'CustomSingleLabelClassification': 'CustomSingleLabelClassificationLROTask', 'EntityLinking': 'EntityLinkingLROTask', 'EntityRecognition': 'EntitiesLROTask', 'Healthcare': 'HealthcareLROTask', 'KeyPhraseExtraction': 'KeyPhraseLROTask', 'PiiEntityRecognition': 'PiiLROTask', 'SentimentAnalysis': 'SentimentAnalysisLROTask'}
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        """
        super(AnalyzeTextLROTask, self).__init__(task_name=task_name, **kwargs)
        self.kind = 'AnalyzeTextLROTask'  # type: str


class AnalyzeTextPiiEntitiesRecognitionInput(AnalyzeTextTask):
    """AnalyzeTextPiiEntitiesRecognitionInput.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Enumeration of supported Text Analysis tasks.Constant filled by server.
     Known values are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition",
     "KeyPhraseExtraction", "LanguageDetection", "EntityLinking".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextTaskKind
    :ivar analysis_input:
    :vartype analysis_input: ~azure.ai.textanalytics.v2022_05_01.models.MultiLanguageAnalysisInput
    :ivar parameters: Supported parameters for a PII Entities Recognition task.
    :vartype parameters: ~azure.ai.textanalytics.v2022_05_01.models.PiiTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'analysis_input': {'key': 'analysisInput', 'type': 'MultiLanguageAnalysisInput'},
        'parameters': {'key': 'parameters', 'type': 'PiiTaskParameters'},
    }

    def __init__(
        self,
        *,
        analysis_input: Optional["_models.MultiLanguageAnalysisInput"] = None,
        parameters: Optional["_models.PiiTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword analysis_input:
        :paramtype analysis_input:
         ~azure.ai.textanalytics.v2022_05_01.models.MultiLanguageAnalysisInput
        :keyword parameters: Supported parameters for a PII Entities Recognition task.
        :paramtype parameters: ~azure.ai.textanalytics.v2022_05_01.models.PiiTaskParameters
        """
        super(AnalyzeTextPiiEntitiesRecognitionInput, self).__init__(**kwargs)
        self.kind = 'PiiEntityRecognition'  # type: str
        self.analysis_input = analysis_input
        self.parameters = parameters


class AnalyzeTextSentimentAnalysisInput(AnalyzeTextTask):
    """AnalyzeTextSentimentAnalysisInput.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Enumeration of supported Text Analysis tasks.Constant filled by server.
     Known values are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition",
     "KeyPhraseExtraction", "LanguageDetection", "EntityLinking".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextTaskKind
    :ivar analysis_input:
    :vartype analysis_input: ~azure.ai.textanalytics.v2022_05_01.models.MultiLanguageAnalysisInput
    :ivar parameters: Supported parameters for a Sentiment Analysis task.
    :vartype parameters: ~azure.ai.textanalytics.v2022_05_01.models.SentimentAnalysisTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'analysis_input': {'key': 'analysisInput', 'type': 'MultiLanguageAnalysisInput'},
        'parameters': {'key': 'parameters', 'type': 'SentimentAnalysisTaskParameters'},
    }

    def __init__(
        self,
        *,
        analysis_input: Optional["_models.MultiLanguageAnalysisInput"] = None,
        parameters: Optional["_models.SentimentAnalysisTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword analysis_input:
        :paramtype analysis_input:
         ~azure.ai.textanalytics.v2022_05_01.models.MultiLanguageAnalysisInput
        :keyword parameters: Supported parameters for a Sentiment Analysis task.
        :paramtype parameters:
         ~azure.ai.textanalytics.v2022_05_01.models.SentimentAnalysisTaskParameters
        """
        super(AnalyzeTextSentimentAnalysisInput, self).__init__(**kwargs)
        self.kind = 'SentimentAnalysis'  # type: str
        self.analysis_input = analysis_input
        self.parameters = parameters


class AnalyzeTextTaskResult(msrest.serialization.Model):
    """AnalyzeTextTaskResult.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: EntityLinkingTaskResult, EntitiesTaskResult, KeyPhraseTaskResult, LanguageDetectionTaskResult, PiiTaskResult, SentimentTaskResult.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Enumeration of supported Text Analysis task results.Constant filled by
     server. Known values are: "SentimentAnalysisResults", "EntityRecognitionResults",
     "PiiEntityRecognitionResults", "KeyPhraseExtractionResults", "LanguageDetectionResults",
     "EntityLinkingResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextTaskResultsKind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'EntityLinkingResults': 'EntityLinkingTaskResult', 'EntityRecognitionResults': 'EntitiesTaskResult', 'KeyPhraseExtractionResults': 'KeyPhraseTaskResult', 'LanguageDetectionResults': 'LanguageDetectionTaskResult', 'PiiEntityRecognitionResults': 'PiiTaskResult', 'SentimentAnalysisResults': 'SentimentTaskResult'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AnalyzeTextTaskResult, self).__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class DocumentResult(msrest.serialization.Model):
    """DocumentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'warnings': {'key': 'warnings', 'type': '[DocumentWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        *,
        id: str,
        warnings: List["_models.DocumentWarning"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
        """
        super(DocumentResult, self).__init__(**kwargs)
        self.id = id
        self.warnings = warnings
        self.statistics = statistics


class ClassificationDocumentResult(DocumentResult):
    """ClassificationDocumentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
    :ivar class_property: Required.
    :vartype class_property: list[~azure.ai.textanalytics.v2022_05_01.models.ClassificationResult]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'class_property': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'warnings': {'key': 'warnings', 'type': '[DocumentWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'class_property': {'key': 'class', 'type': '[ClassificationResult]'},
    }

    def __init__(
        self,
        *,
        id: str,
        warnings: List["_models.DocumentWarning"],
        class_property: List["_models.ClassificationResult"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
        :keyword class_property: Required.
        :paramtype class_property:
         list[~azure.ai.textanalytics.v2022_05_01.models.ClassificationResult]
        """
        super(ClassificationDocumentResult, self).__init__(id=id, warnings=warnings, statistics=statistics, **kwargs)
        self.class_property = class_property


class ClassificationResult(msrest.serialization.Model):
    """ClassificationResult.

    All required parameters must be populated in order to send to Azure.

    :ivar category: Required. Classification type.
    :vartype category: str
    :ivar confidence_score: Required. Confidence score between 0 and 1 of the recognized class.
    :vartype confidence_score: float
    """

    _validation = {
        'category': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        category: str,
        confidence_score: float,
        **kwargs
    ):
        """
        :keyword category: Required. Classification type.
        :paramtype category: str
        :keyword confidence_score: Required. Confidence score between 0 and 1 of the recognized class.
        :paramtype confidence_score: float
        """
        super(ClassificationResult, self).__init__(**kwargs)
        self.category = category
        self.confidence_score = confidence_score


class CustomEntitiesLROTask(AnalyzeTextLROTask):
    """Use custom models to ease the process of information extraction from unstructured documents like contracts or financial documents.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported long-running Text Analysis tasks.Constant filled
     by server. Known values are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition",
     "KeyPhraseExtraction", "EntityLinking", "Healthcare", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for a Custom Entities task.
    :vartype parameters: ~azure.ai.textanalytics.v2022_05_01.models.CustomEntitiesTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'CustomEntitiesTaskParameters'},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        parameters: Optional["_models.CustomEntitiesTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for a Custom Entities task.
        :paramtype parameters: ~azure.ai.textanalytics.v2022_05_01.models.CustomEntitiesTaskParameters
        """
        super(CustomEntitiesLROTask, self).__init__(task_name=task_name, **kwargs)
        self.kind = 'CustomEntityRecognition'  # type: str
        self.parameters = parameters


class CustomResult(msrest.serialization.Model):
    """CustomResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
    :ivar project_name: Required. This field indicates the project name for the model.
    :vartype project_name: str
    :ivar deployment_name: Required. This field indicates the deployment name for the model.
    :vartype deployment_name: str
    """

    _validation = {
        'errors': {'required': True},
        'project_name': {'required': True},
        'deployment_name': {'required': True},
    }

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'project_name': {'key': 'projectName', 'type': 'str'},
        'deployment_name': {'key': 'deploymentName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        project_name: str,
        deployment_name: str,
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
        :keyword project_name: Required. This field indicates the project name for the model.
        :paramtype project_name: str
        :keyword deployment_name: Required. This field indicates the deployment name for the model.
        :paramtype deployment_name: str
        """
        super(CustomResult, self).__init__(**kwargs)
        self.errors = errors
        self.statistics = statistics
        self.project_name = project_name
        self.deployment_name = deployment_name


class CustomEntitiesResult(CustomResult):
    """CustomEntitiesResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
    :ivar project_name: Required. This field indicates the project name for the model.
    :vartype project_name: str
    :ivar deployment_name: Required. This field indicates the deployment name for the model.
    :vartype deployment_name: str
    :ivar documents: Required. Response by document.
    :vartype documents:
     list[~azure.ai.textanalytics.v2022_05_01.models.CustomEntitiesResultDocumentsItem]
    """

    _validation = {
        'errors': {'required': True},
        'project_name': {'required': True},
        'deployment_name': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'project_name': {'key': 'projectName', 'type': 'str'},
        'deployment_name': {'key': 'deploymentName', 'type': 'str'},
        'documents': {'key': 'documents', 'type': '[CustomEntitiesResultDocumentsItem]'},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        project_name: str,
        deployment_name: str,
        documents: List["_models.CustomEntitiesResultDocumentsItem"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
        :keyword project_name: Required. This field indicates the project name for the model.
        :paramtype project_name: str
        :keyword deployment_name: Required. This field indicates the deployment name for the model.
        :paramtype deployment_name: str
        :keyword documents: Required. Response by document.
        :paramtype documents:
         list[~azure.ai.textanalytics.v2022_05_01.models.CustomEntitiesResultDocumentsItem]
        """
        super(CustomEntitiesResult, self).__init__(errors=errors, statistics=statistics, project_name=project_name, deployment_name=deployment_name, **kwargs)
        self.documents = documents


class EntitiesDocumentResult(DocumentResult):
    """EntitiesDocumentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
    :ivar entities: Required. Recognized entities in the document.
    :vartype entities: list[~azure.ai.textanalytics.v2022_05_01.models.Entity]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'warnings': {'key': 'warnings', 'type': '[DocumentWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'entities': {'key': 'entities', 'type': '[Entity]'},
    }

    def __init__(
        self,
        *,
        id: str,
        warnings: List["_models.DocumentWarning"],
        entities: List["_models.Entity"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
        :keyword entities: Required. Recognized entities in the document.
        :paramtype entities: list[~azure.ai.textanalytics.v2022_05_01.models.Entity]
        """
        super(EntitiesDocumentResult, self).__init__(id=id, warnings=warnings, statistics=statistics, **kwargs)
        self.entities = entities


class CustomEntitiesResultDocumentsItem(EntitiesDocumentResult):
    """CustomEntitiesResultDocumentsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
    :ivar entities: Required. Recognized entities in the document.
    :vartype entities: list[~azure.ai.textanalytics.v2022_05_01.models.Entity]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'warnings': {'key': 'warnings', 'type': '[DocumentWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'entities': {'key': 'entities', 'type': '[Entity]'},
    }

    def __init__(
        self,
        *,
        id: str,
        warnings: List["_models.DocumentWarning"],
        entities: List["_models.Entity"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
        :keyword entities: Required. Recognized entities in the document.
        :paramtype entities: list[~azure.ai.textanalytics.v2022_05_01.models.Entity]
        """
        super(CustomEntitiesResultDocumentsItem, self).__init__(id=id, warnings=warnings, statistics=statistics, entities=entities, **kwargs)


class TaskParameters(msrest.serialization.Model):
    """Base parameters object for a text analysis task.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    """

    _attribute_map = {
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        logging_opt_out: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        """
        super(TaskParameters, self).__init__(**kwargs)
        self.logging_opt_out = logging_opt_out


class CustomTaskParameters(TaskParameters):
    """Parameters object for a text analysis task using custom models.

    All required parameters must be populated in order to send to Azure.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar project_name: Required.
    :vartype project_name: str
    :ivar deployment_name: Required.
    :vartype deployment_name: str
    """

    _validation = {
        'project_name': {'required': True},
        'deployment_name': {'required': True},
    }

    _attribute_map = {
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'project_name': {'key': 'projectName', 'type': 'str'},
        'deployment_name': {'key': 'deploymentName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        project_name: str,
        deployment_name: str,
        logging_opt_out: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword project_name: Required.
        :paramtype project_name: str
        :keyword deployment_name: Required.
        :paramtype deployment_name: str
        """
        super(CustomTaskParameters, self).__init__(logging_opt_out=logging_opt_out, **kwargs)
        self.project_name = project_name
        self.deployment_name = deployment_name


class CustomEntitiesTaskParameters(CustomTaskParameters):
    """Supported parameters for a Custom Entities task.

    All required parameters must be populated in order to send to Azure.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar project_name: Required.
    :vartype project_name: str
    :ivar deployment_name: Required.
    :vartype deployment_name: str
    :ivar string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
     "Utf16CodeUnit". Default value: "TextElements_v8".
    :vartype string_index_type: str or ~azure.ai.textanalytics.v2022_05_01.models.StringIndexType
    """

    _validation = {
        'project_name': {'required': True},
        'deployment_name': {'required': True},
    }

    _attribute_map = {
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'project_name': {'key': 'projectName', 'type': 'str'},
        'deployment_name': {'key': 'deploymentName', 'type': 'str'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        project_name: str,
        deployment_name: str,
        logging_opt_out: Optional[bool] = False,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = "TextElements_v8",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword project_name: Required.
        :paramtype project_name: str
        :keyword deployment_name: Required.
        :paramtype deployment_name: str
        :keyword string_index_type: Specifies the method used to interpret string offsets.  Defaults to
         Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
         https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
         "Utf16CodeUnit". Default value: "TextElements_v8".
        :paramtype string_index_type: str or ~azure.ai.textanalytics.v2022_05_01.models.StringIndexType
        """
        super(CustomEntitiesTaskParameters, self).__init__(logging_opt_out=logging_opt_out, project_name=project_name, deployment_name=deployment_name, **kwargs)
        self.string_index_type = string_index_type


class CustomEntityRecognitionLROResult(AnalyzeTextLROResult):
    """CustomEntityRecognitionLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded",
     "partiallyCompleted", "failed", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported Text Analysis long-running operation task
     results.Constant filled by server. Known values are: "SentimentAnalysisLROResults",
     "EntityRecognitionLROResults", "PiiEntityRecognitionLROResults",
     "KeyPhraseExtractionLROResults", "EntityLinkingLROResults", "HealthcareLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2022_05_01.models.CustomEntitiesResult
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'results': {'key': 'results', 'type': 'CustomEntitiesResult'},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.CustomEntitiesResult",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded",
         "partiallyCompleted", "failed", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
        :keyword task_name:
        :paramtype task_name: str
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2022_05_01.models.CustomEntitiesResult
        """
        super(CustomEntityRecognitionLROResult, self).__init__(last_update_date_time=last_update_date_time, status=status, task_name=task_name, **kwargs)
        self.kind = 'CustomEntityRecognitionLROResults'  # type: str
        self.results = results


class CustomLabelClassificationResult(CustomResult):
    """CustomLabelClassificationResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
    :ivar project_name: Required. This field indicates the project name for the model.
    :vartype project_name: str
    :ivar deployment_name: Required. This field indicates the deployment name for the model.
    :vartype deployment_name: str
    :ivar documents: Required. Response by document.
    :vartype documents:
     list[~azure.ai.textanalytics.v2022_05_01.models.CustomLabelClassificationResultDocumentsItem]
    """

    _validation = {
        'errors': {'required': True},
        'project_name': {'required': True},
        'deployment_name': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'project_name': {'key': 'projectName', 'type': 'str'},
        'deployment_name': {'key': 'deploymentName', 'type': 'str'},
        'documents': {'key': 'documents', 'type': '[CustomLabelClassificationResultDocumentsItem]'},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        project_name: str,
        deployment_name: str,
        documents: List["_models.CustomLabelClassificationResultDocumentsItem"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
        :keyword project_name: Required. This field indicates the project name for the model.
        :paramtype project_name: str
        :keyword deployment_name: Required. This field indicates the deployment name for the model.
        :paramtype deployment_name: str
        :keyword documents: Required. Response by document.
        :paramtype documents:
         list[~azure.ai.textanalytics.v2022_05_01.models.CustomLabelClassificationResultDocumentsItem]
        """
        super(CustomLabelClassificationResult, self).__init__(errors=errors, statistics=statistics, project_name=project_name, deployment_name=deployment_name, **kwargs)
        self.documents = documents


class CustomLabelClassificationResultDocumentsItem(ClassificationDocumentResult):
    """CustomLabelClassificationResultDocumentsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
    :ivar class_property: Required.
    :vartype class_property: list[~azure.ai.textanalytics.v2022_05_01.models.ClassificationResult]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'class_property': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'warnings': {'key': 'warnings', 'type': '[DocumentWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'class_property': {'key': 'class', 'type': '[ClassificationResult]'},
    }

    def __init__(
        self,
        *,
        id: str,
        warnings: List["_models.DocumentWarning"],
        class_property: List["_models.ClassificationResult"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
        :keyword class_property: Required.
        :paramtype class_property:
         list[~azure.ai.textanalytics.v2022_05_01.models.ClassificationResult]
        """
        super(CustomLabelClassificationResultDocumentsItem, self).__init__(id=id, warnings=warnings, statistics=statistics, class_property=class_property, **kwargs)


class CustomMultiLabelClassificationLROResult(AnalyzeTextLROResult):
    """CustomMultiLabelClassificationLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded",
     "partiallyCompleted", "failed", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported Text Analysis long-running operation task
     results.Constant filled by server. Known values are: "SentimentAnalysisLROResults",
     "EntityRecognitionLROResults", "PiiEntityRecognitionLROResults",
     "KeyPhraseExtractionLROResults", "EntityLinkingLROResults", "HealthcareLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2022_05_01.models.CustomLabelClassificationResult
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'results': {'key': 'results', 'type': 'CustomLabelClassificationResult'},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.CustomLabelClassificationResult",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded",
         "partiallyCompleted", "failed", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
        :keyword task_name:
        :paramtype task_name: str
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2022_05_01.models.CustomLabelClassificationResult
        """
        super(CustomMultiLabelClassificationLROResult, self).__init__(last_update_date_time=last_update_date_time, status=status, task_name=task_name, **kwargs)
        self.kind = 'CustomMultiLabelClassificationLROResults'  # type: str
        self.results = results


class CustomMultiLabelClassificationLROTask(AnalyzeTextLROTask):
    """Use custom models to classify text into multi label taxonomy.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported long-running Text Analysis tasks.Constant filled
     by server. Known values are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition",
     "KeyPhraseExtraction", "EntityLinking", "Healthcare", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for a Custom Multi Classification task.
    :vartype parameters:
     ~azure.ai.textanalytics.v2022_05_01.models.CustomMultiLabelClassificationTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'CustomMultiLabelClassificationTaskParameters'},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        parameters: Optional["_models.CustomMultiLabelClassificationTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for a Custom Multi Classification task.
        :paramtype parameters:
         ~azure.ai.textanalytics.v2022_05_01.models.CustomMultiLabelClassificationTaskParameters
        """
        super(CustomMultiLabelClassificationLROTask, self).__init__(task_name=task_name, **kwargs)
        self.kind = 'CustomMultiLabelClassification'  # type: str
        self.parameters = parameters


class CustomMultiLabelClassificationTaskParameters(CustomTaskParameters):
    """Supported parameters for a Custom Multi Classification task.

    All required parameters must be populated in order to send to Azure.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar project_name: Required.
    :vartype project_name: str
    :ivar deployment_name: Required.
    :vartype deployment_name: str
    """

    _validation = {
        'project_name': {'required': True},
        'deployment_name': {'required': True},
    }

    _attribute_map = {
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'project_name': {'key': 'projectName', 'type': 'str'},
        'deployment_name': {'key': 'deploymentName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        project_name: str,
        deployment_name: str,
        logging_opt_out: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword project_name: Required.
        :paramtype project_name: str
        :keyword deployment_name: Required.
        :paramtype deployment_name: str
        """
        super(CustomMultiLabelClassificationTaskParameters, self).__init__(logging_opt_out=logging_opt_out, project_name=project_name, deployment_name=deployment_name, **kwargs)


class CustomSingleLabelClassificationLROResult(AnalyzeTextLROResult):
    """CustomSingleLabelClassificationLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded",
     "partiallyCompleted", "failed", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported Text Analysis long-running operation task
     results.Constant filled by server. Known values are: "SentimentAnalysisLROResults",
     "EntityRecognitionLROResults", "PiiEntityRecognitionLROResults",
     "KeyPhraseExtractionLROResults", "EntityLinkingLROResults", "HealthcareLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2022_05_01.models.CustomLabelClassificationResult
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'results': {'key': 'results', 'type': 'CustomLabelClassificationResult'},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.CustomLabelClassificationResult",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded",
         "partiallyCompleted", "failed", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
        :keyword task_name:
        :paramtype task_name: str
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2022_05_01.models.CustomLabelClassificationResult
        """
        super(CustomSingleLabelClassificationLROResult, self).__init__(last_update_date_time=last_update_date_time, status=status, task_name=task_name, **kwargs)
        self.kind = 'CustomSingleLabelClassificationLROResults'  # type: str
        self.results = results


class CustomSingleLabelClassificationLROTask(AnalyzeTextLROTask):
    """Use custom models to classify text into single label taxonomy.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported long-running Text Analysis tasks.Constant filled
     by server. Known values are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition",
     "KeyPhraseExtraction", "EntityLinking", "Healthcare", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for a Custom Single Classification task.
    :vartype parameters:
     ~azure.ai.textanalytics.v2022_05_01.models.CustomSingleLabelClassificationTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'CustomSingleLabelClassificationTaskParameters'},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        parameters: Optional["_models.CustomSingleLabelClassificationTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for a Custom Single Classification task.
        :paramtype parameters:
         ~azure.ai.textanalytics.v2022_05_01.models.CustomSingleLabelClassificationTaskParameters
        """
        super(CustomSingleLabelClassificationLROTask, self).__init__(task_name=task_name, **kwargs)
        self.kind = 'CustomSingleLabelClassification'  # type: str
        self.parameters = parameters


class CustomSingleLabelClassificationTaskParameters(CustomTaskParameters):
    """Supported parameters for a Custom Single Classification task.

    All required parameters must be populated in order to send to Azure.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar project_name: Required.
    :vartype project_name: str
    :ivar deployment_name: Required.
    :vartype deployment_name: str
    """

    _validation = {
        'project_name': {'required': True},
        'deployment_name': {'required': True},
    }

    _attribute_map = {
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'project_name': {'key': 'projectName', 'type': 'str'},
        'deployment_name': {'key': 'deploymentName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        project_name: str,
        deployment_name: str,
        logging_opt_out: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword project_name: Required.
        :paramtype project_name: str
        :keyword deployment_name: Required.
        :paramtype deployment_name: str
        """
        super(CustomSingleLabelClassificationTaskParameters, self).__init__(logging_opt_out=logging_opt_out, project_name=project_name, deployment_name=deployment_name, **kwargs)


class DetectedLanguage(msrest.serialization.Model):
    """DetectedLanguage.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Long name of a detected language (e.g. English, French).
    :vartype name: str
    :ivar iso6391_name: Required. A two letter representation of the detected language according to
     the ISO 639-1 standard (e.g. en, fr).
    :vartype iso6391_name: str
    :ivar confidence_score: Required. A confidence score between 0 and 1. Scores close to 1
     indicate 100% certainty that the identified language is true.
    :vartype confidence_score: float
    """

    _validation = {
        'name': {'required': True},
        'iso6391_name': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'iso6391_name': {'key': 'iso6391Name', 'type': 'str'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        name: str,
        iso6391_name: str,
        confidence_score: float,
        **kwargs
    ):
        """
        :keyword name: Required. Long name of a detected language (e.g. English, French).
        :paramtype name: str
        :keyword iso6391_name: Required. A two letter representation of the detected language according
         to the ISO 639-1 standard (e.g. en, fr).
        :paramtype iso6391_name: str
        :keyword confidence_score: Required. A confidence score between 0 and 1. Scores close to 1
         indicate 100% certainty that the identified language is true.
        :paramtype confidence_score: float
        """
        super(DetectedLanguage, self).__init__(**kwargs)
        self.name = name
        self.iso6391_name = iso6391_name
        self.confidence_score = confidence_score


class DocumentError(msrest.serialization.Model):
    """DocumentError.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Document Id.
    :vartype id: str
    :ivar error: Required. Document Error.
    :vartype error: ~azure.ai.textanalytics.v2022_05_01.models.Error
    """

    _validation = {
        'id': {'required': True},
        'error': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
    }

    def __init__(
        self,
        *,
        id: str,
        error: "_models.Error",
        **kwargs
    ):
        """
        :keyword id: Required. Document Id.
        :paramtype id: str
        :keyword error: Required. Document Error.
        :paramtype error: ~azure.ai.textanalytics.v2022_05_01.models.Error
        """
        super(DocumentError, self).__init__(**kwargs)
        self.id = id
        self.error = error


class DocumentStatistics(msrest.serialization.Model):
    """if showStats=true was specified in the request this field will contain information about the document payload.

    All required parameters must be populated in order to send to Azure.

    :ivar characters_count: Required. Number of text elements recognized in the document.
    :vartype characters_count: int
    :ivar transactions_count: Required. Number of transactions for the document.
    :vartype transactions_count: int
    """

    _validation = {
        'characters_count': {'required': True},
        'transactions_count': {'required': True},
    }

    _attribute_map = {
        'characters_count': {'key': 'charactersCount', 'type': 'int'},
        'transactions_count': {'key': 'transactionsCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        characters_count: int,
        transactions_count: int,
        **kwargs
    ):
        """
        :keyword characters_count: Required. Number of text elements recognized in the document.
        :paramtype characters_count: int
        :keyword transactions_count: Required. Number of transactions for the document.
        :paramtype transactions_count: int
        """
        super(DocumentStatistics, self).__init__(**kwargs)
        self.characters_count = characters_count
        self.transactions_count = transactions_count


class DocumentWarning(msrest.serialization.Model):
    """DocumentWarning.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. Error code. Known values are: "LongWordsInDocument", "DocumentTruncated".
    :vartype code: str or ~azure.ai.textanalytics.v2022_05_01.models.WarningCodeValue
    :ivar message: Required. Warning message.
    :vartype message: str
    :ivar target_ref: A JSON pointer reference indicating the target object.
    :vartype target_ref: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target_ref': {'key': 'targetRef', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Union[str, "_models.WarningCodeValue"],
        message: str,
        target_ref: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Required. Error code. Known values are: "LongWordsInDocument",
         "DocumentTruncated".
        :paramtype code: str or ~azure.ai.textanalytics.v2022_05_01.models.WarningCodeValue
        :keyword message: Required. Warning message.
        :paramtype message: str
        :keyword target_ref: A JSON pointer reference indicating the target object.
        :paramtype target_ref: str
        """
        super(DocumentWarning, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target_ref = target_ref


class EntitiesLROTask(AnalyzeTextLROTask):
    """An object representing the task definition for an Entities Recognition task.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported long-running Text Analysis tasks.Constant filled
     by server. Known values are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition",
     "KeyPhraseExtraction", "EntityLinking", "Healthcare", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for an Entity Recognition task.
    :vartype parameters: ~azure.ai.textanalytics.v2022_05_01.models.EntitiesTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'EntitiesTaskParameters'},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        parameters: Optional["_models.EntitiesTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for an Entity Recognition task.
        :paramtype parameters: ~azure.ai.textanalytics.v2022_05_01.models.EntitiesTaskParameters
        """
        super(EntitiesLROTask, self).__init__(task_name=task_name, **kwargs)
        self.kind = 'EntityRecognition'  # type: str
        self.parameters = parameters


class PreBuiltResult(msrest.serialization.Model):
    """PreBuiltResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    """

    _validation = {
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        model_version: str,
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        """
        super(PreBuiltResult, self).__init__(**kwargs)
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class EntitiesResult(PreBuiltResult):
    """EntitiesResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    :ivar documents: Required. Response by document.
    :vartype documents:
     list[~azure.ai.textanalytics.v2022_05_01.models.EntitiesResultDocumentsItem]
    """

    _validation = {
        'errors': {'required': True},
        'model_version': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
        'documents': {'key': 'documents', 'type': '[EntitiesResultDocumentsItem]'},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        model_version: str,
        documents: List["_models.EntitiesResultDocumentsItem"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        :keyword documents: Required. Response by document.
        :paramtype documents:
         list[~azure.ai.textanalytics.v2022_05_01.models.EntitiesResultDocumentsItem]
        """
        super(EntitiesResult, self).__init__(errors=errors, statistics=statistics, model_version=model_version, **kwargs)
        self.documents = documents


class EntitiesResultDocumentsItem(EntitiesDocumentResult):
    """EntitiesResultDocumentsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
    :ivar entities: Required. Recognized entities in the document.
    :vartype entities: list[~azure.ai.textanalytics.v2022_05_01.models.Entity]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'warnings': {'key': 'warnings', 'type': '[DocumentWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'entities': {'key': 'entities', 'type': '[Entity]'},
    }

    def __init__(
        self,
        *,
        id: str,
        warnings: List["_models.DocumentWarning"],
        entities: List["_models.Entity"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
        :keyword entities: Required. Recognized entities in the document.
        :paramtype entities: list[~azure.ai.textanalytics.v2022_05_01.models.Entity]
        """
        super(EntitiesResultDocumentsItem, self).__init__(id=id, warnings=warnings, statistics=statistics, entities=entities, **kwargs)


class PreBuiltTaskParameters(TaskParameters):
    """Parameters object for a text analysis task using pre-built models.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar model_version:
    :vartype model_version: str
    """

    _attribute_map = {
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        logging_opt_out: Optional[bool] = False,
        model_version: Optional[str] = "latest",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword model_version:
        :paramtype model_version: str
        """
        super(PreBuiltTaskParameters, self).__init__(logging_opt_out=logging_opt_out, **kwargs)
        self.model_version = model_version


class EntitiesTaskParameters(PreBuiltTaskParameters):
    """Supported parameters for an Entity Recognition task.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar model_version:
    :vartype model_version: str
    :ivar string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
     "Utf16CodeUnit". Default value: "TextElements_v8".
    :vartype string_index_type: str or ~azure.ai.textanalytics.v2022_05_01.models.StringIndexType
    """

    _attribute_map = {
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        logging_opt_out: Optional[bool] = False,
        model_version: Optional[str] = "latest",
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = "TextElements_v8",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword model_version:
        :paramtype model_version: str
        :keyword string_index_type: Specifies the method used to interpret string offsets.  Defaults to
         Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
         https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
         "Utf16CodeUnit". Default value: "TextElements_v8".
        :paramtype string_index_type: str or ~azure.ai.textanalytics.v2022_05_01.models.StringIndexType
        """
        super(EntitiesTaskParameters, self).__init__(logging_opt_out=logging_opt_out, model_version=model_version, **kwargs)
        self.string_index_type = string_index_type


class EntitiesTaskResult(AnalyzeTextTaskResult):
    """EntitiesTaskResult.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Enumeration of supported Text Analysis task results.Constant filled by
     server. Known values are: "SentimentAnalysisResults", "EntityRecognitionResults",
     "PiiEntityRecognitionResults", "KeyPhraseExtractionResults", "LanguageDetectionResults",
     "EntityLinkingResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextTaskResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2022_05_01.models.EntitiesResult
    """

    _validation = {
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'results': {'key': 'results', 'type': 'EntitiesResult'},
    }

    def __init__(
        self,
        *,
        results: "_models.EntitiesResult",
        **kwargs
    ):
        """
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2022_05_01.models.EntitiesResult
        """
        super(EntitiesTaskResult, self).__init__(**kwargs)
        self.kind = 'EntityRecognitionResults'  # type: str
        self.results = results


class Entity(msrest.serialization.Model):
    """Entity.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Required. Entity text as appears in the request.
    :vartype text: str
    :ivar category: Required. Entity type.
    :vartype category: str
    :ivar subcategory: (Optional) Entity sub type.
    :vartype subcategory: str
    :ivar offset: Required. Start position for the entity text. Use of different 'stringIndexType'
     values can affect the offset returned.
    :vartype offset: int
    :ivar length: Required. Length for the entity text. Use of different 'stringIndexType' values
     can affect the length returned.
    :vartype length: int
    :ivar confidence_score: Required. Confidence score between 0 and 1 of the extracted entity.
    :vartype confidence_score: float
    """

    _validation = {
        'text': {'required': True},
        'category': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'subcategory': {'key': 'subcategory', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        text: str,
        category: str,
        offset: int,
        length: int,
        confidence_score: float,
        subcategory: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword text: Required. Entity text as appears in the request.
        :paramtype text: str
        :keyword category: Required. Entity type.
        :paramtype category: str
        :keyword subcategory: (Optional) Entity sub type.
        :paramtype subcategory: str
        :keyword offset: Required. Start position for the entity text. Use of different
         'stringIndexType' values can affect the offset returned.
        :paramtype offset: int
        :keyword length: Required. Length for the entity text. Use of different 'stringIndexType'
         values can affect the length returned.
        :paramtype length: int
        :keyword confidence_score: Required. Confidence score between 0 and 1 of the extracted entity.
        :paramtype confidence_score: float
        """
        super(Entity, self).__init__(**kwargs)
        self.text = text
        self.category = category
        self.subcategory = subcategory
        self.offset = offset
        self.length = length
        self.confidence_score = confidence_score


class EntityLinkingLROResult(AnalyzeTextLROResult):
    """EntityLinkingLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded",
     "partiallyCompleted", "failed", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported Text Analysis long-running operation task
     results.Constant filled by server. Known values are: "SentimentAnalysisLROResults",
     "EntityRecognitionLROResults", "PiiEntityRecognitionLROResults",
     "KeyPhraseExtractionLROResults", "EntityLinkingLROResults", "HealthcareLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2022_05_01.models.EntityLinkingResult
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'results': {'key': 'results', 'type': 'EntityLinkingResult'},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.EntityLinkingResult",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded",
         "partiallyCompleted", "failed", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
        :keyword task_name:
        :paramtype task_name: str
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2022_05_01.models.EntityLinkingResult
        """
        super(EntityLinkingLROResult, self).__init__(last_update_date_time=last_update_date_time, status=status, task_name=task_name, **kwargs)
        self.kind = 'EntityLinkingLROResults'  # type: str
        self.results = results


class EntityLinkingLROTask(AnalyzeTextLROTask):
    """An object representing the task definition for an Entity Linking task.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported long-running Text Analysis tasks.Constant filled
     by server. Known values are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition",
     "KeyPhraseExtraction", "EntityLinking", "Healthcare", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for an Entity Linking task.
    :vartype parameters: ~azure.ai.textanalytics.v2022_05_01.models.EntityLinkingTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'EntityLinkingTaskParameters'},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        parameters: Optional["_models.EntityLinkingTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for an Entity Linking task.
        :paramtype parameters: ~azure.ai.textanalytics.v2022_05_01.models.EntityLinkingTaskParameters
        """
        super(EntityLinkingLROTask, self).__init__(task_name=task_name, **kwargs)
        self.kind = 'EntityLinking'  # type: str
        self.parameters = parameters


class EntityLinkingResult(PreBuiltResult):
    """EntityLinkingResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    :ivar documents: Required. Response by document.
    :vartype documents:
     list[~azure.ai.textanalytics.v2022_05_01.models.EntityLinkingResultDocumentsItem]
    """

    _validation = {
        'errors': {'required': True},
        'model_version': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
        'documents': {'key': 'documents', 'type': '[EntityLinkingResultDocumentsItem]'},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        model_version: str,
        documents: List["_models.EntityLinkingResultDocumentsItem"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        :keyword documents: Required. Response by document.
        :paramtype documents:
         list[~azure.ai.textanalytics.v2022_05_01.models.EntityLinkingResultDocumentsItem]
        """
        super(EntityLinkingResult, self).__init__(errors=errors, statistics=statistics, model_version=model_version, **kwargs)
        self.documents = documents


class LinkedEntitiesDocumentResult(DocumentResult):
    """LinkedEntitiesDocumentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
    :ivar entities: Required. Recognized well known entities in the document.
    :vartype entities: list[~azure.ai.textanalytics.v2022_05_01.models.LinkedEntity]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'warnings': {'key': 'warnings', 'type': '[DocumentWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'entities': {'key': 'entities', 'type': '[LinkedEntity]'},
    }

    def __init__(
        self,
        *,
        id: str,
        warnings: List["_models.DocumentWarning"],
        entities: List["_models.LinkedEntity"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
        :keyword entities: Required. Recognized well known entities in the document.
        :paramtype entities: list[~azure.ai.textanalytics.v2022_05_01.models.LinkedEntity]
        """
        super(LinkedEntitiesDocumentResult, self).__init__(id=id, warnings=warnings, statistics=statistics, **kwargs)
        self.entities = entities


class EntityLinkingResultDocumentsItem(LinkedEntitiesDocumentResult):
    """EntityLinkingResultDocumentsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
    :ivar entities: Required. Recognized well known entities in the document.
    :vartype entities: list[~azure.ai.textanalytics.v2022_05_01.models.LinkedEntity]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'warnings': {'key': 'warnings', 'type': '[DocumentWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'entities': {'key': 'entities', 'type': '[LinkedEntity]'},
    }

    def __init__(
        self,
        *,
        id: str,
        warnings: List["_models.DocumentWarning"],
        entities: List["_models.LinkedEntity"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
        :keyword entities: Required. Recognized well known entities in the document.
        :paramtype entities: list[~azure.ai.textanalytics.v2022_05_01.models.LinkedEntity]
        """
        super(EntityLinkingResultDocumentsItem, self).__init__(id=id, warnings=warnings, statistics=statistics, entities=entities, **kwargs)


class EntityLinkingTaskParameters(PreBuiltTaskParameters):
    """Supported parameters for an Entity Linking task.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar model_version:
    :vartype model_version: str
    :ivar string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
     "Utf16CodeUnit". Default value: "TextElements_v8".
    :vartype string_index_type: str or ~azure.ai.textanalytics.v2022_05_01.models.StringIndexType
    """

    _attribute_map = {
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        logging_opt_out: Optional[bool] = False,
        model_version: Optional[str] = "latest",
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = "TextElements_v8",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword model_version:
        :paramtype model_version: str
        :keyword string_index_type: Specifies the method used to interpret string offsets.  Defaults to
         Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
         https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
         "Utf16CodeUnit". Default value: "TextElements_v8".
        :paramtype string_index_type: str or ~azure.ai.textanalytics.v2022_05_01.models.StringIndexType
        """
        super(EntityLinkingTaskParameters, self).__init__(logging_opt_out=logging_opt_out, model_version=model_version, **kwargs)
        self.string_index_type = string_index_type


class EntityLinkingTaskResult(AnalyzeTextTaskResult):
    """EntityLinkingTaskResult.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Enumeration of supported Text Analysis task results.Constant filled by
     server. Known values are: "SentimentAnalysisResults", "EntityRecognitionResults",
     "PiiEntityRecognitionResults", "KeyPhraseExtractionResults", "LanguageDetectionResults",
     "EntityLinkingResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextTaskResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2022_05_01.models.EntityLinkingResult
    """

    _validation = {
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'results': {'key': 'results', 'type': 'EntityLinkingResult'},
    }

    def __init__(
        self,
        *,
        results: "_models.EntityLinkingResult",
        **kwargs
    ):
        """
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2022_05_01.models.EntityLinkingResult
        """
        super(EntityLinkingTaskResult, self).__init__(**kwargs)
        self.kind = 'EntityLinkingResults'  # type: str
        self.results = results


class EntityRecognitionLROResult(AnalyzeTextLROResult):
    """EntityRecognitionLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded",
     "partiallyCompleted", "failed", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported Text Analysis long-running operation task
     results.Constant filled by server. Known values are: "SentimentAnalysisLROResults",
     "EntityRecognitionLROResults", "PiiEntityRecognitionLROResults",
     "KeyPhraseExtractionLROResults", "EntityLinkingLROResults", "HealthcareLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2022_05_01.models.EntitiesResult
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'results': {'key': 'results', 'type': 'EntitiesResult'},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.EntitiesResult",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded",
         "partiallyCompleted", "failed", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
        :keyword task_name:
        :paramtype task_name: str
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2022_05_01.models.EntitiesResult
        """
        super(EntityRecognitionLROResult, self).__init__(last_update_date_time=last_update_date_time, status=status, task_name=task_name, **kwargs)
        self.kind = 'EntityRecognitionLROResults'  # type: str
        self.results = results


class Error(msrest.serialization.Model):
    """The error object.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar code: Required. One of a server-defined set of error codes. Known values are:
     "InvalidRequest", "InvalidArgument", "Unauthorized", "Forbidden", "NotFound",
     "ProjectNotFound", "OperationNotFound", "AzureCognitiveSearchNotFound",
     "AzureCognitiveSearchIndexNotFound", "TooManyRequests", "AzureCognitiveSearchThrottling",
     "AzureCognitiveSearchIndexLimitReached", "InternalServerError", "ServiceUnavailable",
     "Timeout", "QuotaExceeded", "Conflict", "Warning".
    :vartype code: str or ~azure.ai.textanalytics.v2022_05_01.models.ErrorCode
    :ivar message: Required. A human-readable representation of the error.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~azure.ai.textanalytics.v2022_05_01.models.Error]
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.ai.textanalytics.v2022_05_01.models.InnerErrorModel
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[Error]'},
        'innererror': {'key': 'innererror', 'type': 'InnerErrorModel'},
    }

    def __init__(
        self,
        *,
        code: Union[str, "_models.ErrorCode"],
        message: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.Error"]] = None,
        innererror: Optional["_models.InnerErrorModel"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword code: Required. One of a server-defined set of error codes. Known values are:
         "InvalidRequest", "InvalidArgument", "Unauthorized", "Forbidden", "NotFound",
         "ProjectNotFound", "OperationNotFound", "AzureCognitiveSearchNotFound",
         "AzureCognitiveSearchIndexNotFound", "TooManyRequests", "AzureCognitiveSearchThrottling",
         "AzureCognitiveSearchIndexLimitReached", "InternalServerError", "ServiceUnavailable",
         "Timeout", "QuotaExceeded", "Conflict", "Warning".
        :paramtype code: str or ~azure.ai.textanalytics.v2022_05_01.models.ErrorCode
        :keyword message: Required. A human-readable representation of the error.
        :paramtype message: str
        :keyword target: The target of the error.
        :paramtype target: str
        :keyword details: An array of details about specific errors that led to this reported error.
        :paramtype details: list[~azure.ai.textanalytics.v2022_05_01.models.Error]
        :keyword innererror: An object containing more specific information than the current object
         about the error.
        :paramtype innererror: ~azure.ai.textanalytics.v2022_05_01.models.InnerErrorModel
        """
        super(Error, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.innererror = innererror


class ErrorResponse(msrest.serialization.Model):
    """Error response.

    All required parameters must be populated in order to send to Azure.

    :ivar error: Required. The error object.
    :vartype error: ~azure.ai.textanalytics.v2022_05_01.models.Error
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'Error'},
    }

    def __init__(
        self,
        *,
        error: "_models.Error",
        **kwargs
    ):
        """
        :keyword error: Required. The error object.
        :paramtype error: ~azure.ai.textanalytics.v2022_05_01.models.Error
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class HealthcareAssertion(msrest.serialization.Model):
    """HealthcareAssertion.

    :ivar conditionality: Describes any conditionality on the entity. Known values are:
     "hypothetical", "conditional".
    :vartype conditionality: str or ~azure.ai.textanalytics.v2022_05_01.models.Conditionality
    :ivar certainty: Describes the entities certainty and polarity. Known values are: "positive",
     "positivePossible", "neutralPossible", "negativePossible", "negative".
    :vartype certainty: str or ~azure.ai.textanalytics.v2022_05_01.models.Certainty
    :ivar association: Describes if the entity is the subject of the text or if it describes
     someone else. Known values are: "subject", "other".
    :vartype association: str or ~azure.ai.textanalytics.v2022_05_01.models.Association
    """

    _attribute_map = {
        'conditionality': {'key': 'conditionality', 'type': 'str'},
        'certainty': {'key': 'certainty', 'type': 'str'},
        'association': {'key': 'association', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        conditionality: Optional[Union[str, "_models.Conditionality"]] = None,
        certainty: Optional[Union[str, "_models.Certainty"]] = None,
        association: Optional[Union[str, "_models.Association"]] = None,
        **kwargs
    ):
        """
        :keyword conditionality: Describes any conditionality on the entity. Known values are:
         "hypothetical", "conditional".
        :paramtype conditionality: str or ~azure.ai.textanalytics.v2022_05_01.models.Conditionality
        :keyword certainty: Describes the entities certainty and polarity. Known values are:
         "positive", "positivePossible", "neutralPossible", "negativePossible", "negative".
        :paramtype certainty: str or ~azure.ai.textanalytics.v2022_05_01.models.Certainty
        :keyword association: Describes if the entity is the subject of the text or if it describes
         someone else. Known values are: "subject", "other".
        :paramtype association: str or ~azure.ai.textanalytics.v2022_05_01.models.Association
        """
        super(HealthcareAssertion, self).__init__(**kwargs)
        self.conditionality = conditionality
        self.certainty = certainty
        self.association = association


class HealthcareEntitiesDocumentResult(DocumentResult):
    """HealthcareEntitiesDocumentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
    :ivar entities: Required. Healthcare entities.
    :vartype entities: list[~azure.ai.textanalytics.v2022_05_01.models.HealthcareEntity]
    :ivar relations: Required. Healthcare entity relations.
    :vartype relations: list[~azure.ai.textanalytics.v2022_05_01.models.HealthcareRelation]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'entities': {'required': True},
        'relations': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'warnings': {'key': 'warnings', 'type': '[DocumentWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'entities': {'key': 'entities', 'type': '[HealthcareEntity]'},
        'relations': {'key': 'relations', 'type': '[HealthcareRelation]'},
    }

    def __init__(
        self,
        *,
        id: str,
        warnings: List["_models.DocumentWarning"],
        entities: List["_models.HealthcareEntity"],
        relations: List["_models.HealthcareRelation"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
        :keyword entities: Required. Healthcare entities.
        :paramtype entities: list[~azure.ai.textanalytics.v2022_05_01.models.HealthcareEntity]
        :keyword relations: Required. Healthcare entity relations.
        :paramtype relations: list[~azure.ai.textanalytics.v2022_05_01.models.HealthcareRelation]
        """
        super(HealthcareEntitiesDocumentResult, self).__init__(id=id, warnings=warnings, statistics=statistics, **kwargs)
        self.entities = entities
        self.relations = relations


class HealthcareEntity(msrest.serialization.Model):
    """HealthcareEntity.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Required. Entity text as appears in the request.
    :vartype text: str
    :ivar category: Required. Healthcare Entity Category. Known values are: "BODY_STRUCTURE",
     "AGE", "GENDER", "EXAMINATION_NAME", "DATE", "DIRECTION", "FREQUENCY", "MEASUREMENT_VALUE",
     "MEASUREMENT_UNIT", "RELATIONAL_OPERATOR", "TIME", "GENE_OR_PROTEIN", "VARIANT",
     "ADMINISTRATIVE_EVENT", "CARE_ENVIRONMENT", "HEALTHCARE_PROFESSION", "DIAGNOSIS",
     "SYMPTOM_OR_SIGN", "CONDITION_QUALIFIER", "MEDICATION_CLASS", "MEDICATION_NAME", "DOSAGE",
     "MEDICATION_FORM", "MEDICATION_ROUTE", "FAMILY_RELATION", "TREATMENT_NAME".
    :vartype category: str or ~azure.ai.textanalytics.v2022_05_01.models.HealthcareEntityCategory
    :ivar subcategory: (Optional) Entity sub type.
    :vartype subcategory: str
    :ivar offset: Required. Start position for the entity text. Use of different 'stringIndexType'
     values can affect the offset returned.
    :vartype offset: int
    :ivar length: Required. Length for the entity text. Use of different 'stringIndexType' values
     can affect the length returned.
    :vartype length: int
    :ivar confidence_score: Required. Confidence score between 0 and 1 of the extracted entity.
    :vartype confidence_score: float
    :ivar assertion:
    :vartype assertion: ~azure.ai.textanalytics.v2022_05_01.models.HealthcareAssertion
    :ivar name: Preferred name for the entity. Example: 'histologically' would have a 'name' of
     'histologic'.
    :vartype name: str
    :ivar links: Entity references in known data sources.
    :vartype links: list[~azure.ai.textanalytics.v2022_05_01.models.HealthcareEntityLink]
    """

    _validation = {
        'text': {'required': True},
        'category': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'subcategory': {'key': 'subcategory', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
        'assertion': {'key': 'assertion', 'type': 'HealthcareAssertion'},
        'name': {'key': 'name', 'type': 'str'},
        'links': {'key': 'links', 'type': '[HealthcareEntityLink]'},
    }

    def __init__(
        self,
        *,
        text: str,
        category: Union[str, "_models.HealthcareEntityCategory"],
        offset: int,
        length: int,
        confidence_score: float,
        subcategory: Optional[str] = None,
        assertion: Optional["_models.HealthcareAssertion"] = None,
        name: Optional[str] = None,
        links: Optional[List["_models.HealthcareEntityLink"]] = None,
        **kwargs
    ):
        """
        :keyword text: Required. Entity text as appears in the request.
        :paramtype text: str
        :keyword category: Required. Healthcare Entity Category. Known values are: "BODY_STRUCTURE",
         "AGE", "GENDER", "EXAMINATION_NAME", "DATE", "DIRECTION", "FREQUENCY", "MEASUREMENT_VALUE",
         "MEASUREMENT_UNIT", "RELATIONAL_OPERATOR", "TIME", "GENE_OR_PROTEIN", "VARIANT",
         "ADMINISTRATIVE_EVENT", "CARE_ENVIRONMENT", "HEALTHCARE_PROFESSION", "DIAGNOSIS",
         "SYMPTOM_OR_SIGN", "CONDITION_QUALIFIER", "MEDICATION_CLASS", "MEDICATION_NAME", "DOSAGE",
         "MEDICATION_FORM", "MEDICATION_ROUTE", "FAMILY_RELATION", "TREATMENT_NAME".
        :paramtype category: str or ~azure.ai.textanalytics.v2022_05_01.models.HealthcareEntityCategory
        :keyword subcategory: (Optional) Entity sub type.
        :paramtype subcategory: str
        :keyword offset: Required. Start position for the entity text. Use of different
         'stringIndexType' values can affect the offset returned.
        :paramtype offset: int
        :keyword length: Required. Length for the entity text. Use of different 'stringIndexType'
         values can affect the length returned.
        :paramtype length: int
        :keyword confidence_score: Required. Confidence score between 0 and 1 of the extracted entity.
        :paramtype confidence_score: float
        :keyword assertion:
        :paramtype assertion: ~azure.ai.textanalytics.v2022_05_01.models.HealthcareAssertion
        :keyword name: Preferred name for the entity. Example: 'histologically' would have a 'name' of
         'histologic'.
        :paramtype name: str
        :keyword links: Entity references in known data sources.
        :paramtype links: list[~azure.ai.textanalytics.v2022_05_01.models.HealthcareEntityLink]
        """
        super(HealthcareEntity, self).__init__(**kwargs)
        self.text = text
        self.category = category
        self.subcategory = subcategory
        self.offset = offset
        self.length = length
        self.confidence_score = confidence_score
        self.assertion = assertion
        self.name = name
        self.links = links


class HealthcareEntityLink(msrest.serialization.Model):
    """HealthcareEntityLink.

    All required parameters must be populated in order to send to Azure.

    :ivar data_source: Required. Entity Catalog. Examples include: UMLS, CHV, MSH, etc.
    :vartype data_source: str
    :ivar id: Required. Entity id in the given source catalog.
    :vartype id: str
    """

    _validation = {
        'data_source': {'required': True},
        'id': {'required': True},
    }

    _attribute_map = {
        'data_source': {'key': 'dataSource', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_source: str,
        id: str,
        **kwargs
    ):
        """
        :keyword data_source: Required. Entity Catalog. Examples include: UMLS, CHV, MSH, etc.
        :paramtype data_source: str
        :keyword id: Required. Entity id in the given source catalog.
        :paramtype id: str
        """
        super(HealthcareEntityLink, self).__init__(**kwargs)
        self.data_source = data_source
        self.id = id


class HealthcareLROResult(AnalyzeTextLROResult):
    """HealthcareLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded",
     "partiallyCompleted", "failed", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported Text Analysis long-running operation task
     results.Constant filled by server. Known values are: "SentimentAnalysisLROResults",
     "EntityRecognitionLROResults", "PiiEntityRecognitionLROResults",
     "KeyPhraseExtractionLROResults", "EntityLinkingLROResults", "HealthcareLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2022_05_01.models.HealthcareResult
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'results': {'key': 'results', 'type': 'HealthcareResult'},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.HealthcareResult",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded",
         "partiallyCompleted", "failed", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
        :keyword task_name:
        :paramtype task_name: str
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2022_05_01.models.HealthcareResult
        """
        super(HealthcareLROResult, self).__init__(last_update_date_time=last_update_date_time, status=status, task_name=task_name, **kwargs)
        self.kind = 'HealthcareLROResults'  # type: str
        self.results = results


class HealthcareLROTask(AnalyzeTextLROTask):
    """HealthcareLROTask.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported long-running Text Analysis tasks.Constant filled
     by server. Known values are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition",
     "KeyPhraseExtraction", "EntityLinking", "Healthcare", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for a Healthcare task.
    :vartype parameters: ~azure.ai.textanalytics.v2022_05_01.models.HealthcareTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'HealthcareTaskParameters'},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        parameters: Optional["_models.HealthcareTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for a Healthcare task.
        :paramtype parameters: ~azure.ai.textanalytics.v2022_05_01.models.HealthcareTaskParameters
        """
        super(HealthcareLROTask, self).__init__(task_name=task_name, **kwargs)
        self.kind = 'Healthcare'  # type: str
        self.parameters = parameters


class HealthcareRelation(msrest.serialization.Model):
    """Every relation is an entity graph of a certain relationType, where all entities are connected and have specific roles within the relation context.

    All required parameters must be populated in order to send to Azure.

    :ivar relation_type: Required. Type of relation. Examples include: ``DosageOfMedication`` or
     'FrequencyOfMedication', etc. Known values are: "Abbreviation", "DirectionOfBodyStructure",
     "DirectionOfCondition", "DirectionOfExamination", "DirectionOfTreatment", "DosageOfMedication",
     "FormOfMedication", "FrequencyOfMedication", "FrequencyOfTreatment", "QualifierOfCondition",
     "RelationOfExamination", "RouteOfMedication", "TimeOfCondition", "TimeOfEvent",
     "TimeOfExamination", "TimeOfMedication", "TimeOfTreatment", "UnitOfCondition",
     "UnitOfExamination", "ValueOfCondition", "ValueOfExamination".
    :vartype relation_type: str or ~azure.ai.textanalytics.v2022_05_01.models.RelationType
    :ivar entities: Required. The entities in the relation.
    :vartype entities: list[~azure.ai.textanalytics.v2022_05_01.models.HealthcareRelationEntity]
    """

    _validation = {
        'relation_type': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        'relation_type': {'key': 'relationType', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[HealthcareRelationEntity]'},
    }

    def __init__(
        self,
        *,
        relation_type: Union[str, "_models.RelationType"],
        entities: List["_models.HealthcareRelationEntity"],
        **kwargs
    ):
        """
        :keyword relation_type: Required. Type of relation. Examples include: ``DosageOfMedication`` or
         'FrequencyOfMedication', etc. Known values are: "Abbreviation", "DirectionOfBodyStructure",
         "DirectionOfCondition", "DirectionOfExamination", "DirectionOfTreatment", "DosageOfMedication",
         "FormOfMedication", "FrequencyOfMedication", "FrequencyOfTreatment", "QualifierOfCondition",
         "RelationOfExamination", "RouteOfMedication", "TimeOfCondition", "TimeOfEvent",
         "TimeOfExamination", "TimeOfMedication", "TimeOfTreatment", "UnitOfCondition",
         "UnitOfExamination", "ValueOfCondition", "ValueOfExamination".
        :paramtype relation_type: str or ~azure.ai.textanalytics.v2022_05_01.models.RelationType
        :keyword entities: Required. The entities in the relation.
        :paramtype entities: list[~azure.ai.textanalytics.v2022_05_01.models.HealthcareRelationEntity]
        """
        super(HealthcareRelation, self).__init__(**kwargs)
        self.relation_type = relation_type
        self.entities = entities


class HealthcareRelationEntity(msrest.serialization.Model):
    """HealthcareRelationEntity.

    All required parameters must be populated in order to send to Azure.

    :ivar ref: Required. Reference link object, using a JSON pointer RFC 6901 (URI Fragment
     Identifier Representation), pointing to the entity .
    :vartype ref: str
    :ivar role: Required. Role of entity in the relationship. For example: 'CD20-positive diffuse
     large B-cell lymphoma' has the following entities with their roles in parenthesis:  CD20
     (GeneOrProtein), Positive (Expression), diffuse large B-cell lymphoma (Diagnosis).
    :vartype role: str
    """

    _validation = {
        'ref': {'required': True},
        'role': {'required': True},
    }

    _attribute_map = {
        'ref': {'key': 'ref', 'type': 'str'},
        'role': {'key': 'role', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ref: str,
        role: str,
        **kwargs
    ):
        """
        :keyword ref: Required. Reference link object, using a JSON pointer RFC 6901 (URI Fragment
         Identifier Representation), pointing to the entity .
        :paramtype ref: str
        :keyword role: Required. Role of entity in the relationship. For example: 'CD20-positive
         diffuse large B-cell lymphoma' has the following entities with their roles in parenthesis:
         CD20 (GeneOrProtein), Positive (Expression), diffuse large B-cell lymphoma (Diagnosis).
        :paramtype role: str
        """
        super(HealthcareRelationEntity, self).__init__(**kwargs)
        self.ref = ref
        self.role = role


class HealthcareResult(PreBuiltResult):
    """HealthcareResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    :ivar documents: Required.
    :vartype documents:
     list[~azure.ai.textanalytics.v2022_05_01.models.HealthcareResultDocumentsItem]
    """

    _validation = {
        'errors': {'required': True},
        'model_version': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
        'documents': {'key': 'documents', 'type': '[HealthcareResultDocumentsItem]'},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        model_version: str,
        documents: List["_models.HealthcareResultDocumentsItem"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        :keyword documents: Required.
        :paramtype documents:
         list[~azure.ai.textanalytics.v2022_05_01.models.HealthcareResultDocumentsItem]
        """
        super(HealthcareResult, self).__init__(errors=errors, statistics=statistics, model_version=model_version, **kwargs)
        self.documents = documents


class HealthcareResultDocumentsItem(HealthcareEntitiesDocumentResult):
    """HealthcareResultDocumentsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
    :ivar entities: Required. Healthcare entities.
    :vartype entities: list[~azure.ai.textanalytics.v2022_05_01.models.HealthcareEntity]
    :ivar relations: Required. Healthcare entity relations.
    :vartype relations: list[~azure.ai.textanalytics.v2022_05_01.models.HealthcareRelation]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'entities': {'required': True},
        'relations': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'warnings': {'key': 'warnings', 'type': '[DocumentWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'entities': {'key': 'entities', 'type': '[HealthcareEntity]'},
        'relations': {'key': 'relations', 'type': '[HealthcareRelation]'},
    }

    def __init__(
        self,
        *,
        id: str,
        warnings: List["_models.DocumentWarning"],
        entities: List["_models.HealthcareEntity"],
        relations: List["_models.HealthcareRelation"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
        :keyword entities: Required. Healthcare entities.
        :paramtype entities: list[~azure.ai.textanalytics.v2022_05_01.models.HealthcareEntity]
        :keyword relations: Required. Healthcare entity relations.
        :paramtype relations: list[~azure.ai.textanalytics.v2022_05_01.models.HealthcareRelation]
        """
        super(HealthcareResultDocumentsItem, self).__init__(id=id, warnings=warnings, statistics=statistics, entities=entities, relations=relations, **kwargs)


class HealthcareTaskParameters(PreBuiltTaskParameters):
    """Supported parameters for a Healthcare task.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar model_version:
    :vartype model_version: str
    :ivar string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
     "Utf16CodeUnit". Default value: "TextElements_v8".
    :vartype string_index_type: str or ~azure.ai.textanalytics.v2022_05_01.models.StringIndexType
    """

    _attribute_map = {
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        logging_opt_out: Optional[bool] = False,
        model_version: Optional[str] = "latest",
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = "TextElements_v8",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword model_version:
        :paramtype model_version: str
        :keyword string_index_type: Specifies the method used to interpret string offsets.  Defaults to
         Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
         https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
         "Utf16CodeUnit". Default value: "TextElements_v8".
        :paramtype string_index_type: str or ~azure.ai.textanalytics.v2022_05_01.models.StringIndexType
        """
        super(HealthcareTaskParameters, self).__init__(logging_opt_out=logging_opt_out, model_version=model_version, **kwargs)
        self.string_index_type = string_index_type


class InnerErrorModel(msrest.serialization.Model):
    """An object containing more specific information about the error. As per Microsoft One API guidelines - https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. One of a server-defined set of error codes. Known values are:
     "InvalidRequest", "InvalidParameterValue", "KnowledgeBaseNotFound",
     "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", "ExtractionFailure",
     "InvalidRequestBodyFormat", "EmptyRequest", "MissingInputDocuments", "InvalidDocument",
     "ModelVersionIncorrect", "InvalidDocumentBatch", "UnsupportedLanguageCode",
     "InvalidCountryHint".
    :vartype code: str or ~azure.ai.textanalytics.v2022_05_01.models.InnerErrorCode
    :ivar message: Required. Error message.
    :vartype message: str
    :ivar details: Error details.
    :vartype details: dict[str, str]
    :ivar target: Error target.
    :vartype target: str
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.ai.textanalytics.v2022_05_01.models.InnerErrorModel
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '{str}'},
        'target': {'key': 'target', 'type': 'str'},
        'innererror': {'key': 'innererror', 'type': 'InnerErrorModel'},
    }

    def __init__(
        self,
        *,
        code: Union[str, "_models.InnerErrorCode"],
        message: str,
        details: Optional[Dict[str, str]] = None,
        target: Optional[str] = None,
        innererror: Optional["_models.InnerErrorModel"] = None,
        **kwargs
    ):
        """
        :keyword code: Required. One of a server-defined set of error codes. Known values are:
         "InvalidRequest", "InvalidParameterValue", "KnowledgeBaseNotFound",
         "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", "ExtractionFailure",
         "InvalidRequestBodyFormat", "EmptyRequest", "MissingInputDocuments", "InvalidDocument",
         "ModelVersionIncorrect", "InvalidDocumentBatch", "UnsupportedLanguageCode",
         "InvalidCountryHint".
        :paramtype code: str or ~azure.ai.textanalytics.v2022_05_01.models.InnerErrorCode
        :keyword message: Required. Error message.
        :paramtype message: str
        :keyword details: Error details.
        :paramtype details: dict[str, str]
        :keyword target: Error target.
        :paramtype target: str
        :keyword innererror: An object containing more specific information than the current object
         about the error.
        :paramtype innererror: ~azure.ai.textanalytics.v2022_05_01.models.InnerErrorModel
        """
        super(InnerErrorModel, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details
        self.target = target
        self.innererror = innererror


class JobErrors(msrest.serialization.Model):
    """JobErrors.

    :ivar errors:
    :vartype errors: list[~azure.ai.textanalytics.v2022_05_01.models.Error]
    """

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[Error]'},
    }

    def __init__(
        self,
        *,
        errors: Optional[List["_models.Error"]] = None,
        **kwargs
    ):
        """
        :keyword errors:
        :paramtype errors: list[~azure.ai.textanalytics.v2022_05_01.models.Error]
        """
        super(JobErrors, self).__init__(**kwargs)
        self.errors = errors


class KeyPhraseExtractionLROResult(AnalyzeTextLROResult):
    """KeyPhraseExtractionLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded",
     "partiallyCompleted", "failed", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported Text Analysis long-running operation task
     results.Constant filled by server. Known values are: "SentimentAnalysisLROResults",
     "EntityRecognitionLROResults", "PiiEntityRecognitionLROResults",
     "KeyPhraseExtractionLROResults", "EntityLinkingLROResults", "HealthcareLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2022_05_01.models.KeyPhraseResult
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'results': {'key': 'results', 'type': 'KeyPhraseResult'},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.KeyPhraseResult",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded",
         "partiallyCompleted", "failed", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
        :keyword task_name:
        :paramtype task_name: str
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2022_05_01.models.KeyPhraseResult
        """
        super(KeyPhraseExtractionLROResult, self).__init__(last_update_date_time=last_update_date_time, status=status, task_name=task_name, **kwargs)
        self.kind = 'KeyPhraseExtractionLROResults'  # type: str
        self.results = results


class KeyPhraseLROTask(AnalyzeTextLROTask):
    """An object representing the task definition for a Key Phrase Extraction task.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported long-running Text Analysis tasks.Constant filled
     by server. Known values are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition",
     "KeyPhraseExtraction", "EntityLinking", "Healthcare", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for a Key Phrase Extraction task.
    :vartype parameters: ~azure.ai.textanalytics.v2022_05_01.models.KeyPhraseTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'KeyPhraseTaskParameters'},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        parameters: Optional["_models.KeyPhraseTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for a Key Phrase Extraction task.
        :paramtype parameters: ~azure.ai.textanalytics.v2022_05_01.models.KeyPhraseTaskParameters
        """
        super(KeyPhraseLROTask, self).__init__(task_name=task_name, **kwargs)
        self.kind = 'KeyPhraseExtraction'  # type: str
        self.parameters = parameters


class KeyPhraseResult(PreBuiltResult):
    """KeyPhraseResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    :ivar documents: Required. Response by document.
    :vartype documents:
     list[~azure.ai.textanalytics.v2022_05_01.models.KeyPhraseResultDocumentsItem]
    """

    _validation = {
        'errors': {'required': True},
        'model_version': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
        'documents': {'key': 'documents', 'type': '[KeyPhraseResultDocumentsItem]'},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        model_version: str,
        documents: List["_models.KeyPhraseResultDocumentsItem"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        :keyword documents: Required. Response by document.
        :paramtype documents:
         list[~azure.ai.textanalytics.v2022_05_01.models.KeyPhraseResultDocumentsItem]
        """
        super(KeyPhraseResult, self).__init__(errors=errors, statistics=statistics, model_version=model_version, **kwargs)
        self.documents = documents


class KeyPhrasesDocumentResult(DocumentResult):
    """KeyPhrasesDocumentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
    :ivar key_phrases: Required. A list of representative words or phrases. The number of key
     phrases returned is proportional to the number of words in the input document.
    :vartype key_phrases: list[str]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'key_phrases': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'warnings': {'key': 'warnings', 'type': '[DocumentWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'key_phrases': {'key': 'keyPhrases', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        id: str,
        warnings: List["_models.DocumentWarning"],
        key_phrases: List[str],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
        :keyword key_phrases: Required. A list of representative words or phrases. The number of key
         phrases returned is proportional to the number of words in the input document.
        :paramtype key_phrases: list[str]
        """
        super(KeyPhrasesDocumentResult, self).__init__(id=id, warnings=warnings, statistics=statistics, **kwargs)
        self.key_phrases = key_phrases


class KeyPhraseResultDocumentsItem(KeyPhrasesDocumentResult):
    """KeyPhraseResultDocumentsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
    :ivar key_phrases: Required. A list of representative words or phrases. The number of key
     phrases returned is proportional to the number of words in the input document.
    :vartype key_phrases: list[str]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'key_phrases': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'warnings': {'key': 'warnings', 'type': '[DocumentWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'key_phrases': {'key': 'keyPhrases', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        id: str,
        warnings: List["_models.DocumentWarning"],
        key_phrases: List[str],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
        :keyword key_phrases: Required. A list of representative words or phrases. The number of key
         phrases returned is proportional to the number of words in the input document.
        :paramtype key_phrases: list[str]
        """
        super(KeyPhraseResultDocumentsItem, self).__init__(id=id, warnings=warnings, statistics=statistics, key_phrases=key_phrases, **kwargs)


class KeyPhraseTaskParameters(PreBuiltTaskParameters):
    """Supported parameters for a Key Phrase Extraction task.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar model_version:
    :vartype model_version: str
    """

    _attribute_map = {
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        logging_opt_out: Optional[bool] = False,
        model_version: Optional[str] = "latest",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword model_version:
        :paramtype model_version: str
        """
        super(KeyPhraseTaskParameters, self).__init__(logging_opt_out=logging_opt_out, model_version=model_version, **kwargs)


class KeyPhraseTaskResult(AnalyzeTextTaskResult):
    """KeyPhraseTaskResult.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Enumeration of supported Text Analysis task results.Constant filled by
     server. Known values are: "SentimentAnalysisResults", "EntityRecognitionResults",
     "PiiEntityRecognitionResults", "KeyPhraseExtractionResults", "LanguageDetectionResults",
     "EntityLinkingResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextTaskResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2022_05_01.models.KeyPhraseResult
    """

    _validation = {
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'results': {'key': 'results', 'type': 'KeyPhraseResult'},
    }

    def __init__(
        self,
        *,
        results: "_models.KeyPhraseResult",
        **kwargs
    ):
        """
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2022_05_01.models.KeyPhraseResult
        """
        super(KeyPhraseTaskResult, self).__init__(**kwargs)
        self.kind = 'KeyPhraseExtractionResults'  # type: str
        self.results = results


class LanguageDetectionAnalysisInput(msrest.serialization.Model):
    """LanguageDetectionAnalysisInput.

    :ivar documents:
    :vartype documents: list[~azure.ai.textanalytics.v2022_05_01.models.LanguageInput]
    """

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[LanguageInput]'},
    }

    def __init__(
        self,
        *,
        documents: Optional[List["_models.LanguageInput"]] = None,
        **kwargs
    ):
        """
        :keyword documents:
        :paramtype documents: list[~azure.ai.textanalytics.v2022_05_01.models.LanguageInput]
        """
        super(LanguageDetectionAnalysisInput, self).__init__(**kwargs)
        self.documents = documents


class LanguageDetectionDocumentResult(DocumentResult):
    """LanguageDetectionDocumentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
    :ivar detected_language: Required. Detected Language.
    :vartype detected_language: ~azure.ai.textanalytics.v2022_05_01.models.DetectedLanguage
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'detected_language': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'warnings': {'key': 'warnings', 'type': '[DocumentWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'detected_language': {'key': 'detectedLanguage', 'type': 'DetectedLanguage'},
    }

    def __init__(
        self,
        *,
        id: str,
        warnings: List["_models.DocumentWarning"],
        detected_language: "_models.DetectedLanguage",
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
        :keyword detected_language: Required. Detected Language.
        :paramtype detected_language: ~azure.ai.textanalytics.v2022_05_01.models.DetectedLanguage
        """
        super(LanguageDetectionDocumentResult, self).__init__(id=id, warnings=warnings, statistics=statistics, **kwargs)
        self.detected_language = detected_language


class LanguageDetectionResult(PreBuiltResult):
    """LanguageDetectionResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    :ivar documents: Required. Response by document.
    :vartype documents:
     list[~azure.ai.textanalytics.v2022_05_01.models.LanguageDetectionDocumentResult]
    """

    _validation = {
        'errors': {'required': True},
        'model_version': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
        'documents': {'key': 'documents', 'type': '[LanguageDetectionDocumentResult]'},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        model_version: str,
        documents: List["_models.LanguageDetectionDocumentResult"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        :keyword documents: Required. Response by document.
        :paramtype documents:
         list[~azure.ai.textanalytics.v2022_05_01.models.LanguageDetectionDocumentResult]
        """
        super(LanguageDetectionResult, self).__init__(errors=errors, statistics=statistics, model_version=model_version, **kwargs)
        self.documents = documents


class LanguageDetectionTaskParameters(PreBuiltTaskParameters):
    """Supported parameters for a Language Detection task.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar model_version:
    :vartype model_version: str
    """

    _attribute_map = {
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        logging_opt_out: Optional[bool] = False,
        model_version: Optional[str] = "latest",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword model_version:
        :paramtype model_version: str
        """
        super(LanguageDetectionTaskParameters, self).__init__(logging_opt_out=logging_opt_out, model_version=model_version, **kwargs)


class LanguageDetectionTaskResult(AnalyzeTextTaskResult):
    """LanguageDetectionTaskResult.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Enumeration of supported Text Analysis task results.Constant filled by
     server. Known values are: "SentimentAnalysisResults", "EntityRecognitionResults",
     "PiiEntityRecognitionResults", "KeyPhraseExtractionResults", "LanguageDetectionResults",
     "EntityLinkingResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextTaskResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2022_05_01.models.LanguageDetectionResult
    """

    _validation = {
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'results': {'key': 'results', 'type': 'LanguageDetectionResult'},
    }

    def __init__(
        self,
        *,
        results: "_models.LanguageDetectionResult",
        **kwargs
    ):
        """
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2022_05_01.models.LanguageDetectionResult
        """
        super(LanguageDetectionTaskResult, self).__init__(**kwargs)
        self.kind = 'LanguageDetectionResults'  # type: str
        self.results = results


class LanguageInput(msrest.serialization.Model):
    """LanguageInput.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar text: Required.
    :vartype text: str
    :ivar country_hint:
    :vartype country_hint: str
    """

    _validation = {
        'id': {'required': True},
        'text': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'country_hint': {'key': 'countryHint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        text: str,
        country_hint: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword text: Required.
        :paramtype text: str
        :keyword country_hint:
        :paramtype country_hint: str
        """
        super(LanguageInput, self).__init__(**kwargs)
        self.id = id
        self.text = text
        self.country_hint = country_hint


class LinkedEntity(msrest.serialization.Model):
    """LinkedEntity.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Entity Linking formal name.
    :vartype name: str
    :ivar matches: Required. List of instances this entity appears in the text.
    :vartype matches: list[~azure.ai.textanalytics.v2022_05_01.models.Match]
    :ivar language: Required. Language used in the data source.
    :vartype language: str
    :ivar id: Unique identifier of the recognized entity from the data source.
    :vartype id: str
    :ivar url: Required. URL for the entity's page from the data source.
    :vartype url: str
    :ivar data_source: Required. Data source used to extract entity linking, such as Wiki/Bing etc.
    :vartype data_source: str
    :ivar bing_id: Bing Entity Search API unique identifier of the recognized entity.
    :vartype bing_id: str
    """

    _validation = {
        'name': {'required': True},
        'matches': {'required': True},
        'language': {'required': True},
        'url': {'required': True},
        'data_source': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'matches': {'key': 'matches', 'type': '[Match]'},
        'language': {'key': 'language', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'data_source': {'key': 'dataSource', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        matches: List["_models.Match"],
        language: str,
        url: str,
        data_source: str,
        id: Optional[str] = None,
        bing_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Required. Entity Linking formal name.
        :paramtype name: str
        :keyword matches: Required. List of instances this entity appears in the text.
        :paramtype matches: list[~azure.ai.textanalytics.v2022_05_01.models.Match]
        :keyword language: Required. Language used in the data source.
        :paramtype language: str
        :keyword id: Unique identifier of the recognized entity from the data source.
        :paramtype id: str
        :keyword url: Required. URL for the entity's page from the data source.
        :paramtype url: str
        :keyword data_source: Required. Data source used to extract entity linking, such as Wiki/Bing
         etc.
        :paramtype data_source: str
        :keyword bing_id: Bing Entity Search API unique identifier of the recognized entity.
        :paramtype bing_id: str
        """
        super(LinkedEntity, self).__init__(**kwargs)
        self.name = name
        self.matches = matches
        self.language = language
        self.id = id
        self.url = url
        self.data_source = data_source
        self.bing_id = bing_id


class Match(msrest.serialization.Model):
    """Match.

    All required parameters must be populated in order to send to Azure.

    :ivar confidence_score: Required. If a well known item is recognized, a decimal number denoting
     the confidence level between 0 and 1 will be returned.
    :vartype confidence_score: float
    :ivar text: Required. Entity text as appears in the request.
    :vartype text: str
    :ivar offset: Required. Start position for the entity match text.
    :vartype offset: int
    :ivar length: Required. Length for the entity match text.
    :vartype length: int
    """

    _validation = {
        'confidence_score': {'required': True},
        'text': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
    }

    _attribute_map = {
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
        'text': {'key': 'text', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        confidence_score: float,
        text: str,
        offset: int,
        length: int,
        **kwargs
    ):
        """
        :keyword confidence_score: Required. If a well known item is recognized, a decimal number
         denoting the confidence level between 0 and 1 will be returned.
        :paramtype confidence_score: float
        :keyword text: Required. Entity text as appears in the request.
        :paramtype text: str
        :keyword offset: Required. Start position for the entity match text.
        :paramtype offset: int
        :keyword length: Required. Length for the entity match text.
        :paramtype length: int
        """
        super(Match, self).__init__(**kwargs)
        self.confidence_score = confidence_score
        self.text = text
        self.offset = offset
        self.length = length


class MultiLanguageAnalysisInput(msrest.serialization.Model):
    """MultiLanguageAnalysisInput.

    :ivar documents:
    :vartype documents: list[~azure.ai.textanalytics.v2022_05_01.models.MultiLanguageInput]
    """

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[MultiLanguageInput]'},
    }

    def __init__(
        self,
        *,
        documents: Optional[List["_models.MultiLanguageInput"]] = None,
        **kwargs
    ):
        """
        :keyword documents:
        :paramtype documents: list[~azure.ai.textanalytics.v2022_05_01.models.MultiLanguageInput]
        """
        super(MultiLanguageAnalysisInput, self).__init__(**kwargs)
        self.documents = documents


class MultiLanguageInput(msrest.serialization.Model):
    """Contains an input document to be analyzed by the service.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. A unique, non-empty document identifier.
    :vartype id: str
    :ivar text: Required. The input text to process.
    :vartype text: str
    :ivar language: (Optional) This is the 2 letter ISO 639-1 representation of a language. For
     example, use "en" for English; "es" for Spanish etc. If not set, use "en" for English as
     default.
    :vartype language: str
    """

    _validation = {
        'id': {'required': True},
        'text': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'language': {'key': 'language', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        text: str,
        language: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Required. A unique, non-empty document identifier.
        :paramtype id: str
        :keyword text: Required. The input text to process.
        :paramtype text: str
        :keyword language: (Optional) This is the 2 letter ISO 639-1 representation of a language. For
         example, use "en" for English; "es" for Spanish etc. If not set, use "en" for English as
         default.
        :paramtype language: str
        """
        super(MultiLanguageInput, self).__init__(**kwargs)
        self.id = id
        self.text = text
        self.language = language


class Pagination(msrest.serialization.Model):
    """Pagination.

    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link:
        :paramtype next_link: str
        """
        super(Pagination, self).__init__(**kwargs)
        self.next_link = next_link


class PiiEntitiesDocumentResult(DocumentResult):
    """PiiEntitiesDocumentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
    :ivar redacted_text: Required. Returns redacted text.
    :vartype redacted_text: str
    :ivar entities: Required. Recognized entities in the document.
    :vartype entities: list[~azure.ai.textanalytics.v2022_05_01.models.Entity]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'redacted_text': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'warnings': {'key': 'warnings', 'type': '[DocumentWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'redacted_text': {'key': 'redactedText', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[Entity]'},
    }

    def __init__(
        self,
        *,
        id: str,
        warnings: List["_models.DocumentWarning"],
        redacted_text: str,
        entities: List["_models.Entity"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
        :keyword redacted_text: Required. Returns redacted text.
        :paramtype redacted_text: str
        :keyword entities: Required. Recognized entities in the document.
        :paramtype entities: list[~azure.ai.textanalytics.v2022_05_01.models.Entity]
        """
        super(PiiEntitiesDocumentResult, self).__init__(id=id, warnings=warnings, statistics=statistics, **kwargs)
        self.redacted_text = redacted_text
        self.entities = entities


class PiiEntityRecognitionLROResult(AnalyzeTextLROResult):
    """PiiEntityRecognitionLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded",
     "partiallyCompleted", "failed", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported Text Analysis long-running operation task
     results.Constant filled by server. Known values are: "SentimentAnalysisLROResults",
     "EntityRecognitionLROResults", "PiiEntityRecognitionLROResults",
     "KeyPhraseExtractionLROResults", "EntityLinkingLROResults", "HealthcareLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2022_05_01.models.PiiResult
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'results': {'key': 'results', 'type': 'PiiResult'},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.PiiResult",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded",
         "partiallyCompleted", "failed", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
        :keyword task_name:
        :paramtype task_name: str
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2022_05_01.models.PiiResult
        """
        super(PiiEntityRecognitionLROResult, self).__init__(last_update_date_time=last_update_date_time, status=status, task_name=task_name, **kwargs)
        self.kind = 'PiiEntityRecognitionLROResults'  # type: str
        self.results = results


class PiiLROTask(AnalyzeTextLROTask):
    """An object representing the task definition for a PII Entities Recognition task.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported long-running Text Analysis tasks.Constant filled
     by server. Known values are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition",
     "KeyPhraseExtraction", "EntityLinking", "Healthcare", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for a PII Entities Recognition task.
    :vartype parameters: ~azure.ai.textanalytics.v2022_05_01.models.PiiTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'PiiTaskParameters'},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        parameters: Optional["_models.PiiTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for a PII Entities Recognition task.
        :paramtype parameters: ~azure.ai.textanalytics.v2022_05_01.models.PiiTaskParameters
        """
        super(PiiLROTask, self).__init__(task_name=task_name, **kwargs)
        self.kind = 'PiiEntityRecognition'  # type: str
        self.parameters = parameters


class PiiResult(PreBuiltResult):
    """PiiResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    :ivar documents: Required. Response by document.
    :vartype documents: list[~azure.ai.textanalytics.v2022_05_01.models.PiiResultDocumentsItem]
    """

    _validation = {
        'errors': {'required': True},
        'model_version': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
        'documents': {'key': 'documents', 'type': '[PiiResultDocumentsItem]'},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        model_version: str,
        documents: List["_models.PiiResultDocumentsItem"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        :keyword documents: Required. Response by document.
        :paramtype documents: list[~azure.ai.textanalytics.v2022_05_01.models.PiiResultDocumentsItem]
        """
        super(PiiResult, self).__init__(errors=errors, statistics=statistics, model_version=model_version, **kwargs)
        self.documents = documents


class PiiResultDocumentsItem(PiiEntitiesDocumentResult):
    """PiiResultDocumentsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
    :ivar redacted_text: Required. Returns redacted text.
    :vartype redacted_text: str
    :ivar entities: Required. Recognized entities in the document.
    :vartype entities: list[~azure.ai.textanalytics.v2022_05_01.models.Entity]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'redacted_text': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'warnings': {'key': 'warnings', 'type': '[DocumentWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'redacted_text': {'key': 'redactedText', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[Entity]'},
    }

    def __init__(
        self,
        *,
        id: str,
        warnings: List["_models.DocumentWarning"],
        redacted_text: str,
        entities: List["_models.Entity"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
        :keyword redacted_text: Required. Returns redacted text.
        :paramtype redacted_text: str
        :keyword entities: Required. Recognized entities in the document.
        :paramtype entities: list[~azure.ai.textanalytics.v2022_05_01.models.Entity]
        """
        super(PiiResultDocumentsItem, self).__init__(id=id, warnings=warnings, statistics=statistics, redacted_text=redacted_text, entities=entities, **kwargs)


class PiiTaskParameters(PreBuiltTaskParameters):
    """Supported parameters for a PII Entities Recognition task.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar model_version:
    :vartype model_version: str
    :ivar domain: The PII domain used for PII Entity Recognition. Known values are: "phi", "none".
     Default value: "none".
    :vartype domain: str or ~azure.ai.textanalytics.v2022_05_01.models.PiiDomain
    :ivar pii_categories: (Optional) describes the PII categories to return.
    :vartype pii_categories: list[str or ~azure.ai.textanalytics.v2022_05_01.models.PiiCategory]
    :ivar string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
     "Utf16CodeUnit". Default value: "TextElements_v8".
    :vartype string_index_type: str or ~azure.ai.textanalytics.v2022_05_01.models.StringIndexType
    """

    _validation = {
        'pii_categories': {'unique': True},
    }

    _attribute_map = {
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
        'domain': {'key': 'domain', 'type': 'str'},
        'pii_categories': {'key': 'piiCategories', 'type': '[str]'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        logging_opt_out: Optional[bool] = False,
        model_version: Optional[str] = "latest",
        domain: Optional[Union[str, "_models.PiiDomain"]] = "none",
        pii_categories: Optional[List[Union[str, "_models.PiiCategory"]]] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = "TextElements_v8",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword model_version:
        :paramtype model_version: str
        :keyword domain: The PII domain used for PII Entity Recognition. Known values are: "phi",
         "none". Default value: "none".
        :paramtype domain: str or ~azure.ai.textanalytics.v2022_05_01.models.PiiDomain
        :keyword pii_categories: (Optional) describes the PII categories to return.
        :paramtype pii_categories: list[str or ~azure.ai.textanalytics.v2022_05_01.models.PiiCategory]
        :keyword string_index_type: Specifies the method used to interpret string offsets.  Defaults to
         Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
         https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
         "Utf16CodeUnit". Default value: "TextElements_v8".
        :paramtype string_index_type: str or ~azure.ai.textanalytics.v2022_05_01.models.StringIndexType
        """
        super(PiiTaskParameters, self).__init__(logging_opt_out=logging_opt_out, model_version=model_version, **kwargs)
        self.domain = domain
        self.pii_categories = pii_categories
        self.string_index_type = string_index_type


class PiiTaskResult(AnalyzeTextTaskResult):
    """PiiTaskResult.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Enumeration of supported Text Analysis task results.Constant filled by
     server. Known values are: "SentimentAnalysisResults", "EntityRecognitionResults",
     "PiiEntityRecognitionResults", "KeyPhraseExtractionResults", "LanguageDetectionResults",
     "EntityLinkingResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextTaskResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2022_05_01.models.PiiResult
    """

    _validation = {
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'results': {'key': 'results', 'type': 'PiiResult'},
    }

    def __init__(
        self,
        *,
        results: "_models.PiiResult",
        **kwargs
    ):
        """
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2022_05_01.models.PiiResult
        """
        super(PiiTaskResult, self).__init__(**kwargs)
        self.kind = 'PiiEntityRecognitionResults'  # type: str
        self.results = results


class RequestStatistics(msrest.serialization.Model):
    """if showStats=true was specified in the request this field will contain information about the request payload.

    All required parameters must be populated in order to send to Azure.

    :ivar documents_count: Required. Number of documents submitted in the request.
    :vartype documents_count: int
    :ivar valid_documents_count: Required. Number of valid documents. This excludes empty,
     over-size limit or non-supported languages documents.
    :vartype valid_documents_count: int
    :ivar erroneous_documents_count: Required. Number of invalid documents. This includes empty,
     over-size limit or non-supported languages documents.
    :vartype erroneous_documents_count: int
    :ivar transactions_count: Required. Number of transactions for the request.
    :vartype transactions_count: long
    """

    _validation = {
        'documents_count': {'required': True},
        'valid_documents_count': {'required': True},
        'erroneous_documents_count': {'required': True},
        'transactions_count': {'required': True},
    }

    _attribute_map = {
        'documents_count': {'key': 'documentsCount', 'type': 'int'},
        'valid_documents_count': {'key': 'validDocumentsCount', 'type': 'int'},
        'erroneous_documents_count': {'key': 'erroneousDocumentsCount', 'type': 'int'},
        'transactions_count': {'key': 'transactionsCount', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        documents_count: int,
        valid_documents_count: int,
        erroneous_documents_count: int,
        transactions_count: int,
        **kwargs
    ):
        """
        :keyword documents_count: Required. Number of documents submitted in the request.
        :paramtype documents_count: int
        :keyword valid_documents_count: Required. Number of valid documents. This excludes empty,
         over-size limit or non-supported languages documents.
        :paramtype valid_documents_count: int
        :keyword erroneous_documents_count: Required. Number of invalid documents. This includes empty,
         over-size limit or non-supported languages documents.
        :paramtype erroneous_documents_count: int
        :keyword transactions_count: Required. Number of transactions for the request.
        :paramtype transactions_count: long
        """
        super(RequestStatistics, self).__init__(**kwargs)
        self.documents_count = documents_count
        self.valid_documents_count = valid_documents_count
        self.erroneous_documents_count = erroneous_documents_count
        self.transactions_count = transactions_count


class SentenceAssessment(msrest.serialization.Model):
    """SentenceAssessment.

    All required parameters must be populated in order to send to Azure.

    :ivar sentiment: Required. Assessment sentiment in the sentence. Known values are: "positive",
     "mixed", "negative".
    :vartype sentiment: str or ~azure.ai.textanalytics.v2022_05_01.models.TokenSentimentValue
    :ivar confidence_scores: Required. Assessment sentiment confidence scores in the sentence.
    :vartype confidence_scores:
     ~azure.ai.textanalytics.v2022_05_01.models.TargetConfidenceScoreLabel
    :ivar offset: Required. The assessment offset from the start of the sentence.
    :vartype offset: int
    :ivar length: Required. The length of the assessment.
    :vartype length: int
    :ivar text: Required. The assessment text detected.
    :vartype text: str
    :ivar is_negated: Required. The indicator representing if the assessment is negated.
    :vartype is_negated: bool
    """

    _validation = {
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'text': {'required': True},
        'is_negated': {'required': True},
    }

    _attribute_map = {
        'sentiment': {'key': 'sentiment', 'type': 'str'},
        'confidence_scores': {'key': 'confidenceScores', 'type': 'TargetConfidenceScoreLabel'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'text': {'key': 'text', 'type': 'str'},
        'is_negated': {'key': 'isNegated', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        sentiment: Union[str, "_models.TokenSentimentValue"],
        confidence_scores: "_models.TargetConfidenceScoreLabel",
        offset: int,
        length: int,
        text: str,
        is_negated: bool,
        **kwargs
    ):
        """
        :keyword sentiment: Required. Assessment sentiment in the sentence. Known values are:
         "positive", "mixed", "negative".
        :paramtype sentiment: str or ~azure.ai.textanalytics.v2022_05_01.models.TokenSentimentValue
        :keyword confidence_scores: Required. Assessment sentiment confidence scores in the sentence.
        :paramtype confidence_scores:
         ~azure.ai.textanalytics.v2022_05_01.models.TargetConfidenceScoreLabel
        :keyword offset: Required. The assessment offset from the start of the sentence.
        :paramtype offset: int
        :keyword length: Required. The length of the assessment.
        :paramtype length: int
        :keyword text: Required. The assessment text detected.
        :paramtype text: str
        :keyword is_negated: Required. The indicator representing if the assessment is negated.
        :paramtype is_negated: bool
        """
        super(SentenceAssessment, self).__init__(**kwargs)
        self.sentiment = sentiment
        self.confidence_scores = confidence_scores
        self.offset = offset
        self.length = length
        self.text = text
        self.is_negated = is_negated


class SentenceSentiment(msrest.serialization.Model):
    """SentenceSentiment.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Required. The sentence text.
    :vartype text: str
    :ivar sentiment: Required. The predicted Sentiment for the sentence. Known values are:
     "positive", "neutral", "negative".
    :vartype sentiment: str or ~azure.ai.textanalytics.v2022_05_01.models.SentenceSentimentValue
    :ivar confidence_scores: Required. The sentiment confidence score between 0 and 1 for the
     sentence for all classes.
    :vartype confidence_scores:
     ~azure.ai.textanalytics.v2022_05_01.models.SentimentConfidenceScorePerLabel
    :ivar offset: Required. The sentence offset from the start of the document.
    :vartype offset: int
    :ivar length: Required. The length of the sentence.
    :vartype length: int
    :ivar targets: The array of sentence targets for the sentence.
    :vartype targets: list[~azure.ai.textanalytics.v2022_05_01.models.SentenceTarget]
    :ivar assessments: The array of assessments for the sentence.
    :vartype assessments: list[~azure.ai.textanalytics.v2022_05_01.models.SentenceAssessment]
    """

    _validation = {
        'text': {'required': True},
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'sentiment': {'key': 'sentiment', 'type': 'str'},
        'confidence_scores': {'key': 'confidenceScores', 'type': 'SentimentConfidenceScorePerLabel'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'targets': {'key': 'targets', 'type': '[SentenceTarget]'},
        'assessments': {'key': 'assessments', 'type': '[SentenceAssessment]'},
    }

    def __init__(
        self,
        *,
        text: str,
        sentiment: Union[str, "_models.SentenceSentimentValue"],
        confidence_scores: "_models.SentimentConfidenceScorePerLabel",
        offset: int,
        length: int,
        targets: Optional[List["_models.SentenceTarget"]] = None,
        assessments: Optional[List["_models.SentenceAssessment"]] = None,
        **kwargs
    ):
        """
        :keyword text: Required. The sentence text.
        :paramtype text: str
        :keyword sentiment: Required. The predicted Sentiment for the sentence. Known values are:
         "positive", "neutral", "negative".
        :paramtype sentiment: str or ~azure.ai.textanalytics.v2022_05_01.models.SentenceSentimentValue
        :keyword confidence_scores: Required. The sentiment confidence score between 0 and 1 for the
         sentence for all classes.
        :paramtype confidence_scores:
         ~azure.ai.textanalytics.v2022_05_01.models.SentimentConfidenceScorePerLabel
        :keyword offset: Required. The sentence offset from the start of the document.
        :paramtype offset: int
        :keyword length: Required. The length of the sentence.
        :paramtype length: int
        :keyword targets: The array of sentence targets for the sentence.
        :paramtype targets: list[~azure.ai.textanalytics.v2022_05_01.models.SentenceTarget]
        :keyword assessments: The array of assessments for the sentence.
        :paramtype assessments: list[~azure.ai.textanalytics.v2022_05_01.models.SentenceAssessment]
        """
        super(SentenceSentiment, self).__init__(**kwargs)
        self.text = text
        self.sentiment = sentiment
        self.confidence_scores = confidence_scores
        self.offset = offset
        self.length = length
        self.targets = targets
        self.assessments = assessments


class SentenceTarget(msrest.serialization.Model):
    """SentenceTarget.

    All required parameters must be populated in order to send to Azure.

    :ivar sentiment: Required. Targeted sentiment in the sentence. Known values are: "positive",
     "mixed", "negative".
    :vartype sentiment: str or ~azure.ai.textanalytics.v2022_05_01.models.TokenSentimentValue
    :ivar confidence_scores: Required. Target sentiment confidence scores for the target in the
     sentence.
    :vartype confidence_scores:
     ~azure.ai.textanalytics.v2022_05_01.models.TargetConfidenceScoreLabel
    :ivar offset: Required. The target offset from the start of the sentence.
    :vartype offset: int
    :ivar length: Required. The length of the target.
    :vartype length: int
    :ivar text: Required. The target text detected.
    :vartype text: str
    :ivar relations: Required. The array of either assessment or target objects which is related to
     the target.
    :vartype relations: list[~azure.ai.textanalytics.v2022_05_01.models.TargetRelation]
    """

    _validation = {
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'text': {'required': True},
        'relations': {'required': True},
    }

    _attribute_map = {
        'sentiment': {'key': 'sentiment', 'type': 'str'},
        'confidence_scores': {'key': 'confidenceScores', 'type': 'TargetConfidenceScoreLabel'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'text': {'key': 'text', 'type': 'str'},
        'relations': {'key': 'relations', 'type': '[TargetRelation]'},
    }

    def __init__(
        self,
        *,
        sentiment: Union[str, "_models.TokenSentimentValue"],
        confidence_scores: "_models.TargetConfidenceScoreLabel",
        offset: int,
        length: int,
        text: str,
        relations: List["_models.TargetRelation"],
        **kwargs
    ):
        """
        :keyword sentiment: Required. Targeted sentiment in the sentence. Known values are: "positive",
         "mixed", "negative".
        :paramtype sentiment: str or ~azure.ai.textanalytics.v2022_05_01.models.TokenSentimentValue
        :keyword confidence_scores: Required. Target sentiment confidence scores for the target in the
         sentence.
        :paramtype confidence_scores:
         ~azure.ai.textanalytics.v2022_05_01.models.TargetConfidenceScoreLabel
        :keyword offset: Required. The target offset from the start of the sentence.
        :paramtype offset: int
        :keyword length: Required. The length of the target.
        :paramtype length: int
        :keyword text: Required. The target text detected.
        :paramtype text: str
        :keyword relations: Required. The array of either assessment or target objects which is related
         to the target.
        :paramtype relations: list[~azure.ai.textanalytics.v2022_05_01.models.TargetRelation]
        """
        super(SentenceTarget, self).__init__(**kwargs)
        self.sentiment = sentiment
        self.confidence_scores = confidence_scores
        self.offset = offset
        self.length = length
        self.text = text
        self.relations = relations


class SentimentAnalysisLROTask(AnalyzeTextLROTask):
    """An object representing the task definition for a Sentiment Analysis task.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported long-running Text Analysis tasks.Constant filled
     by server. Known values are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition",
     "KeyPhraseExtraction", "EntityLinking", "Healthcare", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for a Sentiment Analysis task.
    :vartype parameters: ~azure.ai.textanalytics.v2022_05_01.models.SentimentAnalysisTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'SentimentAnalysisTaskParameters'},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        parameters: Optional["_models.SentimentAnalysisTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for a Sentiment Analysis task.
        :paramtype parameters:
         ~azure.ai.textanalytics.v2022_05_01.models.SentimentAnalysisTaskParameters
        """
        super(SentimentAnalysisLROTask, self).__init__(task_name=task_name, **kwargs)
        self.kind = 'SentimentAnalysis'  # type: str
        self.parameters = parameters


class SentimentAnalysisTaskParameters(PreBuiltTaskParameters):
    """Supported parameters for a Sentiment Analysis task.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar model_version:
    :vartype model_version: str
    :ivar opinion_mining:
    :vartype opinion_mining: bool
    :ivar string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
     "Utf16CodeUnit". Default value: "TextElements_v8".
    :vartype string_index_type: str or ~azure.ai.textanalytics.v2022_05_01.models.StringIndexType
    """

    _attribute_map = {
        'logging_opt_out': {'key': 'loggingOptOut', 'type': 'bool'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
        'opinion_mining': {'key': 'opinionMining', 'type': 'bool'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        logging_opt_out: Optional[bool] = False,
        model_version: Optional[str] = "latest",
        opinion_mining: Optional[bool] = False,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = "TextElements_v8",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword model_version:
        :paramtype model_version: str
        :keyword opinion_mining:
        :paramtype opinion_mining: bool
        :keyword string_index_type: Specifies the method used to interpret string offsets.  Defaults to
         Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
         https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
         "Utf16CodeUnit". Default value: "TextElements_v8".
        :paramtype string_index_type: str or ~azure.ai.textanalytics.v2022_05_01.models.StringIndexType
        """
        super(SentimentAnalysisTaskParameters, self).__init__(logging_opt_out=logging_opt_out, model_version=model_version, **kwargs)
        self.opinion_mining = opinion_mining
        self.string_index_type = string_index_type


class SentimentConfidenceScorePerLabel(msrest.serialization.Model):
    """Represents the confidence scores between 0 and 1 across all sentiment classes: positive, neutral, negative.

    All required parameters must be populated in order to send to Azure.

    :ivar positive: Required.
    :vartype positive: float
    :ivar neutral: Required.
    :vartype neutral: float
    :ivar negative: Required.
    :vartype negative: float
    """

    _validation = {
        'positive': {'required': True},
        'neutral': {'required': True},
        'negative': {'required': True},
    }

    _attribute_map = {
        'positive': {'key': 'positive', 'type': 'float'},
        'neutral': {'key': 'neutral', 'type': 'float'},
        'negative': {'key': 'negative', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        positive: float,
        neutral: float,
        negative: float,
        **kwargs
    ):
        """
        :keyword positive: Required.
        :paramtype positive: float
        :keyword neutral: Required.
        :paramtype neutral: float
        :keyword negative: Required.
        :paramtype negative: float
        """
        super(SentimentConfidenceScorePerLabel, self).__init__(**kwargs)
        self.positive = positive
        self.neutral = neutral
        self.negative = negative


class SentimentDocumentResult(DocumentResult):
    """SentimentDocumentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
    :ivar sentiment: Required. Predicted sentiment for document (Negative, Neutral, Positive, or
     Mixed). Known values are: "positive", "neutral", "negative", "mixed".
    :vartype sentiment: str or ~azure.ai.textanalytics.v2022_05_01.models.DocumentSentimentValue
    :ivar confidence_scores: Required. Document level sentiment confidence scores between 0 and 1
     for each sentiment class.
    :vartype confidence_scores:
     ~azure.ai.textanalytics.v2022_05_01.models.SentimentConfidenceScorePerLabel
    :ivar sentences: Required. Sentence level sentiment analysis.
    :vartype sentences: list[~azure.ai.textanalytics.v2022_05_01.models.SentenceSentiment]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'sentences': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'warnings': {'key': 'warnings', 'type': '[DocumentWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'sentiment': {'key': 'sentiment', 'type': 'str'},
        'confidence_scores': {'key': 'confidenceScores', 'type': 'SentimentConfidenceScorePerLabel'},
        'sentences': {'key': 'sentences', 'type': '[SentenceSentiment]'},
    }

    def __init__(
        self,
        *,
        id: str,
        warnings: List["_models.DocumentWarning"],
        sentiment: Union[str, "_models.DocumentSentimentValue"],
        confidence_scores: "_models.SentimentConfidenceScorePerLabel",
        sentences: List["_models.SentenceSentiment"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
        :keyword sentiment: Required. Predicted sentiment for document (Negative, Neutral, Positive, or
         Mixed). Known values are: "positive", "neutral", "negative", "mixed".
        :paramtype sentiment: str or ~azure.ai.textanalytics.v2022_05_01.models.DocumentSentimentValue
        :keyword confidence_scores: Required. Document level sentiment confidence scores between 0 and
         1 for each sentiment class.
        :paramtype confidence_scores:
         ~azure.ai.textanalytics.v2022_05_01.models.SentimentConfidenceScorePerLabel
        :keyword sentences: Required. Sentence level sentiment analysis.
        :paramtype sentences: list[~azure.ai.textanalytics.v2022_05_01.models.SentenceSentiment]
        """
        super(SentimentDocumentResult, self).__init__(id=id, warnings=warnings, statistics=statistics, **kwargs)
        self.sentiment = sentiment
        self.confidence_scores = confidence_scores
        self.sentences = sentences


class SentimentLROResult(AnalyzeTextLROResult):
    """SentimentLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded",
     "partiallyCompleted", "failed", "cancelled", "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Required. Enumeration of supported Text Analysis long-running operation task
     results.Constant filled by server. Known values are: "SentimentAnalysisLROResults",
     "EntityRecognitionLROResults", "PiiEntityRecognitionLROResults",
     "KeyPhraseExtractionLROResults", "EntityLinkingLROResults", "HealthcareLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2022_05_01.models.SentimentResponse
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'results': {'key': 'results', 'type': 'SentimentResponse'},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.SentimentResponse",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded",
         "partiallyCompleted", "failed", "cancelled", "cancelling".
        :paramtype status: str or ~azure.ai.textanalytics.v2022_05_01.models.State
        :keyword task_name:
        :paramtype task_name: str
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2022_05_01.models.SentimentResponse
        """
        super(SentimentLROResult, self).__init__(last_update_date_time=last_update_date_time, status=status, task_name=task_name, **kwargs)
        self.kind = 'SentimentAnalysisLROResults'  # type: str
        self.results = results


class SentimentResponse(PreBuiltResult):
    """SentimentResponse.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    :ivar documents: Required. Sentiment analysis per document.
    :vartype documents:
     list[~azure.ai.textanalytics.v2022_05_01.models.SentimentResponseDocumentsItem]
    """

    _validation = {
        'errors': {'required': True},
        'model_version': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
        'documents': {'key': 'documents', 'type': '[SentimentResponseDocumentsItem]'},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        model_version: str,
        documents: List["_models.SentimentResponseDocumentsItem"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        :keyword documents: Required. Sentiment analysis per document.
        :paramtype documents:
         list[~azure.ai.textanalytics.v2022_05_01.models.SentimentResponseDocumentsItem]
        """
        super(SentimentResponse, self).__init__(errors=errors, statistics=statistics, model_version=model_version, **kwargs)
        self.documents = documents


class SentimentResponseDocumentsItem(SentimentDocumentResult):
    """SentimentResponseDocumentsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
    :ivar sentiment: Required. Predicted sentiment for document (Negative, Neutral, Positive, or
     Mixed). Known values are: "positive", "neutral", "negative", "mixed".
    :vartype sentiment: str or ~azure.ai.textanalytics.v2022_05_01.models.DocumentSentimentValue
    :ivar confidence_scores: Required. Document level sentiment confidence scores between 0 and 1
     for each sentiment class.
    :vartype confidence_scores:
     ~azure.ai.textanalytics.v2022_05_01.models.SentimentConfidenceScorePerLabel
    :ivar sentences: Required. Sentence level sentiment analysis.
    :vartype sentences: list[~azure.ai.textanalytics.v2022_05_01.models.SentenceSentiment]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'sentences': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'warnings': {'key': 'warnings', 'type': '[DocumentWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'sentiment': {'key': 'sentiment', 'type': 'str'},
        'confidence_scores': {'key': 'confidenceScores', 'type': 'SentimentConfidenceScorePerLabel'},
        'sentences': {'key': 'sentences', 'type': '[SentenceSentiment]'},
    }

    def __init__(
        self,
        *,
        id: str,
        warnings: List["_models.DocumentWarning"],
        sentiment: Union[str, "_models.DocumentSentimentValue"],
        confidence_scores: "_models.SentimentConfidenceScorePerLabel",
        sentences: List["_models.SentenceSentiment"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v2022_05_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2022_05_01.models.DocumentStatistics
        :keyword sentiment: Required. Predicted sentiment for document (Negative, Neutral, Positive, or
         Mixed). Known values are: "positive", "neutral", "negative", "mixed".
        :paramtype sentiment: str or ~azure.ai.textanalytics.v2022_05_01.models.DocumentSentimentValue
        :keyword confidence_scores: Required. Document level sentiment confidence scores between 0 and
         1 for each sentiment class.
        :paramtype confidence_scores:
         ~azure.ai.textanalytics.v2022_05_01.models.SentimentConfidenceScorePerLabel
        :keyword sentences: Required. Sentence level sentiment analysis.
        :paramtype sentences: list[~azure.ai.textanalytics.v2022_05_01.models.SentenceSentiment]
        """
        super(SentimentResponseDocumentsItem, self).__init__(id=id, warnings=warnings, statistics=statistics, sentiment=sentiment, confidence_scores=confidence_scores, sentences=sentences, **kwargs)


class SentimentTaskResult(AnalyzeTextTaskResult):
    """SentimentTaskResult.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Enumeration of supported Text Analysis task results.Constant filled by
     server. Known values are: "SentimentAnalysisResults", "EntityRecognitionResults",
     "PiiEntityRecognitionResults", "KeyPhraseExtractionResults", "LanguageDetectionResults",
     "EntityLinkingResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextTaskResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2022_05_01.models.SentimentResponse
    """

    _validation = {
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'results': {'key': 'results', 'type': 'SentimentResponse'},
    }

    def __init__(
        self,
        *,
        results: "_models.SentimentResponse",
        **kwargs
    ):
        """
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2022_05_01.models.SentimentResponse
        """
        super(SentimentTaskResult, self).__init__(**kwargs)
        self.kind = 'SentimentAnalysisResults'  # type: str
        self.results = results


class TargetConfidenceScoreLabel(msrest.serialization.Model):
    """Represents the confidence scores across all sentiment classes: positive, neutral, negative.

    All required parameters must be populated in order to send to Azure.

    :ivar positive: Required.
    :vartype positive: float
    :ivar negative: Required.
    :vartype negative: float
    """

    _validation = {
        'positive': {'required': True},
        'negative': {'required': True},
    }

    _attribute_map = {
        'positive': {'key': 'positive', 'type': 'float'},
        'negative': {'key': 'negative', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        positive: float,
        negative: float,
        **kwargs
    ):
        """
        :keyword positive: Required.
        :paramtype positive: float
        :keyword negative: Required.
        :paramtype negative: float
        """
        super(TargetConfidenceScoreLabel, self).__init__(**kwargs)
        self.positive = positive
        self.negative = negative


class TargetRelation(msrest.serialization.Model):
    """TargetRelation.

    All required parameters must be populated in order to send to Azure.

    :ivar relation_type: Required. The type related to the target. Known values are: "assessment",
     "target".
    :vartype relation_type: str or ~azure.ai.textanalytics.v2022_05_01.models.TargetRelationType
    :ivar ref: Required. The JSON pointer indicating the linked object.
    :vartype ref: str
    """

    _validation = {
        'relation_type': {'required': True},
        'ref': {'required': True},
    }

    _attribute_map = {
        'relation_type': {'key': 'relationType', 'type': 'str'},
        'ref': {'key': 'ref', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        relation_type: Union[str, "_models.TargetRelationType"],
        ref: str,
        **kwargs
    ):
        """
        :keyword relation_type: Required. The type related to the target. Known values are:
         "assessment", "target".
        :paramtype relation_type: str or ~azure.ai.textanalytics.v2022_05_01.models.TargetRelationType
        :keyword ref: Required. The JSON pointer indicating the linked object.
        :paramtype ref: str
        """
        super(TargetRelation, self).__init__(**kwargs)
        self.relation_type = relation_type
        self.ref = ref


class TasksStateTasks(msrest.serialization.Model):
    """TasksStateTasks.

    All required parameters must be populated in order to send to Azure.

    :ivar completed: Required.
    :vartype completed: int
    :ivar failed: Required.
    :vartype failed: int
    :ivar in_progress: Required.
    :vartype in_progress: int
    :ivar total: Required.
    :vartype total: int
    :ivar items:
    :vartype items: list[~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROResult]
    """

    _validation = {
        'completed': {'required': True},
        'failed': {'required': True},
        'in_progress': {'required': True},
        'total': {'required': True},
    }

    _attribute_map = {
        'completed': {'key': 'completed', 'type': 'int'},
        'failed': {'key': 'failed', 'type': 'int'},
        'in_progress': {'key': 'inProgress', 'type': 'int'},
        'total': {'key': 'total', 'type': 'int'},
        'items': {'key': 'items', 'type': '[AnalyzeTextLROResult]'},
    }

    def __init__(
        self,
        *,
        completed: int,
        failed: int,
        in_progress: int,
        total: int,
        items: Optional[List["_models.AnalyzeTextLROResult"]] = None,
        **kwargs
    ):
        """
        :keyword completed: Required.
        :paramtype completed: int
        :keyword failed: Required.
        :paramtype failed: int
        :keyword in_progress: Required.
        :paramtype in_progress: int
        :keyword total: Required.
        :paramtype total: int
        :keyword items:
        :paramtype items: list[~azure.ai.textanalytics.v2022_05_01.models.AnalyzeTextLROResult]
        """
        super(TasksStateTasks, self).__init__(**kwargs)
        self.completed = completed
        self.failed = failed
        self.in_progress = in_progress
        self.total = total
        self.items = items
