# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, TYPE_CHECKING, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    import __init__ as _models


class DetectedLanguage(msrest.serialization.Model):
    """DetectedLanguage.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Long name of a detected language (e.g. English, French).
    :vartype name: str
    :ivar iso6391_name: Required. A two letter representation of the detected language according to
     the ISO 639-1 standard (e.g. en, fr).
    :vartype iso6391_name: str
    :ivar confidence_score: Required. A confidence score between 0 and 1. Scores close to 1
     indicate 100% certainty that the identified language is true.
    :vartype confidence_score: float
    """

    _validation = {
        'name': {'required': True},
        'iso6391_name': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'iso6391_name': {'key': 'iso6391Name', 'type': 'str'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        name: str,
        iso6391_name: str,
        confidence_score: float,
        **kwargs
    ):
        """
        :keyword name: Required. Long name of a detected language (e.g. English, French).
        :paramtype name: str
        :keyword iso6391_name: Required. A two letter representation of the detected language according
         to the ISO 639-1 standard (e.g. en, fr).
        :paramtype iso6391_name: str
        :keyword confidence_score: Required. A confidence score between 0 and 1. Scores close to 1
         indicate 100% certainty that the identified language is true.
        :paramtype confidence_score: float
        """
        super(DetectedLanguage, self).__init__(**kwargs)
        self.name = name
        self.iso6391_name = iso6391_name
        self.confidence_score = confidence_score


class DocumentEntities(msrest.serialization.Model):
    """DocumentEntities.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar entities: Required. Recognized entities in the document.
    :vartype entities: list[~azure.ai.textanalytics.v3_0.models.Entity]
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v3_0.models.TextAnalyticsWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_0.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'entities': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[Entity]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        *,
        id: str,
        entities: List["_models.Entity"],
        warnings: List["_models.TextAnalyticsWarning"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword entities: Required. Recognized entities in the document.
        :paramtype entities: list[~azure.ai.textanalytics.v3_0.models.Entity]
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_0.models.TextAnalyticsWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_0.models.DocumentStatistics
        """
        super(DocumentEntities, self).__init__(**kwargs)
        self.id = id
        self.entities = entities
        self.warnings = warnings
        self.statistics = statistics


class DocumentError(msrest.serialization.Model):
    """DocumentError.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Document Id.
    :vartype id: str
    :ivar error: Required. Document Error.
    :vartype error: ~azure.ai.textanalytics.v3_0.models.TextAnalyticsError
    """

    _validation = {
        'id': {'required': True},
        'error': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'error': {'key': 'error', 'type': 'TextAnalyticsError'},
    }

    def __init__(
        self,
        *,
        id: str,
        error: "_models.TextAnalyticsError",
        **kwargs
    ):
        """
        :keyword id: Required. Document Id.
        :paramtype id: str
        :keyword error: Required. Document Error.
        :paramtype error: ~azure.ai.textanalytics.v3_0.models.TextAnalyticsError
        """
        super(DocumentError, self).__init__(**kwargs)
        self.id = id
        self.error = error


class DocumentKeyPhrases(msrest.serialization.Model):
    """DocumentKeyPhrases.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar key_phrases: Required. A list of representative words or phrases. The number of key
     phrases returned is proportional to the number of words in the input document.
    :vartype key_phrases: list[str]
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v3_0.models.TextAnalyticsWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_0.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'key_phrases': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'key_phrases': {'key': 'keyPhrases', 'type': '[str]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        *,
        id: str,
        key_phrases: List[str],
        warnings: List["_models.TextAnalyticsWarning"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword key_phrases: Required. A list of representative words or phrases. The number of key
         phrases returned is proportional to the number of words in the input document.
        :paramtype key_phrases: list[str]
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_0.models.TextAnalyticsWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_0.models.DocumentStatistics
        """
        super(DocumentKeyPhrases, self).__init__(**kwargs)
        self.id = id
        self.key_phrases = key_phrases
        self.warnings = warnings
        self.statistics = statistics


class DocumentLanguage(msrest.serialization.Model):
    """DocumentLanguage.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar detected_language: Required. Detected Language.
    :vartype detected_language: ~azure.ai.textanalytics.v3_0.models.DetectedLanguage
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v3_0.models.TextAnalyticsWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_0.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'detected_language': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'detected_language': {'key': 'detectedLanguage', 'type': 'DetectedLanguage'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        *,
        id: str,
        detected_language: "_models.DetectedLanguage",
        warnings: List["_models.TextAnalyticsWarning"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword detected_language: Required. Detected Language.
        :paramtype detected_language: ~azure.ai.textanalytics.v3_0.models.DetectedLanguage
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_0.models.TextAnalyticsWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_0.models.DocumentStatistics
        """
        super(DocumentLanguage, self).__init__(**kwargs)
        self.id = id
        self.detected_language = detected_language
        self.warnings = warnings
        self.statistics = statistics


class DocumentLinkedEntities(msrest.serialization.Model):
    """DocumentLinkedEntities.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar entities: Required. Recognized well-known entities in the document.
    :vartype entities: list[~azure.ai.textanalytics.v3_0.models.LinkedEntity]
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v3_0.models.TextAnalyticsWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_0.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'entities': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[LinkedEntity]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        *,
        id: str,
        entities: List["_models.LinkedEntity"],
        warnings: List["_models.TextAnalyticsWarning"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword entities: Required. Recognized well-known entities in the document.
        :paramtype entities: list[~azure.ai.textanalytics.v3_0.models.LinkedEntity]
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_0.models.TextAnalyticsWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_0.models.DocumentStatistics
        """
        super(DocumentLinkedEntities, self).__init__(**kwargs)
        self.id = id
        self.entities = entities
        self.warnings = warnings
        self.statistics = statistics


class DocumentSentiment(msrest.serialization.Model):
    """DocumentSentiment.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar sentiment: Required. Predicted sentiment for document (Negative, Neutral, Positive, or
     Mixed). Known values are: "positive", "neutral", "negative", "mixed".
    :vartype sentiment: str or ~azure.ai.textanalytics.v3_0.models.DocumentSentimentValue
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_0.models.DocumentStatistics
    :ivar confidence_scores: Required. Document level sentiment confidence scores between 0 and 1
     for each sentiment class.
    :vartype confidence_scores:
     ~azure.ai.textanalytics.v3_0.models.SentimentConfidenceScorePerLabel
    :ivar sentences: Required. Sentence level sentiment analysis.
    :vartype sentences: list[~azure.ai.textanalytics.v3_0.models.SentenceSentiment]
    :ivar warnings: Required. Warnings encountered while processing document.
    :vartype warnings: list[~azure.ai.textanalytics.v3_0.models.TextAnalyticsWarning]
    """

    _validation = {
        'id': {'required': True},
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'sentences': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'sentiment': {'key': 'sentiment', 'type': 'str'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'confidence_scores': {'key': 'confidenceScores', 'type': 'SentimentConfidenceScorePerLabel'},
        'sentences': {'key': 'sentences', 'type': '[SentenceSentiment]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
    }

    def __init__(
        self,
        *,
        id: str,
        sentiment: Union[str, "_models.DocumentSentimentValue"],
        confidence_scores: "_models.SentimentConfidenceScorePerLabel",
        sentences: List["_models.SentenceSentiment"],
        warnings: List["_models.TextAnalyticsWarning"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword sentiment: Required. Predicted sentiment for document (Negative, Neutral, Positive, or
         Mixed). Known values are: "positive", "neutral", "negative", "mixed".
        :paramtype sentiment: str or ~azure.ai.textanalytics.v3_0.models.DocumentSentimentValue
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_0.models.DocumentStatistics
        :keyword confidence_scores: Required. Document level sentiment confidence scores between 0 and
         1 for each sentiment class.
        :paramtype confidence_scores:
         ~azure.ai.textanalytics.v3_0.models.SentimentConfidenceScorePerLabel
        :keyword sentences: Required. Sentence level sentiment analysis.
        :paramtype sentences: list[~azure.ai.textanalytics.v3_0.models.SentenceSentiment]
        :keyword warnings: Required. Warnings encountered while processing document.
        :paramtype warnings: list[~azure.ai.textanalytics.v3_0.models.TextAnalyticsWarning]
        """
        super(DocumentSentiment, self).__init__(**kwargs)
        self.id = id
        self.sentiment = sentiment
        self.statistics = statistics
        self.confidence_scores = confidence_scores
        self.sentences = sentences
        self.warnings = warnings


class DocumentStatistics(msrest.serialization.Model):
    """if showStats=true was specified in the request this field will contain information about the document payload.

    All required parameters must be populated in order to send to Azure.

    :ivar characters_count: Required. Number of text elements recognized in the document.
    :vartype characters_count: int
    :ivar transactions_count: Required. Number of transactions for the document.
    :vartype transactions_count: int
    """

    _validation = {
        'characters_count': {'required': True},
        'transactions_count': {'required': True},
    }

    _attribute_map = {
        'characters_count': {'key': 'charactersCount', 'type': 'int'},
        'transactions_count': {'key': 'transactionsCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        characters_count: int,
        transactions_count: int,
        **kwargs
    ):
        """
        :keyword characters_count: Required. Number of text elements recognized in the document.
        :paramtype characters_count: int
        :keyword transactions_count: Required. Number of transactions for the document.
        :paramtype transactions_count: int
        """
        super(DocumentStatistics, self).__init__(**kwargs)
        self.characters_count = characters_count
        self.transactions_count = transactions_count


class EntitiesResult(msrest.serialization.Model):
    """EntitiesResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required. Response by document.
    :vartype documents: list[~azure.ai.textanalytics.v3_0.models.DocumentEntities]
    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v3_0.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_0.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentEntities]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        documents: List["_models.DocumentEntities"],
        errors: List["_models.DocumentError"],
        model_version: str,
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword documents: Required. Response by document.
        :paramtype documents: list[~azure.ai.textanalytics.v3_0.models.DocumentEntities]
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v3_0.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_0.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        """
        super(EntitiesResult, self).__init__(**kwargs)
        self.documents = documents
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class Entity(msrest.serialization.Model):
    """Entity.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Required. Entity text as appears in the request.
    :vartype text: str
    :ivar category: Required. Entity type, such as Person/Location/Org/SSN etc.
    :vartype category: str
    :ivar subcategory: Entity sub type, such as Age/Year/TimeRange etc.
    :vartype subcategory: str
    :ivar offset: Required. Start position (in Unicode characters) for the entity text.
    :vartype offset: int
    :ivar length: Required. Length (in Unicode characters) for the entity text.
    :vartype length: int
    :ivar confidence_score: Required. Confidence score between 0 and 1 of the extracted entity.
    :vartype confidence_score: float
    """

    _validation = {
        'text': {'required': True},
        'category': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'subcategory': {'key': 'subcategory', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        text: str,
        category: str,
        offset: int,
        length: int,
        confidence_score: float,
        subcategory: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword text: Required. Entity text as appears in the request.
        :paramtype text: str
        :keyword category: Required. Entity type, such as Person/Location/Org/SSN etc.
        :paramtype category: str
        :keyword subcategory: Entity sub type, such as Age/Year/TimeRange etc.
        :paramtype subcategory: str
        :keyword offset: Required. Start position (in Unicode characters) for the entity text.
        :paramtype offset: int
        :keyword length: Required. Length (in Unicode characters) for the entity text.
        :paramtype length: int
        :keyword confidence_score: Required. Confidence score between 0 and 1 of the extracted entity.
        :paramtype confidence_score: float
        """
        super(Entity, self).__init__(**kwargs)
        self.text = text
        self.category = category
        self.subcategory = subcategory
        self.offset = offset
        self.length = length
        self.confidence_score = confidence_score


class EntityLinkingResult(msrest.serialization.Model):
    """EntityLinkingResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required. Response by document.
    :vartype documents: list[~azure.ai.textanalytics.v3_0.models.DocumentLinkedEntities]
    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v3_0.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_0.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentLinkedEntities]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        documents: List["_models.DocumentLinkedEntities"],
        errors: List["_models.DocumentError"],
        model_version: str,
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword documents: Required. Response by document.
        :paramtype documents: list[~azure.ai.textanalytics.v3_0.models.DocumentLinkedEntities]
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v3_0.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_0.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        """
        super(EntityLinkingResult, self).__init__(**kwargs)
        self.documents = documents
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class ErrorResponse(msrest.serialization.Model):
    """ErrorResponse.

    All required parameters must be populated in order to send to Azure.

    :ivar error: Required. Document Error.
    :vartype error: ~azure.ai.textanalytics.v3_0.models.TextAnalyticsError
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'TextAnalyticsError'},
    }

    def __init__(
        self,
        *,
        error: "_models.TextAnalyticsError",
        **kwargs
    ):
        """
        :keyword error: Required. Document Error.
        :paramtype error: ~azure.ai.textanalytics.v3_0.models.TextAnalyticsError
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class InnerError(msrest.serialization.Model):
    """InnerError.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. Error code. Known values are: "invalidParameterValue",
     "invalidRequestBodyFormat", "emptyRequest", "missingInputRecords", "invalidDocument",
     "modelVersionIncorrect", "invalidDocumentBatch", "unsupportedLanguageCode",
     "invalidCountryHint".
    :vartype code: str or ~azure.ai.textanalytics.v3_0.models.InnerErrorCodeValue
    :ivar message: Required. Error message.
    :vartype message: str
    :ivar details: Error details.
    :vartype details: dict[str, str]
    :ivar target: Error target.
    :vartype target: str
    :ivar innererror: Inner error contains more specific information.
    :vartype innererror: ~azure.ai.textanalytics.v3_0.models.InnerError
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '{str}'},
        'target': {'key': 'target', 'type': 'str'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
    }

    def __init__(
        self,
        *,
        code: Union[str, "_models.InnerErrorCodeValue"],
        message: str,
        details: Optional[Dict[str, str]] = None,
        target: Optional[str] = None,
        innererror: Optional["_models.InnerError"] = None,
        **kwargs
    ):
        """
        :keyword code: Required. Error code. Known values are: "invalidParameterValue",
         "invalidRequestBodyFormat", "emptyRequest", "missingInputRecords", "invalidDocument",
         "modelVersionIncorrect", "invalidDocumentBatch", "unsupportedLanguageCode",
         "invalidCountryHint".
        :paramtype code: str or ~azure.ai.textanalytics.v3_0.models.InnerErrorCodeValue
        :keyword message: Required. Error message.
        :paramtype message: str
        :keyword details: Error details.
        :paramtype details: dict[str, str]
        :keyword target: Error target.
        :paramtype target: str
        :keyword innererror: Inner error contains more specific information.
        :paramtype innererror: ~azure.ai.textanalytics.v3_0.models.InnerError
        """
        super(InnerError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details
        self.target = target
        self.innererror = innererror


class KeyPhraseResult(msrest.serialization.Model):
    """KeyPhraseResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required. Response by document.
    :vartype documents: list[~azure.ai.textanalytics.v3_0.models.DocumentKeyPhrases]
    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v3_0.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_0.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentKeyPhrases]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        documents: List["_models.DocumentKeyPhrases"],
        errors: List["_models.DocumentError"],
        model_version: str,
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword documents: Required. Response by document.
        :paramtype documents: list[~azure.ai.textanalytics.v3_0.models.DocumentKeyPhrases]
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v3_0.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_0.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        """
        super(KeyPhraseResult, self).__init__(**kwargs)
        self.documents = documents
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class LanguageBatchInput(msrest.serialization.Model):
    """LanguageBatchInput.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required.
    :vartype documents: list[~azure.ai.textanalytics.v3_0.models.LanguageInput]
    """

    _validation = {
        'documents': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[LanguageInput]'},
    }

    def __init__(
        self,
        *,
        documents: List["_models.LanguageInput"],
        **kwargs
    ):
        """
        :keyword documents: Required.
        :paramtype documents: list[~azure.ai.textanalytics.v3_0.models.LanguageInput]
        """
        super(LanguageBatchInput, self).__init__(**kwargs)
        self.documents = documents


class LanguageInput(msrest.serialization.Model):
    """LanguageInput.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique, non-empty document identifier.
    :vartype id: str
    :ivar text: Required.
    :vartype text: str
    :ivar country_hint:
    :vartype country_hint: str
    """

    _validation = {
        'id': {'required': True},
        'text': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'country_hint': {'key': 'countryHint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        text: str,
        country_hint: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Required. Unique, non-empty document identifier.
        :paramtype id: str
        :keyword text: Required.
        :paramtype text: str
        :keyword country_hint:
        :paramtype country_hint: str
        """
        super(LanguageInput, self).__init__(**kwargs)
        self.id = id
        self.text = text
        self.country_hint = country_hint


class LanguageResult(msrest.serialization.Model):
    """LanguageResult.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required. Response by document.
    :vartype documents: list[~azure.ai.textanalytics.v3_0.models.DocumentLanguage]
    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v3_0.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_0.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentLanguage]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        documents: List["_models.DocumentLanguage"],
        errors: List["_models.DocumentError"],
        model_version: str,
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword documents: Required. Response by document.
        :paramtype documents: list[~azure.ai.textanalytics.v3_0.models.DocumentLanguage]
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v3_0.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_0.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        """
        super(LanguageResult, self).__init__(**kwargs)
        self.documents = documents
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class LinkedEntity(msrest.serialization.Model):
    """LinkedEntity.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Entity Linking formal name.
    :vartype name: str
    :ivar matches: Required. List of instances this entity appears in the text.
    :vartype matches: list[~azure.ai.textanalytics.v3_0.models.Match]
    :ivar language: Required. Language used in the data source.
    :vartype language: str
    :ivar id: Unique identifier of the recognized entity from the data source.
    :vartype id: str
    :ivar url: Required. URL for the entity's page from the data source.
    :vartype url: str
    :ivar data_source: Required. Data source used to extract entity linking, such as Wiki/Bing etc.
    :vartype data_source: str
    """

    _validation = {
        'name': {'required': True},
        'matches': {'required': True},
        'language': {'required': True},
        'url': {'required': True},
        'data_source': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'matches': {'key': 'matches', 'type': '[Match]'},
        'language': {'key': 'language', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'data_source': {'key': 'dataSource', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        matches: List["_models.Match"],
        language: str,
        url: str,
        data_source: str,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Required. Entity Linking formal name.
        :paramtype name: str
        :keyword matches: Required. List of instances this entity appears in the text.
        :paramtype matches: list[~azure.ai.textanalytics.v3_0.models.Match]
        :keyword language: Required. Language used in the data source.
        :paramtype language: str
        :keyword id: Unique identifier of the recognized entity from the data source.
        :paramtype id: str
        :keyword url: Required. URL for the entity's page from the data source.
        :paramtype url: str
        :keyword data_source: Required. Data source used to extract entity linking, such as Wiki/Bing
         etc.
        :paramtype data_source: str
        """
        super(LinkedEntity, self).__init__(**kwargs)
        self.name = name
        self.matches = matches
        self.language = language
        self.id = id
        self.url = url
        self.data_source = data_source


class Match(msrest.serialization.Model):
    """Match.

    All required parameters must be populated in order to send to Azure.

    :ivar confidence_score: Required. If a well-known item is recognized, a decimal number denoting
     the confidence level between 0 and 1 will be returned.
    :vartype confidence_score: float
    :ivar text: Required. Entity text as appears in the request.
    :vartype text: str
    :ivar offset: Required. Start position (in Unicode characters) for the entity match text.
    :vartype offset: int
    :ivar length: Required. Length (in Unicode characters) for the entity match text.
    :vartype length: int
    """

    _validation = {
        'confidence_score': {'required': True},
        'text': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
    }

    _attribute_map = {
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
        'text': {'key': 'text', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        confidence_score: float,
        text: str,
        offset: int,
        length: int,
        **kwargs
    ):
        """
        :keyword confidence_score: Required. If a well-known item is recognized, a decimal number
         denoting the confidence level between 0 and 1 will be returned.
        :paramtype confidence_score: float
        :keyword text: Required. Entity text as appears in the request.
        :paramtype text: str
        :keyword offset: Required. Start position (in Unicode characters) for the entity match text.
        :paramtype offset: int
        :keyword length: Required. Length (in Unicode characters) for the entity match text.
        :paramtype length: int
        """
        super(Match, self).__init__(**kwargs)
        self.confidence_score = confidence_score
        self.text = text
        self.offset = offset
        self.length = length


class MultiLanguageBatchInput(msrest.serialization.Model):
    """Contains a set of input documents to be analyzed by the service.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required. The set of documents to process as part of this batch.
    :vartype documents: list[~azure.ai.textanalytics.v3_0.models.MultiLanguageInput]
    """

    _validation = {
        'documents': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[MultiLanguageInput]'},
    }

    def __init__(
        self,
        *,
        documents: List["_models.MultiLanguageInput"],
        **kwargs
    ):
        """
        :keyword documents: Required. The set of documents to process as part of this batch.
        :paramtype documents: list[~azure.ai.textanalytics.v3_0.models.MultiLanguageInput]
        """
        super(MultiLanguageBatchInput, self).__init__(**kwargs)
        self.documents = documents


class MultiLanguageInput(msrest.serialization.Model):
    """Contains an input document to be analyzed by the service.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. A unique, non-empty document identifier.
    :vartype id: str
    :ivar text: Required. The input text to process.
    :vartype text: str
    :ivar language: (Optional) This is the 2 letter ISO 639-1 representation of a language. For
     example, use "en" for English; "es" for Spanish etc. If not set, use "en" for English as
     default.
    :vartype language: str
    """

    _validation = {
        'id': {'required': True},
        'text': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'language': {'key': 'language', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        text: str,
        language: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Required. A unique, non-empty document identifier.
        :paramtype id: str
        :keyword text: Required. The input text to process.
        :paramtype text: str
        :keyword language: (Optional) This is the 2 letter ISO 639-1 representation of a language. For
         example, use "en" for English; "es" for Spanish etc. If not set, use "en" for English as
         default.
        :paramtype language: str
        """
        super(MultiLanguageInput, self).__init__(**kwargs)
        self.id = id
        self.text = text
        self.language = language


class RequestStatistics(msrest.serialization.Model):
    """if showStats=true was specified in the request this field will contain information about the request payload.

    All required parameters must be populated in order to send to Azure.

    :ivar documents_count: Required. Number of documents submitted in the request.
    :vartype documents_count: int
    :ivar valid_documents_count: Required. Number of valid documents. This excludes empty,
     over-size limit or non-supported languages documents.
    :vartype valid_documents_count: int
    :ivar erroneous_documents_count: Required. Number of invalid documents. This includes empty,
     over-size limit or non-supported languages documents.
    :vartype erroneous_documents_count: int
    :ivar transactions_count: Required. Number of transactions for the request.
    :vartype transactions_count: long
    """

    _validation = {
        'documents_count': {'required': True},
        'valid_documents_count': {'required': True},
        'erroneous_documents_count': {'required': True},
        'transactions_count': {'required': True},
    }

    _attribute_map = {
        'documents_count': {'key': 'documentsCount', 'type': 'int'},
        'valid_documents_count': {'key': 'validDocumentsCount', 'type': 'int'},
        'erroneous_documents_count': {'key': 'erroneousDocumentsCount', 'type': 'int'},
        'transactions_count': {'key': 'transactionsCount', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        documents_count: int,
        valid_documents_count: int,
        erroneous_documents_count: int,
        transactions_count: int,
        **kwargs
    ):
        """
        :keyword documents_count: Required. Number of documents submitted in the request.
        :paramtype documents_count: int
        :keyword valid_documents_count: Required. Number of valid documents. This excludes empty,
         over-size limit or non-supported languages documents.
        :paramtype valid_documents_count: int
        :keyword erroneous_documents_count: Required. Number of invalid documents. This includes empty,
         over-size limit or non-supported languages documents.
        :paramtype erroneous_documents_count: int
        :keyword transactions_count: Required. Number of transactions for the request.
        :paramtype transactions_count: long
        """
        super(RequestStatistics, self).__init__(**kwargs)
        self.documents_count = documents_count
        self.valid_documents_count = valid_documents_count
        self.erroneous_documents_count = erroneous_documents_count
        self.transactions_count = transactions_count


class SentenceSentiment(msrest.serialization.Model):
    """SentenceSentiment.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Required. The sentence text.
    :vartype text: str
    :ivar sentiment: Required. The predicted Sentiment for the sentence. Known values are:
     "positive", "neutral", "negative".
    :vartype sentiment: str or ~azure.ai.textanalytics.v3_0.models.SentenceSentimentValue
    :ivar confidence_scores: Required. The sentiment confidence score between 0 and 1 for the
     sentence for all classes.
    :vartype confidence_scores:
     ~azure.ai.textanalytics.v3_0.models.SentimentConfidenceScorePerLabel
    :ivar offset: Required. The sentence offset from the start of the document.
    :vartype offset: int
    :ivar length: Required. The length of the sentence by Unicode standard.
    :vartype length: int
    """

    _validation = {
        'text': {'required': True},
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'sentiment': {'key': 'sentiment', 'type': 'str'},
        'confidence_scores': {'key': 'confidenceScores', 'type': 'SentimentConfidenceScorePerLabel'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        text: str,
        sentiment: Union[str, "_models.SentenceSentimentValue"],
        confidence_scores: "_models.SentimentConfidenceScorePerLabel",
        offset: int,
        length: int,
        **kwargs
    ):
        """
        :keyword text: Required. The sentence text.
        :paramtype text: str
        :keyword sentiment: Required. The predicted Sentiment for the sentence. Known values are:
         "positive", "neutral", "negative".
        :paramtype sentiment: str or ~azure.ai.textanalytics.v3_0.models.SentenceSentimentValue
        :keyword confidence_scores: Required. The sentiment confidence score between 0 and 1 for the
         sentence for all classes.
        :paramtype confidence_scores:
         ~azure.ai.textanalytics.v3_0.models.SentimentConfidenceScorePerLabel
        :keyword offset: Required. The sentence offset from the start of the document.
        :paramtype offset: int
        :keyword length: Required. The length of the sentence by Unicode standard.
        :paramtype length: int
        """
        super(SentenceSentiment, self).__init__(**kwargs)
        self.text = text
        self.sentiment = sentiment
        self.confidence_scores = confidence_scores
        self.offset = offset
        self.length = length


class SentimentConfidenceScorePerLabel(msrest.serialization.Model):
    """Represents the confidence scores between 0 and 1 across all sentiment classes: positive, neutral, negative.

    All required parameters must be populated in order to send to Azure.

    :ivar positive: Required.
    :vartype positive: float
    :ivar neutral: Required.
    :vartype neutral: float
    :ivar negative: Required.
    :vartype negative: float
    """

    _validation = {
        'positive': {'required': True},
        'neutral': {'required': True},
        'negative': {'required': True},
    }

    _attribute_map = {
        'positive': {'key': 'positive', 'type': 'float'},
        'neutral': {'key': 'neutral', 'type': 'float'},
        'negative': {'key': 'negative', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        positive: float,
        neutral: float,
        negative: float,
        **kwargs
    ):
        """
        :keyword positive: Required.
        :paramtype positive: float
        :keyword neutral: Required.
        :paramtype neutral: float
        :keyword negative: Required.
        :paramtype negative: float
        """
        super(SentimentConfidenceScorePerLabel, self).__init__(**kwargs)
        self.positive = positive
        self.neutral = neutral
        self.negative = negative


class SentimentResponse(msrest.serialization.Model):
    """SentimentResponse.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Required. Sentiment analysis per document.
    :vartype documents: list[~azure.ai.textanalytics.v3_0.models.DocumentSentiment]
    :ivar errors: Required. Errors by document id.
    :vartype errors: list[~azure.ai.textanalytics.v3_0.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v3_0.models.RequestStatistics
    :ivar model_version: Required. This field indicates which model is used for scoring.
    :vartype model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentSentiment]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        documents: List["_models.DocumentSentiment"],
        errors: List["_models.DocumentError"],
        model_version: str,
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword documents: Required. Sentiment analysis per document.
        :paramtype documents: list[~azure.ai.textanalytics.v3_0.models.DocumentSentiment]
        :keyword errors: Required. Errors by document id.
        :paramtype errors: list[~azure.ai.textanalytics.v3_0.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v3_0.models.RequestStatistics
        :keyword model_version: Required. This field indicates which model is used for scoring.
        :paramtype model_version: str
        """
        super(SentimentResponse, self).__init__(**kwargs)
        self.documents = documents
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class TextAnalyticsError(msrest.serialization.Model):
    """TextAnalyticsError.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. Error code. Known values are: "invalidRequest", "invalidArgument",
     "internalServerError", "serviceUnavailable".
    :vartype code: str or ~azure.ai.textanalytics.v3_0.models.ErrorCodeValue
    :ivar message: Required. Error message.
    :vartype message: str
    :ivar target: Error target.
    :vartype target: str
    :ivar innererror: Inner error contains more specific information.
    :vartype innererror: ~azure.ai.textanalytics.v3_0.models.InnerError
    :ivar details: Details about specific errors that led to this reported error.
    :vartype details: list[~azure.ai.textanalytics.v3_0.models.TextAnalyticsError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
        'details': {'key': 'details', 'type': '[TextAnalyticsError]'},
    }

    def __init__(
        self,
        *,
        code: Union[str, "_models.ErrorCodeValue"],
        message: str,
        target: Optional[str] = None,
        innererror: Optional["_models.InnerError"] = None,
        details: Optional[List["_models.TextAnalyticsError"]] = None,
        **kwargs
    ):
        """
        :keyword code: Required. Error code. Known values are: "invalidRequest", "invalidArgument",
         "internalServerError", "serviceUnavailable".
        :paramtype code: str or ~azure.ai.textanalytics.v3_0.models.ErrorCodeValue
        :keyword message: Required. Error message.
        :paramtype message: str
        :keyword target: Error target.
        :paramtype target: str
        :keyword innererror: Inner error contains more specific information.
        :paramtype innererror: ~azure.ai.textanalytics.v3_0.models.InnerError
        :keyword details: Details about specific errors that led to this reported error.
        :paramtype details: list[~azure.ai.textanalytics.v3_0.models.TextAnalyticsError]
        """
        super(TextAnalyticsError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.innererror = innererror
        self.details = details


class TextAnalyticsWarning(msrest.serialization.Model):
    """TextAnalyticsWarning.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. Error code. Known values are: "LongWordsInDocument", "DocumentTruncated".
    :vartype code: str or ~azure.ai.textanalytics.v3_0.models.WarningCodeValue
    :ivar message: Required. Warning message.
    :vartype message: str
    :ivar target_ref: A JSON pointer reference indicating the target object.
    :vartype target_ref: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target_ref': {'key': 'targetRef', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Union[str, "_models.WarningCodeValue"],
        message: str,
        target_ref: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Required. Error code. Known values are: "LongWordsInDocument",
         "DocumentTruncated".
        :paramtype code: str or ~azure.ai.textanalytics.v3_0.models.WarningCodeValue
        :keyword message: Required. Warning message.
        :paramtype message: str
        :keyword target_ref: A JSON pointer reference indicating the target object.
        :paramtype target_ref: str
        """
        super(TextAnalyticsWarning, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target_ref = target_ref
