# This file is generated by pto-pre-build.sh. Do not edit it manually.
# Wed 10 Jul 2024 04:34:31 PM EDT
# SOURCE NAME: jgtml_cli-ttf-proto-01-2406181221.py
########################
 
import argparse
import pandas as pd
import os
import sys

sys.path.insert(0, os.path.abspath(os.path.dirname(__file__)))

import realityhelper

def create_app_arguments()->argparse.Namespace:
  from jgtutils import jgtcommon
  parser:argparse.ArgumentParser=jgtcommon.new_parser("Create MLF Data (alpha)","jgtmlfcli","Create MLF Data (alpha) for a given instrument and timeframe with patterns")
  #parser = argparse.ArgumentParser(description="Create mlf alpha CSV file")
  
  lagging_group=parser.add_argument_group("Lagging")
  #lag_period
  lagging_group.add_argument("-lp", "--lag_period", type=int, default=1, help="Lag period")
  #total_lagging_periods
  lagging_group.add_argument("-tlp", "--total_lagging_periods", type=int, default=5, help="Total lagging periods")
  
  col_group=parser.add_argument_group("Columns Filtering")
  #columns_to_keep
  col_group.add_argument("-ctk", "--columns_to_keep", nargs='+', help="List of selected columns to keep", default=None)
  #columns_to_drop
  col_group.add_argument("-ctd", "--columns_to_drop", nargs='+', help="List of selected columns to drop", default=None)

  #force_refresh
  parser.add_argument("-f", "--force_refresh", action="store_true", help="Force refresh")
  #flag mfiao
  #parser.add_argument("-mfiao", "--mfiao", action="store_true", help="Use mfiao")
  #drop_bidask
  #parser.add_argument("-dba", "--drop_bidask", action="store_true", help="Drop bidask")
  
  
  pn_group=parser.add_argument_group("Patterns")
  pn_group.add_argument("-pn", "--patternname", help="Pattern Name", default="ttf")
  
  parser=jgtcommon.add_keepbidask_argument(parser)
  parser=jgtcommon.add_instrument_timeframe_arguments(parser)
  parser=jgtcommon.add_bars_amount_V2_arguments(parser)
  parser=jgtcommon.add_use_fresh_argument(parser)
  parser=jgtcommon.add_dropna_volume_argument(parser)
  
  parser.add_argument("-fr", "--force_read", action="store_true", help="Force to read CDS (should increase speed but relies on existing data)")
  
  args:argparse.Namespace=parser.parse_args()
  return args
  


def main():
  
  args = create_app_arguments()
  
  force_refresh=args.fresh
  
  #get_mfis_ao_zone_2407b_feature
  # if args.mfiao:
  #   realityhelper.create_pattern_dataset__ttf_mfis_ao_2407a_pto_get_dataset_we_need_in_here__2407060929(                 args.instrument,
  #                           args.timeframe,
  #                           use_full=args.full if args.full else False,
  #                           force_refresh=force_refresh,
  #                           lag_period=args.lag_period,
  #                           total_lagging_periods=args.total_lagging_periods,
  #                           dropna=True if args.dont_dropna else False,
  #                           columns_to_keep=args.columns_to_keep,
  #                           columns_to_drop=args.columns_to_drop)
  # else:
  #   if args.patternname == "ttf":
  #     realityhelper.get_mfis_ao_zone_2407b_feature(
  #                           args.instrument,
  #                           args.timeframe,
  #                           use_full=args.full if args.full else False,
  #                           force_refresh=force_refresh,
  #                           lag_period=args.lag_period,
  #                           total_lagging_periods=args.total_lagging_periods,
  #                           dropna=True,
  #                           columns_to_keep=args.columns_to_keep,
  #                           columns_to_drop=args.columns_to_drop,
  #                           drop_bid_ask=True if args.drop_bidask else False,
  #                           patternname=args.patternname)
  #   else:
  try:
    realityhelper.generate_mlf_feature_pattern(
                            args.instrument,
                            args.timeframe,
                            use_full=args.full if args.full else False,
                            force_refresh=force_refresh,
                            lag_period=args.lag_period,
                            total_lagging_periods=args.total_lagging_periods,
                            dropna=True,
                            columns_to_keep=args.columns_to_keep,
                            columns_to_drop=args.columns_to_drop,
                            drop_bid_ask=args.rmbidask,
                            pn=args.patternname)
  except:
    print("Error in generate_mlf_feature_pattern")
    print("patternname:", args.patternname, " might just not have its prerequisite TTF/Pattern data.  we would be running: jgtmlttfcli -i {instrument} -t {timeframe} -new")
  #create_ttf_csv(args.instrument, args.timeframe, args.full if args.full else False, args.fresh, args.quotescount, args.force_read)

if __name__ == "__main__":
  main()
  